/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define GNOME_SCAN_TYPE_OPTION_WIDGET (gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_SCAN_IS_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_IS_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass GnomeScanOptionWidgetClass;
typedef struct _GnomeScanOptionWidgetPrivate GnomeScanOptionWidgetPrivate;

#define GNOME_SCAN_TYPE_ENTRY_WIDGET (gnome_scan_entry_widget_get_type ())
#define GNOME_SCAN_ENTRY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidget))
#define GNOME_SCAN_ENTRY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidgetClass))
#define GNOME_SCAN_IS_ENTRY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_ENTRY_WIDGET))
#define GNOME_SCAN_IS_ENTRY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_ENTRY_WIDGET))
#define GNOME_SCAN_ENTRY_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidgetClass))

typedef struct _GnomeScanEntryWidget GnomeScanEntryWidget;
typedef struct _GnomeScanEntryWidgetClass GnomeScanEntryWidgetClass;
typedef struct _GnomeScanEntryWidgetPrivate GnomeScanEntryWidgetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;

#define GNOME_SCAN_TYPE_OPTION_STRING (gnome_scan_option_string_get_type ())
#define GNOME_SCAN_OPTION_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionString))
#define GNOME_SCAN_OPTION_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringClass))
#define GNOME_SCAN_IS_OPTION_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_STRING))
#define GNOME_SCAN_IS_OPTION_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_STRING))
#define GNOME_SCAN_OPTION_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringClass))

typedef struct _GnomeScanOptionString GnomeScanOptionString;
typedef struct _GnomeScanOptionStringClass GnomeScanOptionStringClass;

struct _GnomeScanOptionWidget {
	GtkHBox parent_instance;
	GnomeScanOptionWidgetPrivate * priv;
};

struct _GnomeScanOptionWidgetClass {
	GtkHBoxClass parent_class;
};

struct _GnomeScanEntryWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanEntryWidgetPrivate * priv;
};

struct _GnomeScanEntryWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};

struct _GnomeScanEntryWidgetPrivate {
	GtkEntry* entry;
};


static gpointer gnome_scan_entry_widget_parent_class = NULL;

GType gnome_scan_option_widget_get_type (void);
GType gnome_scan_entry_widget_get_type (void);
#define GNOME_SCAN_ENTRY_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidgetPrivate))
enum  {
	GNOME_SCAN_ENTRY_WIDGET_DUMMY_PROPERTY
};
GType gnome_scan_option_get_type (void);
GnomeScanOption* gnome_scan_option_widget_get_option (GnomeScanOptionWidget* self);
GType gnome_scan_option_string_get_type (void);
void gnome_scan_option_string_set_value (GnomeScanOptionString* self, const char* value);
static void gnome_scan_entry_widget_on_entry_changed (GnomeScanEntryWidget* self);
const char* gnome_scan_option_string_get_value (GnomeScanOptionString* self);
static void gnome_scan_entry_widget_on_option_changed (GnomeScanEntryWidget* self);
GnomeScanEntryWidget* gnome_scan_entry_widget_new (void);
GnomeScanEntryWidget* gnome_scan_entry_widget_construct (GType object_type);
static void _gnome_scan_entry_widget_on_entry_changed_g_object_notify (GtkEntry* _sender, GParamSpec* pspec, gpointer self);
static void _gnome_scan_entry_widget_on_option_changed_g_object_notify (GnomeScanOptionString* _sender, GParamSpec* pspec, gpointer self);
static GObject * gnome_scan_entry_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_entry_widget_finalize (GObject* obj);



static void gnome_scan_entry_widget_on_entry_changed (GnomeScanEntryWidget* self) {
	g_return_if_fail (self != NULL);
	g_object_freeze_notify ((GObject*) gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self));
	gnome_scan_option_string_set_value (GNOME_SCAN_OPTION_STRING (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self)), gtk_entry_get_text (self->priv->entry));
	g_object_thaw_notify ((GObject*) gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self));
}


static void gnome_scan_entry_widget_on_option_changed (GnomeScanEntryWidget* self) {
	g_return_if_fail (self != NULL);
	g_object_freeze_notify ((GObject*) self->priv->entry);
	gtk_entry_set_text (self->priv->entry, gnome_scan_option_string_get_value (GNOME_SCAN_OPTION_STRING (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self))));
	g_object_thaw_notify ((GObject*) self->priv->entry);
}


GnomeScanEntryWidget* gnome_scan_entry_widget_construct (GType object_type) {
	GnomeScanEntryWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanEntryWidget* gnome_scan_entry_widget_new (void) {
	return gnome_scan_entry_widget_construct (GNOME_SCAN_TYPE_ENTRY_WIDGET);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gnome_scan_entry_widget_on_entry_changed_g_object_notify (GtkEntry* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_entry_widget_on_entry_changed (self);
}


static void _gnome_scan_entry_widget_on_option_changed_g_object_notify (GnomeScanOptionString* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_entry_widget_on_option_changed (self);
}


static GObject * gnome_scan_entry_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanEntryWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanEntryWidget * self;
	klass = GNOME_SCAN_ENTRY_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_ENTRY_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_ENTRY_WIDGET (obj);
	{
		GnomeScanOption* _tmp0_;
		GnomeScanOptionString* option;
		GtkEntry* _tmp1_;
		option = _g_object_ref0 ((_tmp0_ = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_STRING (_tmp0_) ? ((GnomeScanOptionString*) _tmp0_) : NULL));
		self->priv->entry = (_tmp1_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->entry), _tmp1_);
		gtk_entry_set_text (self->priv->entry, gnome_scan_option_string_get_value (option));
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->entry, TRUE, TRUE, (guint) 0);
		g_signal_connect_object ((GObject*) self->priv->entry, "notify::text", (GCallback) _gnome_scan_entry_widget_on_entry_changed_g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) option, "notify::value", (GCallback) _gnome_scan_entry_widget_on_option_changed_g_object_notify, self, 0);
		_g_object_unref0 (option);
	}
	return obj;
}


static void gnome_scan_entry_widget_class_init (GnomeScanEntryWidgetClass * klass) {
	gnome_scan_entry_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanEntryWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_entry_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_entry_widget_finalize;
}


static void gnome_scan_entry_widget_instance_init (GnomeScanEntryWidget * self) {
	self->priv = GNOME_SCAN_ENTRY_WIDGET_GET_PRIVATE (self);
}


static void gnome_scan_entry_widget_finalize (GObject* obj) {
	GnomeScanEntryWidget * self;
	self = GNOME_SCAN_ENTRY_WIDGET (obj);
	_g_object_unref0 (self->priv->entry);
	G_OBJECT_CLASS (gnome_scan_entry_widget_parent_class)->finalize (obj);
}


GType gnome_scan_entry_widget_get_type (void) {
	static GType gnome_scan_entry_widget_type_id = 0;
	if (gnome_scan_entry_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanEntryWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_entry_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanEntryWidget), 0, (GInstanceInitFunc) gnome_scan_entry_widget_instance_init, NULL };
		gnome_scan_entry_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "GnomeScanEntryWidget", &g_define_type_info, 0);
	}
	return gnome_scan_entry_widget_type_id;
}




