/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gegl.h>
#include <glib/gi18n-lib.h>


#define GNOME_SCAN_TYPE_NODE (gnome_scan_node_get_type ())
#define GNOME_SCAN_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNode))
#define GNOME_SCAN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))
#define GNOME_SCAN_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))

typedef struct _GnomeScanNode GnomeScanNode;
typedef struct _GnomeScanNodeClass GnomeScanNodeClass;
typedef struct _GnomeScanNodePrivate GnomeScanNodePrivate;

#define GNOME_SCAN_TYPE_STATUS (gnome_scan_status_get_type ())

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_slist_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_slist_free_g_object_unref (var), NULL)))

struct _GnomeScanNode {
	GObject parent_instance;
	GnomeScanNodePrivate * priv;
};

struct _GnomeScanNodeClass {
	GObjectClass parent_class;
	void (*start_scan) (GnomeScanNode* self);
	gboolean (*start_image) (GnomeScanNode* self);
	void (*end_image) (GnomeScanNode* self);
	void (*end_scan) (GnomeScanNode* self);
};

typedef enum  {
	GNOME_SCAN_STATUS_UNKNOWN = 0,
	GNOME_SCAN_STATUS_FAILED = 100,
	GNOME_SCAN_STATUS_INITIALIZING = 200,
	GNOME_SCAN_STATUS_BUSY = 300,
	GNOME_SCAN_STATUS_UNCONFIGURED = 400,
	GNOME_SCAN_STATUS_READY = 500,
	GNOME_SCAN_STATUS_PROCESSING = 600,
	GNOME_SCAN_STATUS_DONE = 700
} GnomeScanStatus;

struct _GnomeScanNodePrivate {
	GnomeScanStatus _status;
	char* _message;
	GHashTable* options_table;
	GSList* _options;
	GSList* _nodes;
};


static gpointer gnome_scan_node_parent_class = NULL;

GType gnome_scan_node_get_type (void);
GType gnome_scan_status_get_type (void);
GType gnome_scan_option_get_type (void);
#define GNOME_SCAN_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_NODE, GnomeScanNodePrivate))
enum  {
	GNOME_SCAN_NODE_DUMMY_PROPERTY,
	GNOME_SCAN_NODE_STATUS,
	GNOME_SCAN_NODE_MESSAGE,
	GNOME_SCAN_NODE_OPTIONS,
	GNOME_SCAN_NODE_NODES
};
static void _g_slist_free_g_object_unref (GSList* self);
void gnome_scan_node_start_scan (GnomeScanNode* self);
static void gnome_scan_node_real_start_scan (GnomeScanNode* self);
gboolean gnome_scan_node_start_image (GnomeScanNode* self);
static gboolean gnome_scan_node_real_start_image (GnomeScanNode* self);
void gnome_scan_node_end_image (GnomeScanNode* self);
static void gnome_scan_node_real_end_image (GnomeScanNode* self);
void gnome_scan_node_end_scan (GnomeScanNode* self);
static void gnome_scan_node_real_end_scan (GnomeScanNode* self);
void gnome_scan_node_set_message (GnomeScanNode* self, const char* value);
void gnome_scan_node_set_status (GnomeScanNode* self, GnomeScanStatus value);
void gnome_scan_node_update_status (GnomeScanNode* self, GnomeScanStatus status, const char* message);
const char* gnome_scan_option_get_name (GnomeScanOption* self);
void gnome_scan_node_install_option (GnomeScanNode* self, GnomeScanOption* option);
GnomeScanOption* gnome_scan_node_lookup_option (GnomeScanNode* self, const char* name);
void gnome_scan_node_append_node (GnomeScanNode* self, GeglNode* node);
void gnome_scan_node_remove_node (GnomeScanNode* self, GeglNode* node);
GnomeScanNode* gnome_scan_node_construct (GType object_type);
GnomeScanStatus gnome_scan_node_get_status (GnomeScanNode* self);
const char* gnome_scan_node_get_message (GnomeScanNode* self);
GSList* gnome_scan_node_get_options (GnomeScanNode* self);
GSList* gnome_scan_node_get_nodes (GnomeScanNode* self);
static GObject * gnome_scan_node_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gnome_scan_node_finalize (GObject* obj);
static void gnome_scan_node_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gnome_scan_node_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


static void gnome_scan_node_real_start_scan (GnomeScanNode* self) {
	g_return_if_fail (self != NULL);
}


void gnome_scan_node_start_scan (GnomeScanNode* self) {
	GNOME_SCAN_NODE_GET_CLASS (self)->start_scan (self);
}


static gboolean gnome_scan_node_real_start_image (GnomeScanNode* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean gnome_scan_node_start_image (GnomeScanNode* self) {
	return GNOME_SCAN_NODE_GET_CLASS (self)->start_image (self);
}


static void gnome_scan_node_real_end_image (GnomeScanNode* self) {
	g_return_if_fail (self != NULL);
}


void gnome_scan_node_end_image (GnomeScanNode* self) {
	GNOME_SCAN_NODE_GET_CLASS (self)->end_image (self);
}


static void gnome_scan_node_real_end_scan (GnomeScanNode* self) {
	g_return_if_fail (self != NULL);
}


void gnome_scan_node_end_scan (GnomeScanNode* self) {
	GNOME_SCAN_NODE_GET_CLASS (self)->end_scan (self);
}


void gnome_scan_node_update_status (GnomeScanNode* self, GnomeScanStatus status, const char* message) {
	g_return_if_fail (self != NULL);
	if (message == NULL) {
		switch (status) {
			case GNOME_SCAN_STATUS_UNKNOWN:
			{
				gnome_scan_node_set_message (self, _ ("Unknown"));
				break;
			}
			case GNOME_SCAN_STATUS_FAILED:
			{
				gnome_scan_node_set_message (self, _ ("Failed"));
				break;
			}
			case GNOME_SCAN_STATUS_INITIALIZING:
			{
				gnome_scan_node_set_message (self, _ ("Initializing"));
				break;
			}
			case GNOME_SCAN_STATUS_UNCONFIGURED:
			{
				gnome_scan_node_set_message (self, _ ("Unconfigured"));
				break;
			}
			case GNOME_SCAN_STATUS_READY:
			{
				gnome_scan_node_set_message (self, _ ("Ready"));
				break;
			}
			case GNOME_SCAN_STATUS_PROCESSING:
			{
				gnome_scan_node_set_message (self, _ ("Processing"));
				break;
			}
			case GNOME_SCAN_STATUS_DONE:
			{
				gnome_scan_node_set_message (self, _ ("Done"));
				break;
			}
		}
	} else {
		gnome_scan_node_set_message (self, message);
	}
	gnome_scan_node_set_status (self, status);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gnome_scan_node_install_option (GnomeScanNode* self, GnomeScanOption* option) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	self->priv->_options = g_slist_append (self->priv->_options, _g_object_ref0 (option));
	g_hash_table_insert (self->priv->options_table, g_strdup (gnome_scan_option_get_name (option)), _g_object_ref0 (option));
}


GnomeScanOption* gnome_scan_node_lookup_option (GnomeScanNode* self, const char* name) {
	GnomeScanOption* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	result = _g_object_ref0 ((GnomeScanOption*) g_hash_table_lookup (self->priv->options_table, name));
	return result;
}


void gnome_scan_node_append_node (GnomeScanNode* self, GeglNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	self->priv->_nodes = g_slist_append (self->priv->_nodes, _g_object_ref0 (node));
}


void gnome_scan_node_remove_node (GnomeScanNode* self, GeglNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	self->priv->_nodes = g_slist_remove (self->priv->_nodes, node);
}


GnomeScanNode* gnome_scan_node_construct (GType object_type) {
	GnomeScanNode * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanStatus gnome_scan_node_get_status (GnomeScanNode* self) {
	GnomeScanStatus result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_status;
	return result;
}


void gnome_scan_node_set_status (GnomeScanNode* self, GnomeScanStatus value) {
	g_return_if_fail (self != NULL);
	self->priv->_status = value;
	g_object_notify ((GObject *) self, "status");
}


const char* gnome_scan_node_get_message (GnomeScanNode* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_message;
	return result;
}


void gnome_scan_node_set_message (GnomeScanNode* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_message = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_message), _tmp0_);
	g_object_notify ((GObject *) self, "message");
}


GSList* gnome_scan_node_get_options (GnomeScanNode* self) {
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_options;
	return result;
}


GSList* gnome_scan_node_get_nodes (GnomeScanNode* self) {
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_nodes;
	return result;
}


static GObject * gnome_scan_node_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanNodeClass * klass;
	GObjectClass * parent_class;
	GnomeScanNode * self;
	klass = GNOME_SCAN_NODE_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_NODE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_NODE (obj);
	{
		GHashTable* _tmp0_;
		self->priv->options_table = (_tmp0_ = g_hash_table_new (g_str_hash, g_str_equal), _g_hash_table_unref0 (self->priv->options_table), _tmp0_);
		gnome_scan_node_update_status (self, GNOME_SCAN_STATUS_INITIALIZING, NULL);
	}
	return obj;
}


static void gnome_scan_node_class_init (GnomeScanNodeClass * klass) {
	gnome_scan_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanNodePrivate));
	GNOME_SCAN_NODE_CLASS (klass)->start_scan = gnome_scan_node_real_start_scan;
	GNOME_SCAN_NODE_CLASS (klass)->start_image = gnome_scan_node_real_start_image;
	GNOME_SCAN_NODE_CLASS (klass)->end_image = gnome_scan_node_real_end_image;
	GNOME_SCAN_NODE_CLASS (klass)->end_scan = gnome_scan_node_real_end_scan;
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_node_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_node_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_node_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_node_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_NODE_STATUS, g_param_spec_enum ("status", "status", "status", GNOME_SCAN_TYPE_STATUS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_NODE_MESSAGE, g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_NODE_OPTIONS, g_param_spec_pointer ("options", "options", "options", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_NODE_NODES, g_param_spec_pointer ("nodes", "nodes", "nodes", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gnome_scan_node_instance_init (GnomeScanNode * self) {
	self->priv = GNOME_SCAN_NODE_GET_PRIVATE (self);
}


static void gnome_scan_node_finalize (GObject* obj) {
	GnomeScanNode * self;
	self = GNOME_SCAN_NODE (obj);
	_g_free0 (self->priv->_message);
	_g_hash_table_unref0 (self->priv->options_table);
	__g_slist_free_g_object_unref0 (self->priv->_options);
	__g_slist_free_g_object_unref0 (self->priv->_nodes);
	G_OBJECT_CLASS (gnome_scan_node_parent_class)->finalize (obj);
}


GType gnome_scan_node_get_type (void) {
	static GType gnome_scan_node_type_id = 0;
	if (gnome_scan_node_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanNode), 0, (GInstanceInitFunc) gnome_scan_node_instance_init, NULL };
		gnome_scan_node_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomeScanNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_node_type_id;
}


static void gnome_scan_node_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanNode * self;
	self = GNOME_SCAN_NODE (object);
	switch (property_id) {
		case GNOME_SCAN_NODE_STATUS:
		g_value_set_enum (value, gnome_scan_node_get_status (self));
		break;
		case GNOME_SCAN_NODE_MESSAGE:
		g_value_set_string (value, gnome_scan_node_get_message (self));
		break;
		case GNOME_SCAN_NODE_OPTIONS:
		g_value_set_pointer (value, gnome_scan_node_get_options (self));
		break;
		case GNOME_SCAN_NODE_NODES:
		g_value_set_pointer (value, gnome_scan_node_get_nodes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_node_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanNode * self;
	self = GNOME_SCAN_NODE (object);
	switch (property_id) {
		case GNOME_SCAN_NODE_STATUS:
		gnome_scan_node_set_status (self, g_value_get_enum (value));
		break;
		case GNOME_SCAN_NODE_MESSAGE:
		gnome_scan_node_set_message (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




