// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEVFSMM_ENUMS_H
#define _LIBGNOMEVFSMM_ENUMS_H

#include <glibmm.h>

/* $Id: enums.hg,v 1.7 2003/07/18 03:34:49 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfs/gnome-vfs-file-info.h>
#include <libgnomevfs/gnome-vfs-result.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>
 

namespace Gnome
{

namespace Vfs
{


/** @addtogroup libgnomevfsmmEnums Enums and Flags */

/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%FileInfoOptions operator|(FileInfoOptions, FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions operator&(FileInfoOptions, FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions operator^(FileInfoOptions, FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions operator~(FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions& operator|=(FileInfoOptions&, FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions& operator&=(FileInfoOptions&, FileInfoOptions)</tt><br>
 * <tt>%FileInfoOptions& operator^=(FileInfoOptions&, FileInfoOptions)</tt><br>
 */
enum FileInfoOptions
{
  FILE_INFO_DEFAULT = 0,
  FILE_INFO_GET_MIME_TYPE = 1 << 0,
  FILE_INFO_FORCE_FAST_MIME_TYPE = 1 << 1,
  FILE_INFO_FORCE_SLOW_MIME_TYPE = 1 << 2,
  FILE_INFO_FOLLOW_LINKS = 1 << 3,
  FILE_INFO_GET_ACCESS_RIGHTS = 1 << 4
};

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions operator|(FileInfoOptions lhs, FileInfoOptions rhs)
  { return static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions operator&(FileInfoOptions lhs, FileInfoOptions rhs)
  { return static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions operator^(FileInfoOptions lhs, FileInfoOptions rhs)
  { return static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions operator~(FileInfoOptions flags)
  { return static_cast<FileInfoOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions& operator|=(FileInfoOptions& lhs, FileInfoOptions rhs)
  { return (lhs = static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions& operator&=(FileInfoOptions& lhs, FileInfoOptions rhs)
  { return (lhs = static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FileInfoOptions& operator^=(FileInfoOptions& lhs, FileInfoOptions rhs)
  { return (lhs = static_cast<FileInfoOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 */
enum Result
{
  OK,
  ERROR_NOT_FOUND,
  ERROR_GENERIC,
  ERROR_INTERNAL,
  ERROR_BAD_PARAMETERS,
  ERROR_NOT_SUPPORTED,
  ERROR_IO,
  ERROR_CORRUPTED_DATA,
  ERROR_WRONG_FORMAT,
  ERROR_BAD_FILE,
  ERROR_TOO_BIG,
  ERROR_NO_SPACE,
  ERROR_READ_ONLY,
  ERROR_INVALID_URI,
  ERROR_NOT_OPEN,
  ERROR_INVALID_OPEN_MODE,
  ERROR_ACCESS_DENIED,
  ERROR_TOO_MANY_OPEN_FILES,
  ERROR_EOF,
  ERROR_NOT_A_DIRECTORY,
  ERROR_IN_PROGRESS,
  ERROR_INTERRUPTED,
  ERROR_FILE_EXISTS,
  ERROR_LOOP,
  ERROR_NOT_PERMITTED,
  ERROR_IS_DIRECTORY,
  ERROR_NO_MEMORY,
  ERROR_HOST_NOT_FOUND,
  ERROR_INVALID_HOST_NAME,
  ERROR_HOST_HAS_NO_ADDRESS,
  ERROR_LOGIN_FAILED,
  ERROR_CANCELLED,
  ERROR_DIRECTORY_BUSY,
  ERROR_DIRECTORY_NOT_EMPTY,
  ERROR_TOO_MANY_LINKS,
  ERROR_READ_ONLY_FILE_SYSTEM,
  ERROR_NOT_SAME_FILE_SYSTEM,
  ERROR_NAME_TOO_LONG,
  ERROR_SERVICE_NOT_AVAILABLE,
  ERROR_SERVICE_OBSOLETE,
  ERROR_PROTOCOL_ERROR,
  ERROR_NO_MASTER_BROWSER,
  NUM_ERRORS
};


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%URIHideOptions operator|(URIHideOptions, URIHideOptions)</tt><br>
 * <tt>%URIHideOptions operator&(URIHideOptions, URIHideOptions)</tt><br>
 * <tt>%URIHideOptions operator^(URIHideOptions, URIHideOptions)</tt><br>
 * <tt>%URIHideOptions operator~(URIHideOptions)</tt><br>
 * <tt>%URIHideOptions& operator|=(URIHideOptions&, URIHideOptions)</tt><br>
 * <tt>%URIHideOptions& operator&=(URIHideOptions&, URIHideOptions)</tt><br>
 * <tt>%URIHideOptions& operator^=(URIHideOptions&, URIHideOptions)</tt><br>
 */
enum URIHideOptions
{
  URI_HIDE_NONE = 0,
  URI_HIDE_USER_NAME = 1 << 0,
  URI_HIDE_PASSWORD = 1 << 1,
  URI_HIDE_HOST_NAME = 1 << 2,
  URI_HIDE_HOST_PORT = 1 << 3,
  URI_HIDE_TOPLEVEL_METHOD = 1 << 4,
  URI_HIDE_FRAGMENT_IDENTIFIER = 1 << 8
};

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions operator|(URIHideOptions lhs, URIHideOptions rhs)
  { return static_cast<URIHideOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions operator&(URIHideOptions lhs, URIHideOptions rhs)
  { return static_cast<URIHideOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions operator^(URIHideOptions lhs, URIHideOptions rhs)
  { return static_cast<URIHideOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions operator~(URIHideOptions flags)
  { return static_cast<URIHideOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions& operator|=(URIHideOptions& lhs, URIHideOptions rhs)
  { return (lhs = static_cast<URIHideOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions& operator&=(URIHideOptions& lhs, URIHideOptions rhs)
  { return (lhs = static_cast<URIHideOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline URIHideOptions& operator^=(URIHideOptions& lhs, URIHideOptions rhs)
  { return (lhs = static_cast<URIHideOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%DirectoryVisitOptions operator|(DirectoryVisitOptions, DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions operator&(DirectoryVisitOptions, DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions operator^(DirectoryVisitOptions, DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions operator~(DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions& operator|=(DirectoryVisitOptions&, DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions& operator&=(DirectoryVisitOptions&, DirectoryVisitOptions)</tt><br>
 * <tt>%DirectoryVisitOptions& operator^=(DirectoryVisitOptions&, DirectoryVisitOptions)</tt><br>
 */
enum DirectoryVisitOptions
{
  DIRECTORY_VISIT_DEFAULT = 0,
  DIRECTORY_VISIT_SAMEFS = 1 << 0,
  DIRECTORY_VISIT_LOOPCHECK = 1 << 1
};

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions operator|(DirectoryVisitOptions lhs, DirectoryVisitOptions rhs)
  { return static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions operator&(DirectoryVisitOptions lhs, DirectoryVisitOptions rhs)
  { return static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions operator^(DirectoryVisitOptions lhs, DirectoryVisitOptions rhs)
  { return static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions operator~(DirectoryVisitOptions flags)
  { return static_cast<DirectoryVisitOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions& operator|=(DirectoryVisitOptions& lhs, DirectoryVisitOptions rhs)
  { return (lhs = static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions& operator&=(DirectoryVisitOptions& lhs, DirectoryVisitOptions rhs)
  { return (lhs = static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline DirectoryVisitOptions& operator^=(DirectoryVisitOptions& lhs, DirectoryVisitOptions rhs)
  { return (lhs = static_cast<DirectoryVisitOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%OpenMode operator|(OpenMode, OpenMode)</tt><br>
 * <tt>%OpenMode operator&(OpenMode, OpenMode)</tt><br>
 * <tt>%OpenMode operator^(OpenMode, OpenMode)</tt><br>
 * <tt>%OpenMode operator~(OpenMode)</tt><br>
 * <tt>%OpenMode& operator|=(OpenMode&, OpenMode)</tt><br>
 * <tt>%OpenMode& operator&=(OpenMode&, OpenMode)</tt><br>
 * <tt>%OpenMode& operator^=(OpenMode&, OpenMode)</tt><br>
 */
enum OpenMode
{
  OPEN_NONE = 0,
  OPEN_READ = 1 << 0,
  OPEN_WRITE = 1 << 1,
  OPEN_RANDOM = 1 << 2
};

/** @ingroup libgnomevfsmmEnums */
inline OpenMode operator|(OpenMode lhs, OpenMode rhs)
  { return static_cast<OpenMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode operator&(OpenMode lhs, OpenMode rhs)
  { return static_cast<OpenMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode operator^(OpenMode lhs, OpenMode rhs)
  { return static_cast<OpenMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode operator~(OpenMode flags)
  { return static_cast<OpenMode>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode& operator|=(OpenMode& lhs, OpenMode rhs)
  { return (lhs = static_cast<OpenMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode& operator&=(OpenMode& lhs, OpenMode rhs)
  { return (lhs = static_cast<OpenMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline OpenMode& operator^=(OpenMode& lhs, OpenMode rhs)
  { return (lhs = static_cast<OpenMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 */
enum SeekPosition
{
  SEEK_POS_START,
  SEEK_POS_CURRENT,
  SEEK_POS_END
};


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%FileFlags operator|(FileFlags, FileFlags)</tt><br>
 * <tt>%FileFlags operator&(FileFlags, FileFlags)</tt><br>
 * <tt>%FileFlags operator^(FileFlags, FileFlags)</tt><br>
 * <tt>%FileFlags operator~(FileFlags)</tt><br>
 * <tt>%FileFlags& operator|=(FileFlags&, FileFlags)</tt><br>
 * <tt>%FileFlags& operator&=(FileFlags&, FileFlags)</tt><br>
 * <tt>%FileFlags& operator^=(FileFlags&, FileFlags)</tt><br>
 */
enum FileFlags
{
  FILE_FLAGS_NONE = 0,
  FILE_FLAGS_SYMLINK = 1 << 0,
  FILE_FLAGS_LOCAL = 1 << 1
};

/** @ingroup libgnomevfsmmEnums */
inline FileFlags operator|(FileFlags lhs, FileFlags rhs)
  { return static_cast<FileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags operator&(FileFlags lhs, FileFlags rhs)
  { return static_cast<FileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags operator^(FileFlags lhs, FileFlags rhs)
  { return static_cast<FileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags operator~(FileFlags flags)
  { return static_cast<FileFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags& operator|=(FileFlags& lhs, FileFlags rhs)
  { return (lhs = static_cast<FileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags& operator&=(FileFlags& lhs, FileFlags rhs)
  { return (lhs = static_cast<FileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FileFlags& operator^=(FileFlags& lhs, FileFlags rhs)
  { return (lhs = static_cast<FileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 */
enum FileType
{
  FILE_TYPE_UNKNOWN,
  FILE_TYPE_REGULAR,
  FILE_TYPE_DIRECTORY,
  FILE_TYPE_FIFO,
  FILE_TYPE_SOCKET,
  FILE_TYPE_CHARACTER_DEVICE,
  FILE_TYPE_BLOCK_DEVICE,
  FILE_TYPE_SYMBOLIC_LINK
};


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%FilePermissions operator|(FilePermissions, FilePermissions)</tt><br>
 * <tt>%FilePermissions operator&(FilePermissions, FilePermissions)</tt><br>
 * <tt>%FilePermissions operator^(FilePermissions, FilePermissions)</tt><br>
 * <tt>%FilePermissions operator~(FilePermissions)</tt><br>
 * <tt>%FilePermissions& operator|=(FilePermissions&, FilePermissions)</tt><br>
 * <tt>%FilePermissions& operator&=(FilePermissions&, FilePermissions)</tt><br>
 * <tt>%FilePermissions& operator^=(FilePermissions&, FilePermissions)</tt><br>
 */
enum FilePermissions
{
  PERM_SUID = S_ISUID,
  PERM_SGID = S_ISGID,
  PERM_STICKY = 01000,
  PERM_USER_READ = S_IRUSR,
  PERM_USER_WRITE = S_IWUSR,
  PERM_USER_EXEC = S_IXUSR,
  PERM_USER_ALL = S_IRUSR | S_IWUSR | S_IXUSR,
  PERM_GROUP_READ = S_IRGRP,
  PERM_GROUP_WRITE = S_IWGRP,
  PERM_GROUP_EXEC = S_IXGRP,
  PERM_GROUP_ALL = S_IRGRP | S_IWGRP | S_IXGRP,
  PERM_OTHER_READ = S_IROTH,
  PERM_OTHER_WRITE = S_IWOTH,
  PERM_OTHER_EXEC = S_IXOTH,
  PERM_OTHER_ALL = S_IROTH | S_IWOTH | S_IXOTH,
  PERM_ACCESS_READABLE = 1 << 16,
  PERM_ACCESS_WRITABLE = 1 << 17,
  PERM_ACCESS_EXECUTABLE = 1 << 18
};

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions operator|(FilePermissions lhs, FilePermissions rhs)
  { return static_cast<FilePermissions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions operator&(FilePermissions lhs, FilePermissions rhs)
  { return static_cast<FilePermissions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions operator^(FilePermissions lhs, FilePermissions rhs)
  { return static_cast<FilePermissions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions operator~(FilePermissions flags)
  { return static_cast<FilePermissions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions& operator|=(FilePermissions& lhs, FilePermissions rhs)
  { return (lhs = static_cast<FilePermissions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions& operator&=(FilePermissions& lhs, FilePermissions rhs)
  { return (lhs = static_cast<FilePermissions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline FilePermissions& operator^=(FilePermissions& lhs, FilePermissions rhs)
  { return (lhs = static_cast<FilePermissions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%SetFileInfoMask operator|(SetFileInfoMask, SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask operator&(SetFileInfoMask, SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask operator^(SetFileInfoMask, SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask operator~(SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask& operator|=(SetFileInfoMask&, SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask& operator&=(SetFileInfoMask&, SetFileInfoMask)</tt><br>
 * <tt>%SetFileInfoMask& operator^=(SetFileInfoMask&, SetFileInfoMask)</tt><br>
 */
enum SetFileInfoMask
{
  SET_FILE_INFO_NONE = 0,
  SET_FILE_INFO_NAME = 1 << 0,
  SET_FILE_INFO_PERMISSIONS = 1 << 1,
  SET_FILE_INFO_OWNER = 1 << 2,
  SET_FILE_INFO_TIME = 1 << 3
};

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask operator|(SetFileInfoMask lhs, SetFileInfoMask rhs)
  { return static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask operator&(SetFileInfoMask lhs, SetFileInfoMask rhs)
  { return static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask operator^(SetFileInfoMask lhs, SetFileInfoMask rhs)
  { return static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask operator~(SetFileInfoMask flags)
  { return static_cast<SetFileInfoMask>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask& operator|=(SetFileInfoMask& lhs, SetFileInfoMask rhs)
  { return (lhs = static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask& operator&=(SetFileInfoMask& lhs, SetFileInfoMask rhs)
  { return (lhs = static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline SetFileInfoMask& operator^=(SetFileInfoMask& lhs, SetFileInfoMask rhs)
  { return (lhs = static_cast<SetFileInfoMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 */
enum MonitorType
{
  MONITOR_FILE,
  MONITOR_DIRECTORY
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum MonitorEventType
{
  MONITOR_EVENT_CHANGED,
  MONITOR_EVENT_DELETED,
  MONITOR_EVENT_STARTEXECUTING,
  MONITOR_EVENT_STOPEXECUTING,
  MONITOR_EVENT_CREATED,
  MONITOR_EVENT_METADATA_CHANGED
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum MimeApplicationArgumentType
{
  APPLICATION_ARGUMENT_TYPE_URIS,
  APPLICATION_ARGUMENT_TYPE_PATHS,
  APPLICATION_ARGUMENT_TYPE_URIS_FOR_NON_FILES
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum MimeActionType
{
  ACTION_TYPE_NONE,
  ACTION_TYPE_APPLICATION,
  ACTION_TYPE_COMPONENT
};


// For the future...
/**
 * @ingroup libgnomevfsmmEnums
 * @par Bitwise operators:
 * <tt>%TransferOptions operator|(TransferOptions, TransferOptions)</tt><br>
 * <tt>%TransferOptions operator&(TransferOptions, TransferOptions)</tt><br>
 * <tt>%TransferOptions operator^(TransferOptions, TransferOptions)</tt><br>
 * <tt>%TransferOptions operator~(TransferOptions)</tt><br>
 * <tt>%TransferOptions& operator|=(TransferOptions&, TransferOptions)</tt><br>
 * <tt>%TransferOptions& operator&=(TransferOptions&, TransferOptions)</tt><br>
 * <tt>%TransferOptions& operator^=(TransferOptions&, TransferOptions)</tt><br>
 */
enum TransferOptions
{
  XFER_DEFAULT = 0,
  XFER_UNUSED_1 = 1 << 0,
  XFER_FOLLOW_LINKS = 1 << 1,
  XFER_UNUSED_2 = 1 << 2,
  XFER_RECURSIVE = 1 << 3,
  XFER_SAMEFS = 1 << 4,
  XFER_DELETE_ITEMS = 1 << 5,
  XFER_EMPTY_DIRECTORIES = 1 << 6,
  XFER_NEW_UNIQUE_DIRECTORY = 1 << 7,
  XFER_REMOVESOURCE = 1 << 8,
  XFER_USE_UNIQUE_NAMES = 1 << 9,
  XFER_LINK_ITEMS = 1 << 10,
  XFER_FOLLOW_LINKS_RECURSIVE = 1 << 11
};

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions operator|(TransferOptions lhs, TransferOptions rhs)
  { return static_cast<TransferOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions operator&(TransferOptions lhs, TransferOptions rhs)
  { return static_cast<TransferOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions operator^(TransferOptions lhs, TransferOptions rhs)
  { return static_cast<TransferOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions operator~(TransferOptions flags)
  { return static_cast<TransferOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions& operator|=(TransferOptions& lhs, TransferOptions rhs)
  { return (lhs = static_cast<TransferOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions& operator&=(TransferOptions& lhs, TransferOptions rhs)
  { return (lhs = static_cast<TransferOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgnomevfsmmEnums */
inline TransferOptions& operator^=(TransferOptions& lhs, TransferOptions rhs)
  { return (lhs = static_cast<TransferOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/**
 * @ingroup libgnomevfsmmEnums
 */
enum ProgressStatus
{
  XFER_PROGRESS_STATUS_OK,
  XFER_PROGRESS_STATUS_VFSERROR,
  XFER_PROGRESS_STATUS_OVERWRITE,
  XFER_PROGRESS_STATUS_DUPLICATE
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum OverwriteMode
{
  XFER_OVERWRITE_MODE_ABORT,
  XFER_OVERWRITE_MODE_QUERY,
  XFER_OVERWRITE_MODE_REPLACE,
  XFER_OVERWRITE_MODE_SKIP
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum OverwriteAction
{
  XFER_OVERWRITE_ACTION_ABORT,
  XFER_OVERWRITE_ACTION_REPLACE,
  XFER_OVERWRITE_ACTION_REPLACE_ALL,
  XFER_OVERWRITE_ACTION_SKIP,
  XFER_OVERWRITE_ACTION_SKIP_ALL
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum ErrorMode
{
  XFER_ERROR_MODE_ABORT,
  XFER_ERROR_MODE_QUERY
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum ErrorAction
{
  XFER_ERROR_ACTION_ABORT,
  XFER_ERROR_ACTION_RETRY,
  XFER_ERROR_ACTION_SKIP
};


/**
 * @ingroup libgnomevfsmmEnums
 */
enum Phase
{
  XFER_PHASE_INITIAL,
  XFER_CHECKING_DESTINATION,
  XFER_PHASE_COLLECTING,
  XFER_PHASE_READYTOGO,
  XFER_PHASE_OPENSOURCE,
  XFER_PHASE_OPENTARGET,
  XFER_PHASE_COPYING,
  XFER_PHASE_MOVING,
  XFER_PHASE_READSOURCE,
  XFER_PHASE_WRITETARGET,
  XFER_PHASE_CLOSESOURCE,
  XFER_PHASE_CLOSETARGET,
  XFER_PHASE_DELETESOURCE,
  XFER_PHASE_SETATTRIBUTES,
  XFER_PHASE_FILECOMPLETED,
  XFER_PHASE_CLEANUP,
  XFER_PHASE_COMPLETED,
  XFER_NUM_PHASES
};


} // namespace Vfs
} // namespace Gnome


#endif /* _LIBGNOMEVFSMM_ENUMS_H */

