#ifndef _GVM_H
#define _GVM_H

/* structure to represent the configuration of the volume manager */
struct gvm_configuration {
	GConfClient *client;

	gboolean automount_drives;
	gboolean automount_media;
	gboolean autorun;
	gchar *autorun_path;

	gboolean autoburn_cdr;
	gchar *autoburn_cdr_command;	

	gboolean autoplay_cda;
	gchar *autoplay_cda_command;

	gboolean autoplay_dvd;
	gchar *autoplay_dvd_command;

	gboolean autophoto;
	gchar *autophoto_command;
};

/* where our settings are rooted in the gconf tree */
#define GCONF_ROOT_SANS_SLASH	"/desktop/gnome/volume_manager"
#define GCONF_ROOT		GCONF_ROOT_SANS_SLASH "/"

#define CLIPBOARD_NAME		"GVM_SELECTION"

extern gboolean gvm_get_clipboard (void);

#endif	/* _GVM_H */
