// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GOOCANVASMM_CANVAS_H
#define _GOOCANVASMM_CANVAS_H


#include <glibmm.h>

/* Copyright (C) 1998-2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <goocanvasmm/item.h>
#include <goocanvasmm/itemmodel.h>
#include <goocanvasmm/itemsimple.h>
#include <goocanvasmm/style.h>
#include <goocanvasmm/widget.h>

#include <gtkmm/adjustment.h>
#include <gtkmm/container.h>
#include <gdkmm/cursor.h>
#include <cairomm/context.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GooCanvas GooCanvas;
typedef struct _GooCanvasClass GooCanvasClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{ class Canvas_Class; } // namespace Goocanvas
namespace Goocanvas
{


class Canvas :
  public Gtk::Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Canvas CppObjectType;
  typedef Canvas_Class CppClassType;
  typedef GooCanvas BaseObjectType;
  typedef GooCanvasClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Canvas();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Canvas_Class;
  static CppClassType canvas_class_;

  // noncopyable
  Canvas(const Canvas&);
  Canvas& operator=(const Canvas&);

protected:
  explicit Canvas(const Glib::ConstructParams& construct_params);
  explicit Canvas(GooCanvas* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GooCanvas*       gobj()       { return reinterpret_cast<GooCanvas*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GooCanvas* gobj() const { return reinterpret_cast<GooCanvas*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_set_scroll_adjustments(Gtk::Adjustment* hadjustment, Gtk::Adjustment* vadjustment);
  virtual void on_item_created(const Glib::RefPtr<Item>& item, const Glib::RefPtr<ItemModel>& model);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  Canvas();

  
  Glib::RefPtr<Item> get_root_item();
  
  Glib::RefPtr<const Item> get_root_item() const;
  
  void set_root_item(const Glib::RefPtr<Item>& item);

  
  Glib::RefPtr<ItemModel> get_root_item_model();
  
  Glib::RefPtr<const ItemModel> get_root_item_model() const;
  
  void set_root_item_model(const Glib::RefPtr<ItemModel>& model);

  
  Glib::RefPtr<Item> get_item(const Glib::RefPtr<ItemModel>& model);
  
  Glib::RefPtr<const Item> get_item(const Glib::RefPtr<ItemModel>& model) const;

  
  Glib::RefPtr<Item> get_item_at(double x, double y, bool is_pointer_event);
  
  Glib::RefPtr<const Item> get_item_at(double x, double y, bool is_pointer_event) const;

  //TODO: Ref the items?
  //TODO: Add const versions
  
  Glib::ListHandle< Glib::RefPtr<Item> > get_items_at(double x, double y, bool is_pointer_event);
  
  Glib::ListHandle< Glib::RefPtr<Item> > get_items_in_area(const Bounds& area, bool inside_area, bool allow_overlaps, bool include_containers) const;

  
  double get_scale() const;
  
  void set_scale(double scale);

  
  void get_bounds(double& left, double& top, double& right, double& bottom) const;
  
  void set_bounds(double left, double top, double right, double bototm);

  
  void scroll_to(double left, double top);

  
  void grab_focus(const Glib::RefPtr<Item>& item);

  
  void render(const Cairo::RefPtr<Cairo::Context>& context, const Bounds& bounds, double scale = 0.0);
  void render(const Cairo::RefPtr<Cairo::Context>& context, double scale = 0.0);

  
  void convert_to_pixels(double& x, double& y) const;
  
  void convert_from_pixels(double& x, double& y) const;
  
  void convert_to_item_space(const Glib::RefPtr<Item>& item, double& x, double& y) const;
  
  void convert_from_item_space(const Glib::RefPtr<Item>& item, double& x, double& y) const;

  //TODO: Use C++ types?
 

  Gdk::GrabStatus pointer_grab(const Glib::RefPtr<Item>& item, Gdk::EventMask mask, const Gdk::Cursor& cursor, guint32 time);
  Gdk::GrabStatus pointer_grab(const Glib::RefPtr<Item>& item, Gdk::EventMask mask, guint32 time);

  
  void pointer_ungrab(const Glib::RefPtr<Item>& item, guint32 time);
  
  GdkGrabStatus keyboard_grab(const Glib::RefPtr<Item>& item, bool owner_events, guint32 time);
  
  void keyboard_ungrab(const Glib::RefPtr<Item>& item, guint32 time);

 
  /**
   * @par Prototype:
   * <tt>void on_my_%set_scroll_adjustments(Gtk::Adjustment* hadjustment, Gtk::Adjustment* vadjustment)</tt>
   */

  Glib::SignalProxy2< void,Gtk::Adjustment*,Gtk::Adjustment* > signal_set_scroll_adjustments();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%item_created(const Glib::RefPtr<Item>& item, const Glib::RefPtr<ItemModel>& model)</tt>
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Item>&,const Glib::RefPtr<ItemModel>& > signal_item_created();


protected:

  
  Cairo::RefPtr<Cairo::Context> create_cairo_context();

  
  Glib::RefPtr<Item> create_item(const Glib::RefPtr<ItemModel>& model);
  
  void unregister_item(const Glib::RefPtr<ItemModel>& model);

  
  void update();
  
  void request_update();
  
  void request_redraw(const Bounds& bounds);
  
  double get_default_line_width() const;

  
  void register_widget_item(const Glib::RefPtr<Goocanvas::Widget>& widget);
  
  void unregister_widget_item(const Glib::RefPtr<Goocanvas::Widget>& widget);


};

}


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Goocanvas::Canvas
   */
  Goocanvas::Canvas* wrap(GooCanvas* object, bool take_copy = false);
} //namespace Glib


#endif /* _GOOCANVASMM_CANVAS_H */

