/* GStreamer - Matroska I/O wrapper
 * Copyright (C) <2003> Ronald Bultje <rbultje@ronald.bitfreak.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_MATROSKA_IO_H__
#define __GST_MATROSKA_IO_H__

#include <gst/gst.h>
#include <gst/gstbytestream.h>
#include <IOCallback.h>

using namespace std;
using namespace LIBEBML_NAMESPACE;

class GstMatroskaIO: public IOCallback {
public:
  /* in case of input */
  GstByteStream *bs;

  /* always */
  GstPad *pad;

  /* are we at the end of the file? */
  gboolean eos;

  /* functions */
  GstMatroskaIO                 (void);
  GstMatroskaIO                 (const char     *path,
		                 const open_mode mode);
  virtual ~GstMatroskaIO        (void);

  virtual uint64 getFilePointer (void);
  virtual void setFilePointer   (int64           offset,
				 seek_mode       mode = seek_beginning);
  virtual uint32 read           (void           *buffer,
				 size_t          size);
  virtual size_t write          (const void     *buffer,
				 size_t          size);
  virtual void close            (void);
  virtual bool eof              (void);
  virtual char *gets            (char           *buffer,
				 size_t          max_size);
  virtual string getline        (void);
  virtual size_t puts_unl       (const char     *s);
};

#endif /* __GST_MATROSKA_IO_H__ */
