/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef CCD_SELECTOR_GROUP_PRIV_H
#define CCD_SELECTOR_GROUP_PRIV_H

#include <stdbool.h>
#include <glib.h>
#include <ccd/ccd-features.h>
#include <ccd/ccd-node.h>
#include <ccd/ccd-selector-group.h>
#include <ccd/ccd-selector.h>
#include <ccd/ccd-style.h>

G_BEGIN_DECLS

void ccd_selector_group_add_selector	(ccd_selector_group_t *self, 
					 ccd_selector_t *selector);
void ccd_selector_group_merge		(ccd_selector_group_t *self,
					 ccd_selector_group_t const *group);
void ccd_selector_group_merge_base	(ccd_selector_group_t *self,
					 ccd_selector_group_t const *group);

GSList const *	ccd_selector_group_get_dangling_selectors	(ccd_selector_group_t const *self);
void		ccd_selector_group_clear_dangling_selectors	(ccd_selector_group_t *self);

bool ccd_selector_group_query_collect (ccd_selector_group_t const *self, 
				       ccd_node_t const *node, 
				       ccd_selector_group_t *result_group,
				       bool as_base);
bool ccd_selector_group_query_apply (ccd_selector_group_t const *self, 
			             ccd_node_t const *node, ccd_style_t *style);

G_END_DECLS

#endif /* CCD_SELECTOR_GROUP_PRIV_H */

