// -*- c++ -*-

/* $Id: interface.cc,v 1.10 2002/01/07 01:22:58 murrayc Exp $ */

/* interface.cc
 *
 * Copyright (C) 1998-2001 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <glibmm/private/interface_p.h>

namespace Glib
{

/* Interface_Class */

GType Interface_Class::get_type()
{
  gtype_ = 0;

  return gtype_;
}

void Interface_Class::iface_init_function(GTypeInterface* iface)
{}

void Interface_Class::class_init_function(GTypeInterface* klass)
{}

/*
//Interfaces don't have real instances - their instance_size is 0.
void Interface_Class::object_init_function(GTypeInterface* gobject)
{}
*/


/* Interface */

Interface::Interface()
{
  //gobject_ will be set in the Object constructor.
  //Any instantiable class that derives from Interface should also inherit from Object.

  // If I understand it correctly, gobject_ shouldn't be 0 now.  daniel.
  // TODO: Make this a g_assert() if the assumption above is correct.
  g_return_if_fail(gobject_ != 0);
}

Interface::Interface(GObject *castitem)
{
  //Store a pointer to this wrapper in the underlying instance,
  //so that we never create a second wrapper for the same underlying instance.
  //Also, specify a callback that will tell us when it's time to delete this C++ wrapper instance:
  ObjectBase::initialize(castitem);
}

Interface::~Interface()
{
}

/*
void Interface::add_interface(GType gtype_implementer)
{
}
*/

Interface::CppClassType Interface::interface_class;


GType Interface::get_type()
{
  return interface_class.get_type();
}

RefPtr<ObjectBase> wrap_interface(GObject* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<ObjectBase>( wrap_auto(object, take_copy) );
}


} //namespace Glib

