
#include <gtkmm/dialog.h>
#include <gtkmm/private/dialog_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: dialog.ccg,v 1.6 2002/03/09 18:10:46 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkdialog.h>

namespace Gtk
{

Dialog::Dialog(const Glib::ustring& title, Gtk::Window& parent, bool modal /* = false */, bool use_separator /* = true */)
: Gtk::Window((GtkWindow*)( g_object_new( get_type() , "title", title.c_str(), 0 ) ))
{
  construct_(modal, use_separator);
  set_transient_for(parent);
}

Dialog::Dialog(const Glib::ustring& title, bool modal /* = false */, bool use_separator /* = true */)
: Gtk::Window((GtkWindow*)( g_object_new( get_type() , "title", title.c_str(), 0 ) ))
{
  construct_(modal, use_separator);
}

void Dialog::construct_(bool modal, bool use_separator)
{
  set_modal(modal);
  set_has_separator(modal);
}


} /* namespace Gtk */


namespace
{


void Dialog_signal_response_callback(GtkDialog*, gint p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,int> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Dialog_signal_response_info =
{
  "response",
  (GCallback) &Dialog_signal_response_callback,
  (GCallback) &Dialog_signal_response_callback
};


const Glib::SignalProxyInfo Dialog_signal_close_info =
{
  "close",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace

// static
GType Glib::Value<Gtk::ResponseType>::value_type()
{
  return gtk_response_type_get_type();
}


namespace Glib
{

Gtk::Dialog* wrap(GtkDialog* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Dialog *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Dialog_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_dialog_get_type(), "gtkmm__Dialog", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Dialog_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->response = &response_callback;
  klass->close = &close_callback;
}


void Dialog_Class::response_callback(GtkDialog* self, gint p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_response(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->response)
      (*base->response)(self, p0);
  }
}

void Dialog_Class::close_callback(GtkDialog* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_close();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->close)
      (*base->close)(self);
  }
}


Glib::ObjectBase* Dialog_Class::wrap_new(GObject* o)
{
  return manage(new Dialog((GtkDialog*)(o)));
}


/* The implementation: */

Dialog::Dialog(GtkDialog* castitem)
: Gtk::Window((GtkWindow*)(castitem))
{}

Dialog::~Dialog()
{
  destroy_();
}

Dialog::CppClassType Dialog::dialog_class_; //Initialize static member.

GType Dialog::get_type()
{
  return dialog_class_.get_type();
}

GType Dialog::get_base_type()
{
  return gtk_dialog_get_type();
}

Dialog::Dialog()
: Gtk::Window((GtkWindow*)(g_object_new(get_type(), (char*)0)))
{}

void Dialog::add_action_widget(Widget& child, int response_id)
{
  gtk_dialog_add_action_widget(gobj(), (child).Gtk::Widget::gobj(), response_id);
}

Widget* Dialog::add_button(const Glib::ustring& button_text, int response_id)
{
  return Glib::wrap(gtk_dialog_add_button(gobj(), button_text.c_str(), response_id));
}

void Dialog::set_response_sensitive(int response_id, bool setting)
{
  gtk_dialog_set_response_sensitive(gobj(), response_id, static_cast<int>(setting));
}

void Dialog::set_default_response(int response_id)
{
  gtk_dialog_set_default_response(gobj(), response_id);
}

void Dialog::set_has_separator(bool setting)
{
  gtk_dialog_set_has_separator(gobj(), static_cast<int>(setting));
}

bool Dialog::get_has_separator() const
{
  return gtk_dialog_get_has_separator(const_cast<GtkDialog*>(gobj()));
}

void Dialog::response(int response_id)
{
  gtk_dialog_response(gobj(), response_id);
}

int Dialog::run()
{
  return gtk_dialog_run(gobj());
}

VBox* Dialog::get_vbox()
{
  return Glib::wrap((GtkVBox*)(gobj()->vbox));
}

const VBox* Dialog::get_vbox() const
{
  return Glib::wrap((GtkVBox*)(gobj()->vbox));
}

HBox* Dialog::get_action_area()
{
  return Glib::wrap((GtkHBox*)(gobj()->action_area));
}

const HBox* Dialog::get_action_area() const
{
  return Glib::wrap((GtkHBox*)(gobj()->action_area));
}


Glib::SignalProxy1<void,int> Dialog::signal_response()
{
  return Glib::SignalProxy1<void,int>(this, &Dialog_signal_response_info);
}

Glib::SignalProxy0<void> Dialog::signal_close()
{
  return Glib::SignalProxy0<void>(this, &Dialog_signal_close_info);
}


Glib::PropertyProxy<bool> Dialog::property_has_separator()
{
  return Glib::PropertyProxy<bool>(this, "has_separator");
}


void Gtk::Dialog::on_response(int response_id)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->response)
    (*base->response)(gobj(),response_id);
}

void Gtk::Dialog::on_close()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->close)
    (*base->close)(gobj());
}


} // namespace Gtk

