// -*- c++ -*-
/* $Id: wrap_init.cc,v 1.2 2002/03/12 21:56:32 daniel Exp $ */

/* wrap_init.cc
 *
 * Copyright 2002 Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/wrap_init.h>
#include <glibmm/convert.h>
#include <glibmm/fileutils.h>
#include <glibmm/shell.h>
#include <glibmm/spawn.h>
#include <glibmm/thread.h>


namespace
{

void throw_convert_error(GError* error)
{
  throw Glib::ConvertError(error);
}

void throw_file_error(GError* error)
{
  throw Glib::FileError(error);
}

void throw_shell_error(GError* error)
{
  throw Glib::ShellError(error);
}

void throw_spawn_error(GError* error)
{
  throw Glib::SpawnError(error);
}

void throw_thread_error(GError* error)
{
  throw Glib::ThreadError(error);
}

} // anonymous namespace


void Glib::wrap_init()
{
  Glib::Error::register_domain(g_convert_error_quark(), &throw_convert_error);
  Glib::Error::register_domain(g_file_error_quark(), &throw_file_error);
  Glib::Error::register_domain(g_shell_error_quark(), &throw_shell_error);
  Glib::Error::register_domain(g_spawn_error_quark(), &throw_spawn_error);
  Glib::Error::register_domain(g_thread_error_quark(), &throw_thread_error);
}

