
#include <gtkmm/frame.h>
#include <gtkmm/private/frame_p.h>

// -*- c++ -*-
/* $Id: frame.ccg,v 1.11 2001/12/19 07:31:20 kenelson Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkframe.h>

namespace Gtk
{

Frame::Frame()
:
  Gtk::Bin(reinterpret_cast<GtkBin*>(g_object_new(get_type(), "label", 0, 0)))
{
}

void Frame::remove_label()
{
  gtk_frame_set_label(gobj(), 0);
}

} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Frame* wrap(GtkFrame* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Frame *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Frame_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_frame_get_type(), "gtkmm__Frame", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Frame_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->compute_child_allocation = &compute_child_allocation_vfunc_callback;
}


void Frame_Class::compute_child_allocation_vfunc_callback(GtkFrame* self, GtkAllocation* allocation)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->compute_child_allocation(allocation);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->compute_child_allocation)
      (*base->compute_child_allocation)(self, allocation);
  }
}


Glib::ObjectBase* Frame_Class::wrap_new(GObject* o)
{
  return manage(new Frame((GtkFrame*)(o)));
}


/* The implementation: */

Frame::Frame(GtkFrame* castitem)
: Gtk::Bin((GtkBin*)(castitem))
{}

Frame::~Frame()
{
  destroy_();
}

Frame::CppClassType Frame::frame_class_; //Initialize static member.

GType Frame::get_type()
{
  return frame_class_.get_type();
}

GType Frame::get_base_type()
{
  return gtk_frame_get_type();
}

Frame::Frame(const Glib::ustring& label)
: Gtk::Bin((GtkBin*)( g_object_new(get_type(), "label", label.c_str(), (char*)0) ))
{}

void Frame::set_label(const Glib::ustring& str)
{
  gtk_frame_set_label(gobj(), str.c_str());
}

Glib::ustring Frame::get_label() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_frame_get_label(const_cast<GtkFrame*>(gobj())));
}

void Frame::set_label_widget(Widget& label_widget)
{
  gtk_frame_set_label_widget(gobj(), (label_widget).Gtk::Widget::gobj());
}

Widget* Frame::get_label_widget()
{
  return Glib::wrap(gtk_frame_get_label_widget(gobj()));
}

void Frame::set_label_align(float xalign, float yalign)
{
  gtk_frame_set_label_align(gobj(), xalign, yalign);
}

void Frame::get_label_align(float& xalign, float& yalign)
{
  gtk_frame_get_label_align(gobj(), &(xalign), &(yalign));
}

void Frame::set_shadow_type(ShadowType type)
{
  gtk_frame_set_shadow_type(gobj(), ((GtkShadowType)(type)));
}

ShadowType Frame::get_shadow_type() const
{
  return ((ShadowType)(gtk_frame_get_shadow_type(const_cast<GtkFrame*>(gobj()))));
}


Glib::PropertyProxy<Glib::ustring> Frame::property_label()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "label");
}

Glib::PropertyProxy<double> Frame::property_label_xalign()
{
  return Glib::PropertyProxy<double>(this, "label_xalign");
}

Glib::PropertyProxy<double> Frame::property_label_yalign()
{
  return Glib::PropertyProxy<double>(this, "label_yalign");
}

Glib::PropertyProxy<ShadowType> Frame::property_shadow_type()
{
  return Glib::PropertyProxy<ShadowType>(this, "shadow_type");
}

Glib::PropertyProxy<Widget*> Frame::property_label_widget()
{
  return Glib::PropertyProxy<Widget*>(this, "label_widget");
}


void Gtk::Frame::compute_child_allocation(GtkAllocation * allocation)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->compute_child_allocation)
    (*base->compute_child_allocation)(gobj(),allocation);
}


} // namespace Gtk

