
#include <gtkmm/range.h>
#include <gtkmm/private/range_p.h>

// -*- c++ -*-
/* $Id: range.ccg,v 1.5 2001/11/11 02:34:25 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkrange.h>
#include <gtkmm/adjustment.h>

namespace Gtk
{

void Range::remove_adjustment()
{
  gtk_range_set_adjustment(gobj(), 0);
}

} /* namespace Gtk */


namespace
{

const Glib::SignalProxyInfo Range_signal_value_changed_info =
{
  "value_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void Range_signal_adjust_bounds_callback(GtkRange*, gdouble p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,gdouble> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Range_signal_adjust_bounds_info =
{
  "adjust_bounds",
  (GCallback) &Range_signal_adjust_bounds_callback,
  (GCallback) &Range_signal_adjust_bounds_callback
};


void Range_signal_move_slider_callback(GtkRange*, GtkScrollType p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,ScrollType> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (((ScrollType)(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Range_signal_move_slider_info =
{
  "move_slider",
  (GCallback) &Range_signal_move_slider_callback,
  (GCallback) &Range_signal_move_slider_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Range* wrap(GtkRange* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Range *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Range_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_range_get_type(), "gtkmm__Range", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Range_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->get_range_border = &get_range_border_vfunc_callback;
  klass->value_changed = &value_changed_callback;
  klass->adjust_bounds = &adjust_bounds_callback;
  klass->move_slider = &move_slider_callback;
}


void Range_Class::get_range_border_vfunc_callback(GtkRange* self, GtkBorder* border)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->get_range_border(border);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->get_range_border)
      (*base->get_range_border)(self, border);
  }
}


void Range_Class::value_changed_callback(GtkRange* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_value_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->value_changed)
      (*base->value_changed)(self);
  }
}

void Range_Class::adjust_bounds_callback(GtkRange* self, gdouble p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_adjust_bounds(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->adjust_bounds)
      (*base->adjust_bounds)(self, p0);
  }
}

void Range_Class::move_slider_callback(GtkRange* self, GtkScrollType p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_move_slider(((ScrollType)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->move_slider)
      (*base->move_slider)(self, p0);
  }
}


Glib::ObjectBase* Range_Class::wrap_new(GObject* o)
{
  return manage(new Range((GtkRange*)(o)));
}


/* The implementation: */

Range::Range(GtkRange* castitem)
: Gtk::Widget((GtkWidget*)(castitem))
{}

Range::~Range()
{
  destroy_();
}

Range::CppClassType Range::range_class_; //Initialize static member.

GType Range::get_type()
{
  return range_class_.get_type();
}

GType Range::get_base_type()
{
  return gtk_range_get_type();
}

Range::Range()
: Gtk::Widget((GtkWidget*)(g_object_new(get_type(), (char*)0)))
{}

void Range::set_update_policy(UpdateType policy)
{
  gtk_range_set_update_policy(gobj(), ((GtkUpdateType)(policy)));
}

UpdateType Range::get_update_policy() const
{
  return ((UpdateType)(gtk_range_get_update_policy(const_cast<GtkRange*>(gobj()))));
}

void Range::set_adjustment(Gtk::Adjustment& adjustment)
{
  gtk_range_set_adjustment(gobj(), (adjustment).gobj());
}

Gtk::Adjustment* Range::get_adjustment()
{
  return Glib::wrap(gtk_range_get_adjustment(gobj()));
}

void Range::set_inverted(bool setting)
{
  gtk_range_set_inverted(gobj(), static_cast<int>(setting));
}

bool Range::get_inverted() const
{
  return gtk_range_get_inverted(const_cast<GtkRange*>(gobj()));
}

void Range::set_increments(double step, double page)
{
  gtk_range_set_increments(gobj(), step, page);
}

void Range::set_range(double min, double max)
{
  gtk_range_set_range(gobj(), min, max);
}

void Range::set_value(double value)
{
  gtk_range_set_value(gobj(), value);
}

double Range::get_value() const
{
  return gtk_range_get_value(const_cast<GtkRange*>(gobj()));
}


Glib::SignalProxy0<void> Range::signal_value_changed()
{
  return Glib::SignalProxy0<void>(this, &Range_signal_value_changed_info);
}

Glib::SignalProxy1<void,gdouble> Range::signal_adjust_bounds()
{
  return Glib::SignalProxy1<void,gdouble>(this, &Range_signal_adjust_bounds_info);
}

Glib::SignalProxy1<void,ScrollType> Range::signal_move_slider()
{
  return Glib::SignalProxy1<void,ScrollType>(this, &Range_signal_move_slider_info);
}


Glib::PropertyProxy<UpdateType> Range::property_update_policy()
{
  return Glib::PropertyProxy<UpdateType>(this, "update_policy");
}

Glib::PropertyProxy<Adjustment*> Range::property_adjustment()
{
  return Glib::PropertyProxy<Adjustment*>(this, "adjustment");
}

Glib::PropertyProxy<bool> Range::property_inverted()
{
  return Glib::PropertyProxy<bool>(this, "inverted");
}


void Gtk::Range::on_value_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->value_changed)
    (*base->value_changed)(gobj());
}

void Gtk::Range::on_adjust_bounds(gdouble new_value)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->adjust_bounds)
    (*base->adjust_bounds)(gobj(),new_value);
}

void Gtk::Range::on_move_slider(ScrollType scroll)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->move_slider)
    (*base->move_slider)(gobj(),((GtkScrollType)(scroll)));
}


void Gtk::Range::get_range_border(GtkBorder* border)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->get_range_border)
    (*base->get_range_border)(gobj(),border);
}


} // namespace Gtk

