
#include <gtkmm/scrollbar.h>
#include <gtkmm/private/scrollbar_p.h>

// -*- c++ -*-
/* $Id: scrollbar.ccg,v 1.5 2001/11/11 02:34:25 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/adjustment.h>

#include <gtk/gtkscrollbar.h>
#include <gtk/gtkhscrollbar.h>
#include <gtk/gtkvscrollbar.h>

namespace Gtk
{

VScrollbar::VScrollbar(Adjustment& adjustment)
: Scrollbar((GtkScrollbar*)(g_object_new(get_type(),0)))
{
  set_adjustment(adjustment);
}

VScrollbar::VScrollbar()
: Scrollbar((GtkScrollbar*)(g_object_new(get_type(),0)))
{
  Adjustment* adjustment = manage(new Adjustment(0.0, 0.0, 0.0,
						  0.0, 0.0, 0.0));
  // The adjustment will be destroyed along with the object
  set_adjustment(*adjustment);
}


HScrollbar::HScrollbar()
:  Scrollbar((GtkScrollbar*)(g_object_new(get_type(),0)))
{
  Adjustment* adjustment = manage(new Adjustment(0.0, 0.0, 0.0,
						  0.0, 0.0, 0.0));

  // The adjustment will be destroyed along with the object
  set_adjustment(*adjustment);
}

HScrollbar::HScrollbar(Adjustment& adjustment)
:  Scrollbar((GtkScrollbar*)(g_object_new(get_type(),0)))
{
  set_adjustment(adjustment);
}


} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Scrollbar* wrap(GtkScrollbar* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Scrollbar *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Scrollbar_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_scrollbar_get_type(), "gtkmm__Scrollbar", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Scrollbar_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Scrollbar_Class::wrap_new(GObject* o)
{
  return manage(new Scrollbar((GtkScrollbar*)(o)));
}


/* The implementation: */

Scrollbar::Scrollbar(GtkScrollbar* castitem)
: Gtk::Range((GtkRange*)(castitem))
{}

Scrollbar::~Scrollbar()
{
  destroy_();
}

Scrollbar::CppClassType Scrollbar::scrollbar_class_; //Initialize static member.

GType Scrollbar::get_type()
{
  return scrollbar_class_.get_type();
}

GType Scrollbar::get_base_type()
{
  return gtk_scrollbar_get_type();
}


} // namespace Gtk


namespace Glib
{

Gtk::VScrollbar* wrap(GtkVScrollbar* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::VScrollbar *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType VScrollbar_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_vscrollbar_get_type(), "gtkmm__VScrollbar", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void VScrollbar_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* VScrollbar_Class::wrap_new(GObject* o)
{
  return manage(new VScrollbar((GtkVScrollbar*)(o)));
}


/* The implementation: */

VScrollbar::VScrollbar(GtkVScrollbar* castitem)
: Gtk::Scrollbar((GtkScrollbar*)(castitem))
{}

VScrollbar::~VScrollbar()
{
  destroy_();
}

VScrollbar::CppClassType VScrollbar::vscrollbar_class_; //Initialize static member.

GType VScrollbar::get_type()
{
  return vscrollbar_class_.get_type();
}

GType VScrollbar::get_base_type()
{
  return gtk_vscrollbar_get_type();
}


} // namespace Gtk


namespace Glib
{

Gtk::HScrollbar* wrap(GtkHScrollbar* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::HScrollbar *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType HScrollbar_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_hscrollbar_get_type(), "gtkmm__HScrollbar", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void HScrollbar_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* HScrollbar_Class::wrap_new(GObject* o)
{
  return manage(new HScrollbar((GtkHScrollbar*)(o)));
}


/* The implementation: */

HScrollbar::HScrollbar(GtkHScrollbar* castitem)
: Gtk::Scrollbar((GtkScrollbar*)(castitem))
{}

HScrollbar::~HScrollbar()
{
  destroy_();
}

HScrollbar::CppClassType HScrollbar::hscrollbar_class_; //Initialize static member.

GType HScrollbar::get_type()
{
  return hscrollbar_class_.get_type();
}

GType HScrollbar::get_base_type()
{
  return gtk_hscrollbar_get_type();
}


} // namespace Gtk

