
#include <gtkmm/treedragdest.h>
#include <gtkmm/private/treedragdest_p.h>

// -*- c++ -*-
/* $Id: treedragdest.ccg,v 1.1 2002/03/22 14:15:38 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Gtk
{

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::TreeDragDest> wrap(GtkTreeDragDest* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::TreeDragDest>( dynamic_cast<Gtk::TreeDragDest*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType TreeDragDest_Class::get_type()
{
  if (!gtype_) //Create the GType if necessary.
    {
      //Make sure that the parent type has been created:
      CppClassParent::CppObjectType::get_type();

      //Get the size of the base C class:
      GType gtype_base = gtk_tree_drag_dest_get_type();
      gtype_ = gtype_base; //We can not derive from another interface.
/*
      GTypeQuery typeQueryBase = {0 ,};
      g_type_query(gtype_base, &typeQueryBase);

      //Create a derived C type.
      //These init funcs will, in turn, call the init functions in the base C type.
      GTypeInfo info =
        {
          typeQueryBase.class_size, // class_size
          (GBaseInitFunc) 0, // base_init *
          (GBaseFinalizeFunc) 0, // base_finalize
          (GClassInitFunc) class_init_function, // class_init
          0, // class_finalize
          0, // class_data
          typeQueryBase.instance_size, // instance_size
          0, // n_preallocs
          (GInstanceInitFunc) object_init_function // instance_init
        };

      gtype_ = g_type_register_static(gtype_base, "gtkmm__TreeDragDest", &info, GTypeFlags(0));
*/
    }
  return gtype_;
}

void TreeDragDest_Class::iface_init_function(BaseClassType* iface)
{
  CppClassParent::iface_init_function((GTypeInterface*)iface);
  BaseClassType* klass = iface; //Allows us to reuse generated code from GObject wrappers.
   klass->drag_data_received = &drag_data_received_vfunc_callback;
  klass->row_drop_possible = &row_drop_possible_vfunc_callback;
 }

void TreeDragDest_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((GTypeInterface*)klass);
}

void TreeDragDest_Class::object_init_function(BaseObjectType* object)
{
}

gboolean TreeDragDest_Class::drag_data_received_vfunc_callback(GtkTreeDragDest* self, GtkTreePath* dest, GtkSelectionData* selection_data)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->drag_data_received_vfunc(dest, selection_data);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->drag_data_received)
      (*base->drag_data_received)(self, dest, selection_data);
  }

  typedef gboolean RType;
  return RType();
}

gboolean TreeDragDest_Class::row_drop_possible_vfunc_callback(GtkTreeDragDest* self, GtkTreePath* dest_path, GtkSelectionData* selection_data)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->row_drop_possible_vfunc(dest_path, selection_data);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
));
    g_assert(base != 0);

    if(base->row_drop_possible)
      (*base->row_drop_possible)(self, dest_path, selection_data);
  }

  typedef gboolean RType;
  return RType();
}


Glib::ObjectBase* TreeDragDest_Class::wrap_new(GObject* o)
{
  return new TreeDragDest((GtkTreeDragDest*)(o));
}


/* The implementation: */

TreeDragDest::TreeDragDest(GtkTreeDragDest* castitem)
: Glib::Interface((GObject*)(castitem))
{}

TreeDragDest::~TreeDragDest()
{
}

/*
GtkTreeDragDest* TreeDragDest::gobj_copy()
{
  reference();
  return gobj();
}
*/

Glib::RefPtr<TreeDragDest> TreeDragDest::wrap_specific_type(GtkTreeDragDest* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<TreeDragDest> refPtr;
  //Check for an existing wrapper:
  TreeDragDest* pCppObject = dynamic_cast<TreeDragDest*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
  if(pCppObject)
  {
    //Return the existing wrapper:
    refPtr = Glib::RefPtr<TreeDragDest>(pCppObject);
  }
  else
  {
    //Create a new wrapper:
    refPtr = Glib::RefPtr<TreeDragDest>( new TreeDragDest(gobject) );
  }

  if(take_copy)
    refPtr->reference();

  return refPtr;
}

TreeDragDest::TreeDragDest()
{
}


void TreeDragDest::add_interface(GType gtype_implementer) //static
{
  static const GInterfaceInfo iface_info =
  {
	  (GInterfaceInitFunc)CppClassType::iface_init_function,
	  NULL,
	  NULL
  };

  g_type_add_interface_static(
    gtype_implementer,
    get_type(), //interface_type: whose direct parent type must be G_TYPE_INTERFACE
    &iface_info
  );
}

TreeDragDest::CppClassType TreeDragDest::treedragdest_class_; //Initialize static member.

GType TreeDragDest::get_type()
{
  return treedragdest_class_.get_type();
}

GType TreeDragDest::get_base_type()
{
  return gtk_tree_drag_dest_get_type();
}


gboolean Gtk::TreeDragDest::drag_data_received_vfunc(GtkTreePath* dest, GtkSelectionData* selection_data)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->drag_data_received)
    return (*base->drag_data_received)(gobj(),dest,selection_data);

  typedef gboolean RType;
  return RType();
}

gboolean Gtk::TreeDragDest::row_drop_possible_vfunc(GtkTreePath* dest_path, GtkSelectionData* selection_data)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface.
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
));
  g_assert(base != 0);

  if(base->row_drop_possible)
    return (*base->row_drop_possible)(gobj(),dest_path,selection_data);

  typedef gboolean RType;
  return RType();
}

bool Gtk::TreeDragDest::drag_data_received(const TreePath& dest, GtkSelectionData* selection_data)
{
  return drag_data_received_vfunc(const_cast<GtkTreePath*>((dest).gobj()), selection_data);
 }

bool Gtk::TreeDragDest::row_drop_possible(const TreePath& dest_path, GtkSelectionData* selection_data)
{
  return row_drop_possible_vfunc(const_cast<GtkTreePath*>((dest_path).gobj()), selection_data);
 }

;

} // namespace Gtk

