
#include <pangomm/layoutiter.h>
#include <pangomm/private/layoutiter_p.h>

// -*- c++ -*-
/* $Id: layoutiter.ccg,v 1.2 2002/03/26 18:43:34 daniel Exp $ */

/*
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Pango
{

LayoutIter::LayoutIter()
:
  gobject_ (0)
{}

LayoutIter::~LayoutIter()
{
  if(gobject_)
    pango_layout_iter_free(gobject_);
}

void LayoutIter::assign_gobj(PangoLayoutIter* src)
{
  if(src != gobject_)
  {
    if(gobject_)
      pango_layout_iter_free(gobject_);

    gobject_ = src;
  }
}

} // namespace Pango


namespace
{
} // anonymous namespace


namespace Pango
{


int LayoutIter::get_index()
{
  return pango_layout_iter_get_index(gobj());
}

PangoLayoutRun* LayoutIter::get_run()
{
  return pango_layout_iter_get_run(gobj());
}

Glib::RefPtr<LayoutLine> LayoutIter::get_line()
{
  return Glib::wrap(pango_layout_iter_get_line(gobj()));
}

bool LayoutIter::at_last_line() const
{
  return pango_layout_iter_at_last_line(const_cast<PangoLayoutIter*>(gobj()));
}

bool LayoutIter::next_char()
{
  return pango_layout_iter_next_char(gobj());
}

bool LayoutIter::next_cluster()
{
  return pango_layout_iter_next_cluster(gobj());
}

bool LayoutIter::next_run()
{
  return pango_layout_iter_next_run(gobj());
}

bool LayoutIter::next_line()
{
  return pango_layout_iter_next_line(gobj());
}

void LayoutIter::get_char_extents(PangoRectangle& logical_rect) const
{
  pango_layout_iter_get_char_extents(const_cast<PangoLayoutIter*>(gobj()), &logical_rect);
}

void LayoutIter::get_cluster_extents(PangoRectangle& ink_rect, PangoRectangle& logical_rect) const
{
  pango_layout_iter_get_cluster_extents(const_cast<PangoLayoutIter*>(gobj()), &ink_rect, &logical_rect);
}

void LayoutIter::get_run_extents(PangoRectangle& ink_rect, PangoRectangle& logical_rect) const
{
  pango_layout_iter_get_run_extents(const_cast<PangoLayoutIter*>(gobj()), &ink_rect, &logical_rect);
}

void LayoutIter::get_line_extents(PangoRectangle& ink_rect, PangoRectangle& logical_rect) const
{
  pango_layout_iter_get_line_extents(const_cast<PangoLayoutIter*>(gobj()), &ink_rect, &logical_rect);
}

void LayoutIter::get_line_yrange(int& y0, int& y1) const
{
  pango_layout_iter_get_line_yrange(const_cast<PangoLayoutIter*>(gobj()), &y0, &y1);
}

void LayoutIter::get_layout_extents(PangoRectangle& ink_rect, PangoRectangle& logical_rect) const
{
  pango_layout_iter_get_layout_extents(const_cast<PangoLayoutIter*>(gobj()), &ink_rect, &logical_rect);
}

int LayoutIter::get_baseline() const
{
  return pango_layout_iter_get_baseline(const_cast<PangoLayoutIter*>(gobj()));
}


} // namespace Pango

