
#include <atkmm/relationset.h>
#include <atkmm/private/relationset_p.h>

// -*- c++ -*-
/* $Id: relationset.ccg,v 1.1 2002/02/24 15:27:17 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Atk::RelationSet> wrap(AtkRelationSet* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Atk::RelationSet>( dynamic_cast<Atk::RelationSet*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Atk
{


/* The *_Class implementation: */

GType RelationSet_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(atk_relation_set_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void RelationSet_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* RelationSet_Class::wrap_new(GObject* o)
{
  return new RelationSet((AtkRelationSet*)(o));
}


/* The implementation: */

AtkRelationSet* RelationSet::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<RelationSet> RelationSet::wrap_specific_type(AtkRelationSet* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<RelationSet> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    RelationSet* pCppObject = dynamic_cast<RelationSet*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<RelationSet>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<RelationSet>( new RelationSet(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

RelationSet::RelationSet(AtkRelationSet* castitem)
: Glib::Object((GObject*)(castitem))
{}

RelationSet::~RelationSet()
{
}

RelationSet::CppClassType RelationSet::relationset_class_; //Initialize static member.

GType RelationSet::get_type()
{
  return relationset_class_.get_type();
}

GType RelationSet::get_base_type()
{
  return atk_relation_set_get_type();
}

RelationSet::RelationSet()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<RelationSet> RelationSet::create()
{
  return Glib::RefPtr<RelationSet>( new RelationSet() );
}
bool RelationSet::set_contains(RelationType relationship)
{
  return atk_relation_set_contains(gobj(), ((AtkRelationType)(relationship)));
}

void RelationSet::set_remove(const Glib::RefPtr<Relation>& relation)
{
  atk_relation_set_remove(gobj(), (relation)->gobj());
}

void RelationSet::set_add(const Glib::RefPtr<Relation>& relation)
{
  atk_relation_set_add(gobj(), (relation)->gobj());
}

int RelationSet::get_n_relations() const
{
  return atk_relation_set_get_n_relations(const_cast<AtkRelationSet*>(gobj()));
}

Glib::RefPtr<Relation> RelationSet::get_relation(gint i)
{
  Glib::RefPtr<Relation> retvalue = Glib::wrap(atk_relation_set_get_relation(gobj(), i));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Relation> RelationSet::get_relation(RelationType relationship)
{
  Glib::RefPtr<Relation> retvalue = Glib::wrap(atk_relation_set_get_relation_by_type(gobj(), ((AtkRelationType)(relationship))));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}


} // namespace Atk

