
#include <stdio.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <gtkmm/main.h>
#include <gtkmm/toolbar.h>
#include <gtkmm/button.h>
#include <gtkmm/togglebutton.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/box.h>
#include <gtkmm/window.h>

using namespace SigC;

class MainWindowClass : public Gtk::Window
{
public:
  MainWindowClass ();
  virtual ~MainWindowClass ();

private:
  Gtk::HBox main_hbox;
  Gtk::HBox hbox;
  Gtk::Button button;
  Gtk::Toolbar toolbar;
  
  void quit_pressed_cb();
  void toolbar_button_cb(const char*);
};

void MainWindowClass::toolbar_button_cb(const char* c)
{
  printf("toolbar_button_cb : %s\n", c);
}

MainWindowClass::MainWindowClass()
:  button("Quit")
{

  set_size_request(400,50);
  
  add(main_hbox);

  main_hbox.add(hbox);
  
  hbox.pack_start(button,false,false,0);
  hbox.pack_start(toolbar,false,false,0);

  button.signal_clicked().connect(
      slot(*this, &MainWindowClass::quit_pressed_cb));

  {
  using namespace Gtk::Toolbar_Helpers;
  toolbar.tools().push_back(ButtonElem( "Click me", 
    bind(slot(*this, &MainWindowClass::toolbar_button_cb),
    "'Click me' button"),
    "toolbar btn",""));
  toolbar.tools().push_back(Space());

  toolbar.tools().push_back(ButtonElem( "Click me too", 
    bind(slot(*this, &MainWindowClass::toolbar_button_cb),
    "'Click me too' button"),
    "other toolbar btn", ""));

  toolbar.tools().push_back(ToggleElem( "Toggle me", 
    bind(slot(*this, &MainWindowClass::toolbar_button_cb), 
    "This is from a toggle connector"),
    "toggle duh", ""));

  Gtk::RadioButton::Group gr;
  toolbar.tools().push_back(RadioElem(gr,"R1"));
  toolbar.tools().push_back(RadioElem(gr,"R2"));
  toolbar.tools().push_back(RadioElem(gr,"R3"));
  }

  toolbar.show();
  button.show();
  hbox.show();
  main_hbox.show();
}

MainWindowClass::~MainWindowClass()
{}

void MainWindowClass::quit_pressed_cb()
{
  hide();
}

int main(gint argc, gchar **argv)
{
  Gtk::Main kit(argc,argv);
  MainWindowClass main_window;
  
  kit.run(main_window);

  return(0);
}
