
#include <gtkmm/notebook.h>
#include <gtkmm/private/notebook_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: notebook.ccg,v 1.10 2002/04/02 13:25:18 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtknotebook.h>
#include <gtk/gtklabel.h>

namespace Gtk
{

Notebook::Page* Notebook::get_current() const
{
   return reinterpret_cast<Notebook::Page*>(gobj()->cur_page);
}

Widget*
Notebook::get_current_child()
{
  GtkNotebookPage* page = gobj()->cur_page;
  return Glib::wrap(GTK_WIDGET(page->child));
}

namespace Notebook_Helpers
{

/*********************************************************************
***** Page Properties
*********************************************************************/

Widget* Page::get_child()
{
 return Glib::wrap(gobj()->child);
}

bool Page::get_expand()
{
  return gobj()->expand;
}

bool Page::get_fill()
{
  return gobj()->fill;
}

PackType Page::get_pack()
{
  return PackType(gobj()->pack);
}

Widget* Page::get_tab()
{
  if (gobj()->default_tab) return 0;
  return Glib::wrap(gobj()->tab_label);
}

Widget* Page::get_menu()
{
  if (gobj()->default_menu) return 0;
  return Glib::wrap(gobj()->menu_label);
}

void Page::set_tab (Widget* tab)
{
  gtk_notebook_set_tab_label(parent(),gobj()->child,(tab?tab->gobj():0));
}

void Page::set_tab (Widget& tab)
{
  gtk_notebook_set_tab_label(parent(),gobj()->child,tab.gobj());
}

Glib::ustring Page::get_tab_text()
{
  GtkWidget* w=gtk_notebook_get_tab_label(parent(),gobj()->child);
  char *s=0;
  if (w&& GTK_IS_LABEL(w))
    s=GTK_LABEL(w)->text;
  if (s) return s;
  return "";
}

void Page::set_tab_text(const Glib::ustring& str)
{
  gtk_notebook_set_tab_label_text(parent(),gobj()->child,str.c_str());
}

void Page::remove_tab_text()
{
  gtk_notebook_set_tab_label_text(parent(),gobj()->child,0);
}

void Page::set_menu(Widget* menu)
{
  gtk_notebook_set_menu_label(parent(),gobj()->child,(menu?menu->gobj():0));
}

void Page::set_menu(Widget& menu)
{
  gtk_notebook_set_menu_label(parent(),gobj()->child,menu.gobj());
}

void Page::set_tab_packing(bool expand,bool fill,PackType pack_type)
{
  gtk_notebook_set_tab_label_packing(parent(), gobj()->child, expand, fill, (GtkPackType)pack_type);
}

/*********************************************************************
***** List properties
*********************************************************************/
typedef PageList::iterator page_iterator;

page_iterator PageList::insert(page_iterator position,const Element& e)
{
  int pos;

  // locate the items desired position
  if (!position.node)
    pos=-1;
  else
    pos=g_list_position(glist(),position.node);

  // give item to gtk+
  gtk_notebook_insert_page_menu(
                             gparent(),
                             ((e.child_)?e.child_->gobj():0),
                             ((e.tab_)?e.tab_->gobj():0),
                             ((e.menu_)?e.menu_->gobj():0),
                             pos);

  // return the right iterator
  if (pos==0)
    return begin();
  if (!position.node)
    return --end();
  return --position;
}

void PageList::reorder(page_iterator pos,page_iterator page)
{
  int position = g_list_position(glist(), pos.node);
  gtk_notebook_reorder_child(gparent(), (*page)->gobj()->child,position);
}

} /* namespace Notebook_Helpers */

Notebook::PageList& Notebook::pages()
{
  pages_proxy_ = PageList(gobj());
  return pages_proxy_;
}

const Notebook::PageList& Notebook::pages() const
{
  pages_proxy_ = PageList(const_cast<GtkNotebook*>(gobj()));
  return pages_proxy_;
}

} //namespace Gtk


namespace
{


void Notebook_signal_switch_page_callback(GtkNotebook*, GtkNotebookPage* p0,guint p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,GtkNotebookPage*,guint> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0,p1, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Notebook_signal_switch_page_info =
{
  "switch_page",
  (GCallback) &Notebook_signal_switch_page_callback,
  (GCallback) &Notebook_signal_switch_page_callback
};


gboolean Notebook_signal_select_page_callback(GtkNotebook*, gboolean p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<bool,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Notebook_signal_select_page_notify_callback(GtkNotebook*, gboolean p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Notebook_signal_select_page_info =
{
  "select_page",
  (GCallback) &Notebook_signal_select_page_callback,
  (GCallback) &Notebook_signal_select_page_notify_callback
};


gboolean Notebook_signal_focus_tab_callback(GtkNotebook*, GtkNotebookTab p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<bool,NotebookTab> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (((NotebookTab)(p0))
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Notebook_signal_focus_tab_notify_callback(GtkNotebook*, GtkNotebookTab p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,NotebookTab> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (((NotebookTab)(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Notebook_signal_focus_tab_info =
{
  "focus_tab",
  (GCallback) &Notebook_signal_focus_tab_callback,
  (GCallback) &Notebook_signal_focus_tab_notify_callback
};


void Notebook_signal_change_current_page_callback(GtkNotebook*, gint p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,int> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Notebook_signal_change_current_page_info =
{
  "change_current_page",
  (GCallback) &Notebook_signal_change_current_page_callback,
  (GCallback) &Notebook_signal_change_current_page_callback
};


void Notebook_signal_move_focus_out_callback(GtkNotebook*, GtkDirectionType p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,DirectionType> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (((DirectionType)(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Notebook_signal_move_focus_out_info =
{
  "move_focus_out",
  (GCallback) &Notebook_signal_move_focus_out_callback,
  (GCallback) &Notebook_signal_move_focus_out_callback
};

} // anonymous namespace

// static
GType Glib::Value<Gtk::NotebookTab>::value_type()
{
  return gtk_notebook_tab_get_type();
}


namespace Glib
{

Gtk::Notebook* wrap(GtkNotebook* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Notebook *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Notebook_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_notebook_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Notebook_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->switch_page = &switch_page_callback;
  klass->select_page = &select_page_callback;
  klass->focus_tab = &focus_tab_callback;
  klass->change_current_page = &change_current_page_callback;
  klass->move_focus_out = &move_focus_out_callback;
}


void Notebook_Class::switch_page_callback(GtkNotebook* self, GtkNotebookPage* p0, guint p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_switch_page(p0, p1);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->switch_page)
      (*base->switch_page)(self, p0, p1);
  }
}

gboolean Notebook_Class::select_page_callback(GtkNotebook* self, gboolean p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_select_page(p0
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->select_page)
      (*base->select_page)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

gboolean Notebook_Class::focus_tab_callback(GtkNotebook* self, GtkNotebookTab p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_focus_tab(((NotebookTab)(p0))
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->focus_tab)
      (*base->focus_tab)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

void Notebook_Class::change_current_page_callback(GtkNotebook* self, gint p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_change_current_page(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->change_current_page)
      (*base->change_current_page)(self, p0);
  }
}

void Notebook_Class::move_focus_out_callback(GtkNotebook* self, GtkDirectionType p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_move_focus_out(((DirectionType)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->move_focus_out)
      (*base->move_focus_out)(self, p0);
  }
}


Glib::ObjectBase* Notebook_Class::wrap_new(GObject* o)
{
  return manage(new Notebook((GtkNotebook*)(o)));
}


/* The implementation: */

Notebook::Notebook(GtkNotebook* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

Notebook::~Notebook()
{
  destroy_();
}

Notebook::CppClassType Notebook::notebook_class_; //Initialize static member.

GType Notebook::get_type()
{
  return notebook_class_.get_type();
}

GType Notebook::get_base_type()
{
  return gtk_notebook_get_type();
}


namespace Notebook_Helpers
{

void PageList::remove(const_reference child)
{
  g_return_if_fail(child != 0);
  gtk_container_remove(GTK_CONTAINER(gparent_),
                       (GtkWidget*)(child->get_child()->gobj()));
}

void PageList::remove(Widget &w)
{
  gtk_container_remove(GTK_CONTAINER(gparent_), (GtkWidget*)(w.gobj()));
}

PageList::iterator PageList::erase(iterator position)
{
  if ( !position.node || (position == end()) )
    return end();

  iterator next = position;
  next++;

  gtk_container_remove(GTK_CONTAINER(gparent_),
      (GtkWidget*)((*position)->get_child()->gobj()));
  return next;
}

} /* namespace Notebook_Helpers */


namespace Notebook_Helpers
{

PageList::iterator PageList::find(const_reference w)
{
  iterator i = begin();
  for(i = begin(); i != end() && (*i != w); i++);
  return i;
}

PageList::iterator PageList::find(Widget& w)
{
  iterator i;
  for (i = begin(); i != end() && ((*i)->get_child() != &w); i++);
  return i;
}

} /* namespace Notebook_Helpers */


namespace Notebook_Helpers
{

PageList::PageList()
{}

PageList::PageList(GtkNotebook* gparent)
: type_base((GObject*)gparent)
{}

PageList::PageList(const PageList& src)
{
  operator=(src);
}

PageList& PageList::operator=(const PageList& src)
{
  gparent_ = src.gparent_;
  return *this;
}

GList*& PageList::glist() const
{
  return ((GtkNotebook*)gparent_)->children;
}

void PageList::erase(iterator start, iterator stop)
{
  type_base::erase(start, stop);
}

GtkNotebook* PageList::gparent()
{
  return (GtkNotebook*)type_base::gparent();
}

const GtkNotebook* PageList::gparent() const
{
  return (GtkNotebook*)type_base::gparent();
}

PageList::value_type PageList::operator[](size_type l) const
{
  return type_base::operator[](l);
}

} /* namespace Notebook_Helpers */

Notebook::Notebook()
: Gtk::Container((GtkContainer*)(g_object_new(get_type(), (char*)0)))
{}

int Notebook::get_current_page_num()
{
  return gtk_notebook_get_current_page(gobj());
}

Widget* Notebook::get_nth_page(int page_number)
{
  return Glib::wrap(gtk_notebook_get_nth_page(gobj(), page_number));
}

int Notebook::page_num(const Widget & child)
{
  return gtk_notebook_page_num(gobj(), const_cast<GtkWidget*>((child).gobj()));
}

void Notebook::set_current_page(int page_number)
{
  gtk_notebook_set_current_page(gobj(), page_number);
}

void Notebook::next_page()
{
  gtk_notebook_next_page(gobj());
}

void Notebook::prev_page()
{
  gtk_notebook_prev_page(gobj());
}

PositionType Notebook::get_tab_pos() const
{
  return PositionType(gobj()->tab_pos);
}

bool Notebook::get_show_tabs() const
{
  return gobj()->show_tabs;
}

bool Notebook::get_show_border() const
{
  return gobj()->show_border;
}

void Notebook::set_show_border(bool show_border)
{
  gtk_notebook_set_show_border(gobj(), static_cast<int>(show_border));
}

void Notebook::set_show_tabs(bool show_tabs)
{
  gtk_notebook_set_show_tabs(gobj(), static_cast<int>(show_tabs));
}

void Notebook::set_tab_pos(PositionType pos)
{
  gtk_notebook_set_tab_pos(gobj(), ((GtkPositionType)(pos)));
}

void Notebook::set_scrollable(bool scrollable)
{
  gtk_notebook_set_scrollable(gobj(), static_cast<int>(scrollable));
}

void Notebook::popup_enable()
{
  gtk_notebook_popup_enable(gobj());
}

void Notebook::popup_disable()
{
  gtk_notebook_popup_disable(gobj());
}


Glib::SignalProxy2<void,GtkNotebookPage*,guint> Notebook::signal_switch_page()
{
  return Glib::SignalProxy2<void,GtkNotebookPage*,guint>(this, &Notebook_signal_switch_page_info);
}

Glib::SignalProxy1<bool,bool> Notebook::signal_select_page()
{
  return Glib::SignalProxy1<bool,bool>(this, &Notebook_signal_select_page_info);
}

Glib::SignalProxy1<bool,NotebookTab> Notebook::signal_focus_tab()
{
  return Glib::SignalProxy1<bool,NotebookTab>(this, &Notebook_signal_focus_tab_info);
}

Glib::SignalProxy1<void,int> Notebook::signal_change_current_page()
{
  return Glib::SignalProxy1<void,int>(this, &Notebook_signal_change_current_page_info);
}

Glib::SignalProxy1<void,DirectionType> Notebook::signal_move_focus_out()
{
  return Glib::SignalProxy1<void,DirectionType>(this, &Notebook_signal_move_focus_out_info);
}


void Gtk::Notebook::on_switch_page(GtkNotebookPage* page, guint page_num)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->switch_page)
    (*base->switch_page)(gobj(),page,page_num);
}

bool Gtk::Notebook::on_select_page(bool move_focus)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->select_page)
    return (*base->select_page)(gobj(),static_cast<int>(move_focus));

  typedef bool RType;
  return RType();
}

bool Gtk::Notebook::on_focus_tab(NotebookTab type)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->focus_tab)
    return (*base->focus_tab)(gobj(),((GtkNotebookTab)(type)));

  typedef bool RType;
  return RType();
}

void Gtk::Notebook::on_change_current_page(int offset)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->change_current_page)
    (*base->change_current_page)(gobj(),offset);
}

void Gtk::Notebook::on_move_focus_out(DirectionType direction)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->move_focus_out)
    (*base->move_focus_out)(gobj(),((GtkDirectionType)(direction)));
}


} // namespace Gtk

