// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREESELECTION_H
#define _GTKMM_TREESELECTION_H

#include <glibmm.h>

/* $Id: treeselection.hg,v 1.19 2002/04/18 15:23:14 murrayc Exp $ */

/* treeselection.h
 * 
 * Copyright(C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/enums.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treeiter.h>
#include <gtkmm/treepath.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeSelection GtkTreeSelection;
typedef struct _GtkTreeSelectionClass GtkTreeSelectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeSelection_Class; } // namespace Gtk
namespace Gtk
{

class TreeView;
class TreeModel;
class TreePath;

/** This is a helper object to manage the selection for a Gtk::TreeView widget.
 * It is automatically created when a new Gtk::TreeView widget is created, and cannot exist independently of this widget.
 * The primary reason this class exists is for cleanliness of code and API. That is, there is no conceptual reason all these methods could
 * not be methods on the Gtk::TreeView widget instead of a separate class.
 *
 * The Gtk::TreeSelection object can be obtained from a Gtk::TreeView by calling Gtk::TreeView::get_selection().
 * It can be manipulated to check the selection status of the tree, as well as to select and deselect individual rows.
 * Selection is done completely view-side. As a result, multiple views of the same model can have completely different selections.
 * Additionally, you cannot change the selection of a row on the model that is not currently displayed by the view without expanding its parents first.
 *
 * When monitoring the selection of a view, it's important to remember that the "changed" signal is mostly a hint. That is, it may only emit
 * one signal when a range of rows is selected. Additionally, it may on occasion emit a "changed" signal when nothing has happened.
 *
 * @ingroup TreeView
 */

class TreeSelection : public Glib::Object
{
   public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeSelection          CppObjectType;
  typedef TreeSelection_Class    CppClassType;
  typedef GtkTreeSelection           BaseObjectType;
  typedef GtkTreeSelectionClass      BaseClassType;

private:
  friend class TreeSelection_Class;
  static CppClassType treeselection_class_;

  TreeSelection(const TreeSelection&);
  TreeSelection& operator=(const TreeSelection&); // not implemented

protected:
  explicit TreeSelection(GtkTreeSelection* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TreeSelection();

  static Glib::RefPtr<TreeSelection> wrap_specific_type(GtkTreeSelection* gobject, bool take_copy = false); //Re-uses the existing wrapper, if it exists.

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkTreeSelection* gobj()             { return (GtkTreeSelection*)(gobject_); }
  const GtkTreeSelection* gobj() const { return (GtkTreeSelection*)(gobject_); }

  GtkTreeSelection* gobj_copy();


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_changed();


private:

   
protected:
  

public:
  
  void set_mode(SelectionMode type);
  
  SelectionMode get_mode();

  typedef SigC::Slot3<bool, const Glib::RefPtr<TreeModel>&, TreePath&, bool> SlotSelect;
  void set_select_function(SlotSelect& slot);

  
  gpointer get_user_data();
  
  TreeView* get_tree_view();

  /** Get the currently selected row.
   * @return The currently selected row.
   * @note This method won't work if the selection mode is @c SELECTION_MULTIPLE.
   */
  TreeIter get_selected() const;

  /** Get the currently selected row.
   * @param model Output argument: will be filled with the current model as a convenience.
   * @return The currently selected row.
   * @note This method won't work if the selection mode is @c SELECTION_MULTIPLE.
   */
  TreeIter get_selected(Glib::RefPtr<TreeModel>& model) const;

  /*
  typedef SigC::Slot3(void, Glib::RefPtr<TreeModel>&, TreePath&, TreeIter&> SlotForEach;
  void foreach(const SlotForEach& slot);
  */

  
  void select(const TreePath& path);
  
  void select(const TreeIter& iter);
  
  void select(const TreePath& start_path, const TreePath& end_path);
  
  void unselect(const TreePath& path);
  
  void unselect(const TreeIter& iter);
  
  bool is_selected(const TreePath& path);
  
  bool is_selected(const TreeIter& iter);
  
  void select_all();
  
  void unselect_all();


  /**
   * @par Prototype:
   * <tt>void %changed()</tt>
   */
  Glib::SignalProxy0<void> signal_changed();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::TreeSelection */
  Glib::RefPtr<Gtk::TreeSelection> wrap(GtkTreeSelection* object, bool take_copy = false);
}


#endif /* _GTKMM_TREESELECTION_H */

