
#include <gtkmm/accelgroup.h>
#include <gtkmm/private/accelgroup_p.h>

// -*- c++ -*-
/* $Id: accelgroup.ccg,v 1.10 2002/04/16 13:01:52 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkaccelgroup.h>

namespace Gtk
{


#if 0
bool 
AccelGroup::activate(const Glib::RefPtr<Glib::Object>& obj, guint accel_key, Gdk::ModifierType accel_mod)
{
  return (gtk_accel_groups_activate(obj->gobj(), accel_key, accel_mod)) ? true : false;
}

bool 
AccelGroup::activate(guint accel_key, Gdk::ModifierType accel_mod)
{
  return (gtk_accel_group_activate(gobj(), accel_key, accel_mod)) ? true : false;
}
#endif


bool 
AccelGroup::valid(guint keyval, Gdk::ModifierType modifiers) 
{
  return (gtk_accelerator_valid(keyval, (GdkModifierType) modifiers));
}

void 
AccelGroup::parse(const Glib::ustring & accelerator,
		  guint &accelerator_key, // out arg
		  Gdk::ModifierType &accelerator_mods) // out arg
{
  gtk_accelerator_parse(accelerator.c_str(),
			&accelerator_key,
			(GdkModifierType*) &accelerator_mods);
}

Glib::ustring
AccelGroup::name(guint accelerator_key,
		     Gdk::ModifierType accelerator_mods) 
{
  return gtk_accelerator_name(accelerator_key, (GdkModifierType) accelerator_mods);
}

//Glib::RefPtr<AccelGroup>
//AccelGroup::get_default()
//{
//  return Glib::wrap(gtk_accel_group_get_default());
//}

void 
AccelGroup::set_default_mod_mask(Gdk::ModifierType default_mod_mask) 
{
  gtk_accelerator_set_default_mod_mask((GdkModifierType) default_mod_mask);
}

Gdk::ModifierType AccelGroup::get_default_mod_mask() 
{
  return (Gdk::ModifierType) gtk_accelerator_get_default_mod_mask();
}


} //namespace Gtk


namespace
{


void AccelGroup_signal_accel_changed_callback(GtkAccelGroup*, guint p0,GdkModifierType p1,GClosure* p2,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot3<void,guint,GdkModifierType,GClosure*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0,p1,p2, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo AccelGroup_signal_accel_changed_info =
{
  "accel_changed",
  (GCallback) &AccelGroup_signal_accel_changed_callback,
  (GCallback) &AccelGroup_signal_accel_changed_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::AccelGroup> wrap(GtkAccelGroup* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::AccelGroup>( dynamic_cast<Gtk::AccelGroup*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType AccelGroup_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_accel_group_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void AccelGroup_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->accel_changed = &accel_changed_callback;
}


void AccelGroup_Class::accel_changed_callback(GtkAccelGroup* self, guint p0, GdkModifierType p1, GClosure* p2)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_accel_changed(p0, p1, p2);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->accel_changed)
      (*base->accel_changed)(self, p0, p1, p2);
  }
}


Glib::ObjectBase* AccelGroup_Class::wrap_new(GObject* o)
{
  return new AccelGroup((GtkAccelGroup*)(o));
}


/* The implementation: */

GtkAccelGroup* AccelGroup::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<AccelGroup> AccelGroup::wrap_specific_type(GtkAccelGroup* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<AccelGroup> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    AccelGroup* pCppObject = dynamic_cast<AccelGroup*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<AccelGroup>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<AccelGroup>( new AccelGroup(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

AccelGroup::AccelGroup(GtkAccelGroup* castitem)
: Glib::Object((GObject*)(castitem))
{}

AccelGroup::~AccelGroup()
{
}

AccelGroup::CppClassType AccelGroup::accelgroup_class_; //Initialize static member.

GType AccelGroup::get_type()
{
  return accelgroup_class_.get_type();
}

GType AccelGroup::get_base_type()
{
  return gtk_accel_group_get_type();
}

AccelGroup::AccelGroup()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<AccelGroup> AccelGroup::create()
{
  return Glib::RefPtr<AccelGroup>( new AccelGroup() );
}
void AccelGroup::lock()
{
  gtk_accel_group_lock(gobj());
}

void AccelGroup::unlock()
{
  gtk_accel_group_unlock(gobj());
}

bool AccelGroup::disconnect_key(guint accel_key, Gdk::ModifierType accel_mods)
{
  return gtk_accel_group_disconnect_key(gobj(), accel_key, ((GdkModifierType)(accel_mods)));
}


Glib::SignalProxy3<void,guint,GdkModifierType,GClosure*> AccelGroup::signal_accel_changed()
{
  return Glib::SignalProxy3<void,guint,GdkModifierType,GClosure*>(this, &AccelGroup_signal_accel_changed_info);
}


void Gtk::AccelGroup::on_accel_changed(guint keyval, GdkModifierType modifier, GClosure* accel_closure)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->accel_changed)
    (*base->accel_changed)(gobj(),keyval,modifier,accel_closure);
}


} // namespace Gtk

