
#include <gtkmm/cellrendererpixbuf.h>
#include <gtkmm/private/cellrendererpixbuf_p.h>

// -*- c++ -*-
/* $Id: cellrendererpixbuf.ccg,v 1.2 2002/05/07 12:58:16 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gtk/gtkcellrendererpixbuf.h>

namespace Gtk
{

Glib::PropertyProxy_Base CellRendererPixbuf::_property_renderable()
{
  return property_pixbuf();
}

} //namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::CellRendererPixbuf* wrap(GtkCellRendererPixbuf* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::CellRendererPixbuf *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType CellRendererPixbuf_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_cell_renderer_pixbuf_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void CellRendererPixbuf_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* CellRendererPixbuf_Class::wrap_new(GObject* o)
{
  return manage(new CellRendererPixbuf((GtkCellRendererPixbuf*)(o)));
}


/* The implementation: */

CellRendererPixbuf::CellRendererPixbuf(GtkCellRendererPixbuf* castitem)
: Gtk::CellRenderer((GtkCellRenderer*)(castitem))
{}

CellRendererPixbuf::~CellRendererPixbuf()
{
  destroy_();
}

CellRendererPixbuf::CppClassType CellRendererPixbuf::cellrendererpixbuf_class_; //Initialize static member.

GType CellRendererPixbuf::get_type()
{
  return cellrendererpixbuf_class_.get_type();
}

GType CellRendererPixbuf::get_base_type()
{
  return gtk_cell_renderer_pixbuf_get_type();
}

CellRendererPixbuf::CellRendererPixbuf()
: Gtk::CellRenderer((GtkCellRenderer*)(g_object_new(get_type(), (char*)0)))
{}


Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > CellRendererPixbuf::property_pixbuf()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> >(this, "pixbuf");
}


} // namespace Gtk

