
#include <gtkmm/container.h>
#include <gtkmm/private/container_p.h>

// -*- c++ -*-
/* $Id: container.ccg,v 1.16 2002/05/07 10:58:15 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sigc++/method_slot.h>
#include <gtkmm/adjustment.h>
#include <gtk/gtkcontainer.h>


namespace
{
extern "C"
{

void container_foreach_callback(GtkWidget* widget_gobj, void* data)
{
  try
  {
    Gtk::Container::ForeachSlot& slot = *static_cast<Gtk::Container::ForeachSlot*>(data);
    Gtk::Widget *const widget = Glib::wrap(widget_gobj);

    g_return_if_fail(widget != 0);

    slot(*widget);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

} // extern "C"
} // anonymous namespace


namespace Gtk
{

void Container::foreach(const Container::ForeachSlot& slot)
{
  ForeachSlot slot_copy (slot);
  gtk_container_foreach(gobj(), &container_foreach_callback, &slot_copy);
}

void  Container::add(Widget& widget)
{
  gtk_container_add(gobj(), widget.gobj());
}

bool Container::has_focus_chain() const
{
  return gtk_container_get_focus_chain(const_cast<GtkContainer*>(gobj()), 0);
}

Glib::ListHandle<Widget*> Container::get_focus_chain()
{
  GList* list = 0;
  gtk_container_get_focus_chain(gobj(), &list);

  return Glib::ListHandle<Widget*>(list, Glib::OWNERSHIP_SHALLOW);
}

void Container::show_all_children(bool recursive)
{
  // Plain C version if this turns out to be performance-critical:
  //GtkCallback callback = (GtkCallback) ((recursive) ? &gtk_widget_show_all : &gtk_widget_show);
  //gtk_container_foreach(gobj(), callback, 0);

  // This could also be done with get_children() and an explicit loop,
  // if any problems should arise.  In gtkmm-1.2, foreach() is known to
  // cause segfaults eventually, but it seems to work now.

  foreach(SigC::slot((recursive) ? &Widget::show_all : &Widget::show));
}

void Container::on_destroy()
{
  //This is an override of the default signal handler for GtkObject's "destroy" signal.
  //This seems to be called just _before_ the refcount reaches zero,
  //whereas Gtk::Object::_destroy_notify() is called just _after_ the refcount reaches zero.
  //
  //We remove the child widgets here because we can't use gtk_container_remove(widget) on a container with refcount of 0,
  //and that's what Gtk::destroy_notify() would try to do (indirectly, via the destructor) if we didn't do it here first.

  //foreach() probably can't cope well with the removal of children,
  //so we'll store the list and iterate over it:
  //foreach(SigC::slot(&Widget::unparent));

  typedef std::list<Gtk::Widget*> type_listWidgets;
  type_listWidgets listChildren = get_children();
  for(type_listWidgets::iterator iter = listChildren.begin(); iter != listChildren.end(); ++iter)
  {
    remove( *(*iter) );
  }

  //Call base class:
  Gtk::Object::on_destroy();
}

} // namespace Gtk


namespace
{


void Container_signal_add_callback(GtkContainer*, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,Widget*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Container_signal_add_info =
{
  "add",
  (GCallback) &Container_signal_add_callback,
  (GCallback) &Container_signal_add_callback
};


void Container_signal_remove_callback(GtkContainer*, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,Widget*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Container_signal_remove_info =
{
  "remove",
  (GCallback) &Container_signal_remove_callback,
  (GCallback) &Container_signal_remove_callback
};


const Glib::SignalProxyInfo Container_signal_check_resize_info =
{
  "check_resize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void Container_signal_set_focus_child_callback(GtkContainer*, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,Widget*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Container_signal_set_focus_child_info =
{
  "set_focus_child",
  (GCallback) &Container_signal_set_focus_child_callback,
  (GCallback) &Container_signal_set_focus_child_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Container* wrap(GtkContainer* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Container *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Container_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_container_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Container_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->child_type = &child_type_vfunc_callback;
  klass->forall = &forall_vfunc_callback;
  klass->composite_name = &composite_name_vfunc_callback;
  klass->set_child_property = &set_child_property_vfunc_callback;
  klass->get_child_property = &get_child_property_vfunc_callback;
  klass->add = &add_callback;
  klass->remove = &remove_callback;
  klass->check_resize = &check_resize_callback;
  klass->set_focus_child = &set_focus_child_callback;
}


GtkType Container_Class::child_type_vfunc_callback(GtkContainer* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->child_type_vfunc();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->child_type)
      (*base->child_type)(self);
  }

  typedef GtkType RType;
  return RType();
}

void Container_Class::forall_vfunc_callback(GtkContainer* self, gboolean include_internals, GtkCallback callback, gpointer callback_data)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->forall_vfunc(include_internals, callback, callback_data);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->forall)
      (*base->forall)(self, include_internals, callback, callback_data);
  }
}

gchar* Container_Class::composite_name_vfunc_callback(GtkContainer* self, GtkWidget* child)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->composite_name(child);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->composite_name)
      (*base->composite_name)(self, child);
  }

  typedef gchar* RType;
  return RType();
}

void Container_Class::set_child_property_vfunc_callback(GtkContainer* self, GtkWidget* child, guint property_id, const GValue* value, GParamSpec* pspec)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->set_child_property(child, property_id, value, pspec);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->set_child_property)
      (*base->set_child_property)(self, child, property_id, value, pspec);
  }
}

void Container_Class::get_child_property_vfunc_callback(GtkContainer* self, GtkWidget* child, guint property_id, GValue* value, GParamSpec* pspec)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->get_child_property(child, property_id, value, pspec);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->get_child_property)
      (*base->get_child_property)(self, child, property_id, value, pspec);
  }
}


void Container_Class::add_callback(GtkContainer* self, GtkWidget* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_add(Glib::wrap(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->add)
      (*base->add)(self, p0);
  }
}

void Container_Class::remove_callback(GtkContainer* self, GtkWidget* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_remove(Glib::wrap(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->remove)
      (*base->remove)(self, p0);
  }
}

void Container_Class::check_resize_callback(GtkContainer* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_check_resize();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->check_resize)
      (*base->check_resize)(self);
  }
}

void Container_Class::set_focus_child_callback(GtkContainer* self, GtkWidget* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_set_focus_child(Glib::wrap(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->set_focus_child)
      (*base->set_focus_child)(self, p0);
  }
}


Glib::ObjectBase* Container_Class::wrap_new(GObject* o)
{
  return manage(new Container((GtkContainer*)(o)));
}


/* The implementation: */

Container::Container(GtkContainer* castitem)
: Gtk::Widget((GtkWidget*)(castitem))
{}

Container::~Container()
{
  destroy_();
}

Container::CppClassType Container::container_class_; //Initialize static member.

GType Container::get_type()
{
  return container_class_.get_type();
}

GType Container::get_base_type()
{
  return gtk_container_get_type();
}

void Container::set_border_width(guint border_width)
{
  gtk_container_set_border_width(gobj(), border_width);
}

guint Container::get_border_width() const
{
  return gtk_container_get_border_width(const_cast<GtkContainer*>(gobj()));
}

void Container::remove(Widget& widget)
{
  gtk_container_remove(gobj(), (widget).Gtk::Widget::gobj());
}

void Container::set_resize_mode(ResizeMode resize_mode)
{
  gtk_container_set_resize_mode(gobj(), ((GtkResizeMode)(resize_mode)));
}

ResizeMode Container::get_resize_mode() const
{
  return ((ResizeMode)(gtk_container_get_resize_mode(const_cast<GtkContainer*>(gobj()))));
}

void Container::check_resize()
{
  gtk_container_check_resize(gobj());
}

Glib::ListHandle<Widget*> Container::get_children()
{
  return Glib::ListHandle<Widget*>(gtk_container_get_children(gobj()), Glib::OWNERSHIP_SHALLOW);
}

void Container::propagate_expose(Widget& child, GdkEventExpose* event)
{
  gtk_container_propagate_expose(gobj(), (child).Gtk::Widget::gobj(), event);
}

void Container::set_focus_chain(const Glib::ListHandle<Widget*>& focusable_widgets)
{
  gtk_container_set_focus_chain(gobj(), focusable_widgets.data());
}

void Container::unset_focus_chain()
{
  gtk_container_unset_focus_chain(gobj());
}

void Container::set_reallocate_redraws(bool needs_redraws)
{
  gtk_container_set_reallocate_redraws(gobj(), static_cast<int>(needs_redraws));
}

void Container::set_focus_child(Widget& widget)
{
  gtk_container_set_focus_child(gobj(), (widget).Gtk::Widget::gobj());
}

void Container::set_focus_vadjustment(Adjustment& adjustment)
{
  gtk_container_set_focus_vadjustment(gobj(), (adjustment).gobj());
}

Adjustment* Container::get_focus_vadjustment()
{
  return Glib::wrap(gtk_container_get_focus_vadjustment(gobj()));
}

void Container::set_focus_hadjustment(Adjustment& adjustment)
{
  gtk_container_set_focus_hadjustment(gobj(), (adjustment).gobj());
}

Adjustment* Container::get_focus_hadjustment()
{
  return Glib::wrap(gtk_container_get_focus_hadjustment(gobj()));
}

void Container::resize_children()
{
  gtk_container_resize_children(gobj());
}

GtkType Container::child_type()
{
  return gtk_container_child_type(gobj());
}

Container::Container()
: Gtk::Widget((GtkWidget*)(g_object_new(get_type(), (char*)0)))
{}


Glib::SignalProxy1<void,Widget*> Container::signal_add()
{
  return Glib::SignalProxy1<void,Widget*>(this, &Container_signal_add_info);
}

Glib::SignalProxy1<void,Widget*> Container::signal_remove()
{
  return Glib::SignalProxy1<void,Widget*>(this, &Container_signal_remove_info);
}

Glib::SignalProxy0<void> Container::signal_check_resize()
{
  return Glib::SignalProxy0<void>(this, &Container_signal_check_resize_info);
}

Glib::SignalProxy1<void,Widget*> Container::signal_set_focus_child()
{
  return Glib::SignalProxy1<void,Widget*>(this, &Container_signal_set_focus_child_info);
}


Glib::PropertyProxy<guint> Container::property_border_width()
{
  return Glib::PropertyProxy<guint>(this, "border_width");
}

Glib::PropertyProxy<ResizeMode> Container::property_resize_mode()
{
  return Glib::PropertyProxy<ResizeMode>(this, "resize_mode");
}

Glib::PropertyProxy_WriteOnly<Widget*> Container::property_child()
{
  return Glib::PropertyProxy_WriteOnly<Widget*>(this, "child");
}


void Gtk::Container::on_add(Widget* widget)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->add)
    (*base->add)(gobj(),(GtkWidget*)Glib::unwrap(widget));
}

void Gtk::Container::on_remove(Widget* widget)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->remove)
    (*base->remove)(gobj(),(GtkWidget*)Glib::unwrap(widget));
}

void Gtk::Container::on_check_resize()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->check_resize)
    (*base->check_resize)(gobj());
}

void Gtk::Container::on_set_focus_child(Widget* widget)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->set_focus_child)
    (*base->set_focus_child)(gobj(),(GtkWidget*)Glib::unwrap(widget));
}


GtkType Gtk::Container::child_type_vfunc()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->child_type)
    return (*base->child_type)(gobj());

  typedef GtkType RType;
  return RType();
}

void Gtk::Container::forall_vfunc(gboolean include_internals, GtkCallback callback, gpointer callback_data)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->forall)
    (*base->forall)(gobj(),include_internals,callback,callback_data);
}

char* Gtk::Container::composite_name(GtkWidget* child)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->composite_name)
    return (*base->composite_name)(gobj(),child);

  typedef char* RType;
  return RType();
}

void Gtk::Container::set_child_property(GtkWidget* child, guint property_id, const GValue* value, GParamSpec* pspec)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->set_child_property)
    (*base->set_child_property)(gobj(),child,property_id,value,pspec);
}

void Gtk::Container::get_child_property(GtkWidget* child, guint property_id, GValue* value, GParamSpec* pspec)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->get_child_property)
    (*base->get_child_property)(gobj(),child,property_id,value,pspec);
}


} // namespace Gtk

