// This demonstrated how to create a singleton dialog.
#include <gtkmm/main.h>
#include <gtkmm/window.h>
#include <gtkmm/dialog.h>
#include <gtkmm/button.h>
#include <iostream>

using namespace Gtk;
using SigC::slot;

class MyDialog : public Dialog {

public:
  // create one dialog only
  static MyDialog* instance()
  {
    if( _instance == 0 ) {
      _instance = new MyDialog;
    }
    return _instance;
  }

protected:
  MyDialog()
  {
    set_size_request(100, 100);
    set_title("Little Dialog");
 
    Gtk::Button *button=manage(new Gtk::Button("Ok"));
    get_action_area()->pack_start(*button);
    button->signal_clicked().connect(slot(*this, &Widget::hide));
    button->show();
  }


private:
  static MyDialog* _instance;
};

MyDialog* MyDialog::_instance(0);


class MyWindow : public Window
{
public:

  MyWindow()
  {

    set_size_request(200, 200);

    Box* mainBox = manage(new HBox);
    MyDialog* dialog = MyDialog::instance();
    Button* button = manage(new Button("Show Dialog"));
    button->signal_clicked().connect(slot(*dialog, &Widget::show));
    mainBox->pack_start(*button);
    add(*mainBox);
  }
};

int main(int argc, char* argv[])
{
  Gtk::Main kit(argc, argv);
  MyWindow win;
  win.show_all();
  kit.run(win);
  return 0;
}

