// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_PIXBUF_H
#define _GDKMM_PIXBUF_H

#include <glibmm.h>

/* $Id: pixbuf.hg,v 1.21 2002/05/20 02:07:19 daniel Exp $ */

/* pixbuf.h
 *
 * Copyright (C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/drawable.h>
#include <gdkmm/image.h>
#include <gdkmm/pixmap.h>
#include <gdkmm/bitmap.h>
#include <gdkmm/types.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdkpixbuf.h> //For some reason the functions are split over 2 headers.


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkPixbuf GdkPixbuf;
typedef struct _GdkPixbufClass GdkPixbufClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Pixbuf_Class; } // namespace Gdk
namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum Colorspace
{
  COLORSPACE_RGB
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Colorspace> : public Glib::Value_Enum<Gdk::Colorspace>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum InterpType
{
  INTERP_NEAREST,
  INTERP_TILES,
  INTERP_BILINEAR,
  INTERP_HYPER
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::InterpType> : public Glib::Value_Enum<Gdk::InterpType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum PixbufAlphaMode
{
  PIXBUF_ALPHA_BILEVEL,
  PIXBUF_ALPHA_FULL
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::PixbufAlphaMode> : public Glib::Value_Enum<Gdk::PixbufAlphaMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


/** Exception class for Gdk::Pixbuf errors.
 */
class PixbufError : public Glib::Error
{
public:
  enum Code
  {
    CORRUPT_IMAGE,
    INSUFFICIENT_MEMORY,
    BAD_OPTION,
    UNKNOWN_TYPE,
    UNSUPPORTED_OPERATION,
    FAILED
  };

  explicit PixbufError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  static void throw_func(GError* gobject);
  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::PixbufError::Code> : public Glib::Value_Enum<Gdk::PixbufError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class Pixbuf : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Pixbuf CppObjectType;
  typedef Pixbuf_Class CppClassType;
  typedef GdkPixbuf BaseObjectType;
  typedef GdkPixbufClass BaseClassType;

private:
  friend class Pixbuf_Class;
  static CppClassType pixbuf_class_;

  // noncopyable
  Pixbuf(const Pixbuf&);
  Pixbuf& operator=(const Pixbuf&);

protected:
  explicit Pixbuf(const Glib::ConstructParams& construct_params);
  explicit Pixbuf(GdkPixbuf* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Pixbuf();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GdkPixbuf*       gobj()       { return reinterpret_cast<GdkPixbuf*>(gobject_); }
  const GdkPixbuf* gobj() const { return reinterpret_cast<GdkPixbuf*>(gobject_); }

  GdkPixbuf* gobj_copy();

private:

  
protected:

	Pixbuf(const Glib::RefPtr<Drawable>& src, const Glib::RefPtr<Colormap>& cmap,
				 int src_x, int src_y, int dest_x, int dest_y, int width, int height);
  Pixbuf(const Glib::RefPtr<Image>& src, const Glib::RefPtr<Colormap>& cmap,
         int src_x, int src_y, int dest_x, int dest_y, int width, int height);

public:
  
  static Glib::RefPtr<Pixbuf> create(const Glib::RefPtr<Drawable>& src, const Glib::RefPtr<Colormap>& cmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height);

  
  static Glib::RefPtr<Pixbuf> create(const Glib::RefPtr<Image>& src, const Glib::RefPtr<Colormap>& cmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height);


  Glib::RefPtr<Pixbuf> copy() const;

  
  static Glib::RefPtr<Pixbuf> create(
                   Colorspace colorspace, bool has_alpha,
                   int bits_per_sample, int width, int height);

  
  static Glib::RefPtr<Pixbuf> create_subpixbuf(
                  const Glib::RefPtr<Pixbuf>& pixbuf,
                  int src_x, int src_y, int width, int height);

  /** Load an image file.
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  static Glib::RefPtr<Pixbuf> create_from_file(const std::string& filename);

  
  static Glib::RefPtr<Pixbuf>
                   create_from_xpm_data(const char *const * data);


  Colorspace get_colorspace() const;

  
  int get_n_channels() const;
  
  bool get_has_alpha() const;
  
  int get_bits_per_sample() const;
  
  guchar* get_pixels() const;
  
  int get_width() const;
  
  int get_height() const;
  
  int get_rowstride() const;

  
  void fill(guint32 pixel);

  /** Save an image file.
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  void save(const std::string& filename, const Glib::ustring& type);
  

  /** Save an image file.
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  void save(const std::string& filename, const Glib::ustring& type,
            const Glib::StringArrayHandle& option_keys,
            const Glib::StringArrayHandle& option_values);
  

  //: Adding an alpha channel
  
  Glib::RefPtr<Gdk::Pixbuf> add_alpha(
                   bool substitute_color, guchar r, guchar g, guchar b) const;

  //: Copy an area of a pixbuf onto another one
  
  void copy_area(
                   int src_x, int src_y, int width, int height,
                   const Glib::RefPtr<Gdk::Pixbuf>& dest_pixbuf,
                   int dest_x, int dest_y) const;

  //: Brighten/darken and optionally make it pixelated-looking
  
  void saturate_and_pixelate(
                   const Glib::RefPtr<Gdk::Pixbuf>& dest,
                   float saturation, bool pixelate) const;


  void scale(const Glib::RefPtr<Gdk::Pixbuf>& dest,
                          int    dest_x,      int    dest_y,
                          int    dest_width,  int    dest_height,
                          double offset_x,    double offset_y,
                          double scale_x,     double scale_y,
                          InterpType interp_type) const;

  
  void composite(const Glib::RefPtr<Gdk::Pixbuf>& dest,
                              int    dest_x,      int    dest_y,
                              int    dest_width,  int    dest_height,
                              double offset_x,    double offset_y,
                              double scale_x,     double scale_y,
                              InterpType interp_type,
                              int overall_alpha) const;

  
  void composite_color(const Glib::RefPtr<Gdk::Pixbuf>& dest,
                                    int    dest_x,      int    dest_y,
                                    int    dest_width,  int    dest_height,
                                    double offset_x,    double offset_y,
                                    double scale_x,     double scale_y,
                                    InterpType interp_type,
                                    int overall_alpha,
                                    int check_x, int check_y,
                                    int check_size,
                                    guint32 color1, guint32 color2) const;

  
  Glib::RefPtr<Gdk::Pixbuf> scale_simple(
                   int dest_width, int dest_height,
                   InterpType interp_type) const;

  
  Glib::RefPtr<Gdk::Pixbuf> composite_color_simple(
                   int dest_width, int dest_height,
                   InterpType interp_type,
                   int overall_alpha, int check_size,
                   guint32 color1, guint32 color2) const;


  void render_threshold_alpha(const Glib::RefPtr<Gdk::Bitmap>& bitmap,
					  int src_x, int src_y,
					  int dest_x, int dest_y,
					  int width, int height,
					  int alpha_threshold);

  
  void render_to_drawable(const Glib::RefPtr<Drawable>& drawable,
					  const Glib::RefPtr<Gdk::GC>& gc,
					  int src_x, int src_y,
					  int dest_x, int dest_y,
					  int width, int height,
					  RgbDither dither,
					  int x_dither, int y_dither);
  
  void render_to_drawable_alpha(const Glib::RefPtr<Drawable>& drawable,
					  int src_x, int src_y,
					  int dest_x, int dest_y,
					  int width, int height,
					  PixbufAlphaMode alpha_mode,
					  int alpha_threshold,
					  RgbDither dither,
					  int x_dither, int y_dither);

  void render_pixmap_and_mask_for_colormap(const Glib::RefPtr<Colormap>& colormap,
                                           Glib::RefPtr<Pixmap>& pixmap_return, Glib::RefPtr<Bitmap>& mask_return,
						                         int alpha_threshold);
  void render_pixmap_and_mask(Glib::RefPtr<Pixmap>& pixmap_return, Glib::RefPtr<Bitmap>& mask_return, int alpha_threshold);

  
  Glib::ustring get_option(const Glib::ustring& key) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** @relates Gdk::Pixbuf */
  Glib::RefPtr<Gdk::Pixbuf> wrap(GdkPixbuf* object, bool take_copy = false);
}


#endif /* _GDKMM_PIXBUF_H */

