// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_DEVICE_H
#define _GDKMM_DEVICE_H

#include <glibmm.h>

/* $Id: device.hg,v 1.1 2002/11/30 11:03:25 murrayc Exp $ */

/* Copyright (C) 002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/window.h>
#include <gdkmm/event.h>
#include <gdk/gdkinput.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkDevice GdkDevice;
typedef struct _GdkDeviceClass GdkDeviceClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Device_Class; } // namespace Gdk
namespace Gdk
{

/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum InputMode
{
  MODE_DISABLED,
  MODE_SCREEN,
  MODE_WINDOW
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::InputMode> : public Glib::Value_Enum<Gdk::InputMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class Device : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Device CppObjectType;
  typedef Device_Class CppClassType;
  typedef GdkDevice BaseObjectType;
  typedef GdkDeviceClass BaseClassType;

private:
  friend class Device_Class;
  static CppClassType device_class_;

  // noncopyable
  Device(const Device&);
  Device& operator=(const Device&);

protected:
  explicit Device(const Glib::ConstructParams& construct_params);
  explicit Device(GdkDevice* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Device();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GdkDevice*       gobj()       { return reinterpret_cast<GdkDevice*>(gobject_); }
  const GdkDevice* gobj() const { return reinterpret_cast<GdkDevice*>(gobject_); }

  GdkDevice* gobj_copy();

private:


protected:
  Device();

public:

  
  void set_source(GdkInputSource  source);
  
  bool set_mode(InputMode mode);
  
  void set_key (guint index_, guint keyval, ModifierType modifiers);
  
  void set_axis_use (guint index_, AxisUse use);
  
  void get_state(const Glib::RefPtr<Window>& window, double& axes, ModifierType& mask);
  
  bool get_history(const Glib::RefPtr<Window>& window, guint32 start, guint32 stop, GdkTimeCoord**& events, int& n_events);
  
  /** Interprets an array of double as axis values for a given device,
   * and locates the value in the array for a given axis use.
   * @param axes Pointer to an array of axes.
   * @param use The use to look for.
   * @param value Location to store the found value.
   * @return <tt>true</tt> if the given axis use was found, otherwies <tt>false</tt>.
   */
  bool get_axis(double& axes, AxisUse use, double& value) const;
          

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** @relates Gdk::Device */
  Glib::RefPtr<Gdk::Device> wrap(GdkDevice* object, bool take_copy = false);
}


#endif /* _GDKMM_DEVICE_H */

