// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_CLIPBOARD_H
#define _GTKMM_CLIPBOARD_H

#include <glibmm.h>

/* $Id: clipboard.hg,v 1.1 2002/12/03 22:56:38 murrayc Exp $ */

/* accelgroup.h
 * 
 * Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 
#include <gdkmm/display.h>
#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
typedef struct _GtkSelectionData GtkSelectionData;
typedef struct _GtkTargetEntry GtkTargetEntry;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkClipboard GtkClipboard;
typedef struct _GtkClipboardClass GtkClipboardClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Clipboard_Class; } // namespace Gtk
namespace Gtk
{


class Clipboard : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Clipboard CppObjectType;
  typedef Clipboard_Class CppClassType;
  typedef GtkClipboard BaseObjectType;
  typedef GtkClipboardClass BaseClassType;

private:
  friend class Clipboard_Class;
  static CppClassType clipboard_class_;

  // noncopyable
  Clipboard(const Clipboard&);
  Clipboard& operator=(const Clipboard&);

protected:
  explicit Clipboard(const Glib::ConstructParams& construct_params);
  explicit Clipboard(GtkClipboard* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Clipboard();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkClipboard*       gobj()       { return reinterpret_cast<GtkClipboard*>(gobject_); }
  const GtkClipboard* gobj() const { return reinterpret_cast<GtkClipboard*>(gobject_); }

  GtkClipboard* gobj_copy();

private:

protected:
  Clipboard();

public:
  
  static Glib::RefPtr<Clipboard> create();


  static Glib::RefPtr<Clipboard> get_for_display(const Glib::RefPtr<Gdk::Display>& display, GdkAtom selection);

  
  Glib::RefPtr<Gdk::Display> get_display();
  
  Glib::RefPtr<const Gdk::Display> get_display() const;

  /// e.g.: void on_get(GtkSelectionData* selection_data, guint info);
  typedef SigC::Slot2<void, GtkSelectionData*, guint> SlotGet;

  /// e.g.: void on_clear();
  typedef SigC::Slot0<void> SlotClear;
  
  bool set(const GtkTargetEntry* targets, guint n_targets, const SlotGet& slot_get, const SlotClear& slot_clear);

  
  /** If the clipboard contents callbacks were set with 
   * gtk_clipboard_set_with_owner(), and the gtk_clipboard_set_with_data() or 
   * gtk_clipboard_clear() has not subsequently called, returns the owner set 
   * by gtk_clipboard_set_with_owner().
   * @return The owner of the clipboard, if any; otherwise <tt>0</tt>.
   */
  Glib::RefPtr<Glib::Object> get_owner();
  
  /** If the clipboard contents callbacks were set with 
   * gtk_clipboard_set_with_owner(), and the gtk_clipboard_set_with_data() or 
   * gtk_clipboard_clear() has not subsequently called, returns the owner set 
   * by gtk_clipboard_set_with_owner().
   * @return The owner of the clipboard, if any; otherwise <tt>0</tt>.
   */
  Glib::RefPtr<const Glib::Object> get_owner() const;
  
  
  /** Clears the contents of the clipboard. Generally this should only
   * be called between the time you call gtk_clipboard_set_with_owner()
   * or gtk_clipboard_set_with_data(),
   * and when the @a clear_func you supplied is called. Otherwise, the
   * clipboard may be owned by someone else.
   */
  void clear();
  void set_text(const Glib::ustring& text);

  /// e.g.: void on_received(GtkSelectionData* selection_data);
  typedef SigC::Slot1<void, GtkSelectionData*> SlotReceived;
  void request_contents(GdkAtom target, const SlotReceived& slot);

  /// e.g.: void on_textreceived(const Glib::ustring& text);
  typedef SigC::Slot1<void, const Glib::ustring&> SlotTextReceived;
  void request_text(const SlotTextReceived& slot);
               

  /** Requests the contents of the clipboard using the given target.
   * This function waits for the data to be received using the main 
   * loop, so events, timeouts, etc, may be dispatched during the wait.
   * @param target An atom representing the form into which the clipboard
   * owner should convert the selection.
   * @return A newly-allocated Gtk::SelectionData object or <tt>0</tt>
   * if retrieving the given target failed. If non-<tt>0</tt>,
   * this value must be freed with gtk_selection_data_free() 
   * when you are finished with it.
   */
  GtkSelectionData* wait_for_contents(GdkAtom target);

  
  /** Requests the contents of the clipboard as text and converts
   * the result to UTF-8 if necessary. This function waits for
   * the data to be received using the main loop, so events,
   * timeouts, etc, may be dispatched during the wait.
   * @return A newly-allocated UTF-8 string which must
   * be freed with Glib::free(), or <tt>0</tt> if retrieving
   * the selection data failed. (This could happen
   * for various reasons, in particular if the
   * clipboard was empty or if the contents of the
   * clipboard could not be converted into text form.).
   */
  Glib::ustring wait_for_text();
  
  /** Test to see if there is text available to be pasted
   * This is done by requesting the TARGETS atom and checking
   * if it contains any of the names: STRING, TEXT, COMPOUND_TEXT,
   * UTF8_STRING. This function waits for the data to be received
   * using the main loop, so events, timeouts, etc, may be dispatched
   * during the wait.
   * 
   * This function is a little faster than calling
   * gtk_clipboard_wait_for_text() since it doesn't need to retrieve
   * the actual text.
   * @return <tt>true</tt> is there is text available, <tt>false</tt> otherwise.
   */
  bool wait_is_text_available();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Clipboard */
  Glib::RefPtr<Gtk::Clipboard> wrap(GtkClipboard* object, bool take_copy = false);
}


#endif /* _GTKMM_CLIPBOARD_H */

