// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gtkmm/menushell.h>
#include <gtkmm/private/menushell_p.h>

// -*- c++ -*-
/* $Id: menushell.ccg,v 1.34 2002/10/11 18:05:57 murrayc Exp $ */

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkmenuitem.h>


namespace Gtk
{

// All ctors are manually implemented just to initialize accel_window_.

MenuShell::MenuShell()
:
  Glib::ObjectBase(0), //Mark this class as gtkmmproc-generated, rather than a custom class, to allow vfunc optimisations.
  Gtk::Container(Glib::ConstructParams(menushell_class_.init(), (char*) 0)),
  items_proxy_  (gobj()),
  accel_window_ (0)
{}

MenuShell::MenuShell(const Glib::ConstructParams& construct_params)
:
  Glib::ObjectBase(0),
  Gtk::Container  (construct_params),
  items_proxy_    (gobj()),
  accel_window_   (0)
{}

MenuShell::MenuShell(GtkMenuShell* castitem)
:
  Gtk::Container((GtkContainer*) castitem),
  items_proxy_  (gobj()),
  accel_window_ (0)
{}

// TODO: Why do we need a custom dtor?
MenuShell::~MenuShell()
{}

void MenuShell::accelerate(Window& window)
{
  // accel_window_ is used by menuitems that are added to the menushell
  // after it has been accelerated.  TODO: install a weak ref?
  accel_window_ = &window;

  const MenuList::iterator items_end = items().end();

  for(MenuList::iterator iter = items().begin(); iter != items_end; ++iter)
    iter->accelerate(window);
}

void MenuShell::accelerate(Widget& parent)
{
  Gtk::Window* toplevel_window 
      = dynamic_cast<Gtk::Window*>(parent.get_toplevel());
  if(toplevel_window)
    accelerate(*toplevel_window);
}

MenuShell::MenuList& MenuShell::items()
{
  return items_proxy_;
}

const MenuShell::MenuList& MenuShell::items() const
{
  return items_proxy_;
}

void MenuShell_Class::insert_vfunc_callback(GtkMenuShell* self, GtkWidget* child, int position)
{
  try
  {
    MenuShell *const obj = dynamic_cast<MenuShell*>(
        Glib::ObjectBase::_get_current_wrapper((GObject*) self));

    // If MenuShell is accelerated initialize accelerators of new MenuItem.
    if(obj && obj->accel_window_ && GTK_IS_MENU_ITEM(child))
    {
      Glib::wrap((GtkMenuItem*) child)->accelerate(*obj->accel_window_);
    }
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  GtkMenuShellClass *const base = static_cast<GtkMenuShellClass*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)));

  if(base && base->insert)
    (*base->insert)(self, child, position);
}


namespace Menu_Helpers
{

// List implementation:

MenuList::iterator MenuList::insert(MenuList::iterator position, const Element& element)
{
  const Glib::RefPtr<Gtk::MenuItem> item = element.get_child();

  g_return_val_if_fail(item != 0, position);
  g_return_val_if_fail(gparent() != 0, position);

  int pos = -1;

  if(position.node_)
    pos = g_list_position(glist(), position.node_);

  gtk_menu_shell_insert(gparent(), item->Widget::gobj(), pos);

  return --position;
}

} // namespace Menu_Helpers

} // namespace Gtk


namespace
{

const Glib::SignalProxyInfo MenuShell_signal_deactivate_info =
{
  "deactivate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo MenuShell_signal_selection_done_info =
{
  "selection_done",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void MenuShell_signal_move_current_callback(GtkMenuShell* self, GtkMenuDirectionType p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,MenuDirectionType> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*(SlotType::Proxy)(slot->proxy_))
            (((MenuDirectionType)(p0))
, slot);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

const Glib::SignalProxyInfo MenuShell_signal_move_current_info =
{
  "move_current",
  (GCallback) &MenuShell_signal_move_current_callback,
  (GCallback) &MenuShell_signal_move_current_callback
};


void MenuShell_signal_activate_current_callback(GtkMenuShell* self, gboolean p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,bool> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*(SlotType::Proxy)(slot->proxy_))
            (p0
, slot);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

const Glib::SignalProxyInfo MenuShell_signal_activate_current_info =
{
  "activate_current",
  (GCallback) &MenuShell_signal_activate_current_callback,
  (GCallback) &MenuShell_signal_activate_current_callback
};


const Glib::SignalProxyInfo MenuShell_signal_cancel_info =
{
  "cancel",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::MenuShell* wrap(GtkMenuShell* object, bool take_copy)
{
  return dynamic_cast<Gtk::MenuShell *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& MenuShell_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &MenuShell_Class::class_init_function;

    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually necessary?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_menu_shell_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return *this;
}

void MenuShell_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

    klass->insert = &insert_vfunc_callback;
    klass->deactivate = &deactivate_callback;
  klass->selection_done = &selection_done_callback;
  klass->move_current = &move_current_callback;
  klass->activate_current = &activate_current_callback;
  klass->cancel = &cancel_callback;
}


void MenuShell_Class::deactivate_callback(GtkMenuShell* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_deactivate();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->deactivate)
      (*base->deactivate)(self);
  }
}

void MenuShell_Class::selection_done_callback(GtkMenuShell* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_selection_done();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->selection_done)
      (*base->selection_done)(self);
  }
}

void MenuShell_Class::move_current_callback(GtkMenuShell* self, GtkMenuDirectionType p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_move_current(((MenuDirectionType)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->move_current)
      (*base->move_current)(self, p0);
  }
}

void MenuShell_Class::activate_current_callback(GtkMenuShell* self, gboolean p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_activate_current(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->activate_current)
      (*base->activate_current)(self, p0);
  }
}

void MenuShell_Class::cancel_callback(GtkMenuShell* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      obj->on_cancel();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->cancel)
      (*base->cancel)(self);
  }
}


Glib::ObjectBase* MenuShell_Class::wrap_new(GObject* o)
{
  return manage(new MenuShell((GtkMenuShell*)(o)));

}


/* The implementation: */

MenuShell::CppClassType MenuShell::menushell_class_; // initialize static member

GType MenuShell::get_type()
{
  return menushell_class_.init().get_type();
}

GType MenuShell::get_base_type()
{
  return gtk_menu_shell_get_type();
}


namespace Menu_Helpers
{

void MenuList::remove(const_reference child)
{
  gtk_container_remove(GTK_CONTAINER(gparent_),
                       (GtkWidget*)(child.gobj()));
}

void MenuList::remove(Widget& widget)
{
  gtk_container_remove(GTK_CONTAINER(gparent_), (GtkWidget*)(widget.gobj()));
}

MenuList::iterator MenuList::erase(iterator position)
{
  //Check that it is a valid iterator, to a real item:
  if ( !position.node_|| (position == end()) )
    return end();

  //Get an iterator the the next item, to return:
  iterator next = position;
  next++;

  //Use GTK+ C function to remove it, by providing the GtkWidget*:
  gtk_container_remove( GTK_CONTAINER(gparent_), (GtkWidget*)(position->gobj()) );
  return next;
}

} /* namespace Menu_Helpers */


namespace Menu_Helpers
{

MenuList::MenuList()
{}

MenuList::MenuList(GtkMenuShell* gparent)
: type_base((GObject*)gparent)
{}

MenuList::MenuList(const MenuList& src)
:
  type_base(src)
{}

MenuList& MenuList::operator=(const MenuList& src)
{
  type_base::operator=(src);
  return *this;
}

GList*& MenuList::glist() const
{
  return ((GtkMenuShell*)gparent_)->children;
}

void MenuList::erase(iterator start, iterator stop)
{
  type_base::erase(start, stop);
}

GtkMenuShell* MenuList::gparent()
{
  return (GtkMenuShell*)type_base::gparent();
}

const GtkMenuShell* MenuList::gparent() const
{
  return (GtkMenuShell*)type_base::gparent();
}

MenuList::reference MenuList::operator[](size_type l) const
{
  return type_base::operator[](l);
}

} /* namespace Menu_Helpers */

void MenuShell::append(MenuItem& menu_item)
{
  gtk_menu_shell_append(gobj(), (menu_item).Gtk::Widget::gobj());
}

void MenuShell::prepend(MenuItem& menu_item)
{
  gtk_menu_shell_prepend(gobj(), (menu_item).Gtk::Widget::gobj());
}

void MenuShell::insert(MenuItem& menu_item, int position)
{
  gtk_menu_shell_insert(gobj(), (menu_item).Gtk::Widget::gobj(), position);
}

void MenuShell::select_item(MenuItem& menu_item)
{
  gtk_menu_shell_select_item(gobj(), (menu_item).Gtk::Widget::gobj());
}

void MenuShell::deselect()
{
  gtk_menu_shell_deselect(gobj());
}

void MenuShell::activate_item(MenuItem& menu_item, bool force_deactivate)
{
  gtk_menu_shell_activate_item(gobj(), (menu_item).Gtk::Widget::gobj(), static_cast<int>(force_deactivate));
}

void MenuShell::select_first(bool search_sensitive)
{
  gtk_menu_shell_select_first(gobj(), static_cast<int>(search_sensitive));
}

void MenuShell::deactivate()
{
  gtk_menu_shell_deactivate(gobj());
}


Glib::SignalProxy0<void> MenuShell::signal_deactivate()
{
  return Glib::SignalProxy0<void>(this, &MenuShell_signal_deactivate_info);
}

Glib::SignalProxy0<void> MenuShell::signal_selection_done()
{
  return Glib::SignalProxy0<void>(this, &MenuShell_signal_selection_done_info);
}

Glib::SignalProxy1<void,MenuDirectionType> MenuShell::signal_move_current()
{
  return Glib::SignalProxy1<void,MenuDirectionType>(this, &MenuShell_signal_move_current_info);
}

Glib::SignalProxy1<void,bool> MenuShell::signal_activate_current()
{
  return Glib::SignalProxy1<void,bool>(this, &MenuShell_signal_activate_current_info);
}

Glib::SignalProxy0<void> MenuShell::signal_cancel()
{
  return Glib::SignalProxy0<void>(this, &MenuShell_signal_cancel_info);
}


void Gtk::MenuShell::on_deactivate()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->deactivate)
    (*base->deactivate)(gobj());
}

void Gtk::MenuShell::on_selection_done()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_done)
    (*base->selection_done)(gobj());
}

void Gtk::MenuShell::on_move_current(MenuDirectionType direction)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->move_current)
    (*base->move_current)(gobj(),((GtkMenuDirectionType)(direction)));
}

void Gtk::MenuShell::on_activate_current(bool force_hide)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->activate_current)
    (*base->activate_current)(gobj(),static_cast<int>(force_hide));
}

void Gtk::MenuShell::on_cancel()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->cancel)
    (*base->cancel)(gobj());
}


} // namespace Gtk


