// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TOGGLEBUTTON_H
#define _GTKMM_TOGGLEBUTTON_H

#include <glibmm.h>

/* $Id: togglebutton.hg,v 1.21 2002/10/11 18:05:59 murrayc Exp $ */

/* togglebutton.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/button.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkToggleButton GtkToggleButton;
typedef struct _GtkToggleButtonClass GtkToggleButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ToggleButton_Class; } // namespace Gtk
namespace Gtk
{

/** A Gtk::ToggleButton will remain 'pressed-in' when clicked. Clicking again will cause the toggle button to return to it's normal state.
 * The state of a Gtk::ToggleButton can be set specifically using set_active(), and retrieved using get_active().
 * To simply switch the state of a toggle button, use toggled().
 *
 * @ingroup Widgets
 */

class ToggleButton : public Button
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ToggleButton CppObjectType;
  typedef ToggleButton_Class CppClassType;
  typedef GtkToggleButton BaseObjectType;
  typedef GtkToggleButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ToggleButton();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ToggleButton_Class;
  static CppClassType togglebutton_class_;

  // noncopyable
  ToggleButton(const ToggleButton&);
  ToggleButton& operator=(const ToggleButton&);

protected:
  explicit ToggleButton(const Glib::ConstructParams& construct_params);
  explicit ToggleButton(GtkToggleButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkToggleButton*       gobj()       { return reinterpret_cast<GtkToggleButton*>(gobject_); }
  const GtkToggleButton* gobj() const { return reinterpret_cast<GtkToggleButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_toggled();


private:

public:

  /** Create an empty toggle button.
   * With an empty button, you can Gtk::Button::add() a widget such as a
   * Gtk::Pixmap or Gtk::Box.
   *
   * If you just wish to add a Gtk::Label, you may want to use the
   * Gtk::ToggleButton(const Glib::ustring &label) constructor directly
   * instead.
   */
  ToggleButton();

  /** Create a toggle button with a label.
   * You won't be able
   * to add a widget to this button since it already contains a Gtk::Label
   */
  explicit ToggleButton(const Glib::ustring& label, bool mnemonic = false);
  

  void set_mode(bool draw_indicator = true);
  
  /** Retrieves whether the button is displayed as a separate indicator
   * and label. See set_mode().
   * @return <tt>true</tt> if the togglebutton is drawn as a separate indicator
   * and label.
   */
  bool get_mode() const;

  
  void set_active(bool is_active = true);
  
  bool get_active() const;

  
  /** If the user has selected a range of elements (such as some text or
   * spreadsheet cells) that are affected by a toggle button, and the
   * current values in that range are inconsistent, you may want to
   * display the toggle in an "in between" state. This function turns on
   * "in between" display.  Normally you would turn off the inconsistent
   * state again if the user toggles the toggle button. This has to be
   * done manually, set_inconsistent() only affects
   * visual appearance, it doesn't affect the semantics of the button.
   * @param setting <tt>true</tt> if state is inconsistent.
   */
  void set_inconsistent(bool setting = true);
  
  /** Gets the value set by set_inconsistent().
   * @return <tt>true</tt> if the button is displayed as inconsistent, <tt>false</tt> otherwise.
   */
  bool get_inconsistent() const;

  
  void toggled();

  
  /**
   * @par Prototype:
   * <tt>void %toggled()</tt>
   */
  Glib::SignalProxy0<void> signal_toggled();


  Glib::PropertyProxy<bool> property_active();

  Glib::PropertyProxy<bool> property_inconsistent();

  Glib::PropertyProxy<bool> property_draw_indicator();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::ToggleButton */
  Gtk::ToggleButton* wrap(GtkToggleButton* object, bool take_copy = false);
}
#endif /* _GTKMM_TOGGLEBUTTON_H */

