// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _ATKMM_VALUE_H
#define _ATKMM_VALUE_H


#include <glibmm.h>

/* $Id$ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
  typedef struct _AtkValueIface AtkValueIface;
  typedef struct _AtkValue      AtkValue;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _AtkValue AtkValue;
typedef struct _AtkValueClass AtkValueClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Atk
{ class Value_Class; } // namespace Atk
namespace Atk
{

/** The ATK interface implemented by valuators and components which display or select a value from a bounded range of values.
 * This should be implemented for components which either display a value from a bounded range, or which allow the user
 * to specify a value from a bounded range, or both. For instance, most sliders and range controls, as well as dials,
 * should have Atk::Object representations which implement Atk::Value on the component's behalf. Atk::Values may be
 * read-only, in which case attempts to alter the value return false to indicate failure.
 */

class Value : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Value CppObjectType;
  typedef Value_Class CppClassType;
  typedef AtkValue BaseObjectType;
  typedef AtkValueIface BaseClassType;

private:
  friend class Value_Class;
  static CppClassType value_class_;

  // noncopyable
  Value(const Value&);
  Value& operator=(const Value&);

protected:
  Value(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Value(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Value(AtkValue* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Value();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkValue*       gobj()       { return reinterpret_cast<AtkValue*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const AtkValue* gobj() const { return reinterpret_cast<AtkValue*>(gobject_); }

private:


public:
  
  /** Gets the value of this object.
   * @param value A Value representing the current accessible value.
   */
  void get_current_value(Glib::ValueBase& value) const;
  
  /** Gets the maximum value of this object.
   * @param value A Value representing the maximum accessible value.
   */
  void get_maximum_value(Glib::ValueBase& value) const;
  
  /** Gets the minimum value of this object.
   * @param value A Value representing the minimum accessible value.
   */
  void get_minimum_value(Glib::ValueBase& value) const;
  
  /** Sets the value of this object.
   * @param value A Value which is the desired new accessible value.
   * @return <tt>true</tt> if new value is successfully set, <tt>false</tt> otherwise.
   */
  bool set_current_value(const Glib::ValueBase& value);

protected:
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_current_value_vfunc(Glib::ValueBase& value) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_maximum_value_vfunc(Glib::ValueBase& value) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_minimum_value_vfunc(Glib::ValueBase& value) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool set_current_value_vfunc(const Glib::ValueBase& value);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::Value
   */
  Glib::RefPtr<Atk::Value> wrap(AtkValue* object, bool take_copy = false);

} // namespace Glib


#endif /* _ATKMM_VALUE_H */

