// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_MISC_H
#define _GTKMM_MISC_H

#include <glibmm.h>

/* $Id: misc.hg,v 1.21 2002/10/11 18:05:58 murrayc Exp $ */

/* misc.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkMisc GtkMisc;
typedef struct _GtkMiscClass GtkMiscClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Misc_Class; } // namespace Gtk
namespace Gtk
{

/** A base class for widgets with alignments and padding.
 *
 * This is an abstract for a set of utility widgets
 * that lack a physical window.  They do have
 * alignment and padding within their defined space.
 *
 * Without a window, widgets of this type cannot capture events.
 * To capture events place in Gtk::EventBox.
 *
 */

class Misc : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Misc CppObjectType;
  typedef Misc_Class CppClassType;
  typedef GtkMisc BaseObjectType;
  typedef GtkMiscClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Misc();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Misc_Class;
  static CppClassType misc_class_;

  // noncopyable
  Misc(const Misc&);
  Misc& operator=(const Misc&);

protected:
  explicit Misc(const Glib::ConstructParams& construct_params);
  explicit Misc(GtkMisc* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkMisc*       gobj()       { return reinterpret_cast<GtkMisc*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkMisc* gobj() const { return reinterpret_cast<GtkMisc*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

protected:
  Misc();
public:

  
  void set_alignment(float xalign = 0.0, float yalign = 0.5);
  
  void set_alignment(AlignmentEnum xalign = Gtk::ALIGN_LEFT, AlignmentEnum yalign = Gtk::ALIGN_CENTER);

  
  /** Gets the X and Y alignment of the widget within its allocation. See
   * set_alignment().
   * @param xalign Location to store X alignment of @a misc , or <tt>0</tt>.
   * @param yalign Location to store Y alignment of @a misc , or <tt>0</tt>.
   */
  void get_alignment(float& xalign, float& yalign) const;

  
  void set_padding(int xpad, int ypad);
  
  /** Gets the padding in the X and Y directions of the widget. See set_padding().
   * @param xpad Location to store padding in the X direction, or <tt>0</tt>.
   * @param ypad Location to store padding in the Y direction, or <tt>0</tt>.
   */
  void get_padding(int& xpad, int& ypad) const;

  Glib::PropertyProxy<float> property_xalign();

  Glib::PropertyProxy<float> property_yalign();

  Glib::PropertyProxy<int> property_xpad();

  Glib::PropertyProxy<int> property_ypad();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Misc */
  Gtk::Misc* wrap(GtkMisc* object, bool take_copy = false);
}
#endif /* _GTKMM_MISC_H */

