// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_SCROLLEDWINDOW_H
#define _GTKMM_SCROLLEDWINDOW_H

#include <glibmm.h>

/* $Id: scrolledwindow.hg,v 1.3 2003/11/01 17:02:39 murrayc Exp $ */

/* scrolledwindow.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkScrolledWindow GtkScrolledWindow;
typedef struct _GtkScrolledWindowClass GtkScrolledWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ScrolledWindow_Class; } // namespace Gtk
namespace Gtk
{

class Adjustment;
class HScrollbar;
class VScrollbar;

/** Adds scrollbars to its child widget.
 *
 * This container accepts a single child widget. It adds scrollbars to the child widget and optionally draws a beveled frame around the child widget.
 * The scrolled window can work in two ways:
 * 1) Some widgets have native scrolling support; these widgets handle certain Gtk::Adjustment signals. Widgets with native scroll support include Gtk::TreeView, Gtk::TextView, and Gtk::Layout.
 * 2) For widgets that lack native scrolling support, such as Gtk::Table, Gtk::Box, and so on, the widget will be placed inside a Gtk::Viewport.
 *
 * The position of the scrollbars is controlled by the scroll adjustments. See Gtk::Adjustment for the fields in an adjustment - for Gtk::Scrollbar, used by Gtk::ScrolledWindow,
 * the "value" field represents the position of the scrollbar, which must be between the "lower" field and "upper - page_size."
 * The "page_size" field represents the size of the visible scrollable area.
 * The "step_increment" and "page_increment" fields are used when the user asks to step down (using the small stepper arrows) or page down (using for example the PageDown key).
 *
 * If a Gtk::ScrolledWindow doesn't behave quite as you would like, or doesn't have exactly the right layout, it's very possible to set up your own scrolling with Gtk::Scrollbar and, for example, a Gtk::Table.
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class ScrolledWindow : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ScrolledWindow CppObjectType;
  typedef ScrolledWindow_Class CppClassType;
  typedef GtkScrolledWindow BaseObjectType;
  typedef GtkScrolledWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ScrolledWindow();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ScrolledWindow_Class;
  static CppClassType scrolledwindow_class_;

  // noncopyable
  ScrolledWindow(const ScrolledWindow&);
  ScrolledWindow& operator=(const ScrolledWindow&);

protected:
  explicit ScrolledWindow(const Glib::ConstructParams& construct_params);
  explicit ScrolledWindow(GtkScrolledWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkScrolledWindow*       gobj()       { return reinterpret_cast<GtkScrolledWindow*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkScrolledWindow* gobj() const { return reinterpret_cast<GtkScrolledWindow*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:


public:
  ScrolledWindow();
  explicit ScrolledWindow(Adjustment& hadjustment, Adjustment& vadjustment);
  

  void set_hadjustment(Gtk::Adjustment* hadjustment = 0);
  
  void set_vadjustment(Gtk::Adjustment* vadjustment = 0);
  
  void set_hadjustment(Gtk::Adjustment& hadjustment);
  
  void set_vadjustment(Gtk::Adjustment& vadjustment);

  
  Gtk::Adjustment* get_hadjustment();
  
  const Gtk::Adjustment* get_hadjustment() const;
  
  Gtk::Adjustment* get_vadjustment();
  
  const Gtk::Adjustment* get_vadjustment() const;

  
  void set_policy(PolicyType hscrollbar_policy, PolicyType vscrollbar_policy);
  
  /** Retrieves the current policy values for the horizontal and vertical
   * scrollbars. See set_policy().
   * @param hscrollbar_policy Location to store the policy for the horizontal scrollbar, or <tt>0</tt>.
   * @param vscrollbar_policy Location to store the policy for the horizontal scrollbar, or <tt>0</tt>.
   */
  void get_policy(PolicyType& hscrollbar_policy, PolicyType& vscrollbar_policy) const;

  
  void set_placement(CornerType window_placement);
  
  /** Gets the placement of the scrollbars for the scrolled window. See 
   * set_placement().
   * @return The current placement value.
   */
  CornerType get_placement() const;

  
  /** Changes the type of shadow drawn around the contents of
   *  @a scrolled_window .
   * @param type Kind of shadow to draw around scrolled window contents.
   */
  void set_shadow_type(ShadowType type);
  
  /** Gets the shadow type of the scrolled window. See 
   * set_shadow_type().
   * @return The current shadow type.
   */
  ShadowType get_shadow_type() const;

  ///Puts the child inside a Gtk::Viewport if it doesn't have native scrolling capability.
  virtual void add(Gtk::Widget& widget);
  

  bool get_vscrollbar_visible() const;
  bool get_hscrollbar_visible() const;
  Gtk::HScrollbar* get_hscrollbar();
  const Gtk::HScrollbar* get_hscrollbar() const;
  Gtk::VScrollbar* get_vscrollbar();
  const Gtk::VScrollbar* get_vscrollbar() const;

  //Keybinding signals:
  
  
  /** The GtkAdjustment for the horizontal position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::Adjustment*> property_hadjustment() ;

/** The GtkAdjustment for the horizontal position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Adjustment*> property_hadjustment() const;

  /** The GtkAdjustment for the vertical position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::Adjustment*> property_vadjustment() ;

/** The GtkAdjustment for the vertical position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Adjustment*> property_vadjustment() const;

  /** When the horizontal scrollbar is displayed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<PolicyType> property_hscrollbar_policy() ;

/** When the horizontal scrollbar is displayed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PolicyType> property_hscrollbar_policy() const;

  /** When the vertical scrollbar is displayed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<PolicyType> property_vscrollbar_policy() ;

/** When the vertical scrollbar is displayed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PolicyType> property_vscrollbar_policy() const;

  /** Where the contents are located with respect to the scrollbars.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<CornerType> property_window_placement() ;

/** Where the contents are located with respect to the scrollbars.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<CornerType> property_window_placement() const;

  /** Style of bevel around the contents.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ShadowType> property_shadow_type() ;

/** Style of bevel around the contents.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ShadowType> property_shadow_type() const;


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::ScrolledWindow
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::ScrolledWindow* wrap(GtkScrolledWindow* object, bool take_copy = false);
}
#endif /* _GTKMM_SCROLLEDWINDOW_H */

