/* document_view.c generated by valac 0.10.2, the Vala compiler
 * generated from document_view.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksourceview.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gdk/gdk.h>


#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _DocumentViewPrivate DocumentViewPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
typedef struct _Block16Data Block16Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DocumentView {
	GtkSourceView parent_instance;
	DocumentViewPrivate * priv;
};

struct _DocumentViewClass {
	GtkSourceViewClass parent_class;
};

struct _DocumentViewPrivate {
	GSettings* editor_settings;
	PangoFontDescription* font_desc;
};

struct _Block16Data {
	int _ref_count_;
	DocumentView * self;
	CompletionProvider* provider;
};


static gpointer document_view_parent_class = NULL;

GType document_view_get_type (void) G_GNUC_CONST;
#define DOCUMENT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_VIEW, DocumentViewPrivate))
enum  {
	DOCUMENT_VIEW_DUMMY_PROPERTY
};
#define DOCUMENT_VIEW_SCROLL_MARGIN 0.02
GType document_get_type (void) G_GNUC_CONST;
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type, Document* doc);
static void _lambda14_ (GObject* d, GParamSpec* p, DocumentView* self);
gboolean document_get_readonly (Document* self);
static void __lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void document_view_set_font_from_settings (DocumentView* self);
void document_set_style_scheme_from_string (Document* self, const char* scheme_id);
GType completion_provider_get_type (void) G_GNUC_CONST;
CompletionProvider* completion_provider_get_default (void);
static void _lambda15_ (Block16Data* _data16_);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static void __lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (Block16Data* _data16_);
static gboolean document_view_on_backspace (DocumentView* self, GdkEventKey* event);
static gboolean _document_view_on_backspace_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void document_view_scroll_to_cursor (DocumentView* self, double margin);
void document_view_cut_selection (DocumentView* self);
void document_view_copy_selection (DocumentView* self);
void document_view_my_paste_clipboard (DocumentView* self);
void document_view_delete_selection (DocumentView* self);
void document_view_my_select_all (DocumentView* self);
guint document_view_my_get_visual_column (DocumentView* self, GtkTextIter* iter);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
const char* app_settings_get_system_font (AppSettings* self);
void document_view_set_font_from_string (DocumentView* self, const char* font);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
char* document_view_get_indentation_style (DocumentView* self);
static void document_view_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _lambda14_ (GObject* d, GParamSpec* p, DocumentView* self) {
	g_return_if_fail (d != NULL);
	g_return_if_fail (p != NULL);
	gtk_text_view_set_editable ((GtkTextView*) self, !document_get_readonly (DOCUMENT (d)));
}


static void __lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda14_ (_sender, pspec, self);
}


static void _lambda15_ (Block16Data* _data16_) {
	DocumentView * self;
	self = _data16_->self;
	completion_provider_hide_calltip_window (_data16_->provider);
}


static void __lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda15_ (self);
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (Block16Data* _data16_) {
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		_g_object_unref0 (_data16_->self);
		_g_object_unref0 (_data16_->provider);
		g_slice_free (Block16Data, _data16_);
	}
}


static gboolean _document_view_on_backspace_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = document_view_on_backspace (self, event);
	return result;
}


DocumentView* document_view_construct (GType object_type, Document* doc) {
	DocumentView * self;
	GSettings* _tmp0_;
	guint tmp = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	gtk_text_view_set_buffer ((GtkTextView*) self, (GtkTextBuffer*) doc);
	g_signal_connect_object ((GObject*) doc, "notify::readonly", (GCallback) __lambda14__g_object_notify, self, 0);
	gtk_text_view_set_wrap_mode ((GtkTextView*) self, GTK_WRAP_WORD);
	gtk_source_view_set_auto_indent ((GtkSourceView*) self, TRUE);
	gtk_source_view_set_indent_width ((GtkSourceView*) self, -1);
	self->priv->editor_settings = (_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor"), _g_object_unref0 (self->priv->editor_settings), _tmp0_);
	document_view_set_font_from_settings (self);
	g_settings_get (self->priv->editor_settings, "tabs-size", "u", &tmp);
	gtk_source_view_set_tab_width ((GtkSourceView*) self, tmp);
	gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) self, g_settings_get_boolean (self->priv->editor_settings, "insert-spaces"));
	gtk_source_view_set_show_line_numbers ((GtkSourceView*) self, g_settings_get_boolean (self->priv->editor_settings, "display-line-numbers"));
	gtk_source_view_set_highlight_current_line ((GtkSourceView*) self, g_settings_get_boolean (self->priv->editor_settings, "highlight-current-line"));
	gtk_source_buffer_set_highlight_matching_brackets ((GtkSourceBuffer*) doc, g_settings_get_boolean (self->priv->editor_settings, "bracket-matching"));
	document_set_style_scheme_from_string (doc, g_settings_get_string (self->priv->editor_settings, "scheme"));
	{
		Block16Data* _data16_;
		_data16_ = g_slice_new0 (Block16Data);
		_data16_->_ref_count_ = 1;
		_data16_->self = g_object_ref (self);
		_data16_->provider = completion_provider_get_default ();
		gtk_source_completion_add_provider (gtk_source_view_get_completion ((GtkSourceView*) self), (GtkSourceCompletionProvider*) _data16_->provider, &_inner_error_);
		if (_inner_error_ != NULL) {
			block16_data_unref (_data16_);
			goto __catch41_g_error;
		}
		g_object_set (gtk_source_view_get_completion ((GtkSourceView*) self), "remember-info-visibility", TRUE, NULL);
		g_signal_connect_data ((GObject*) gtk_text_view_get_buffer ((GtkTextView*) self), "notify::cursor-position", (GCallback) __lambda15__g_object_notify, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
		block16_data_unref (_data16_);
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Error completion: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally41:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _document_view_on_backspace_gtk_widget_key_press_event, self, 0);
	return self;
}


DocumentView* document_view_new (Document* doc) {
	return document_view_construct (TYPE_DOCUMENT_VIEW, doc);
}


void document_view_scroll_to_cursor (DocumentView* self, double margin) {
	g_return_if_fail (self != NULL);
	gtk_text_view_scroll_to_mark ((GtkTextView*) self, gtk_text_buffer_get_insert (gtk_text_view_get_buffer ((GtkTextView*) self)), margin, FALSE, (double) 0, (double) 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void document_view_cut_selection (DocumentView* self) {
	GtkClipboard* clipboard;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gtk_text_view_get_buffer ((GtkTextView*) self) != NULL);
	clipboard = _g_object_ref0 (gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD));
	gtk_text_buffer_cut_clipboard (gtk_text_view_get_buffer ((GtkTextView*) self), clipboard, !document_get_readonly (DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) self))));
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_copy_selection (DocumentView* self) {
	GtkClipboard* clipboard;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gtk_text_view_get_buffer ((GtkTextView*) self) != NULL);
	clipboard = _g_object_ref0 (gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD));
	gtk_text_buffer_copy_clipboard (gtk_text_view_get_buffer ((GtkTextView*) self), clipboard);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_my_paste_clipboard (DocumentView* self) {
	GtkClipboard* clipboard;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gtk_text_view_get_buffer ((GtkTextView*) self) != NULL);
	clipboard = _g_object_ref0 (gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD));
	gtk_text_buffer_paste_clipboard (gtk_text_view_get_buffer ((GtkTextView*) self), clipboard, NULL, !document_get_readonly (DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) self))));
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_delete_selection (DocumentView* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (gtk_text_view_get_buffer ((GtkTextView*) self) != NULL);
	gtk_text_buffer_delete_selection (gtk_text_view_get_buffer ((GtkTextView*) self), TRUE, !document_get_readonly (DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) self))));
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
}


void document_view_my_select_all (DocumentView* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (gtk_text_view_get_buffer ((GtkTextView*) self) != NULL);
	gtk_text_buffer_get_bounds (gtk_text_view_get_buffer ((GtkTextView*) self), &start, &end);
	gtk_text_buffer_select_range (gtk_text_view_get_buffer ((GtkTextView*) self), &start, &end);
}


guint document_view_my_get_visual_column (DocumentView* self, GtkTextIter* iter) {
	guint result = 0U;
	guint column;
	guint tab_width;
	GtkTextIter position;
	g_return_val_if_fail (self != NULL, 0U);
	column = (guint) 0;
	tab_width = gtk_source_view_get_tab_width ((GtkSourceView*) self);
	position = *iter;
	gtk_text_iter_set_visible_line_offset (&position, 0);
	while (TRUE) {
		if (!(!gtk_text_iter_equal (iter, &position))) {
			break;
		}
		if (gtk_text_iter_get_char (&position) == '\t') {
			column = column + (tab_width - (column % tab_width));
		} else {
			column++;
		}
		if (!gtk_text_iter_forward_char (&position)) {
			break;
		}
	}
	result = column;
	return result;
}


void document_view_set_font_from_settings (DocumentView* self) {
	char* font;
	g_return_if_fail (self != NULL);
	font = NULL;
	if (g_settings_get_boolean (self->priv->editor_settings, "use-default-font")) {
		AppSettings* _tmp0_;
		char* _tmp1_;
		font = (_tmp1_ = g_strdup (app_settings_get_system_font (_tmp0_ = app_settings_get_default ())), _g_free0 (font), _tmp1_);
		_g_object_unref0 (_tmp0_);
	} else {
		char* _tmp2_;
		font = (_tmp2_ = g_strdup (g_settings_get_string (self->priv->editor_settings, "editor-font")), _g_free0 (font), _tmp2_);
	}
	document_view_set_font_from_string (self, font);
	_g_free0 (font);
}


void document_view_set_font_from_string (DocumentView* self, const char* font) {
	PangoFontDescription* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	self->priv->font_desc = (_tmp0_ = pango_font_description_from_string (font), _pango_font_description_free0 (self->priv->font_desc), _tmp0_);
	gtk_widget_modify_font ((GtkWidget*) self, self->priv->font_desc);
}


void document_view_enlarge_font (DocumentView* self) {
	g_return_if_fail (self != NULL);
	pango_font_description_set_size (self->priv->font_desc, pango_font_description_get_size (self->priv->font_desc) + PANGO_SCALE);
	gtk_widget_modify_font ((GtkWidget*) self, self->priv->font_desc);
}


void document_view_shrink_font (DocumentView* self) {
	g_return_if_fail (self != NULL);
	pango_font_description_set_size (self->priv->font_desc, pango_font_description_get_size (self->priv->font_desc) - PANGO_SCALE);
	gtk_widget_modify_font ((GtkWidget*) self, self->priv->font_desc);
}


char* document_view_get_indentation_style (DocumentView* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (gtk_source_view_get_insert_spaces_instead_of_tabs ((GtkSourceView*) self)) {
		result = g_strnfill ((gsize) gtk_source_view_get_tab_width ((GtkSourceView*) self), ' ');
		return result;
	}
	result = g_strdup ("\t");
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static gboolean document_view_on_backspace (DocumentView* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkTextIter iter_start = {0};
	GtkTextIter iter_insert = {0};
	char* text;
	gint nb_chars_to_delete;
	gboolean between;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!g_settings_get_boolean (self->priv->editor_settings, "insert-spaces")) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = !g_settings_get_boolean (self->priv->editor_settings, "forget-no-tabs");
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = (*event).keyval != 0xff08;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = gtk_text_buffer_get_has_selection (gtk_text_view_get_buffer ((GtkTextView*) self));
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = gtk_source_view_get_tab_width ((GtkSourceView*) self) == 1;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	gtk_text_buffer_get_iter_at_mark (gtk_text_view_get_buffer ((GtkTextView*) self), &iter_insert, gtk_text_buffer_get_insert (gtk_text_view_get_buffer ((GtkTextView*) self)));
	gtk_text_buffer_get_iter_at_line (gtk_text_view_get_buffer ((GtkTextView*) self), &iter_start, gtk_text_iter_get_line (&iter_insert));
	text = gtk_text_buffer_get_text (gtk_text_view_get_buffer ((GtkTextView*) self), &iter_start, &iter_insert, FALSE);
	if (_vala_strcmp0 (text, "") == 0) {
		result = FALSE;
		_g_free0 (text);
		return result;
	}
	nb_chars_to_delete = 0;
	between = TRUE;
	{
		glong i;
		i = (glong) 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < string_get_length (text))) {
					break;
				}
				if (g_utf8_get_char (g_utf8_offset_to_pointer (text, i)) == '\t') {
					nb_chars_to_delete = 1;
					between = TRUE;
					continue;
				}
				if (g_utf8_get_char (g_utf8_offset_to_pointer (text, i)) != ' ') {
					result = FALSE;
					_g_free0 (text);
					return result;
				}
				if (between) {
					nb_chars_to_delete = 1;
					between = FALSE;
					continue;
				}
				nb_chars_to_delete++;
				if (nb_chars_to_delete == gtk_source_view_get_tab_width ((GtkSourceView*) self)) {
					between = TRUE;
				}
			}
		}
	}
	iter_start = iter_insert;
	if (!gtk_text_iter_backward_chars (&iter_start, nb_chars_to_delete)) {
		result = FALSE;
		_g_free0 (text);
		return result;
	}
	gtk_text_buffer_begin_user_action (gtk_text_view_get_buffer ((GtkTextView*) self));
	g_signal_emit_by_name (gtk_text_view_get_buffer ((GtkTextView*) self), "delete-range", &iter_start, &iter_insert);
	gtk_text_buffer_end_user_action (gtk_text_view_get_buffer ((GtkTextView*) self));
	result = TRUE;
	_g_free0 (text);
	return result;
}


static void document_view_class_init (DocumentViewClass * klass) {
	document_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = document_view_finalize;
}


static void document_view_instance_init (DocumentView * self) {
	self->priv = DOCUMENT_VIEW_GET_PRIVATE (self);
}


static void document_view_finalize (GObject* obj) {
	DocumentView * self;
	self = DOCUMENT_VIEW (obj);
	_g_object_unref0 (self->priv->editor_settings);
	_pango_font_description_free0 (self->priv->font_desc);
	G_OBJECT_CLASS (document_view_parent_class)->finalize (obj);
}


GType document_view_get_type (void) {
	static volatile gsize document_view_type_id__volatile = 0;
	if (g_once_init_enter (&document_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentView), 0, (GInstanceInitFunc) document_view_instance_init, NULL };
		GType document_view_type_id;
		document_view_type_id = g_type_register_static (GTK_TYPE_SOURCE_VIEW, "DocumentView", &g_define_type_info, 0);
		g_once_init_leave (&document_view_type_id__volatile, document_view_type_id);
	}
	return document_view_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




