/* preferences_dialog.c generated by valac 0.10.3, the Vala compiler
 * generated from preferences_dialog.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <config.h>
#include <stdio.h>
#include <gtksourceview/gtksourcestyleschememanager.h>
#include <gtksourceview/gtksourceview.h>
#include <gee.h>


#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;

#define PREFERENCES_DIALOG_TYPE_STYLE_SCHEMES (preferences_dialog_style_schemes_get_type ())

#define PREFERENCES_DIALOG_TYPE_BUILD_TOOL_COLUMN (preferences_dialog_build_tool_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GtkListStore* build_tools_store;
	GtkTreeView* build_tools_view;
};

typedef enum  {
	PREFERENCES_DIALOG_STYLE_SCHEMES_ID,
	PREFERENCES_DIALOG_STYLE_SCHEMES_DESC,
	PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS
} PreferencesDialogStyleSchemes;

typedef enum  {
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION,
	PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS
} PreferencesDialogBuildToolColumn;

struct _Block1Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkLabel* autosave_label;
	GtkButton* default_font_checkbutton;
	GtkTreeView* schemes_treeview;
	GtkLabel* interactive_comp_label;
	GSettings* settings;
};

struct _Block2Data {
	int _ref_count_;
	PreferencesDialog * self;
	GtkWidget* widget;
	gboolean must_be_enabled;
};

struct _BuildJob {
	gboolean must_succeed;
	char* post_processor;
	char* command;
};

struct _BuildTool {
	char* description;
	char* extensions;
	char* label;
	char* icon;
	gboolean compilation;
	GList* jobs;
};


static PreferencesDialog* preferences_dialog_preferences_dialog;
static PreferencesDialog* preferences_dialog_preferences_dialog = NULL;
static gpointer preferences_dialog_parent_class = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
#define PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES_DIALOG, PreferencesDialogPrivate))
enum  {
	PREFERENCES_DIALOG_DUMMY_PROPERTY
};
static GType preferences_dialog_style_schemes_get_type (void) G_GNUC_UNUSED;
static GType preferences_dialog_build_tool_column_get_type (void) G_GNUC_UNUSED;
static PreferencesDialog* preferences_dialog_new (void);
static PreferencesDialog* preferences_dialog_construct (GType object_type);
static void _lambda0_ (gint response_id, PreferencesDialog* self);
static GtkDialog* preferences_dialog_get_reset_all_confirm_dialog (PreferencesDialog* self, const char* msg);
static void __lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void preferences_dialog_init_schemes_treeview (PreferencesDialog* self, GtkTreeView* treeview, const char* current_id);
static void _lambda1_ (GtkTreeView* treeview, Block1Data* _data1_);
static void __lambda1__gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self);
static void _lambda2_ (GSettings* setting, const char* key, Block1Data* _data1_);
static void __lambda2__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void preferences_dialog_set_sensitivity (PreferencesDialog* self, GSettings* settings, const char* key, GtkWidget* widget, gboolean must_be_enabled);
static void _lambda4_ (GSettings* setting, const char* key, Block1Data* _data1_);
static void __lambda4__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void _lambda5_ (GSettings* setting, const char* key, Block1Data* _data1_);
static void __lambda5__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static void preferences_dialog_set_system_font_label (PreferencesDialog* self, GtkButton* button);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
static void _lambda93_ (Block1Data* _data1_);
static void __lambda93__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void preferences_dialog_init_build_tools_treeview (PreferencesDialog* self);
static void preferences_dialog_init_build_tools_buttons (PreferencesDialog* self, GtkButton* bt_new, GtkButton* bt_delete, GtkButton* bt_up, GtkButton* bt_down, GtkButton* bt_properties, GtkButton* bt_reset);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda3_ (GSettings* setting, const char* k, Block2Data* _data2_);
static void __lambda3__g_settings_changed (GSettings* _sender, const char* key, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
const char* app_settings_get_system_font (AppSettings* self);
GType main_window_get_type (void) G_GNUC_CONST;
void preferences_dialog_show_me (MainWindow* parent);
static void _lambda64_ (void);
static void __lambda64__gtk_object_destroy (GtkObject* _sender, gpointer self);
static void preferences_dialog_update_build_tools_store (PreferencesDialog* self);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GeeLinkedList* app_settings_get_build_tools (AppSettings* self);
static void _lambda94_ (PreferencesDialog* self);
static void preferences_dialog_run_build_tool_dialog (PreferencesDialog* self, gint num);
static void __lambda94__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda102_ (PreferencesDialog* self);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter_to_set);
static void __lambda102__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda103_ (PreferencesDialog* self);
void app_settings_delete_build_tool (AppSettings* self, gint num);
static void __lambda103__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda104_ (PreferencesDialog* self);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
void app_settings_move_build_tool_up (AppSettings* self, gint num);
static void __lambda104__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda105_ (PreferencesDialog* self);
void app_settings_move_build_tool_down (AppSettings* self, gint num);
static void __lambda105__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda106_ (PreferencesDialog* self);
void app_settings_reset_all_build_tools (AppSettings* self);
static void __lambda106__gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean build_tool_dialog_show_me (GtkWindow* parent, gint num);
static void preferences_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static GType preferences_dialog_style_schemes_get_type (void) {
	static volatile gsize preferences_dialog_style_schemes_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_style_schemes_type_id__volatile)) {
		static const GEnumValue values[] = {{PREFERENCES_DIALOG_STYLE_SCHEMES_ID, "PREFERENCES_DIALOG_STYLE_SCHEMES_ID", "id"}, {PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, "PREFERENCES_DIALOG_STYLE_SCHEMES_DESC", "desc"}, {PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS, "PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType preferences_dialog_style_schemes_type_id;
		preferences_dialog_style_schemes_type_id = g_enum_register_static ("PreferencesDialogStyleSchemes", values);
		g_once_init_leave (&preferences_dialog_style_schemes_type_id__volatile, preferences_dialog_style_schemes_type_id);
	}
	return preferences_dialog_style_schemes_type_id__volatile;
}


static GType preferences_dialog_build_tool_column_get_type (void) {
	static volatile gsize preferences_dialog_build_tool_column_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_build_tool_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF", "pixbuf"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL", "label"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION", "description"}, {PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS, "PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType preferences_dialog_build_tool_column_type_id;
		preferences_dialog_build_tool_column_type_id = g_enum_register_static ("PreferencesDialogBuildToolColumn", values);
		g_once_init_leave (&preferences_dialog_build_tool_column_type_id__volatile, preferences_dialog_build_tool_column_type_id);
	}
	return preferences_dialog_build_tool_column_type_id__volatile;
}


static void _lambda0_ (gint response_id, PreferencesDialog* self) {
	GtkDialog* dialog;
	gint resp;
	gint settings_str_length1;
	gint _settings_str_size_;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	char** settings_str;
	if (response_id == GTK_RESPONSE_CLOSE) {
		gtk_widget_hide ((GtkWidget*) self);
		return;
	}
	dialog = preferences_dialog_get_reset_all_confirm_dialog (self, _ ("Do you really want to reset all preferences?"));
	resp = gtk_dialog_run (dialog);
	gtk_object_destroy ((GtkObject*) dialog);
	if (resp != GTK_RESPONSE_YES) {
		_g_object_unref0 (dialog);
		return;
	}
	settings_str = (_tmp1_ = (_tmp0_ = g_new0 (char*, 3 + 1), _tmp0_[0] = g_strdup ("org.gnome.latexila.preferences.editor"), _tmp0_[1] = g_strdup ("org.gnome.latexila.preferences.latex"), _tmp0_[2] = g_strdup ("org.gnome.latexila.preferences.file-browser"), _tmp0_), settings_str_length1 = 3, _settings_str_size_ = settings_str_length1, _tmp1_);
	{
		char** setting_str_collection;
		int setting_str_collection_length1;
		int setting_str_it;
		setting_str_collection = settings_str;
		setting_str_collection_length1 = settings_str_length1;
		for (setting_str_it = 0; setting_str_it < settings_str_length1; setting_str_it = setting_str_it + 1) {
			char* setting_str;
			setting_str = g_strdup (setting_str_collection[setting_str_it]);
			{
				GSettings* settings;
				gint keys_length1;
				gint _keys_size_;
				char** _tmp3_;
				char** _tmp2_;
				char** keys;
				settings = g_settings_new (setting_str);
				keys = (_tmp3_ = _tmp2_ = g_settings_list_keys (settings), keys_length1 = _vala_array_length (_tmp2_), _keys_size_ = keys_length1, _tmp3_);
				{
					char** key_collection;
					int key_collection_length1;
					int key_it;
					key_collection = keys;
					key_collection_length1 = keys_length1;
					for (key_it = 0; key_it < keys_length1; key_it = key_it + 1) {
						char* key;
						key = g_strdup (key_collection[key_it]);
						{
							g_settings_reset (settings, key);
							_g_free0 (key);
						}
					}
				}
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (settings);
				_g_free0 (setting_str);
			}
		}
	}
	settings_str = (_vala_array_free (settings_str, settings_str_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (dialog);
}


static void __lambda0__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda0_ (response_id, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda1_ (GtkTreeView* treeview, Block1Data* _data1_) {
	PreferencesDialog * self;
	GtkTreePath* tree_path;
	GtkTreeIter iter = {0};
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* _tmp1_;
	GtkTreeModel* model;
	char* id;
	self = _data1_->self;
	g_return_if_fail (treeview != NULL);
	tree_path = NULL;
	gtk_tree_view_get_cursor (_data1_->schemes_treeview, &_tmp0_, NULL);
	tree_path = (_tmp1_ = _tmp0_, _gtk_tree_path_free0 (tree_path), _tmp1_);
	model = _g_object_ref0 (gtk_tree_view_get_model (treeview));
	gtk_tree_model_get_iter (model, &iter, tree_path);
	id = NULL;
	gtk_tree_model_get (model, &iter, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, &id, -1, -1);
	g_settings_set_string (_data1_->settings, "scheme", id);
	_g_free0 (id);
	_g_object_unref0 (model);
	_gtk_tree_path_free0 (tree_path);
}


static void __lambda1__gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _lambda2_ (GSettings* setting, const char* key, Block1Data* _data1_) {
	PreferencesDialog * self;
	char* val;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	gboolean valid;
	self = _data1_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	val = g_settings_get_string (setting, key);
	model = _g_object_ref0 (gtk_tree_view_get_model (_data1_->schemes_treeview));
	valid = gtk_tree_model_get_iter_first (model, &iter);
	while (TRUE) {
		char* scheme;
		if (!valid) {
			break;
		}
		scheme = NULL;
		gtk_tree_model_get (model, &iter, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, &scheme, -1, -1);
		if (_vala_strcmp0 (scheme, val) == 0) {
			GtkTreeSelection* select;
			select = _g_object_ref0 (gtk_tree_view_get_selection (_data1_->schemes_treeview));
			gtk_tree_selection_select_iter (select, &iter);
			_g_object_unref0 (select);
			_g_free0 (scheme);
			_g_object_unref0 (model);
			_g_free0 (val);
			return;
		}
		valid = gtk_tree_model_iter_next (model, &iter);
		_g_free0 (scheme);
	}
	_g_object_unref0 (model);
	_g_free0 (val);
}


static void __lambda2__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda2_ (_sender, key, self);
}


static void _lambda4_ (GSettings* setting, const char* key, Block1Data* _data1_) {
	PreferencesDialog * self;
	guint val = 0U;
	const char* _tmp0_;
	self = _data1_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	g_settings_get (setting, key, "u", &val);
	_tmp0_ = NULL;
	if (val > 1) {
		_tmp0_ = _ ("minutes");
	} else {
		_tmp0_ = _ ("minute");
	}
	gtk_label_set_label (_data1_->autosave_label, _tmp0_);
}


static void __lambda4__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda4_ (_sender, key, self);
}


static void _lambda5_ (GSettings* setting, const char* key, Block1Data* _data1_) {
	PreferencesDialog * self;
	gint val;
	const char* _tmp0_;
	self = _data1_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (key != NULL);
	val = g_settings_get_int (setting, key);
	_tmp0_ = NULL;
	if (val > 1) {
		_tmp0_ = _ ("characters");
	} else {
		_tmp0_ = _ ("character");
	}
	gtk_label_set_label (_data1_->interactive_comp_label, _tmp0_);
}


static void __lambda5__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda5_ (_sender, key, self);
}


static void _lambda93_ (Block1Data* _data1_) {
	PreferencesDialog * self;
	self = _data1_->self;
	preferences_dialog_set_system_font_label (self, _data1_->default_font_checkbutton);
}


static void __lambda93__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda93_ (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->settings);
		_g_object_unref0 (_data1_->interactive_comp_label);
		_g_object_unref0 (_data1_->schemes_treeview);
		_g_object_unref0 (_data1_->default_font_checkbutton);
		_g_object_unref0 (_data1_->autosave_label);
		g_slice_free (Block1Data, _data1_);
	}
}


static PreferencesDialog* preferences_dialog_construct (GType object_type) {
	PreferencesDialog * self;
	GtkButton* reset_button;
	GtkImage* image;
	char* path;
	GError * _inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
	reset_button = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label (_ ("Reset All")));
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_MENU));
	gtk_button_set_image (reset_button, (GtkWidget*) image);
	gtk_widget_show_all ((GtkWidget*) reset_button);
	gtk_dialog_add_action_widget ((GtkDialog*) self, (GtkWidget*) reset_button, (gint) GTK_RESPONSE_APPLY);
	gtk_dialog_add_button ((GtkDialog*) self, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	gtk_window_set_title ((GtkWindow*) self, _ ("Preferences"));
	gtk_dialog_set_has_separator ((GtkDialog*) self, FALSE);
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __lambda0__gtk_dialog_response, self, 0);
	path = g_build_filename (DATA_DIR, "ui", "preferences_dialog.ui", NULL);
	{
		Block1Data* _data1_;
		GtkBuilder* builder;
		GtkNotebook* notebook;
		GObject* display_line_nb_checkbutton;
		GObject* tab_width_spinbutton;
		GtkWidget* insert_spaces_checkbutton;
		GtkWidget* forget_no_tabs;
		GObject* hl_current_line_checkbutton;
		GObject* bracket_matching_checkbutton;
		GObject* backup_checkbutton;
		GObject* autosave_checkbutton;
		GtkWidget* autosave_spinbutton;
		GObject* reopen_checkbutton;
		GObject* font_button;
		GtkWidget* font_hbox;
		GObject* interactive_comp_checkbutton;
		GtkWidget* interactive_comp_spinbutton;
		GObject* document_view_program;
		GObject* web_browser;
		GObject* nb_most_used_symbols;
		GtkTreeView* _tmp0_;
		GtkButton* bt_new;
		GtkButton* bt_delete;
		GtkButton* bt_up;
		GtkButton* bt_down;
		GtkButton* bt_properties;
		GtkButton* bt_reset;
		GObject* confirm_clean_up_checkbutton;
		GtkWidget* auto_clean_up_checkbutton;
		GObject* clean_up_entry;
		GObject* file_browser_show_all;
		GtkWidget* vbox_file_browser_show_all;
		GtkWidget* file_browser_except;
		GtkWidget* file_browser_show_hidden;
		GtkWidget* file_browser_entry;
		GSettings* latex_settings;
		GSettings* fb_settings;
		char* current_scheme_id;
		guint interval = 0U;
		const char* _tmp1_;
		gint min_nb_chars;
		const char* _tmp2_;
		AppSettings* app_settings;
		GtkBox* content_area;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		builder = gtk_builder_new ();
		gtk_builder_add_from_file (builder, path, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (builder);
			block1_data_unref (_data1_);
			goto __catch0_g_error;
		}
		notebook = _g_object_ref0 (GTK_NOTEBOOK (gtk_builder_get_object (builder, "notebook")));
		display_line_nb_checkbutton = _g_object_ref0 (gtk_builder_get_object (builder, "display_line_nb_checkbutton"));
		tab_width_spinbutton = _g_object_ref0 (gtk_builder_get_object (builder, "tab_width_spinbutton"));
		insert_spaces_checkbutton = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "insert_spaces_checkbutton")));
		forget_no_tabs = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "forget_no_tabs")));
		hl_current_line_checkbutton = _g_object_ref0 (gtk_builder_get_object (builder, "hl_current_line_checkbutton"));
		bracket_matching_checkbutton = _g_object_ref0 (gtk_builder_get_object (builder, "bracket_matching_checkbutton"));
		backup_checkbutton = _g_object_ref0 (gtk_builder_get_object (builder, "backup_checkbutton"));
		autosave_checkbutton = _g_object_ref0 (gtk_builder_get_object (builder, "autosave_checkbutton"));
		autosave_spinbutton = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "autosave_spinbutton")));
		_data1_->autosave_label = _g_object_ref0 (GTK_LABEL (gtk_builder_get_object (builder, "autosave_label")));
		reopen_checkbutton = _g_object_ref0 (gtk_builder_get_object (builder, "reopen_checkbutton"));
		_data1_->default_font_checkbutton = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "default_font_checkbutton")));
		font_button = _g_object_ref0 (gtk_builder_get_object (builder, "font_button"));
		font_hbox = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "font_hbox")));
		_data1_->schemes_treeview = _g_object_ref0 (GTK_TREE_VIEW (gtk_builder_get_object (builder, "schemes_treeview")));
		interactive_comp_checkbutton = _g_object_ref0 (gtk_builder_get_object (builder, "interactive_comp_checkbutton"));
		interactive_comp_spinbutton = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "interactive_comp_spinbutton")));
		_data1_->interactive_comp_label = _g_object_ref0 (GTK_LABEL (gtk_builder_get_object (builder, "interactive_comp_label")));
		document_view_program = _g_object_ref0 (gtk_builder_get_object (builder, "document_view_program"));
		web_browser = _g_object_ref0 (gtk_builder_get_object (builder, "web_browser"));
		nb_most_used_symbols = _g_object_ref0 (gtk_builder_get_object (builder, "nb_most_used_symbols"));
		self->priv->build_tools_view = (_tmp0_ = _g_object_ref0 (GTK_TREE_VIEW (gtk_builder_get_object (builder, "build_tools_treeview"))), _g_object_unref0 (self->priv->build_tools_view), _tmp0_);
		bt_new = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "build_tool_new")));
		bt_delete = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "build_tool_delete")));
		bt_up = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "build_tool_up")));
		bt_down = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "build_tool_down")));
		bt_properties = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "build_tool_properties")));
		bt_reset = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (builder, "build_tool_reset")));
		confirm_clean_up_checkbutton = _g_object_ref0 (gtk_builder_get_object (builder, "confirm_clean_up_checkbutton"));
		auto_clean_up_checkbutton = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "auto_clean_up_checkbutton")));
		clean_up_entry = _g_object_ref0 (gtk_builder_get_object (builder, "clean_up_entry"));
		file_browser_show_all = _g_object_ref0 (gtk_builder_get_object (builder, "file_browser_show_all"));
		vbox_file_browser_show_all = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "vbox_file_browser_show_all")));
		file_browser_except = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "file_browser_except")));
		file_browser_show_hidden = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "file_browser_show_hidden")));
		file_browser_entry = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (builder, "file_browser_entry")));
		_data1_->settings = g_settings_new ("org.gnome.latexila.preferences.editor");
		g_settings_bind (_data1_->settings, "use-default-font", _data1_->default_font_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "editor-font", font_button, "font-name", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "tabs-size", tab_width_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "insert-spaces", insert_spaces_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "forget-no-tabs", forget_no_tabs, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "display-line-numbers", display_line_nb_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "highlight-current-line", hl_current_line_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "bracket-matching", bracket_matching_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "create-backup-copy", backup_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "auto-save", autosave_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "auto-save-interval", autosave_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "reopen-files", reopen_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "web-browser", web_browser, "text", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (_data1_->settings, "nb-most-used-symbols", nb_most_used_symbols, "value", G_SETTINGS_BIND_DEFAULT);
		latex_settings = g_settings_new ("org.gnome.latexila.preferences.latex");
		g_settings_bind (latex_settings, "interactive-completion", interactive_comp_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (latex_settings, "interactive-completion-num", interactive_comp_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (latex_settings, "document-view-program", document_view_program, "text", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (latex_settings, "no-confirm-clean", confirm_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (latex_settings, "automatic-clean", auto_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (latex_settings, "clean-extensions", clean_up_entry, "text", G_SETTINGS_BIND_DEFAULT);
		fb_settings = g_settings_new ("org.gnome.latexila.preferences.file-browser");
		g_settings_bind (fb_settings, "show-all-files", file_browser_show_all, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (fb_settings, "show-all-files-except", file_browser_except, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (fb_settings, "show-hidden-files", file_browser_show_hidden, "active", G_SETTINGS_BIND_DEFAULT);
		g_settings_bind (fb_settings, "file-extensions", file_browser_entry, "text", G_SETTINGS_BIND_DEFAULT);
		current_scheme_id = g_settings_get_string (_data1_->settings, "scheme");
		preferences_dialog_init_schemes_treeview (self, _data1_->schemes_treeview, current_scheme_id);
		g_signal_connect_data (_data1_->schemes_treeview, "cursor-changed", (GCallback) __lambda1__gtk_tree_view_cursor_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		g_signal_connect_data (_data1_->settings, "changed::scheme", (GCallback) __lambda2__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		preferences_dialog_set_sensitivity (self, _data1_->settings, "insert-spaces", forget_no_tabs, TRUE);
		preferences_dialog_set_sensitivity (self, _data1_->settings, "auto-save", autosave_spinbutton, TRUE);
		g_settings_get (_data1_->settings, "auto-save-interval", "u", &interval);
		_tmp1_ = NULL;
		if (interval > 1) {
			_tmp1_ = _ ("minutes");
		} else {
			_tmp1_ = _ ("minute");
		}
		gtk_label_set_label (_data1_->autosave_label, _tmp1_);
		g_signal_connect_data (_data1_->settings, "changed::auto-save-interval", (GCallback) __lambda4__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		preferences_dialog_set_sensitivity (self, latex_settings, "interactive-completion", interactive_comp_spinbutton, TRUE);
		min_nb_chars = g_settings_get_int (latex_settings, "interactive-completion-num");
		_tmp2_ = NULL;
		if (min_nb_chars > 1) {
			_tmp2_ = _ ("characters");
		} else {
			_tmp2_ = _ ("character");
		}
		gtk_label_set_label (_data1_->interactive_comp_label, _tmp2_);
		g_signal_connect_data (latex_settings, "changed::interactive-completion-num", (GCallback) __lambda5__g_settings_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		preferences_dialog_set_sensitivity (self, _data1_->settings, "use-default-font", font_hbox, FALSE);
		preferences_dialog_set_system_font_label (self, _data1_->default_font_checkbutton);
		app_settings = app_settings_get_default ();
		g_signal_connect_data ((GObject*) app_settings, "notify::system-font", (GCallback) __lambda93__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		preferences_dialog_set_sensitivity (self, latex_settings, "no-confirm-clean", auto_clean_up_checkbutton, TRUE);
		preferences_dialog_set_sensitivity (self, fb_settings, "show-all-files", vbox_file_browser_show_all, TRUE);
		preferences_dialog_set_sensitivity (self, fb_settings, "show-all-files", file_browser_entry, FALSE);
		preferences_dialog_init_build_tools_treeview (self);
		preferences_dialog_init_build_tools_buttons (self, bt_new, bt_delete, bt_up, bt_down, bt_properties, bt_reset);
		content_area = _g_object_ref0 (GTK_BOX (gtk_dialog_get_content_area ((GtkDialog*) self)));
		gtk_box_pack_start (content_area, (GtkWidget*) notebook, TRUE, TRUE, (guint) 0);
		gtk_container_set_border_width ((GtkContainer*) notebook, (guint) 5);
		_g_object_unref0 (content_area);
		_g_object_unref0 (app_settings);
		_g_free0 (current_scheme_id);
		_g_object_unref0 (fb_settings);
		_g_object_unref0 (latex_settings);
		_g_object_unref0 (file_browser_entry);
		_g_object_unref0 (file_browser_show_hidden);
		_g_object_unref0 (file_browser_except);
		_g_object_unref0 (vbox_file_browser_show_all);
		_g_object_unref0 (file_browser_show_all);
		_g_object_unref0 (clean_up_entry);
		_g_object_unref0 (auto_clean_up_checkbutton);
		_g_object_unref0 (confirm_clean_up_checkbutton);
		_g_object_unref0 (bt_reset);
		_g_object_unref0 (bt_properties);
		_g_object_unref0 (bt_down);
		_g_object_unref0 (bt_up);
		_g_object_unref0 (bt_delete);
		_g_object_unref0 (bt_new);
		_g_object_unref0 (nb_most_used_symbols);
		_g_object_unref0 (web_browser);
		_g_object_unref0 (document_view_program);
		_g_object_unref0 (interactive_comp_spinbutton);
		_g_object_unref0 (interactive_comp_checkbutton);
		_g_object_unref0 (font_hbox);
		_g_object_unref0 (font_button);
		_g_object_unref0 (reopen_checkbutton);
		_g_object_unref0 (autosave_spinbutton);
		_g_object_unref0 (autosave_checkbutton);
		_g_object_unref0 (backup_checkbutton);
		_g_object_unref0 (bracket_matching_checkbutton);
		_g_object_unref0 (hl_current_line_checkbutton);
		_g_object_unref0 (forget_no_tabs);
		_g_object_unref0 (insert_spaces_checkbutton);
		_g_object_unref0 (tab_width_spinbutton);
		_g_object_unref0 (display_line_nb_checkbutton);
		_g_object_unref0 (notebook);
		_g_object_unref0 (builder);
		block1_data_unref (_data1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* message;
			GtkLabel* label_error;
			GtkBox* content_area;
			message = g_strdup_printf ("Error: %s", e->message);
			fprintf (stderr, "%s\n", message);
			label_error = g_object_ref_sink ((GtkLabel*) gtk_label_new (message));
			gtk_label_set_line_wrap (label_error, TRUE);
			content_area = _g_object_ref0 (GTK_BOX (gtk_dialog_get_content_area ((GtkDialog*) self)));
			gtk_box_pack_start (content_area, (GtkWidget*) label_error, TRUE, TRUE, (guint) 0);
			gtk_widget_show_all ((GtkWidget*) content_area);
			_g_object_unref0 (content_area);
			_g_object_unref0 (label_error);
			_g_free0 (message);
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_object_unref0 (image);
		_g_object_unref0 (reset_button);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (path);
	_g_object_unref0 (image);
	_g_object_unref0 (reset_button);
	return self;
}


static PreferencesDialog* preferences_dialog_new (void) {
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG);
}


static void _lambda3_ (GSettings* setting, const char* k, Block2Data* _data2_) {
	PreferencesDialog * self;
	gboolean v;
	gboolean _tmp0_ = FALSE;
	self = _data2_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (k != NULL);
	v = g_settings_get_boolean (setting, k);
	if (_data2_->must_be_enabled) {
		_tmp0_ = v;
	} else {
		_tmp0_ = !v;
	}
	gtk_widget_set_sensitive (_data2_->widget, _tmp0_);
}


static void __lambda3__g_settings_changed (GSettings* _sender, const char* key, gpointer self) {
	_lambda3_ (_sender, key, self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->widget);
		g_slice_free (Block2Data, _data2_);
	}
}


static void preferences_dialog_set_sensitivity (PreferencesDialog* self, GSettings* settings, const char* key, GtkWidget* widget, gboolean must_be_enabled) {
	Block2Data* _data2_;
	gboolean val;
	gboolean _tmp0_ = FALSE;
	char* _tmp2_ = NULL;
	char* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (widget != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->widget = _g_object_ref0 (widget);
	_data2_->must_be_enabled = must_be_enabled;
	val = g_settings_get_boolean (settings, key);
	if (_data2_->must_be_enabled) {
		_tmp0_ = val;
	} else {
		_tmp0_ = !val;
	}
	gtk_widget_set_sensitive (_data2_->widget, _tmp0_);
	g_signal_connect_data (settings, (_tmp2_ = g_strconcat ("changed::", key, NULL), _tmp2_), (GCallback) __lambda3__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
	block2_data_unref (_data2_);
}


static void preferences_dialog_set_system_font_label (PreferencesDialog* self, GtkButton* button) {
	AppSettings* app_settings;
	char* label;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	app_settings = app_settings_get_default ();
	label = g_strdup_printf (_ ("Use the system fixed width font (%s)"), app_settings_get_system_font (app_settings));
	gtk_button_set_label (button, label);
	_g_free0 (label);
	_g_object_unref0 (app_settings);
}


static void _lambda64_ (void) {
	if (preferences_dialog_preferences_dialog != NULL) {
		PreferencesDialog* _tmp0_;
		preferences_dialog_preferences_dialog = (_tmp0_ = NULL, _g_object_unref0 (preferences_dialog_preferences_dialog), _tmp0_);
	}
}


static void __lambda64__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	_lambda64_ ();
}


void preferences_dialog_show_me (MainWindow* parent) {
	g_return_if_fail (parent != NULL);
	if (preferences_dialog_preferences_dialog == NULL) {
		PreferencesDialog* _tmp0_;
		preferences_dialog_preferences_dialog = (_tmp0_ = g_object_ref_sink (preferences_dialog_new ()), _g_object_unref0 (preferences_dialog_preferences_dialog), _tmp0_);
		g_signal_connect ((GtkObject*) preferences_dialog_preferences_dialog, "destroy", (GCallback) __lambda64__gtk_object_destroy, NULL);
	}
	if (GTK_WINDOW (parent) != gtk_window_get_transient_for ((GtkWindow*) preferences_dialog_preferences_dialog)) {
		gtk_window_set_transient_for ((GtkWindow*) preferences_dialog_preferences_dialog, (GtkWindow*) parent);
	}
	gtk_window_present ((GtkWindow*) preferences_dialog_preferences_dialog);
}


static void preferences_dialog_init_schemes_treeview (PreferencesDialog* self, GtkTreeView* treeview, const char* current_id) {
	GtkListStore* list_store;
	GtkCellRendererText* renderer;
	GtkTreeViewColumn* column;
	GtkTreeSelection* select;
	GtkSourceStyleSchemeManager* manager;
	g_return_if_fail (self != NULL);
	g_return_if_fail (treeview != NULL);
	g_return_if_fail (current_id != NULL);
	list_store = gtk_list_store_new ((gint) PREFERENCES_DIALOG_STYLE_SCHEMES_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) list_store, (gint) PREFERENCES_DIALOG_STYLE_SCHEMES_ID, GTK_SORT_ASCENDING);
	gtk_tree_view_set_model (treeview, (GtkTreeModel*) list_store);
	renderer = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
	column = g_object_ref_sink (gtk_tree_view_column_new_with_attributes ("Name and description", (GtkCellRenderer*) renderer, "markup", PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, NULL, NULL));
	gtk_tree_view_append_column (treeview, column);
	select = _g_object_ref0 (gtk_tree_view_get_selection (treeview));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	manager = _g_object_ref0 (gtk_source_style_scheme_manager_get_default ());
	{
		char** _tmp0_;
		char** id_collection;
		int id_collection_length1;
		int id_it;
		id_collection = _tmp0_ = gtk_source_style_scheme_manager_get_scheme_ids (manager);
		id_collection_length1 = _vala_array_length (_tmp0_);
		for (id_it = 0; id_it < _vala_array_length (_tmp0_); id_it = id_it + 1) {
			char* id;
			id = g_strdup (id_collection[id_it]);
			{
				GtkSourceStyleScheme* scheme;
				char* desc;
				GtkTreeIter iter = {0};
				scheme = _g_object_ref0 (gtk_source_style_scheme_manager_get_scheme (manager, id));
				desc = g_strdup_printf ("<b>%s</b> - %s", gtk_source_style_scheme_get_name (scheme), gtk_source_style_scheme_get_description (scheme));
				gtk_list_store_append (list_store, &iter);
				gtk_list_store_set (list_store, &iter, PREFERENCES_DIALOG_STYLE_SCHEMES_ID, gtk_source_style_scheme_get_id (scheme), PREFERENCES_DIALOG_STYLE_SCHEMES_DESC, desc, -1, -1);
				if (_vala_strcmp0 (id, current_id) == 0) {
					gtk_tree_selection_select_iter (select, &iter);
				}
				_g_free0 (desc);
				_g_object_unref0 (scheme);
				_g_free0 (id);
			}
		}
	}
	_g_object_unref0 (manager);
	_g_object_unref0 (select);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer);
	_g_object_unref0 (list_store);
}


static void preferences_dialog_init_build_tools_treeview (PreferencesDialog* self) {
	GtkListStore* _tmp0_;
	GtkTreeViewColumn* column;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* text_renderer;
	GtkTreeSelection* select;
	g_return_if_fail (self != NULL);
	self->priv->build_tools_store = (_tmp0_ = gtk_list_store_new ((gint) PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING), _g_object_unref0 (self->priv->build_tools_store), _tmp0_);
	gtk_tree_view_set_model (self->priv->build_tools_view, (GtkTreeModel*) self->priv->build_tools_store);
	column = g_object_ref_sink (gtk_tree_view_column_new ());
	gtk_tree_view_append_column (self->priv->build_tools_view, column);
	pixbuf_renderer = g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, NULL, NULL);
	text_renderer = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, NULL, NULL);
	gtk_tree_view_set_tooltip_column (self->priv->build_tools_view, (gint) PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION);
	select = _g_object_ref0 (gtk_tree_view_get_selection (self->priv->build_tools_view));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	preferences_dialog_update_build_tools_store (self);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
}


static void preferences_dialog_update_build_tools_store (PreferencesDialog* self) {
	AppSettings* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* tools;
	g_return_if_fail (self != NULL);
	gtk_list_store_clear (self->priv->build_tools_store);
	tools = (_tmp1_ = app_settings_get_build_tools (_tmp0_ = app_settings_get_default ()), _g_object_unref0 (_tmp0_), _tmp1_);
	{
		GeeIterator* _tool_it;
		_tool_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) tools);
		while (TRUE) {
			BuildTool* _tmp2_;
			BuildTool _tmp3_ = {0};
			BuildTool _tmp4_;
			BuildTool tool;
			GtkTreeIter iter = {0};
			if (!gee_iterator_next (_tool_it)) {
				break;
			}
			tool = (_tmp4_ = (build_tool_copy (_tmp2_ = (BuildTool*) gee_iterator_get (_tool_it), &_tmp3_), _tmp3_), _build_tool_free0 (_tmp2_), _tmp4_);
			gtk_list_store_append (self->priv->build_tools_store, &iter);
			gtk_list_store_set (self->priv->build_tools_store, &iter, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_PIXBUF, tool.icon, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, tool.label, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_DESCRIPTION, tool.description, -1, -1);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
}


static void _lambda94_ (PreferencesDialog* self) {
	preferences_dialog_run_build_tool_dialog (self, -1);
}


static void __lambda94__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda94_ (self);
}


static void _lambda102_ (PreferencesDialog* self) {
	gint num;
	num = utils_get_selected_row (self->priv->build_tools_view, NULL);
	preferences_dialog_run_build_tool_dialog (self, num);
}


static void __lambda102__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda102_ (self);
}


static void _lambda103_ (PreferencesDialog* self) {
	GtkTreeIter iter = {0};
	gint i;
	char* label;
	GtkTreeModel* model;
	GtkDialog* dialog;
	i = utils_get_selected_row (self->priv->build_tools_view, &iter);
	if (i == (-1)) {
		return;
	}
	label = NULL;
	model = _g_object_ref0 (GTK_TREE_MODEL (self->priv->build_tools_store));
	gtk_tree_model_get (model, &iter, PREFERENCES_DIALOG_BUILD_TOOL_COLUMN_LABEL, &label, -1, -1);
	dialog = (GtkDialog*) g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Do you really want to delete the build tool \"%s\"?"), label));
	gtk_dialog_add_buttons (dialog, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_YES, NULL);
	if (gtk_dialog_run (dialog) == GTK_RESPONSE_YES) {
		AppSettings* _tmp0_;
		gtk_list_store_remove (self->priv->build_tools_store, &iter);
		app_settings_delete_build_tool (_tmp0_ = app_settings_get_default (), i);
		_g_object_unref0 (_tmp0_);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (model);
	_g_free0 (label);
}


static void __lambda103__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda103_ (self);
}


static void _lambda104_ (PreferencesDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	gint i;
	gboolean _tmp0_ = FALSE;
	i = utils_get_selected_row (self->priv->build_tools_view, &iter1);
	if (i != (-1)) {
		_tmp0_ = i > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		iter2 = iter1;
		if (utils_tree_model_iter_prev ((GtkTreeModel*) self->priv->build_tools_store, &iter2)) {
			AppSettings* _tmp1_;
			gtk_list_store_swap (self->priv->build_tools_store, &iter1, &iter2);
			app_settings_move_build_tool_up (_tmp1_ = app_settings_get_default (), i);
			_g_object_unref0 (_tmp1_);
		}
	}
}


static void __lambda104__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda104_ (self);
}


static void _lambda105_ (PreferencesDialog* self) {
	GtkTreeIter iter1 = {0};
	GtkTreeIter iter2 = {0};
	gint i;
	i = utils_get_selected_row (self->priv->build_tools_view, &iter1);
	if (i != (-1)) {
		iter2 = iter1;
		if (gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->build_tools_store, &iter2)) {
			AppSettings* _tmp0_;
			gtk_list_store_swap (self->priv->build_tools_store, &iter1, &iter2);
			app_settings_move_build_tool_down (_tmp0_ = app_settings_get_default (), i);
			_g_object_unref0 (_tmp0_);
		}
	}
}


static void __lambda105__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda105_ (self);
}


static void _lambda106_ (PreferencesDialog* self) {
	GtkDialog* dialog;
	dialog = preferences_dialog_get_reset_all_confirm_dialog (self, _ ("Do you really want to reset all build tools?"));
	if (gtk_dialog_run (dialog) == GTK_RESPONSE_YES) {
		AppSettings* _tmp0_;
		app_settings_reset_all_build_tools (_tmp0_ = app_settings_get_default ());
		_g_object_unref0 (_tmp0_);
		preferences_dialog_update_build_tools_store (self);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static void __lambda106__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda106_ (self);
}


static void preferences_dialog_init_build_tools_buttons (PreferencesDialog* self, GtkButton* bt_new, GtkButton* bt_delete, GtkButton* bt_up, GtkButton* bt_down, GtkButton* bt_properties, GtkButton* bt_reset) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (bt_new != NULL);
	g_return_if_fail (bt_delete != NULL);
	g_return_if_fail (bt_up != NULL);
	g_return_if_fail (bt_down != NULL);
	g_return_if_fail (bt_properties != NULL);
	g_return_if_fail (bt_reset != NULL);
	g_signal_connect_object (bt_new, "clicked", (GCallback) __lambda94__gtk_button_clicked, self, 0);
	g_signal_connect_object (bt_properties, "clicked", (GCallback) __lambda102__gtk_button_clicked, self, 0);
	g_signal_connect_object (bt_delete, "clicked", (GCallback) __lambda103__gtk_button_clicked, self, 0);
	g_signal_connect_object (bt_up, "clicked", (GCallback) __lambda104__gtk_button_clicked, self, 0);
	g_signal_connect_object (bt_down, "clicked", (GCallback) __lambda105__gtk_button_clicked, self, 0);
	g_signal_connect_object (bt_reset, "clicked", (GCallback) __lambda106__gtk_button_clicked, self, 0);
}


static GtkDialog* preferences_dialog_get_reset_all_confirm_dialog (PreferencesDialog* self, const char* msg) {
	GtkDialog* result = NULL;
	GtkDialog* dialog;
	GtkButton* button;
	GtkImage* image;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	dialog = (GtkDialog*) g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, msg));
	gtk_dialog_add_button (dialog, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	button = g_object_ref_sink ((GtkButton*) gtk_button_new_with_label (_ ("Reset All")));
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_BUTTON));
	gtk_button_set_image (button, (GtkWidget*) image);
	gtk_widget_show_all ((GtkWidget*) button);
	gtk_dialog_add_action_widget (dialog, (GtkWidget*) button, (gint) GTK_RESPONSE_YES);
	result = dialog;
	_g_object_unref0 (image);
	_g_object_unref0 (button);
	return result;
}


static void preferences_dialog_run_build_tool_dialog (PreferencesDialog* self, gint num) {
	g_return_if_fail (self != NULL);
	if (build_tool_dialog_show_me (gtk_window_get_transient_for ((GtkWindow*) self), num)) {
		preferences_dialog_update_build_tools_store (self);
	}
}


static void preferences_dialog_class_init (PreferencesDialogClass * klass) {
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
}


static void preferences_dialog_instance_init (PreferencesDialog * self) {
	self->priv = PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void preferences_dialog_finalize (GObject* obj) {
	PreferencesDialog * self;
	self = PREFERENCES_DIALOG (obj);
	_g_object_unref0 (self->priv->build_tools_store);
	_g_object_unref0 (self->priv->build_tools_view);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}


GType preferences_dialog_get_type (void) {
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "PreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




