/* document_tab.c generated by valac 0.10.3, the Vala compiler
 * generated from document_tab.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
typedef struct _DocumentTabPrivate DocumentTabPrivate;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_TAB_INFO_BAR (tab_info_bar_get_type ())
#define TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_INFO_BAR, TabInfoBar))
#define TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_INFO_BAR, TabInfoBarClass))
#define IS_TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_INFO_BAR))
#define IS_TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_INFO_BAR))
#define TAB_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_INFO_BAR, TabInfoBarClass))

typedef struct _TabInfoBar TabInfoBar;
typedef struct _TabInfoBarClass TabInfoBarClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
typedef struct _Block20Data Block20Data;

struct _DocumentTab {
	GtkVBox parent_instance;
	DocumentTabPrivate * priv;
};

struct _DocumentTabClass {
	GtkVBoxClass parent_class;
};

struct _DocumentTabPrivate {
	DocumentView* _view;
	Document* _document;
	gboolean ask_if_externally_modified;
	GtkHBox* _label;
	GtkLabel* _label_text;
	GtkLabel* _label_mark;
	guint auto_save_timeout;
	guint _auto_save_interval;
	gboolean _auto_save;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block20Data {
	int _ref_count_;
	DocumentTab * self;
	TabInfoBar* infobar;
};


static gpointer document_tab_parent_class = NULL;

GType document_tab_get_type (void) G_GNUC_CONST;
GType document_view_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
#define DOCUMENT_TAB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_TAB, DocumentTabPrivate))
enum  {
	DOCUMENT_TAB_DUMMY_PROPERTY,
	DOCUMENT_TAB_VIEW,
	DOCUMENT_TAB_DOCUMENT,
	DOCUMENT_TAB_LABEL,
	DOCUMENT_TAB_LABEL_TEXT,
	DOCUMENT_TAB_AUTO_SAVE_INTERVAL,
	DOCUMENT_TAB_AUTO_SAVE
};
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
Document* document_new (void);
Document* document_construct (GType object_type);
static void document_tab_set_document (DocumentTab* self, Document* value);
Document* document_tab_get_document (DocumentTab* self);
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type, Document* doc);
static void document_tab_set_view (DocumentTab* self, DocumentView* value);
static void document_tab_initialize (DocumentTab* self);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type, GFile* location);
void document_load (Document* self, GFile* location);
DocumentTab* document_tab_new_with_view (DocumentView* view);
DocumentTab* document_tab_construct_with_view (GType object_type, DocumentView* view);
static void _lambda16_ (DocumentTab* self);
static void document_tab_update_label_text (DocumentTab* self);
static void document_tab_update_label_tooltip (DocumentTab* self);
static void __lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _document_tab_update_label_tooltip_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _document_tab_update_label_text_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda17_ (GtkTextBuffer* s, DocumentTab* self);
gboolean document_get_modified (Document* self);
static void __lambda17__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self);
DocumentView* document_tab_get_view (DocumentTab* self);
static gboolean document_tab_view_focused_in (DocumentTab* self);
static gboolean _document_tab_view_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void _lambda19_ (DocumentTab* self);
static void __lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self);
void document_tab_set_auto_save (DocumentTab* self, gboolean value);
void document_tab_set_auto_save_interval (DocumentTab* self, guint value);
static gboolean document_tab_install_auto_save_timeout_if_needed (DocumentTab* self);
static void _lambda20_ (DocumentTab* self);
static void __lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType tab_info_bar_get_type (void) G_GNUC_CONST;
TabInfoBar* document_tab_add_message (DocumentTab* self, const char* primary_msg, const char* secondary_msg, GtkMessageType msg_type);
TabInfoBar* tab_info_bar_new (const char* primary_msg, const char* secondary_msg, GtkMessageType msg_type);
TabInfoBar* tab_info_bar_construct (GType object_type, const char* primary_msg, const char* secondary_msg, GtkMessageType msg_type);
char* utils_str_middle_truncate (const char* str, guint max_length);
char* document_get_short_name_for_display (Document* self);
static void document_tab_set_label_text (DocumentTab* self, const char* value);
GFile* document_get_location (Document* self);
char* document_get_uri_for_display (Document* self);
gint document_get_project_id (Document* self);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
Project* app_settings_get_project (AppSettings* self, gint id);
char* utils_replace_home_dir_with_tilde (const char* uri);
char* document_tab_get_name (DocumentTab* self);
const char* document_tab_get_label_text (DocumentTab* self);
char* document_tab_get_menu_tip (DocumentTab* self);
gboolean document_is_local (Document* self);
gboolean document_is_externally_modified (Document* self);
void tab_info_bar_add_stock_button_with_text (TabInfoBar* self, const char* text, const char* stock_id, gint response_id);
static void _lambda18_ (gint response_id, Block20Data* _data20_);
static void __lambda18__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (Block20Data* _data20_);
static void document_tab_install_auto_save_timeout (DocumentTab* self);
gboolean document_tab_get_auto_save (DocumentTab* self);
guint document_tab_get_auto_save_interval (DocumentTab* self);
static gboolean document_tab_on_auto_save (DocumentTab* self);
static gboolean _document_tab_on_auto_save_gsource_func (gpointer self);
gboolean document_get_readonly (Document* self);
static void document_tab_remove_auto_save_timeout (DocumentTab* self);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GtkHBox* document_tab_get_label (DocumentTab* self);
static void document_tab_finalize (GObject* obj);
static void document_tab_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void document_tab_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DocumentTab* document_tab_construct (GType object_type) {
	DocumentTab * self;
	Document* _tmp0_;
	DocumentView* _tmp1_;
	self = g_object_newv (object_type, 0, NULL);
	document_tab_set_document (self, _tmp0_ = document_new ());
	_g_object_unref0 (_tmp0_);
	document_tab_set_view (self, _tmp1_ = g_object_ref_sink (document_view_new (self->priv->_document)));
	_g_object_unref0 (_tmp1_);
	document_tab_initialize (self);
	return self;
}


DocumentTab* document_tab_new (void) {
	return document_tab_construct (TYPE_DOCUMENT_TAB);
}


DocumentTab* document_tab_construct_from_location (GType object_type, GFile* location) {
	DocumentTab * self = NULL;
	g_return_val_if_fail (location != NULL, NULL);
	self = (DocumentTab*) document_tab_construct (object_type);
	document_load (self->priv->_document, location);
	return self;
}


DocumentTab* document_tab_new_from_location (GFile* location) {
	return document_tab_construct_from_location (TYPE_DOCUMENT_TAB, location);
}


DocumentTab* document_tab_construct_with_view (GType object_type, DocumentView* view) {
	DocumentTab * self;
	g_return_val_if_fail (view != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	document_tab_set_view (self, view);
	document_tab_set_document (self, DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) view)));
	document_tab_initialize (self);
	return self;
}


DocumentTab* document_tab_new_with_view (DocumentView* view) {
	return document_tab_construct_with_view (TYPE_DOCUMENT_TAB, view);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda16_ (DocumentTab* self) {
	document_tab_update_label_text (self);
	document_tab_update_label_tooltip (self);
}


static void __lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda16_ (self);
}


static void _document_tab_update_label_tooltip_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	document_tab_update_label_tooltip (self);
}


static void _document_tab_update_label_text_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	document_tab_update_label_text (self);
}


static void _lambda17_ (GtkTextBuffer* s, DocumentTab* self) {
	const char* _tmp0_;
	g_return_if_fail (s != NULL);
	_tmp0_ = NULL;
	if (document_get_modified (self->priv->_document)) {
		_tmp0_ = "*";
	} else {
		_tmp0_ = "";
	}
	gtk_label_set_label (self->priv->_label_mark, _tmp0_);
}


static void __lambda17__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self) {
	_lambda17_ (_sender, self);
}


static gboolean _document_tab_view_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = document_tab_view_focused_in (self);
	return result;
}


static void _lambda19_ (DocumentTab* self) {
	g_signal_emit_by_name (self, "close-document");
}


static void __lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda19_ (self);
}


static void _lambda20_ (DocumentTab* self) {
	if (self->priv->auto_save_timeout <= 0) {
		document_tab_install_auto_save_timeout_if_needed (self);
	}
}


static void __lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda20_ (self);
}


static void document_tab_initialize (DocumentTab* self) {
	gboolean reparent;
	DocumentTab* _tmp0_;
	GtkScrolledWindow* sw;
	GtkButton* close_button;
	GtkImage* _tmp1_;
	GtkHBox* _tmp2_;
	GSettings* settings;
	guint tmp = 0U;
	g_return_if_fail (self != NULL);
	reparent = self->priv->_document->tab != NULL;
	self->priv->_document->tab = (_tmp0_ = _g_object_ref0 (self), _g_object_unref0 (self->priv->_document->tab), _tmp0_);
	g_signal_connect_object ((GObject*) self->priv->_document, "notify::location", (GCallback) __lambda16__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->_document, "notify::project-id", (GCallback) _document_tab_update_label_tooltip_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->_document, "notify::unsaved-document-n", (GCallback) _document_tab_update_label_text_g_object_notify, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self->priv->_document, "modified-changed", (GCallback) __lambda17__gtk_text_buffer_modified_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->_view, "focus-in-event", (GCallback) _document_tab_view_focused_in_gtk_widget_focus_in_event, self, 0);
	sw = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
	gtk_scrolled_window_set_policy (sw, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	if (reparent) {
		gtk_widget_reparent ((GtkWidget*) self->priv->_view, (GtkWidget*) sw);
	} else {
		gtk_container_add ((GtkContainer*) sw, (GtkWidget*) self->priv->_view);
	}
	gtk_widget_show_all ((GtkWidget*) sw);
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	document_tab_update_label_text (self);
	close_button = g_object_ref_sink ((GtkButton*) gtk_button_new ());
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	gtk_button_set_focus_on_click (close_button, FALSE);
	gtk_widget_set_name ((GtkWidget*) close_button, "my-close-button");
	gtk_widget_set_tooltip_text ((GtkWidget*) close_button, _ ("Close document"));
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) (_tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU))));
	_g_object_unref0 (_tmp1_);
	g_signal_connect_object (close_button, "clicked", (GCallback) __lambda19__gtk_button_clicked, self, 0);
	self->priv->_label = (_tmp2_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0)), _g_object_unref0 (self->priv->_label), _tmp2_);
	gtk_box_pack_start ((GtkBox*) self->priv->_label, (GtkWidget*) self->priv->_label_mark, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self->priv->_label, (GtkWidget*) self->priv->_label_text, TRUE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self->priv->_label, (GtkWidget*) close_button, FALSE, FALSE, (guint) 0);
	document_tab_update_label_tooltip (self);
	gtk_widget_show_all ((GtkWidget*) self->priv->_label);
	settings = g_settings_new ("org.gnome.latexila.preferences.editor");
	document_tab_set_auto_save (self, g_settings_get_boolean (settings, "auto-save"));
	g_settings_get (settings, "auto-save-interval", "u", &tmp);
	document_tab_set_auto_save_interval (self, tmp);
	document_tab_install_auto_save_timeout_if_needed (self);
	g_signal_connect_object ((GObject*) self->priv->_document, "notify::location", (GCallback) __lambda20__g_object_notify, self, 0);
	_g_object_unref0 (settings);
	_g_object_unref0 (close_button);
	_g_object_unref0 (sw);
}


TabInfoBar* document_tab_add_message (DocumentTab* self, const char* primary_msg, const char* secondary_msg, GtkMessageType msg_type) {
	TabInfoBar* result = NULL;
	TabInfoBar* infobar;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (primary_msg != NULL, NULL);
	g_return_val_if_fail (secondary_msg != NULL, NULL);
	infobar = g_object_ref_sink (tab_info_bar_new (primary_msg, secondary_msg, msg_type));
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) infobar, FALSE, FALSE, (guint) 0);
	result = infobar;
	return result;
}


static void document_tab_update_label_text (DocumentTab* self) {
	char* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	document_tab_set_label_text (self, _tmp1_ = utils_str_middle_truncate (_tmp0_ = document_get_short_name_for_display (self->priv->_document), (guint) 42));
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
}


static void document_tab_update_label_tooltip (DocumentTab* self) {
	g_return_if_fail (self != NULL);
	if (document_get_location (self->priv->_document) == NULL) {
		gtk_widget_set_tooltip_markup ((GtkWidget*) self->priv->_label, "");
	} else {
		char* _tmp0_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) self->priv->_label, _tmp0_ = document_get_uri_for_display (self->priv->_document));
		_g_free0 (_tmp0_);
		if (document_get_project_id (self->priv->_document) != (-1)) {
			AppSettings* _tmp1_;
			Project* _tmp2_;
			Project* project;
			project = (_tmp2_ = app_settings_get_project (_tmp1_ = app_settings_get_default (), document_get_project_id (self->priv->_document)), _g_object_unref0 (_tmp1_), _tmp2_);
			if (project == NULL) {
				_project_free0 (project);
				return;
			}
			if (g_file_equal ((*project).main_file, document_get_location (self->priv->_document))) {
				char* _tmp3_;
				char* _tmp4_;
				char* _tmp5_;
				gtk_widget_set_tooltip_markup ((GtkWidget*) self->priv->_label, _tmp5_ = g_strconcat (gtk_widget_get_tooltip_markup ((GtkWidget*) self->priv->_label), _tmp4_ = g_strconcat (_tmp3_ = g_strconcat ("\n<b>", _ ("Main File"), NULL), "</b>", NULL), NULL));
				_g_free0 (_tmp5_);
				_g_free0 (_tmp4_);
				_g_free0 (_tmp3_);
			} else {
				char* _tmp6_;
				char* _tmp7_;
				char* _tmp8_;
				char* _tmp9_;
				char* _tmp10_;
				char* _tmp11_;
				gtk_widget_set_tooltip_markup ((GtkWidget*) self->priv->_label, _tmp11_ = g_strconcat (gtk_widget_get_tooltip_markup ((GtkWidget*) self->priv->_label), _tmp10_ = g_strconcat (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat ("\n<b>", _ ("Main File:"), NULL), "</b> ", NULL), _tmp9_ = utils_replace_home_dir_with_tilde (_tmp8_ = g_file_get_parse_name ((*project).main_file)), NULL), NULL));
				_g_free0 (_tmp11_);
				_g_free0 (_tmp10_);
				_g_free0 (_tmp9_);
				_g_free0 (_tmp8_);
				_g_free0 (_tmp7_);
				_g_free0 (_tmp6_);
			}
			_project_free0 (project);
		}
	}
}


char* document_tab_get_name (DocumentTab* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strconcat (gtk_label_get_label (self->priv->_label_mark), document_tab_get_label_text (self), NULL);
	return result;
}


char* document_tab_get_menu_tip (DocumentTab* self) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strdup_printf (_ ("Activate '%s'"), _tmp0_ = document_get_uri_for_display (self->priv->_document)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static void _lambda18_ (gint response_id, Block20Data* _data20_) {
	DocumentTab * self;
	self = _data20_->self;
	if (response_id == GTK_RESPONSE_OK) {
		document_load (self->priv->_document, document_get_location (self->priv->_document));
		self->priv->ask_if_externally_modified = FALSE;
	}
	gtk_object_destroy ((GtkObject*) _data20_->infobar);
	gtk_widget_grab_focus ((GtkWidget*) self->priv->_view);
}


static void __lambda18__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	_lambda18_ (response_id, self);
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (Block20Data* _data20_) {
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		_g_object_unref0 (_data20_->self);
		_g_object_unref0 (_data20_->infobar);
		g_slice_free (Block20Data, _data20_);
	}
}


static gboolean document_tab_view_focused_in (DocumentTab* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->ask_if_externally_modified) {
		result = FALSE;
		return result;
	}
	if (!document_is_local (self->priv->_document)) {
		result = FALSE;
		return result;
	}
	if (document_is_externally_modified (self->priv->_document)) {
		Block20Data* _data20_;
		char* _tmp0_;
		char* _tmp1_;
		char* primary_msg;
		char* secondary_msg;
		_data20_ = g_slice_new0 (Block20Data);
		_data20_->_ref_count_ = 1;
		_data20_->self = g_object_ref (self);
		self->priv->ask_if_externally_modified = TRUE;
		primary_msg = (_tmp1_ = g_strdup_printf (_ ("The file %s changed on disk."), _tmp0_ = g_file_get_parse_name (document_get_location (self->priv->_document))), _g_free0 (_tmp0_), _tmp1_);
		secondary_msg = NULL;
		if (document_get_modified (self->priv->_document)) {
			char* _tmp2_;
			secondary_msg = (_tmp2_ = g_strdup (_ ("Do you want to drop your changes and reload the file?")), _g_free0 (secondary_msg), _tmp2_);
		} else {
			char* _tmp3_;
			secondary_msg = (_tmp3_ = g_strdup (_ ("Do you want to reload the file?")), _g_free0 (secondary_msg), _tmp3_);
		}
		_data20_->infobar = document_tab_add_message (self, primary_msg, secondary_msg, GTK_MESSAGE_WARNING);
		tab_info_bar_add_stock_button_with_text (_data20_->infobar, _ ("Reload"), GTK_STOCK_REFRESH, (gint) GTK_RESPONSE_OK);
		gtk_info_bar_add_button ((GtkInfoBar*) _data20_->infobar, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
		g_signal_connect_data ((GtkInfoBar*) _data20_->infobar, "response", (GCallback) __lambda18__gtk_info_bar_response, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
		_g_free0 (secondary_msg);
		_g_free0 (primary_msg);
		block20_data_unref (_data20_);
	}
	result = FALSE;
	return result;
}


static gboolean _document_tab_on_auto_save_gsource_func (gpointer self) {
	gboolean result;
	result = document_tab_on_auto_save (self);
	return result;
}


static void document_tab_install_auto_save_timeout (DocumentTab* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->auto_save_timeout <= 0);
	g_return_if_fail (document_tab_get_auto_save (self));
	g_return_if_fail (document_tab_get_auto_save_interval (self) > 0);
	self->priv->auto_save_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, document_tab_get_auto_save_interval (self) * 60, _document_tab_on_auto_save_gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean document_tab_install_auto_save_timeout_if_needed (DocumentTab* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (self->priv->auto_save_timeout <= 0, FALSE);
	if (document_tab_get_auto_save (self)) {
		_tmp1_ = document_get_location (self->priv->_document) != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !document_get_readonly (self->priv->_document);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		document_tab_install_auto_save_timeout (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void document_tab_remove_auto_save_timeout (DocumentTab* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->priv->auto_save_timeout > 0);
	g_source_remove (self->priv->auto_save_timeout);
	self->priv->auto_save_timeout = (guint) 0;
}


static gboolean document_tab_on_auto_save (DocumentTab* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (document_get_location (self->priv->_document) != NULL, FALSE);
	g_return_val_if_fail (!document_get_readonly (self->priv->_document), FALSE);
	g_return_val_if_fail (self->priv->auto_save_timeout > 0, FALSE);
	g_return_val_if_fail (document_tab_get_auto_save (self), FALSE);
	g_return_val_if_fail (document_tab_get_auto_save_interval (self) > 0, FALSE);
	if (document_get_modified (self->priv->_document)) {
		document_save (self->priv->_document, TRUE, FALSE);
	}
	result = TRUE;
	return result;
}


DocumentView* document_tab_get_view (DocumentTab* self) {
	DocumentView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_view;
	return result;
}


static void document_tab_set_view (DocumentTab* self, DocumentView* value) {
	DocumentView* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_view = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_view), _tmp0_);
	g_object_notify ((GObject *) self, "view");
}


Document* document_tab_get_document (DocumentTab* self) {
	Document* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_document;
	return result;
}


static void document_tab_set_document (DocumentTab* self, Document* value) {
	Document* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_document = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_document), _tmp0_);
	g_object_notify ((GObject *) self, "document");
}


GtkHBox* document_tab_get_label (DocumentTab* self) {
	GtkHBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label;
	return result;
}


const char* document_tab_get_label_text (DocumentTab* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = gtk_label_get_label (self->priv->_label_text);
	return result;
}


static void document_tab_set_label_text (DocumentTab* self, const char* value) {
	g_return_if_fail (self != NULL);
	gtk_label_set_label (self->priv->_label_text, value);
	g_object_notify ((GObject *) self, "label-text");
}


guint document_tab_get_auto_save_interval (DocumentTab* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_auto_save_interval;
	return result;
}


void document_tab_set_auto_save_interval (DocumentTab* self, guint value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (value > 0);
	if (self->priv->_auto_save_interval == value) {
		return;
	}
	self->priv->_auto_save_interval = value;
	if (!self->priv->_auto_save) {
		return;
	}
	if (self->priv->auto_save_timeout > 0) {
		g_return_if_fail (document_get_location (self->priv->_document) != NULL);
		g_return_if_fail (!document_get_readonly (self->priv->_document));
		document_tab_remove_auto_save_timeout (self);
		document_tab_install_auto_save_timeout (self);
	}
	g_object_notify ((GObject *) self, "auto-save-interval");
}


gboolean document_tab_get_auto_save (DocumentTab* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_auto_save;
	return result;
}


void document_tab_set_auto_save (DocumentTab* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	if (value == self->priv->_auto_save) {
		return;
	}
	self->priv->_auto_save = value;
	if (self->priv->_auto_save) {
		_tmp2_ = self->priv->auto_save_timeout <= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = document_get_location (self->priv->_document) != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !document_get_readonly (self->priv->_document);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		document_tab_install_auto_save_timeout (self);
		return;
	}
	if (!self->priv->_auto_save) {
		_tmp3_ = self->priv->auto_save_timeout > 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		document_tab_remove_auto_save_timeout (self);
		return;
	}
	if (!self->priv->_auto_save) {
		_tmp6_ = self->priv->auto_save_timeout <= 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = document_get_location (self->priv->_document) == NULL;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = document_get_readonly (self->priv->_document);
	}
	g_return_if_fail (_tmp4_);
	g_object_notify ((GObject *) self, "auto-save");
}


static void document_tab_class_init (DocumentTabClass * klass) {
	document_tab_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentTabPrivate));
	G_OBJECT_CLASS (klass)->get_property = document_tab_get_property;
	G_OBJECT_CLASS (klass)->set_property = document_tab_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_tab_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_VIEW, g_param_spec_object ("view", "view", "view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_DOCUMENT, g_param_spec_object ("document", "document", "document", TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_LABEL, g_param_spec_object ("label", "label", "label", GTK_TYPE_HBOX, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_LABEL_TEXT, g_param_spec_string ("label-text", "label-text", "label-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_AUTO_SAVE_INTERVAL, g_param_spec_uint ("auto-save-interval", "auto-save-interval", "auto-save-interval", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_AUTO_SAVE, g_param_spec_boolean ("auto-save", "auto-save", "auto-save", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("close_document", TYPE_DOCUMENT_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void document_tab_instance_init (DocumentTab * self) {
	self->priv = DOCUMENT_TAB_GET_PRIVATE (self);
	self->priv->ask_if_externally_modified = FALSE;
	self->priv->_label_text = g_object_ref_sink ((GtkLabel*) gtk_label_new (NULL));
	self->priv->_label_mark = g_object_ref_sink ((GtkLabel*) gtk_label_new (NULL));
}


static void document_tab_finalize (GObject* obj) {
	DocumentTab * self;
	self = DOCUMENT_TAB (obj);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->_document);
	_g_object_unref0 (self->priv->_label);
	_g_object_unref0 (self->priv->_label_text);
	_g_object_unref0 (self->priv->_label_mark);
	G_OBJECT_CLASS (document_tab_parent_class)->finalize (obj);
}


GType document_tab_get_type (void) {
	static volatile gsize document_tab_type_id__volatile = 0;
	if (g_once_init_enter (&document_tab_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentTab), 0, (GInstanceInitFunc) document_tab_instance_init, NULL };
		GType document_tab_type_id;
		document_tab_type_id = g_type_register_static (GTK_TYPE_VBOX, "DocumentTab", &g_define_type_info, 0);
		g_once_init_leave (&document_tab_type_id__volatile, document_tab_type_id);
	}
	return document_tab_type_id__volatile;
}


static void document_tab_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DocumentTab * self;
	self = DOCUMENT_TAB (object);
	switch (property_id) {
		case DOCUMENT_TAB_VIEW:
		g_value_set_object (value, document_tab_get_view (self));
		break;
		case DOCUMENT_TAB_DOCUMENT:
		g_value_set_object (value, document_tab_get_document (self));
		break;
		case DOCUMENT_TAB_LABEL:
		g_value_set_object (value, document_tab_get_label (self));
		break;
		case DOCUMENT_TAB_LABEL_TEXT:
		g_value_set_string (value, document_tab_get_label_text (self));
		break;
		case DOCUMENT_TAB_AUTO_SAVE_INTERVAL:
		g_value_set_uint (value, document_tab_get_auto_save_interval (self));
		break;
		case DOCUMENT_TAB_AUTO_SAVE:
		g_value_set_boolean (value, document_tab_get_auto_save (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void document_tab_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DocumentTab * self;
	self = DOCUMENT_TAB (object);
	switch (property_id) {
		case DOCUMENT_TAB_VIEW:
		document_tab_set_view (self, g_value_get_object (value));
		break;
		case DOCUMENT_TAB_DOCUMENT:
		document_tab_set_document (self, g_value_get_object (value));
		break;
		case DOCUMENT_TAB_LABEL_TEXT:
		document_tab_set_label_text (self, g_value_get_string (value));
		break;
		case DOCUMENT_TAB_AUTO_SAVE_INTERVAL:
		document_tab_set_auto_save_interval (self, g_value_get_uint (value));
		break;
		case DOCUMENT_TAB_AUTO_SAVE:
		document_tab_set_auto_save (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




