/* templates.c generated by valac 0.12.1, the Vala compiler
 * generated from templates.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <config.h>
#include <stdio.h>
#include <gtksourceview/gtksourceview.h>
#include <float.h>
#include <math.h>


#define TYPE_TEMPLATES (templates_get_type ())
#define TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEMPLATES, Templates))
#define TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEMPLATES, TemplatesClass))
#define IS_TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEMPLATES))
#define IS_TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEMPLATES))
#define TEMPLATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEMPLATES, TemplatesClass))

typedef struct _Templates Templates;
typedef struct _TemplatesClass TemplatesClass;
typedef struct _TemplatesPrivate TemplatesPrivate;

#define TEMPLATES_TYPE_TEMPLATE_COLUMN (templates_template_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block10Data Block10Data;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

struct _Templates {
	GObject parent_instance;
	TemplatesPrivate * priv;
};

struct _TemplatesClass {
	GObjectClass parent_class;
};

struct _TemplatesPrivate {
	GtkListStore* default_store;
	GtkListStore* personal_store;
	gint nb_personal_templates;
	gchar* rc_file;
	gchar* rc_dir;
};

typedef enum  {
	TEMPLATES_TEMPLATE_COLUMN_PIXBUF,
	TEMPLATES_TEMPLATE_COLUMN_ICON_ID,
	TEMPLATES_TEMPLATE_COLUMN_NAME,
	TEMPLATES_TEMPLATE_COLUMN_CONTENTS,
	TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS
} TemplatesTemplateColumn;

struct _Block10Data {
	int _ref_count_;
	Templates * self;
	GtkDialog* dialog;
	GtkVPaned* vpaned;
	GtkIconView* icon_view_default_templates;
	GtkIconView* icon_view_personal_templates;
	MainWindow* parent;
};


static gpointer templates_parent_class = NULL;
static Templates* templates_templates;
static Templates* templates_templates = NULL;

GType templates_get_type (void) G_GNUC_CONST;
#define TEMPLATES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEMPLATES, TemplatesPrivate))
enum  {
	TEMPLATES_DUMMY_PROPERTY
};
static GType templates_template_column_get_type (void) G_GNUC_UNUSED;
static Templates* templates_new (void);
static Templates* templates_construct (GType object_type);
static void templates_add_template_from_string (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, const gchar* contents);
static void templates_add_template_from_file (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, GFile* file);
Templates* templates_get_default (void);
GType main_window_get_type (void) G_GNUC_CONST;
void templates_show_dialog_new (Templates* self, MainWindow* parent);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static GtkIconView* templates_create_icon_view (Templates* self, GtkListStore* store);
static GtkWidget* templates_get_dialog_component (Templates* self, const gchar* title, GtkWidget* widget);
static void _lambda78_ (Block10Data* _data10_);
static void templates_on_icon_view_selection_changed (Templates* self, GtkIconView* icon_view, GtkIconView* other_icon_view);
static void __lambda78__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
static void _lambda79_ (Block10Data* _data10_);
static void __lambda79__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
static void _lambda80_ (GtkTreePath* path, Block10Data* _data10_);
static void templates_open_template (Templates* self, MainWindow* main_window, GtkTreeModel* model, GtkTreePath* path);
static void templates_close_dialog_new (Templates* self, GtkDialog* dialog, GtkVPaned* vpaned);
static void __lambda80__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
static void _lambda81_ (GtkTreePath* path, Block10Data* _data10_);
static void __lambda81__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
GType document_get_type (void) G_GNUC_CONST;
Document* document_tab_get_document (DocumentTab* self);
void document_set_contents (Document* self, const gchar* contents);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
void templates_show_dialog_create (Templates* self, MainWindow* parent);
DocumentTab* main_window_get_active_tab (MainWindow* self);
Document* main_window_get_active_document (MainWindow* self);
static void templates_add_personal_template (Templates* self, const gchar* contents);
void templates_show_dialog_delete (Templates* self, MainWindow* parent);
static void templates_save_rc_file (Templates* self);
static void templates_save_contents (Templates* self);
static void templates_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType templates_template_column_get_type (void) {
	static volatile gsize templates_template_column_type_id__volatile = 0;
	if (g_once_init_enter (&templates_template_column_type_id__volatile)) {
		static const GEnumValue values[] = {{TEMPLATES_TEMPLATE_COLUMN_PIXBUF, "TEMPLATES_TEMPLATE_COLUMN_PIXBUF", "pixbuf"}, {TEMPLATES_TEMPLATE_COLUMN_ICON_ID, "TEMPLATES_TEMPLATE_COLUMN_ICON_ID", "icon-id"}, {TEMPLATES_TEMPLATE_COLUMN_NAME, "TEMPLATES_TEMPLATE_COLUMN_NAME", "name"}, {TEMPLATES_TEMPLATE_COLUMN_CONTENTS, "TEMPLATES_TEMPLATE_COLUMN_CONTENTS", "contents"}, {TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, "TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType templates_template_column_type_id;
		templates_template_column_type_id = g_enum_register_static ("TemplatesTemplateColumn", values);
		g_once_init_leave (&templates_template_column_type_id__volatile, templates_template_column_type_id);
	}
	return templates_template_column_type_id__volatile;
}


static Templates* templates_construct (GType object_type) {
	Templates * self = NULL;
	GtkListStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GFile* _tmp18_ = NULL;
	GFile* _tmp19_;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GFile* _tmp24_ = NULL;
	GFile* _tmp25_;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GFile* _tmp30_ = NULL;
	GFile* _tmp31_;
	GtkListStore* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	GFile* _tmp37_ = NULL;
	GFile* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	GKeyFile* _tmp41_ = NULL;
	GKeyFile* key_file;
	gsize _tmp42_;
	gchar** _tmp43_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	gsize _tmp44_;
	gchar** _tmp45_ = NULL;
	gchar** icons;
	gint icons_length1;
	gint _icons_size_;
	GError * _inner_error_ = NULL;
	self = (Templates*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_list_store_new ((gint) TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->priv->default_store);
	self->priv->default_store = _tmp0_;
	_tmp1_ = _ ("Empty");
	templates_add_template_from_string (self, self->priv->default_store, _tmp1_, "empty", "");
	_tmp2_ = _ ("Article");
	_tmp3_ = _ ("article-en.tex");
	_tmp4_ = g_strconcat (DATA_DIR "/templates/", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_tmp7_ = _tmp6_;
	templates_add_template_from_file (self, self->priv->default_store, _tmp2_, "article", _tmp7_);
	_g_object_unref0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = _ ("Report");
	_tmp9_ = _ ("report-en.tex");
	_tmp10_ = g_strconcat (DATA_DIR "/templates/", _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_tmp13_ = _tmp12_;
	templates_add_template_from_file (self, self->priv->default_store, _tmp8_, "report", _tmp13_);
	_g_object_unref0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp14_ = _ ("Book");
	_tmp15_ = _ ("book-en.tex");
	_tmp16_ = g_strconcat (DATA_DIR "/templates/", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_file_new_for_path (_tmp17_);
	_tmp19_ = _tmp18_;
	templates_add_template_from_file (self, self->priv->default_store, _tmp14_, "book", _tmp19_);
	_g_object_unref0 (_tmp19_);
	_g_free0 (_tmp17_);
	_tmp20_ = _ ("Letter");
	_tmp21_ = _ ("letter-en.tex");
	_tmp22_ = g_strconcat (DATA_DIR "/templates/", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_file_new_for_path (_tmp23_);
	_tmp25_ = _tmp24_;
	templates_add_template_from_file (self, self->priv->default_store, _tmp20_, "letter", _tmp25_);
	_g_object_unref0 (_tmp25_);
	_g_free0 (_tmp23_);
	_tmp26_ = _ ("Presentation");
	_tmp27_ = _ ("beamer-en.tex");
	_tmp28_ = g_strconcat (DATA_DIR "/templates/", _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_file_new_for_path (_tmp29_);
	_tmp31_ = _tmp30_;
	templates_add_template_from_file (self, self->priv->default_store, _tmp26_, "beamer", _tmp31_);
	_g_object_unref0 (_tmp31_);
	_g_free0 (_tmp29_);
	_tmp32_ = gtk_list_store_new ((gint) TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->priv->personal_store);
	self->priv->personal_store = _tmp32_;
	self->priv->nb_personal_templates = 0;
	_tmp33_ = g_get_user_data_dir ();
	_tmp34_ = g_build_filename (_tmp33_, "latexila", "templatesrc", NULL, NULL);
	_g_free0 (self->priv->rc_file);
	self->priv->rc_file = _tmp34_;
	_tmp35_ = g_get_user_data_dir ();
	_tmp36_ = g_build_filename (_tmp35_, "latexila", NULL, NULL);
	_g_free0 (self->priv->rc_dir);
	self->priv->rc_dir = _tmp36_;
	_tmp37_ = g_file_new_for_path (self->priv->rc_file);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_file_query_exists (_tmp38_, NULL);
	_tmp40_ = !_tmp39_;
	_g_object_unref0 (_tmp38_);
	if (_tmp40_) {
		return self;
	}
	_tmp41_ = g_key_file_new ();
	key_file = _tmp41_;
	g_key_file_load_from_file (key_file, self->priv->rc_file, G_KEY_FILE_NONE, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (key_file);
		goto __catch9_g_error;
	}
	_tmp43_ = g_key_file_get_string_list (key_file, APP_NAME, "names", &_tmp42_, &_inner_error_);
	names = _tmp43_;
	names_length1 = _tmp42_;
	_names_size_ = _tmp42_;
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (key_file);
		goto __catch9_g_error;
	}
	_tmp45_ = g_key_file_get_string_list (key_file, APP_NAME, "icons", &_tmp44_, &_inner_error_);
	icons = _tmp45_;
	icons_length1 = _tmp44_;
	_icons_size_ = _tmp44_;
	if (_inner_error_ != NULL) {
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_free0 (key_file);
		goto __catch9_g_error;
	}
	self->priv->nb_personal_templates = names_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp46_;
			_tmp46_ = TRUE;
			while (TRUE) {
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_;
				GFile* _tmp49_ = NULL;
				GFile* _tmp50_;
				GFile* file;
				gboolean _tmp51_;
				if (!_tmp46_) {
					i++;
				}
				_tmp46_ = FALSE;
				if (!(i < self->priv->nb_personal_templates)) {
					break;
				}
				_tmp47_ = g_strdup_printf ("%s/%d.tex", self->priv->rc_dir, i);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_file_new_for_path (_tmp48_);
				_tmp50_ = _tmp49_;
				_g_free0 (_tmp48_);
				file = _tmp50_;
				_tmp51_ = g_file_query_exists (file, NULL);
				if (!_tmp51_) {
					_g_object_unref0 (file);
					continue;
				}
				templates_add_template_from_file (self, self->priv->personal_store, names[i], icons[i], file);
				_g_object_unref0 (file);
			}
		}
	}
	icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_key_file_free0 (key_file);
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Warning: load templates failed: %s\n", e->message);
		_g_error_free0 (e);
		return self;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static Templates* templates_new (void) {
	return templates_construct (TYPE_TEMPLATES);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Templates* templates_get_default (void) {
	Templates* result = NULL;
	Templates* _tmp1_;
	if (templates_templates == NULL) {
		Templates* _tmp0_ = NULL;
		_tmp0_ = templates_new ();
		_g_object_unref0 (templates_templates);
		templates_templates = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (templates_templates);
	result = _tmp1_;
	return result;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->icon_view_personal_templates);
		_g_object_unref0 (_data10_->icon_view_default_templates);
		_g_object_unref0 (_data10_->vpaned);
		_g_object_unref0 (_data10_->dialog);
		_g_object_unref0 (_data10_->parent);
		g_slice_free (Block10Data, _data10_);
	}
}


static void _lambda78_ (Block10Data* _data10_) {
	Templates * self;
	self = _data10_->self;
	templates_on_icon_view_selection_changed (self, _data10_->icon_view_default_templates, _data10_->icon_view_personal_templates);
}


static void __lambda78__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	_lambda78_ (self);
}


static void _lambda79_ (Block10Data* _data10_) {
	Templates * self;
	self = _data10_->self;
	templates_on_icon_view_selection_changed (self, _data10_->icon_view_personal_templates, _data10_->icon_view_default_templates);
}


static void __lambda79__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	_lambda79_ (self);
}


static void _lambda80_ (GtkTreePath* path, Block10Data* _data10_) {
	Templates * self;
	self = _data10_->self;
	g_return_if_fail (path != NULL);
	templates_open_template (self, _data10_->parent, (GtkTreeModel*) self->priv->default_store, path);
	templates_close_dialog_new (self, _data10_->dialog, _data10_->vpaned);
}


static void __lambda80__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	_lambda80_ (path, self);
}


static void _lambda81_ (GtkTreePath* path, Block10Data* _data10_) {
	Templates * self;
	self = _data10_->self;
	g_return_if_fail (path != NULL);
	templates_open_template (self, _data10_->parent, (GtkTreeModel*) self->priv->personal_store, path);
	templates_close_dialog_new (self, _data10_->dialog, _data10_->vpaned);
}


static void __lambda81__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	_lambda81_ (path, self);
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


void templates_show_dialog_new (Templates* self, MainWindow* parent) {
	Block10Data* _data10_;
	const gchar* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* settings;
	gint w = 0;
	gint h = 0;
	GtkWidget* _tmp3_ = NULL;
	GtkBox* _tmp4_;
	GtkBox* content_area;
	GtkVPaned* _tmp5_ = NULL;
	gint _tmp6_;
	GtkIconView* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* component;
	GtkIconView* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkWidget* _tmp12_ = NULL;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->parent = _g_object_ref0 (parent);
	_tmp0_ = _ ("New File...");
	_tmp1_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _data10_->parent, GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL, NULL);
	_data10_->dialog = g_object_ref_sink (_tmp1_);
	_tmp2_ = g_settings_new ("org.gnome.latexila.state.window");
	settings = _tmp2_;
	g_settings_get (settings, "new-file-dialog-size", "(ii)", &w, &h);
	gtk_window_set_default_size ((GtkWindow*) _data10_->dialog, w, h);
	gtk_widget_set_size_request ((GtkWidget*) _data10_->dialog, 0, 0);
	_tmp3_ = gtk_dialog_get_content_area (_data10_->dialog);
	_tmp4_ = _g_object_ref0 (GTK_BOX (_tmp3_));
	content_area = _tmp4_;
	_tmp5_ = (GtkVPaned*) gtk_vpaned_new ();
	_data10_->vpaned = g_object_ref_sink (_tmp5_);
	gtk_box_pack_start (content_area, (GtkWidget*) _data10_->vpaned, TRUE, TRUE, (guint) 0);
	_tmp6_ = g_settings_get_int (settings, "new-file-dialog-paned-position");
	gtk_paned_set_position ((GtkPaned*) _data10_->vpaned, _tmp6_);
	_tmp7_ = templates_create_icon_view (self, self->priv->default_store);
	_data10_->icon_view_default_templates = _tmp7_;
	_tmp8_ = _ ("Default templates");
	_tmp9_ = templates_get_dialog_component (self, _tmp8_, (GtkWidget*) _data10_->icon_view_default_templates);
	component = _tmp9_;
	gtk_paned_pack1 ((GtkPaned*) _data10_->vpaned, component, TRUE, TRUE);
	_tmp10_ = templates_create_icon_view (self, self->priv->personal_store);
	_data10_->icon_view_personal_templates = _tmp10_;
	_tmp11_ = _ ("Your personal templates");
	_tmp12_ = templates_get_dialog_component (self, _tmp11_, (GtkWidget*) _data10_->icon_view_personal_templates);
	_g_object_unref0 (component);
	component = _tmp12_;
	gtk_paned_pack2 ((GtkPaned*) _data10_->vpaned, component, FALSE, TRUE);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (_data10_->icon_view_default_templates, "selection-changed", (GCallback) __lambda78__gtk_icon_view_selection_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	g_signal_connect_data (_data10_->icon_view_personal_templates, "selection-changed", (GCallback) __lambda79__gtk_icon_view_selection_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	g_signal_connect_data (_data10_->icon_view_default_templates, "item-activated", (GCallback) __lambda80__gtk_icon_view_item_activated, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	g_signal_connect_data (_data10_->icon_view_personal_templates, "item-activated", (GCallback) __lambda81__gtk_icon_view_item_activated, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp13_ = gtk_dialog_run (_data10_->dialog);
	if (_tmp13_ == GTK_RESPONSE_ACCEPT) {
		GList* _tmp14_ = NULL;
		GList* selected_items;
		GtkTreeModel* _tmp15_;
		GtkTreeModel* model;
		guint _tmp16_;
		gconstpointer _tmp19_ = NULL;
		GtkTreePath* _tmp20_;
		GtkTreePath* path;
		_tmp14_ = gtk_icon_view_get_selected_items (_data10_->icon_view_default_templates);
		selected_items = _tmp14_;
		_tmp15_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->default_store));
		model = _tmp15_;
		_tmp16_ = g_list_length (selected_items);
		if (_tmp16_ == 0) {
			GList* _tmp17_ = NULL;
			GtkTreeModel* _tmp18_;
			_tmp17_ = gtk_icon_view_get_selected_items (_data10_->icon_view_personal_templates);
			__g_list_free__gtk_tree_path_free0_0 (selected_items);
			selected_items = _tmp17_;
			_tmp18_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->personal_store));
			_g_object_unref0 (model);
			model = _tmp18_;
		}
		_tmp19_ = g_list_nth_data (selected_items, (guint) 0);
		_tmp20_ = _gtk_tree_path_copy0 ((GtkTreePath*) ((GtkTreePath*) _tmp19_));
		path = _tmp20_;
		templates_open_template (self, _data10_->parent, model, path);
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		__g_list_free__gtk_tree_path_free0_0 (selected_items);
	}
	templates_close_dialog_new (self, _data10_->dialog, _data10_->vpaned);
	_g_object_unref0 (component);
	_g_object_unref0 (content_area);
	_g_object_unref0 (settings);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static void templates_open_template (Templates* self, MainWindow* main_window, GtkTreeModel* model, GtkTreePath* path) {
	GtkTreeIter _tmp0_ = {0};
	GtkTreeIter iter;
	gchar* _tmp1_;
	gchar* contents;
	gboolean _tmp2_ = FALSE;
	DocumentTab* _tmp5_ = NULL;
	DocumentTab* tab;
	Document* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_window != NULL);
	g_return_if_fail (model != NULL);
	iter = _tmp0_;
	_tmp1_ = g_strdup ("");
	contents = _tmp1_;
	if (path != NULL) {
		GtkTreeIter _tmp3_ = {0};
		gboolean _tmp4_;
		_tmp4_ = gtk_tree_model_get_iter (model, &_tmp3_, path);
		iter = _tmp3_;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gtk_tree_model_get (model, &iter, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, &contents, -1, -1);
	}
	_tmp5_ = main_window_create_tab (main_window, TRUE);
	tab = _tmp5_;
	_tmp6_ = document_tab_get_document (tab);
	document_set_contents (_tmp6_, contents);
	_g_object_unref0 (tab);
	_g_free0 (contents);
}


static void templates_close_dialog_new (Templates* self, GtkDialog* dialog, GtkVPaned* vpaned) {
	gint w = 0;
	gint h = 0;
	gint _tmp0_;
	gint _tmp1_;
	GSettings* _tmp2_ = NULL;
	GSettings* settings;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (vpaned != NULL);
	gtk_window_get_size ((GtkWindow*) dialog, &_tmp0_, &_tmp1_);
	w = _tmp0_;
	h = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.latexila.state.window");
	settings = _tmp2_;
	g_settings_set (settings, "new-file-dialog-size", "(ii)", w, h);
	_tmp3_ = gtk_paned_get_position ((GtkPaned*) vpaned);
	g_settings_set_int (settings, "new-file-dialog-paned-position", _tmp3_);
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (settings);
}


static GtkWidget* templates_get_dialog_component (Templates* self, const gchar* title, GtkWidget* widget) {
	GtkWidget* result = NULL;
	GtkVBox* _tmp0_ = NULL;
	GtkVBox* vbox;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* label;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkAlignment* _tmp6_ = NULL;
	GtkAlignment* alignment;
	GtkWidget* _tmp7_ = NULL;
	GtkWidget* scrollbar;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 6);
	vbox = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	label = g_object_ref_sink (_tmp1_);
	_tmp2_ = g_strconcat ("<b>", title, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "</b>", NULL);
	_tmp5_ = _tmp4_;
	gtk_label_set_markup (label, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	g_object_set ((GtkMisc*) label, "xalign", (gfloat) 0.0, NULL);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp6_ = (GtkAlignment*) gtk_alignment_new ((gfloat) 0.5, (gfloat) 0.5, (gfloat) 1.0, (gfloat) 1.0);
	alignment = g_object_ref_sink (_tmp6_);
	g_object_set (alignment, "left-padding", (guint) 12, NULL);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) alignment, TRUE, TRUE, (guint) 0);
	_tmp7_ = utils_add_scrollbar (widget);
	scrollbar = _tmp7_;
	gtk_container_add ((GtkContainer*) alignment, scrollbar);
	result = (GtkWidget*) vbox;
	_g_object_unref0 (scrollbar);
	_g_object_unref0 (alignment);
	_g_object_unref0 (label);
	return result;
}


void templates_show_dialog_create (Templates* self, MainWindow* parent) {
	DocumentTab* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	GtkDialog* dialog;
	GtkWidget* _tmp3_ = NULL;
	GtkBox* _tmp4_;
	GtkBox* content_area;
	GtkHBox* _tmp5_ = NULL;
	GtkHBox* hbox;
	const gchar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* label;
	GtkEntry* _tmp8_ = NULL;
	GtkEntry* entry;
	GtkIconView* _tmp9_ = NULL;
	GtkIconView* icon_view;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* scrollbar;
	const gchar* _tmp11_ = NULL;
	GtkFrame* _tmp12_ = NULL;
	GtkFrame* frame;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = main_window_get_active_tab (parent);
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = _ ("New Template...");
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp1_, (GtkWindow*) parent, 0, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL, NULL);
	dialog = g_object_ref_sink (_tmp2_);
	gtk_window_set_default_size ((GtkWindow*) dialog, 400, 330);
	_tmp3_ = gtk_dialog_get_content_area (dialog);
	_tmp4_ = _g_object_ref0 (GTK_BOX (_tmp3_));
	content_area = _tmp4_;
	_tmp5_ = (GtkHBox*) gtk_hbox_new (FALSE, 5);
	hbox = g_object_ref_sink (_tmp5_);
	_tmp6_ = _ ("Name of the new template:");
	_tmp7_ = (GtkLabel*) gtk_label_new (_tmp6_);
	label = g_object_ref_sink (_tmp7_);
	_tmp8_ = (GtkEntry*) gtk_entry_new ();
	entry = g_object_ref_sink (_tmp8_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) entry, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (content_area, (GtkWidget*) hbox, FALSE, FALSE, (guint) 10);
	_tmp9_ = templates_create_icon_view (self, self->priv->default_store);
	icon_view = _tmp9_;
	_tmp10_ = utils_add_scrollbar ((GtkWidget*) icon_view);
	scrollbar = _tmp10_;
	_tmp11_ = _ ("Choose an icon:");
	_tmp12_ = (GtkFrame*) gtk_frame_new (_tmp11_);
	frame = g_object_ref_sink (_tmp12_);
	gtk_container_add ((GtkContainer*) frame, scrollbar);
	gtk_box_pack_start (content_area, (GtkWidget*) frame, TRUE, TRUE, (guint) 10);
	gtk_widget_show_all ((GtkWidget*) content_area);
	while (TRUE) {
		gint _tmp13_;
		guint _tmp14_;
		GList* _tmp15_ = NULL;
		GList* selected_items;
		guint _tmp16_;
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		Document* _tmp17_ = NULL;
		GtkTextIter _tmp18_ = {0};
		GtkTextIter _tmp19_ = {0};
		Document* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* contents;
		GtkTreeModel* _tmp22_;
		GtkTreeModel* model;
		gconstpointer _tmp23_ = NULL;
		GtkTreePath* _tmp24_;
		GtkTreePath* path;
		GtkTreeIter iter = {0};
		gchar* icon_id = NULL;
		GtkTreeIter _tmp25_ = {0};
		const gchar* _tmp26_ = NULL;
		_tmp13_ = gtk_dialog_run (dialog);
		if (!(_tmp13_ == GTK_RESPONSE_ACCEPT)) {
			break;
		}
		_tmp14_ = gtk_entry_get_text_length (entry);
		if (_tmp14_ == 0) {
			continue;
		}
		_tmp15_ = gtk_icon_view_get_selected_items (icon_view);
		selected_items = _tmp15_;
		_tmp16_ = g_list_length (selected_items);
		if (_tmp16_ == 0) {
			__g_list_free__gtk_tree_path_free0_0 (selected_items);
			continue;
		}
		self->priv->nb_personal_templates++;
		_tmp17_ = main_window_get_active_document (parent);
		gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp17_, &_tmp18_, &_tmp19_);
		start = _tmp18_;
		end = _tmp19_;
		_tmp20_ = main_window_get_active_document (parent);
		_tmp21_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp20_, &start, &end, FALSE);
		contents = _tmp21_;
		_tmp22_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->default_store));
		model = _tmp22_;
		_tmp23_ = g_list_nth_data (selected_items, (guint) 0);
		_tmp24_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp23_);
		path = _tmp24_;
		gtk_tree_model_get_iter (model, &_tmp25_, path);
		iter = _tmp25_;
		gtk_tree_model_get (model, &iter, TEMPLATES_TEMPLATE_COLUMN_ICON_ID, &icon_id, -1, -1);
		_tmp26_ = gtk_entry_get_text (entry);
		templates_add_template_from_string (self, self->priv->personal_store, _tmp26_, icon_id, contents);
		templates_add_personal_template (self, contents);
		_g_free0 (icon_id);
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		_g_free0 (contents);
		__g_list_free__gtk_tree_path_free0_0 (selected_items);
		break;
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (frame);
	_g_object_unref0 (scrollbar);
	_g_object_unref0 (icon_view);
	_g_object_unref0 (entry);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
}


void templates_show_dialog_delete (Templates* self, MainWindow* parent) {
	const gchar* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkDialog* dialog;
	GtkWidget* _tmp2_ = NULL;
	GtkBox* _tmp3_;
	GtkBox* content_area;
	GtkIconView* _tmp4_ = NULL;
	GtkIconView* icon_view;
	const gchar* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkWidget* component;
	gint nb_personal_templates_before;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = _ ("Delete Template(s)...");
	_tmp1_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) parent, GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_DELETE, GTK_RESPONSE_ACCEPT, GTK_STOCK_OK, GTK_RESPONSE_REJECT, NULL, NULL);
	dialog = g_object_ref_sink (_tmp1_);
	gtk_window_set_default_size ((GtkWindow*) dialog, 400, 200);
	_tmp2_ = gtk_dialog_get_content_area (dialog);
	_tmp3_ = _g_object_ref0 (GTK_BOX (_tmp2_));
	content_area = _tmp3_;
	_tmp4_ = templates_create_icon_view (self, self->priv->personal_store);
	icon_view = _tmp4_;
	gtk_icon_view_set_selection_mode (icon_view, GTK_SELECTION_MULTIPLE);
	_tmp5_ = _ ("Personal templates");
	_tmp6_ = templates_get_dialog_component (self, _tmp5_, (GtkWidget*) icon_view);
	component = _tmp6_;
	gtk_box_pack_start (content_area, component, TRUE, TRUE, (guint) 10);
	gtk_widget_show_all ((GtkWidget*) content_area);
	nb_personal_templates_before = self->priv->nb_personal_templates;
	while (TRUE) {
		gint _tmp7_;
		GList* _tmp8_ = NULL;
		GList* selected_items;
		GtkTreeModel* _tmp9_;
		GtkTreeModel* model;
		guint _tmp10_;
		guint nb_selected_items;
		_tmp7_ = gtk_dialog_run (dialog);
		if (!(_tmp7_ == GTK_RESPONSE_ACCEPT)) {
			break;
		}
		_tmp8_ = gtk_icon_view_get_selected_items (icon_view);
		selected_items = _tmp8_;
		_tmp9_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->personal_store));
		model = _tmp9_;
		_tmp10_ = g_list_length (selected_items);
		nb_selected_items = _tmp10_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp11_;
				_tmp11_ = TRUE;
				while (TRUE) {
					gconstpointer _tmp12_ = NULL;
					GtkTreePath* _tmp13_;
					GtkTreePath* path;
					GtkTreeIter iter = {0};
					GtkTreeIter _tmp14_ = {0};
					if (!_tmp11_) {
						i++;
					}
					_tmp11_ = FALSE;
					if (!(i < nb_selected_items)) {
						break;
					}
					_tmp12_ = g_list_nth_data (selected_items, (guint) i);
					_tmp13_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp12_);
					path = _tmp13_;
					gtk_tree_model_get_iter (model, &_tmp14_, path);
					iter = _tmp14_;
					gtk_list_store_remove (self->priv->personal_store, &iter);
					_gtk_tree_path_free0 (path);
				}
			}
		}
		self->priv->nb_personal_templates = self->priv->nb_personal_templates - ((gint) nb_selected_items);
		_g_object_unref0 (model);
		__g_list_free__gtk_tree_path_free0_0 (selected_items);
	}
	if (self->priv->nb_personal_templates != nb_personal_templates_before) {
		templates_save_rc_file (self);
		templates_save_contents (self);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (component);
	_g_object_unref0 (icon_view);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
}


static void templates_add_template_from_string (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, const gchar* contents) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* pixbuf;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp6_ = {0};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (contents != NULL);
	_tmp0_ = g_strconcat (DATA_DIR "/images/templates/", icon_id, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".png", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = gdk_pixbuf_new_from_file (_tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	pixbuf = _tmp5_;
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	gtk_list_store_append (store, &_tmp6_);
	iter = _tmp6_;
	gtk_list_store_set (store, &iter, TEMPLATES_TEMPLATE_COLUMN_PIXBUF, pixbuf, TEMPLATES_TEMPLATE_COLUMN_ICON_ID, icon_id, TEMPLATES_TEMPLATE_COLUMN_NAME, name, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, contents, -1, -1);
	_g_object_unref0 (pixbuf);
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Warning: impossible to load the icon of the template: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void templates_add_template_from_file (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, GFile* file) {
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (file != NULL);
	g_file_load_contents (file, NULL, &_tmp0_, NULL, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp0_;
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		goto __catch11_g_error;
	}
	templates_add_template_from_string (self, store, name, icon_id, contents);
	_g_free0 (contents);
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Warning: impossible to load the template \"%s\": %s\n", name, e->message);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static GtkIconView* templates_create_icon_view (Templates* self, GtkListStore* store) {
	GtkIconView* result = NULL;
	GtkIconView* _tmp0_ = NULL;
	GtkIconView* icon_view;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = (GtkIconView*) gtk_icon_view_new_with_model ((GtkTreeModel*) store);
	icon_view = g_object_ref_sink (_tmp0_);
	gtk_icon_view_set_selection_mode (icon_view, GTK_SELECTION_SINGLE);
	gtk_icon_view_set_text_column (icon_view, (gint) TEMPLATES_TEMPLATE_COLUMN_NAME);
	gtk_icon_view_set_pixbuf_column (icon_view, (gint) TEMPLATES_TEMPLATE_COLUMN_PIXBUF);
	result = icon_view;
	return result;
}


static void templates_on_icon_view_selection_changed (Templates* self, GtkIconView* icon_view, GtkIconView* other_icon_view) {
	GList* _tmp0_ = NULL;
	GList* selected_items;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_view != NULL);
	g_return_if_fail (other_icon_view != NULL);
	_tmp0_ = gtk_icon_view_get_selected_items (icon_view);
	selected_items = _tmp0_;
	_tmp1_ = g_list_length (selected_items);
	if (_tmp1_ > 0) {
		g_signal_emit_by_name (other_icon_view, "unselect-all");
	}
	__g_list_free__gtk_tree_path_free0_0 (selected_items);
}


static void templates_add_personal_template (Templates* self, const gchar* contents) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	GFile* file;
	GFile* _tmp4_ = NULL;
	GFile* parent;
	gboolean _tmp5_ = FALSE;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	templates_save_rc_file (self);
	_tmp0_ = g_strdup_printf ("%s/%d.tex", self->priv->rc_dir, self->priv->nb_personal_templates - 1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	file = _tmp3_;
	_tmp4_ = g_file_get_parent (file);
	parent = _tmp4_;
	if (parent != NULL) {
		gboolean _tmp6_;
		_tmp6_ = g_file_query_exists (parent, NULL);
		_tmp5_ = !_tmp6_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch12_g_error;
		}
	}
	_tmp7_ = strlen (contents);
	g_file_replace_contents (file, contents, (gsize) _tmp7_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parent);
		goto __catch12_g_error;
	}
	_g_object_unref0 (parent);
	goto __finally12;
	__catch12_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Warning: impossible to save templates: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
}


static void templates_save_rc_file (Templates* self) {
	gchar** _tmp2_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp3_ = NULL;
	gchar** icons;
	gint icons_length1;
	gint _icons_size_;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp4_;
	GtkTreeModel* model;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_;
	gboolean valid_iter;
	gint i;
	GKeyFile* _tmp8_ = NULL;
	GKeyFile* key_file;
	gchar* _tmp9_ = NULL;
	gchar* key_file_data;
	GFile* _tmp10_ = NULL;
	GFile* file;
	GFile* _tmp11_ = NULL;
	GFile* parent;
	gboolean _tmp12_ = FALSE;
	gint _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->nb_personal_templates == 0) {
		GFile* _tmp0_ = NULL;
		GFile* _tmp1_;
		_tmp0_ = g_file_new_for_path (self->priv->rc_file);
		_tmp1_ = _tmp0_;
		g_file_delete (_tmp1_, NULL, &_inner_error_);
		_g_object_unref0 (_tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally13:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		return;
	}
	_tmp2_ = g_new0 (gchar*, self->priv->nb_personal_templates + 1);
	names = _tmp2_;
	names_length1 = self->priv->nb_personal_templates;
	_names_size_ = self->priv->nb_personal_templates;
	_tmp3_ = g_new0 (gchar*, self->priv->nb_personal_templates + 1);
	icons = _tmp3_;
	icons_length1 = self->priv->nb_personal_templates;
	_icons_size_ = self->priv->nb_personal_templates;
	_tmp4_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->personal_store));
	model = _tmp4_;
	_tmp6_ = gtk_tree_model_get_iter_first (model, &_tmp5_);
	iter = _tmp5_;
	valid_iter = _tmp6_;
	i = 0;
	while (TRUE) {
		gboolean _tmp7_;
		if (!valid_iter) {
			break;
		}
		gtk_tree_model_get (model, &iter, TEMPLATES_TEMPLATE_COLUMN_NAME, &names[i], TEMPLATES_TEMPLATE_COLUMN_ICON_ID, &icons[i], -1, -1);
		_tmp7_ = gtk_tree_model_iter_next (model, &iter);
		valid_iter = _tmp7_;
		i++;
	}
	_tmp8_ = g_key_file_new ();
	key_file = _tmp8_;
	g_key_file_set_string_list (key_file, APP_NAME, "names", (const gchar* const*) names, names_length1);
	g_key_file_set_string_list (key_file, APP_NAME, "icons", (const gchar* const*) icons, icons_length1);
	_tmp9_ = g_key_file_to_data (key_file, NULL, NULL);
	key_file_data = _tmp9_;
	_tmp10_ = g_file_new_for_path (self->priv->rc_file);
	file = _tmp10_;
	_tmp11_ = g_file_get_parent (file);
	parent = _tmp11_;
	if (parent != NULL) {
		gboolean _tmp13_;
		_tmp13_ = g_file_query_exists (parent, NULL);
		_tmp12_ = !_tmp13_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			_g_free0 (key_file_data);
			_g_key_file_free0 (key_file);
			goto __catch14_g_error;
		}
	}
	_tmp14_ = strlen (key_file_data);
	g_file_replace_contents (file, key_file_data, (gsize) _tmp14_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		_g_free0 (key_file_data);
		_g_key_file_free0 (key_file);
		goto __catch14_g_error;
	}
	_g_object_unref0 (parent);
	_g_object_unref0 (file);
	_g_free0 (key_file_data);
	_g_key_file_free0 (key_file);
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Warning: impossible to save templates: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (model);
		icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (model);
	icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
}


static void templates_save_contents (Templates* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gboolean valid_iter;
	gint i;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf ("rm -f %s/*.tex", self->priv->rc_dir);
	_tmp1_ = _tmp0_;
	system (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->personal_store));
	model = _tmp2_;
	_tmp4_ = gtk_tree_model_get_iter_first (model, &_tmp3_);
	iter = _tmp3_;
	valid_iter = _tmp4_;
	i = 0;
	while (TRUE) {
		gchar* contents = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_;
		GFile* file;
		GFile* _tmp9_ = NULL;
		GFile* parent;
		gboolean _tmp10_ = FALSE;
		gint _tmp12_;
		gboolean _tmp13_;
		if (!valid_iter) {
			break;
		}
		gtk_tree_model_get (model, &iter, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, &contents, -1, -1);
		_tmp5_ = g_strdup_printf ("%s/%d.tex", self->priv->rc_dir, i);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_new_for_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		file = _tmp8_;
		_tmp9_ = g_file_get_parent (file);
		parent = _tmp9_;
		if (parent != NULL) {
			gboolean _tmp11_;
			_tmp11_ = g_file_query_exists (parent, NULL);
			_tmp10_ = !_tmp11_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				goto __catch15_g_error;
			}
		}
		_tmp12_ = strlen (contents);
		g_file_replace_contents (file, contents, (gsize) _tmp12_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch15_g_error;
		}
		_g_object_unref0 (parent);
		goto __finally15;
		__catch15_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stderr, "Warning: impossible to save the template: %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally15:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_object_unref0 (model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp13_ = gtk_tree_model_iter_next (model, &iter);
		valid_iter = _tmp13_;
		i++;
		_g_object_unref0 (file);
		_g_free0 (contents);
	}
	_g_object_unref0 (model);
}


static void templates_class_init (TemplatesClass * klass) {
	templates_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TemplatesPrivate));
	G_OBJECT_CLASS (klass)->finalize = templates_finalize;
}


static void templates_instance_init (Templates * self) {
	self->priv = TEMPLATES_GET_PRIVATE (self);
}


static void templates_finalize (GObject* obj) {
	Templates * self;
	self = TEMPLATES (obj);
	_g_object_unref0 (self->priv->default_store);
	_g_object_unref0 (self->priv->personal_store);
	_g_free0 (self->priv->rc_file);
	_g_free0 (self->priv->rc_dir);
	G_OBJECT_CLASS (templates_parent_class)->finalize (obj);
}


GType templates_get_type (void) {
	static volatile gsize templates_type_id__volatile = 0;
	if (g_once_init_enter (&templates_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TemplatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) templates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Templates), 0, (GInstanceInitFunc) templates_instance_init, NULL };
		GType templates_type_id;
		templates_type_id = g_type_register_static (G_TYPE_OBJECT, "Templates", &g_define_type_info, 0);
		g_once_init_leave (&templates_type_id__volatile, templates_type_id);
	}
	return templates_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



