/* application.c generated by valac 0.12.1, the Vala compiler
 * generated from application.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gtksourceview/gtksourceview.h>
#include <unique/unique.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define APPLICATION_TYPE_STOCK_ICON (application_stock_icon_get_type ())
typedef struct _ApplicationStockIcon ApplicationStockIcon;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _Block20Data Block20Data;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _gtk_icon_source_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_source_free (var), NULL)))
#define _gtk_icon_set_unref0(var) ((var == NULL) ? NULL : (var = (gtk_icon_set_unref (var), NULL)))

struct _Application {
	GObject parent_instance;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GObjectClass parent_class;
};

struct _ApplicationPrivate {
	GList* _windows;
	MainWindow* _active_window;
};

struct _ApplicationStockIcon {
	gchar* filename;
	gchar* stock_id;
};

struct _Block20Data {
	int _ref_count_;
	Application * self;
	MainWindow* window;
};


static gpointer application_parent_class = NULL;
extern gint application_NEW_WINDOW;
gint application_NEW_WINDOW = 1;
static Application* application_instance;
static Application* application_instance = NULL;

GType application_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY,
	APPLICATION_WINDOWS,
	APPLICATION_ACTIVE_WINDOW
};
static GType application_stock_icon_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ApplicationStockIcon* application_stock_icon_dup (const ApplicationStockIcon* self);
static void application_stock_icon_free (ApplicationStockIcon* self);
static void application_stock_icon_copy (const ApplicationStockIcon* self, ApplicationStockIcon* dest);
static void application_stock_icon_destroy (ApplicationStockIcon* self);
static Application* application_new (void);
static Application* application_construct (GType object_type);
static void application_set_windows (Application* self, GList* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void application_register_my_stock_icons (Application* self);
static void application_add_theme_icon_to_stock (Application* self, const gchar* icon_name, const gchar* stock_id);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
MainWindow* application_create_window (Application* self, GdkScreen* screen);
Application* application_get_default (void);
GType document_get_type (void) G_GNUC_CONST;
GList* application_get_documents (Application* self);
GList* application_get_windows (Application* self);
GList* main_window_get_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
GList* application_get_views (Application* self);
GList* main_window_get_views (MainWindow* self);
UniqueResponse application_message (Application* self, UniqueApp* sender, gint command, UniqueMessageData* data, guint time);
MainWindow* application_get_active_window (Application* self);
gboolean main_window_is_on_workspace_screen (MainWindow* self, GdkScreen* screen, guint workspace);
static void application_set_active_window (Application* self, MainWindow* value);
void application_create_document (Application* self);
void application_open_documents (Application* self, gchar** uris);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (Block20Data* _data20_);
void main_window_save_state (MainWindow* self, gboolean sync);
MainWindow* main_window_new (void);
MainWindow* main_window_construct (GType object_type);
static void _lambda82_ (Block20Data* _data20_);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
void projects_save (Projects* self);
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
BuildTools* build_tools_get_default (void);
void build_tools_save (BuildTools* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
MostUsedSymbols* most_used_symbols_get_default (void);
void most_used_symbols_save (MostUsedSymbols* self);
static void __lambda82__gtk_object_destroy (GtkObject* _sender, gpointer self);
static gboolean _lambda83_ (Block20Data* _data20_);
static gboolean __lambda83__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
static void application_finalize (GObject* obj);
static void _vala_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_application_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const ApplicationStockIcon APPLICATION_stock_icons[82] = {{DATA_DIR "/images/icons/compile_dvi.png", "compile_dvi"}, {DATA_DIR "/images/icons/compile_pdf.png", "compile_pdf"}, {DATA_DIR "/images/icons/compile_ps.png", "compile_ps"}, {DATA_DIR "/images/icons/view_dvi.png", "view_dvi"}, {DATA_DIR "/images/icons/view_pdf.png", "view_pdf"}, {DATA_DIR "/images/icons/view_ps.png", "view_ps"}, {DATA_DIR "/images/icons/textbf.png", "bold"}, {DATA_DIR "/images/icons/textit.png", "italic"}, {DATA_DIR "/images/icons/texttt.png", "typewriter"}, {DATA_DIR "/images/icons/textsl.png", "slanted"}, {DATA_DIR "/images/icons/textsc.png", "small_caps"}, {DATA_DIR "/images/icons/textsf.png", "sans_serif"}, {DATA_DIR "/images/icons/roman.png", "roman"}, {DATA_DIR "/images/icons/underline.png", "underline"}, {DATA_DIR "/images/misc-math/set-R.png", "blackboard"}, {DATA_DIR "/images/icons/sectioning-part.png", "sectioning-part"}, {DATA_DIR "/images/icons/sectioning-chapter.png", "sectioning-chapter"}, {DATA_DIR "/images/icons/sectioning-section.png", "sectioning-section"}, {DATA_DIR "/images/icons/sectioning-subsection.png", "sectioning-subsection"}, {DATA_DIR "/images/icons/sectioning-subsubsection.png", "sectioning-subsubsection"}, {DATA_DIR "/images/icons/sectioning-paragraph.png", "sectioning-paragraph"}, {DATA_DIR "/images/icons/character-size.png", "character-size"}, {DATA_DIR "/images/icons/list-itemize.png", "list-itemize"}, {DATA_DIR "/images/icons/list-enumerate.png", "list-enumerate"}, {DATA_DIR "/images/icons/list-description.png", "list-description"}, {DATA_DIR "/images/icons/list-item.png", "list-item"}, {DATA_DIR "/images/icons/references.png", "references"}, {DATA_DIR "/images/icons/math.png", "math"}, {DATA_DIR "/images/icons/math-centered.png", "math-centered"}, {DATA_DIR "/images/icons/math-numbered.png", "math-numbered"}, {DATA_DIR "/images/icons/math-array.png", "math-array"}, {DATA_DIR "/images/icons/math-numbered-array.png", "math-numbered-array"}, {DATA_DIR "/images/icons/math-superscript.png", "math-superscript"}, {DATA_DIR "/images/icons/math-subscript.png", "math-subscript"}, {DATA_DIR "/images/icons/math-frac.png", "math-frac"}, {DATA_DIR "/images/icons/math-square-root.png", "math-square-root"}, {DATA_DIR "/images/icons/math-nth-root.png", "math-nth-root"}, {DATA_DIR "/images/icons/mathcal.png", "mathcal"}, {DATA_DIR "/images/icons/mathfrak.png", "mathfrak"}, {DATA_DIR "/images/icons/delimiters-left.png", "delimiters-left"}, {DATA_DIR "/images/icons/delimiters-right.png", "delimiters-right"}, {DATA_DIR "/images/icons/badbox.png", "badbox"}, {DATA_DIR "/images/icons/logviewer.png", "view_log"}, {DATA_DIR "/images/greek/01.png", "symbol_alpha"}, {DATA_DIR "/images/icons/accent0.png", "accent0"}, {DATA_DIR "/images/icons/accent1.png", "accent1"}, {DATA_DIR "/images/icons/accent2.png", "accent2"}, {DATA_DIR "/images/icons/accent3.png", "accent3"}, {DATA_DIR "/images/icons/accent4.png", "accent4"}, {DATA_DIR "/images/icons/accent5.png", "accent5"}, {DATA_DIR "/images/icons/accent6.png", "accent6"}, {DATA_DIR "/images/icons/accent7.png", "accent7"}, {DATA_DIR "/images/icons/accent8.png", "accent8"}, {DATA_DIR "/images/icons/accent9.png", "accent9"}, {DATA_DIR "/images/icons/accent10.png", "accent10"}, {DATA_DIR "/images/icons/accent11.png", "accent11"}, {DATA_DIR "/images/icons/accent12.png", "accent12"}, {DATA_DIR "/images/icons/accent13.png", "accent13"}, {DATA_DIR "/images/icons/accent14.png", "accent14"}, {DATA_DIR "/images/icons/accent15.png", "accent15"}, {DATA_DIR "/images/icons/mathaccent0.png", "mathaccent0"}, {DATA_DIR "/images/icons/mathaccent1.png", "mathaccent1"}, {DATA_DIR "/images/icons/mathaccent2.png", "mathaccent2"}, {DATA_DIR "/images/icons/mathaccent3.png", "mathaccent3"}, {DATA_DIR "/images/icons/mathaccent4.png", "mathaccent4"}, {DATA_DIR "/images/icons/mathaccent5.png", "mathaccent5"}, {DATA_DIR "/images/icons/mathaccent6.png", "mathaccent6"}, {DATA_DIR "/images/icons/mathaccent7.png", "mathaccent7"}, {DATA_DIR "/images/icons/mathaccent8.png", "mathaccent8"}, {DATA_DIR "/images/icons/mathaccent9.png", "mathaccent9"}, {DATA_DIR "/images/icons/mathaccent10.png", "mathaccent10"}, {DATA_DIR "/images/icons/completion_choice.png", "completion_choice"}, {DATA_DIR "/images/icons/completion_cmd.png", "completion_cmd"}, {DATA_DIR "/images/icons/tree_part.png", "tree_part"}, {DATA_DIR "/images/icons/tree_chapter.png", "tree_chapter"}, {DATA_DIR "/images/icons/tree_section.png", "tree_section"}, {DATA_DIR "/images/icons/tree_subsection.png", "tree_subsection"}, {DATA_DIR "/images/icons/tree_subsubsection.png", "tree_subsubsection"}, {DATA_DIR "/images/icons/tree_paragraph.png", "tree_paragraph"}, {DATA_DIR "/images/icons/tree_todo.png", "tree_todo"}, {DATA_DIR "/images/icons/tree_label.png", "tree_label"}, {DATA_DIR "/images/icons/table.png", "table"}};

static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static Application* application_construct (GType object_type) {
	Application * self = NULL;
	GList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** filenames;
	gint filenames_length1;
	gint _filenames_size_;
	GList* list;
	AppSettings* _tmp10_ = NULL;
	AppSettings* _tmp11_;
	MainWindow* _tmp12_ = NULL;
	MainWindow* _tmp13_;
	GError * _inner_error_ = NULL;
	self = (Application*) g_object_new (object_type, NULL);
	_tmp0_ = NULL;
	application_set_windows (self, _tmp0_);
	__g_list_free__g_object_unref0_0 (_tmp0_);
	gtk_rc_parse_string ("\n" \
"            style \"my-button-style\"\n" \
"            {\n" \
"                GtkWidget::focus-padding = 0\n" \
"                GtkWidget::focus-line-width = 0\n" \
"                xthickness = 0\n" \
"                ythickness = 0\n" \
"            }\n" \
"            widget \"*.my-close-button\" style \"my-button-style\"\n" \
"        ");
	_tmp1_ = g_strdup (ICONS_DIR "/16x16/apps/latexila.png");
	_tmp2_ = g_strdup (ICONS_DIR "/22x22/apps/latexila.png");
	_tmp3_ = g_strdup (ICONS_DIR "/24x24/apps/latexila.png");
	_tmp4_ = g_strdup (ICONS_DIR "/32x32/apps/latexila.png");
	_tmp5_ = g_strdup (ICONS_DIR "/48x48/apps/latexila.png");
	_tmp6_ = g_new0 (gchar*, 5 + 1);
	_tmp6_[0] = _tmp1_;
	_tmp6_[1] = _tmp2_;
	_tmp6_[2] = _tmp3_;
	_tmp6_[3] = _tmp4_;
	_tmp6_[4] = _tmp5_;
	filenames = _tmp6_;
	filenames_length1 = 5;
	_filenames_size_ = 5;
	list = NULL;
	{
		gchar** filename_collection;
		int filename_collection_length1;
		int filename_it;
		filename_collection = filenames;
		filename_collection_length1 = filenames_length1;
		for (filename_it = 0; filename_it < filenames_length1; filename_it = filename_it + 1) {
			gchar* _tmp7_;
			gchar* filename;
			_tmp7_ = g_strdup (filename_collection[filename_it]);
			filename = _tmp7_;
			{
				GdkPixbuf* _tmp8_ = NULL;
				GdkPixbuf* _tmp9_;
				_tmp8_ = gdk_pixbuf_new_from_file (filename, &_inner_error_);
				_tmp9_ = _tmp8_;
				if (_inner_error_ != NULL) {
					goto __catch52_g_error;
				}
				list = g_list_append (list, _tmp9_);
				goto __finally52;
				__catch52_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_warning ("application.vala:165: Error with an icon: %s", e->message);
					_g_error_free0 (e);
				}
				__finally52:
				if (_inner_error_ != NULL) {
					_g_free0 (filename);
					__g_list_free__g_object_unref0_0 (list);
					filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (filename);
			}
		}
	}
	gtk_window_set_default_icon_list (list);
	application_register_my_stock_icons (self);
	application_add_theme_icon_to_stock (self, "image-x-generic", "image");
	application_add_theme_icon_to_stock (self, "text-x-generic", "tree_include");
	_tmp10_ = app_settings_get_default ();
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp11_);
	_tmp12_ = application_create_window (self, NULL);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp13_);
	__g_list_free__g_object_unref0_0 (list);
	filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


static Application* application_new (void) {
	return application_construct (TYPE_APPLICATION);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Application* application_get_default (void) {
	Application* result = NULL;
	Application* _tmp1_;
	if (application_instance == NULL) {
		Application* _tmp0_ = NULL;
		_tmp0_ = application_new ();
		_g_object_unref0 (application_instance);
		application_instance = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (application_instance);
	result = _tmp1_;
	return result;
}


GList* application_get_documents (Application* self) {
	GList* result = NULL;
	GList* res;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	{
		GList* w_collection;
		GList* w_it;
		w_collection = self->priv->_windows;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MainWindow* _tmp0_;
			MainWindow* w;
			_tmp0_ = _g_object_ref0 ((MainWindow*) w_it->data);
			w = _tmp0_;
			{
				GList* _tmp1_ = NULL;
				_tmp1_ = main_window_get_documents (w);
				res = g_list_concat (res, _tmp1_);
				_g_object_unref0 (w);
			}
		}
	}
	result = res;
	return result;
}


GList* application_get_views (Application* self) {
	GList* result = NULL;
	GList* res;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	{
		GList* w_collection;
		GList* w_it;
		w_collection = self->priv->_windows;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MainWindow* _tmp0_;
			MainWindow* w;
			_tmp0_ = _g_object_ref0 ((MainWindow*) w_it->data);
			w = _tmp0_;
			{
				GList* _tmp1_ = NULL;
				_tmp1_ = main_window_get_views (w);
				res = g_list_concat (res, _tmp1_);
				_g_object_unref0 (w);
			}
		}
	}
	result = res;
	return result;
}


UniqueResponse application_message (Application* self, UniqueApp* sender, gint command, UniqueMessageData* data, guint time) {
	UniqueResponse result = 0;
	guint _tmp2_;
	guint workspace;
	GdkScreen* _tmp3_ = NULL;
	GdkScreen* _tmp4_;
	GdkScreen* screen;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sender != NULL, 0);
	g_return_val_if_fail (data != NULL, 0);
	if (command == application_NEW_WINDOW) {
		MainWindow* _tmp0_ = NULL;
		MainWindow* _tmp1_;
		_tmp0_ = application_create_window (self, NULL);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (_tmp1_);
		result = UNIQUE_RESPONSE_OK;
		return result;
	}
	_tmp2_ = unique_message_data_get_workspace (data);
	workspace = _tmp2_;
	_tmp3_ = unique_message_data_get_screen (data);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	screen = _tmp4_;
	_tmp5_ = main_window_is_on_workspace_screen (self->priv->_active_window, screen, workspace);
	if (!_tmp5_) {
		gboolean found;
		found = FALSE;
		{
			GList* w_collection;
			GList* w_it;
			w_collection = self->priv->_windows;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				MainWindow* _tmp6_;
				MainWindow* w;
				_tmp6_ = _g_object_ref0 ((MainWindow*) w_it->data);
				w = _tmp6_;
				{
					gboolean _tmp7_;
					if (w == self->priv->_active_window) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp7_ = main_window_is_on_workspace_screen (w, screen, workspace);
					if (_tmp7_) {
						found = TRUE;
						application_set_active_window (self, w);
						_g_object_unref0 (w);
						break;
					}
					_g_object_unref0 (w);
				}
			}
		}
		if (!found) {
			MainWindow* _tmp8_ = NULL;
			MainWindow* _tmp9_;
			_tmp8_ = application_create_window (self, screen);
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp9_);
		}
	}
	if (command == UNIQUE_NEW) {
		application_create_document (self);
	} else {
		if (command == UNIQUE_OPEN) {
			gchar** _tmp10_ = NULL;
			gchar** _tmp11_;
			gint _tmp11__length1;
			_tmp10_ = unique_message_data_get_uris (data);
			_tmp11_ = _tmp10_;
			_tmp11__length1 = -1;
			application_open_documents (self, _tmp11_);
			_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		}
	}
	gtk_window_present_with_time ((GtkWindow*) self->priv->_active_window, (guint32) time);
	result = UNIQUE_RESPONSE_OK;
	_g_object_unref0 (screen);
	return result;
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (Block20Data* _data20_) {
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		_g_object_unref0 (_data20_->self);
		_g_object_unref0 (_data20_->window);
		g_slice_free (Block20Data, _data20_);
	}
}


static void _lambda82_ (Block20Data* _data20_) {
	Application * self;
	guint _tmp0_;
	self = _data20_->self;
	self->priv->_windows = g_list_remove (self->priv->_windows, _data20_->window);
	_tmp0_ = g_list_length (self->priv->_windows);
	if (_tmp0_ == 0) {
		Projects* _tmp1_ = NULL;
		Projects* _tmp2_;
		BuildTools* _tmp3_ = NULL;
		BuildTools* _tmp4_;
		MostUsedSymbols* _tmp5_ = NULL;
		MostUsedSymbols* _tmp6_;
		_tmp1_ = projects_get_default ();
		_tmp2_ = _tmp1_;
		projects_save (_tmp2_);
		_projects_unref0 (_tmp2_);
		_tmp3_ = build_tools_get_default ();
		_tmp4_ = _tmp3_;
		build_tools_save (_tmp4_);
		_build_tools_unref0 (_tmp4_);
		_tmp5_ = most_used_symbols_get_default ();
		_tmp6_ = _tmp5_;
		most_used_symbols_save (_tmp6_);
		_g_object_unref0 (_tmp6_);
		gtk_main_quit ();
	} else {
		if (_data20_->window == self->priv->_active_window) {
			application_set_active_window (self, MAIN_WINDOW ((MainWindow*) self->priv->_windows->data));
			g_object_notify ((GObject*) self, "active-window");
		}
	}
}


static void __lambda82__gtk_object_destroy (GtkObject* _sender, gpointer self) {
	_lambda82_ (self);
}


static gboolean _lambda83_ (Block20Data* _data20_) {
	Application * self;
	gboolean result = FALSE;
	self = _data20_->self;
	application_set_active_window (self, _data20_->window);
	g_object_notify ((GObject*) self, "active-window");
	result = FALSE;
	return result;
}


static gboolean __lambda83__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = _lambda83_ (self);
	return result;
}


MainWindow* application_create_window (Application* self, GdkScreen* screen) {
	MainWindow* result = NULL;
	Block20Data* _data20_;
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_;
	MainWindow* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	if (self->priv->_active_window != NULL) {
		main_window_save_state (self->priv->_active_window, TRUE);
	}
	_tmp0_ = main_window_new ();
	_data20_->window = g_object_ref_sink (_tmp0_);
	application_set_active_window (self, _data20_->window);
	g_object_notify ((GObject*) self, "active-window");
	if (screen != NULL) {
		gtk_window_set_screen ((GtkWindow*) _data20_->window, screen);
	}
	g_signal_connect_data ((GtkObject*) _data20_->window, "destroy", (GCallback) __lambda82__gtk_object_destroy, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	g_signal_connect_data ((GtkWidget*) _data20_->window, "focus-in-event", (GCallback) __lambda83__gtk_widget_focus_in_event, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	_tmp1_ = _g_object_ref0 (_data20_->window);
	self->priv->_windows = g_list_append (self->priv->_windows, _tmp1_);
	gtk_widget_show ((GtkWidget*) _data20_->window);
	_tmp2_ = _g_object_ref0 (_data20_->window);
	result = _tmp2_;
	block20_data_unref (_data20_);
	_data20_ = NULL;
	return result;
}


void application_create_document (Application* self) {
	DocumentTab* _tmp0_ = NULL;
	DocumentTab* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_create_tab (self->priv->_active_window, TRUE);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


void application_open_documents (Application* self, gchar** uris) {
	gboolean jump_to;
	g_return_if_fail (self != NULL);
	jump_to = TRUE;
	{
		gchar** uri_collection;
		int uri_collection_length1;
		int uri_it;
		uri_collection = uris;
		uri_collection_length1 = _vala_array_length (uris);
		for (uri_it = 0; uri_it < _vala_array_length (uris); uri_it = uri_it + 1) {
			gchar* _tmp0_;
			gchar* uri;
			_tmp0_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp0_;
			{
				gint _tmp1_;
				GFile* _tmp2_ = NULL;
				GFile* location;
				DocumentTab* _tmp3_ = NULL;
				DocumentTab* _tmp4_;
				_tmp1_ = strlen (uri);
				if (_tmp1_ == 0) {
					_g_free0 (uri);
					continue;
				}
				_tmp2_ = g_file_new_for_uri (uri);
				location = _tmp2_;
				_tmp3_ = main_window_open_document (self->priv->_active_window, location, jump_to);
				_tmp4_ = _tmp3_;
				_g_object_unref0 (_tmp4_);
				jump_to = FALSE;
				_g_object_unref0 (location);
				_g_free0 (uri);
			}
		}
	}
}


static void application_register_my_stock_icons (Application* self) {
	GtkIconFactory* _tmp0_ = NULL;
	GtkIconFactory* icon_factory;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_factory_new ();
	icon_factory = _tmp0_;
	{
		ApplicationStockIcon* icon_collection;
		int icon_collection_length1;
		int icon_it;
		icon_collection = APPLICATION_stock_icons;
		icon_collection_length1 = G_N_ELEMENTS (APPLICATION_stock_icons);
		for (icon_it = 0; icon_it < G_N_ELEMENTS (APPLICATION_stock_icons); icon_it = icon_it + 1) {
			ApplicationStockIcon _tmp1_;
			ApplicationStockIcon _tmp2_ = {0};
			ApplicationStockIcon icon;
			application_stock_icon_copy (&icon_collection[icon_it], &_tmp2_);
			_tmp1_ = _tmp2_;
			icon = _tmp1_;
			{
				GtkIconSet* _tmp3_ = NULL;
				GtkIconSet* icon_set;
				GtkIconSource* _tmp4_ = NULL;
				GtkIconSource* icon_source;
				_tmp3_ = gtk_icon_set_new ();
				icon_set = _tmp3_;
				_tmp4_ = gtk_icon_source_new ();
				icon_source = _tmp4_;
				gtk_icon_source_set_filename (icon_source, icon.filename);
				gtk_icon_set_add_source (icon_set, icon_source);
				gtk_icon_factory_add (icon_factory, icon.stock_id, icon_set);
				_gtk_icon_source_free0 (icon_source);
				_gtk_icon_set_unref0 (icon_set);
				application_stock_icon_destroy (&icon);
			}
		}
	}
	gtk_icon_factory_add_default (icon_factory);
	_g_object_unref0 (icon_factory);
}


static void application_add_theme_icon_to_stock (Application* self, const gchar* icon_name, const gchar* stock_id) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* theme;
	GtkIconSet* _tmp2_ = NULL;
	GtkIconSet* icon_set;
	GtkIconSize* _tmp3_ = NULL;
	GtkIconSize* sizes;
	gint sizes_length1;
	gint _sizes_size_;
	GtkIconFactory* _tmp7_ = NULL;
	GtkIconFactory* icon_factory;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (stock_id != NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	theme = _tmp1_;
	_tmp2_ = gtk_icon_set_new ();
	icon_set = _tmp2_;
	_tmp3_ = g_new0 (GtkIconSize, 6);
	_tmp3_[0] = GTK_ICON_SIZE_MENU;
	_tmp3_[1] = GTK_ICON_SIZE_SMALL_TOOLBAR;
	_tmp3_[2] = GTK_ICON_SIZE_LARGE_TOOLBAR;
	_tmp3_[3] = GTK_ICON_SIZE_BUTTON;
	_tmp3_[4] = GTK_ICON_SIZE_DND;
	_tmp3_[5] = GTK_ICON_SIZE_DIALOG;
	sizes = _tmp3_;
	sizes_length1 = 6;
	_sizes_size_ = 6;
	{
		GtkIconSize* size_collection;
		int size_collection_length1;
		int size_it;
		size_collection = sizes;
		size_collection_length1 = sizes_length1;
		for (size_it = 0; size_it < sizes_length1; size_it = size_it + 1) {
			GtkIconSize size;
			size = size_collection[size_it];
			{
				GdkPixbuf* pixbuf;
				GdkPixbuf* _tmp4_ = NULL;
				GdkPixbuf* _tmp5_;
				GtkIconSource* _tmp6_ = NULL;
				GtkIconSource* icon_source;
				pixbuf = NULL;
				_tmp4_ = gtk_icon_theme_load_icon (theme, icon_name, (gint) size, 0, &_inner_error_);
				_tmp5_ = _tmp4_;
				if (_inner_error_ != NULL) {
					goto __catch53_g_error;
				}
				_g_object_unref0 (pixbuf);
				pixbuf = _tmp5_;
				goto __finally53;
				__catch53_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_warning ("application.vala:347: Get theme icon failed: %s", e->message);
					_g_error_free0 (e);
					_g_object_unref0 (pixbuf);
					continue;
				}
				__finally53:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (pixbuf);
					sizes = (g_free (sizes), NULL);
					_gtk_icon_set_unref0 (icon_set);
					_g_object_unref0 (theme);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp6_ = gtk_icon_source_new ();
				icon_source = _tmp6_;
				gtk_icon_source_set_pixbuf (icon_source, pixbuf);
				gtk_icon_source_set_size (icon_source, size);
				gtk_icon_set_add_source (icon_set, icon_source);
				_gtk_icon_source_free0 (icon_source);
				_g_object_unref0 (pixbuf);
			}
		}
	}
	_tmp7_ = gtk_icon_factory_new ();
	icon_factory = _tmp7_;
	gtk_icon_factory_add (icon_factory, stock_id, icon_set);
	gtk_icon_factory_add_default (icon_factory);
	_g_object_unref0 (icon_factory);
	sizes = (g_free (sizes), NULL);
	_gtk_icon_set_unref0 (icon_set);
	_g_object_unref0 (theme);
}


GList* application_get_windows (Application* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_windows;
	return result;
}


static void application_set_windows (Application* self, GList* value) {
	g_return_if_fail (self != NULL);
	self->priv->_windows = value;
	g_object_notify ((GObject *) self, "windows");
}


MainWindow* application_get_active_window (Application* self) {
	MainWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_window;
	return result;
}


static void application_set_active_window (Application* self, MainWindow* value) {
	MainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_active_window);
	self->priv->_active_window = _tmp0_;
	g_object_notify ((GObject *) self, "active-window");
}


static void application_stock_icon_copy (const ApplicationStockIcon* self, ApplicationStockIcon* dest) {
	dest->filename = g_strdup (self->filename);
	dest->stock_id = g_strdup (self->stock_id);
}


static void application_stock_icon_destroy (ApplicationStockIcon* self) {
	_g_free0 ((*self).filename);
	_g_free0 ((*self).stock_id);
}


static ApplicationStockIcon* application_stock_icon_dup (const ApplicationStockIcon* self) {
	ApplicationStockIcon* dup;
	dup = g_new0 (ApplicationStockIcon, 1);
	application_stock_icon_copy (self, dup);
	return dup;
}


static void application_stock_icon_free (ApplicationStockIcon* self) {
	application_stock_icon_destroy (self);
	g_free (self);
}


static GType application_stock_icon_get_type (void) {
	static volatile gsize application_stock_icon_type_id__volatile = 0;
	if (g_once_init_enter (&application_stock_icon_type_id__volatile)) {
		GType application_stock_icon_type_id;
		application_stock_icon_type_id = g_boxed_type_register_static ("ApplicationStockIcon", (GBoxedCopyFunc) application_stock_icon_dup, (GBoxedFreeFunc) application_stock_icon_free);
		g_once_init_leave (&application_stock_icon_type_id__volatile, application_stock_icon_type_id);
	}
	return application_stock_icon_type_id__volatile;
}


static void application_class_init (ApplicationClass * klass) {
	application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_WINDOWS, g_param_spec_pointer ("windows", "windows", "windows", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACTIVE_WINDOW, g_param_spec_object ("active-window", "active-window", "active-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void application_instance_init (Application * self) {
	self->priv = APPLICATION_GET_PRIVATE (self);
}


static void application_finalize (GObject* obj) {
	Application * self;
	self = APPLICATION (obj);
	_g_object_unref0 (self->priv->_active_window);
	G_OBJECT_CLASS (application_parent_class)->finalize (obj);
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, NULL };
		GType application_type_id;
		application_type_id = g_type_register_static (G_TYPE_OBJECT, "Application", &g_define_type_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


static void _vala_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Application * self;
	self = APPLICATION (object);
	switch (property_id) {
		case APPLICATION_WINDOWS:
		g_value_set_pointer (value, application_get_windows (self));
		break;
		case APPLICATION_ACTIVE_WINDOW:
		g_value_set_object (value, application_get_active_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_application_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Application * self;
	self = APPLICATION (object);
	switch (property_id) {
		case APPLICATION_WINDOWS:
		application_set_windows (self, g_value_get_pointer (value));
		break;
		case APPLICATION_ACTIVE_WINDOW:
		application_set_active_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



