/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 36 "./parser.y"

#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libgda/sql-parser/gda-sql-parser-private.h>
#include <libgda/sql-parser/gda-statement-struct-util.h>
#include <libgda/sql-parser/gda-statement-struct-trans.h>
#include <libgda/sql-parser/gda-statement-struct-insert.h>
#include <libgda/sql-parser/gda-statement-struct-update.h>
#include <libgda/sql-parser/gda-statement-struct-delete.h>
#include <libgda/sql-parser/gda-statement-struct-select.h>
#include <libgda/sql-parser/gda-statement-struct-compound.h>
#include <libgda/sql-parser/gda-statement-struct-parts.h>
#include <assert.h>

typedef struct {
	GValue *fname;
	GdaSqlExpr *expr;
} UpdateSet;

typedef struct {
	gboolean    distinct;
	GdaSqlExpr *expr;
} Distinct;

typedef struct {
	GdaSqlExpr *count;
	GdaSqlExpr *offset;
} Limit;

typedef struct {
	GSList *when_list;
	GSList *then_list;
} CaseBody;

static GdaSqlOperatorType
sql_operation_string_to_operator (const gchar *op)
{
	switch (g_ascii_toupper (*op)) {
	case 'A':
		return GDA_SQL_OPERATOR_TYPE_AND;
	case 'O':
		return GDA_SQL_OPERATOR_TYPE_OR;
	case 'N':
		return GDA_SQL_OPERATOR_TYPE_NOT;
	case '=':
		return GDA_SQL_OPERATOR_TYPE_EQ;
	case 'I':
		if (op[1] == 'S')
			return GDA_SQL_OPERATOR_TYPE_IS;
		else if (op[1] == 'N')
			return GDA_SQL_OPERATOR_TYPE_IN;
		else if (op[1] == 'I')
			return GDA_SQL_OPERATOR_TYPE_ILIKE;
		break;
	case 'L':
		return GDA_SQL_OPERATOR_TYPE_LIKE;
	case 'B':
		return GDA_SQL_OPERATOR_TYPE_BETWEEN;
	case '>':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_GEQ;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_GT;
		break;
	case '<':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_LEQ;
		else if (op[1] == '>')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_LT;
		break;
	case '!':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == '~') {
			if (op[2] == 0)
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP;
			else if (op[2] == '*')
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP_CI;
		}
		break;
	case '~':
		if (op[1] == '*')
			return GDA_SQL_OPERATOR_TYPE_REGEXP_CI;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_REGEXP;
		break;
	case 'S':
		return GDA_SQL_OPERATOR_TYPE_SIMILAR;
	case '|':
		if (op[1] == '|')
			return GDA_SQL_OPERATOR_TYPE_CONCAT;
		else
			return GDA_SQL_OPERATOR_TYPE_BITOR;
	case '+':
		return GDA_SQL_OPERATOR_TYPE_PLUS;
	case '-':
		return GDA_SQL_OPERATOR_TYPE_MINUS;
	case '*':
		return GDA_SQL_OPERATOR_TYPE_STAR;
	case '/':
		return GDA_SQL_OPERATOR_TYPE_DIV;
	case '%':
		return GDA_SQL_OPERATOR_TYPE_REM;
	case '&':
		return GDA_SQL_OPERATOR_TYPE_BITAND;
	}
	g_error ("Unhandled operator named '%s'\n", op);
	return 0;
}

static GdaSqlOperatorType
string_to_op_type (GValue *value)
{
	GdaSqlOperatorType op;
	op = sql_operation_string_to_operator (g_value_get_string (value));
	g_value_reset (value);
	g_free (value);
	return op;
}

static GdaSqlExpr *
compose_multiple_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	if (left->cond && (left->cond->operator_type == op)) {
		ret = left;
		ret->cond->operands = g_slist_append (ret->cond->operands, right);
	}
	else {
		GdaSqlOperation *cond;
		ret = gda_sql_expr_new (NULL);
		cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
		ret->cond = cond;
		cond->operator_type = op;
		cond->operands = g_slist_prepend (NULL, right);
		GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
		cond->operands = g_slist_prepend (cond->operands, left);
		GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	}
	return ret;
}

static GdaSqlExpr *
create_two_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, right);
	GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
	cond->operands = g_slist_prepend (cond->operands, left);
	GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlExpr *
create_uni_expr (GdaSqlOperatorType op, GdaSqlExpr *expr) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, expr);
	GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlStatement *
compose_multiple_compounds (GdaSqlStatementCompoundType ctype, GdaSqlStatement *left, GdaSqlStatement *right) {
	GdaSqlStatement *ret = NULL;
	GdaSqlStatementCompound *lc = (GdaSqlStatementCompound*) left->contents;
	if (lc->compound_type == ctype) {
		GdaSqlStatementCompound *rc = (GdaSqlStatementCompound*) right->contents;
		if (!rc->stmt_list->next || rc->compound_type == ctype) {
			GSList *list;
			for (list = rc->stmt_list; list; list = list->next)
				GDA_SQL_ANY_PART (((GdaSqlStatement*)list->data)->contents)->parent = GDA_SQL_ANY_PART (lc);

			ret = left;
			lc->stmt_list = g_slist_concat (lc->stmt_list, rc->stmt_list);
			rc->stmt_list = NULL;
			gda_sql_statement_free (right);
		}
	}
	else {
		ret = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
		gda_sql_statement_compound_set_type (ret, ctype);
		gda_sql_statement_compound_take_stmt (ret, left);
		gda_sql_statement_compound_take_stmt (ret, right);
	}
	return ret;
}

#line 208 "parser.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    gda_lemon_postgres_parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is gda_lemon_postgres_parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    gda_lemon_postgres_parserARG_SDECL     A static variable declaration for the %extra_argument
**    gda_lemon_postgres_parserARG_PDECL     A parameter declaration for the %extra_argument
**    gda_lemon_postgres_parserARG_STORE     Code to store %extra_argument into yypParser
**    gda_lemon_postgres_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 209
#define YYACTIONTYPE unsigned short int
#define gda_lemon_postgres_parserTOKENTYPE GValue *
typedef union {
  int yyinit;
  gda_lemon_postgres_parserTOKENTYPE yy0;
  GSList * yy33;
  CaseBody yy51;
  gboolean yy100;
  GSList* yy105;
  GdaTransactionIsolation yy197;
  Distinct * yy249;
  GdaSqlStatement * yy252;
  GdaSqlSelectFrom * yy259;
  GdaSqlOperatorType yy295;
  GdaSqlExpr * yy302;
  GdaSqlParamSpec * yy303;
  GdaSqlExpr* yy354;
  GdaSqlSelectJoinType yy367;
  Limit yy408;
  GdaSqlSelectTarget * yy414;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define gda_lemon_postgres_parserARG_SDECL GdaSqlParserIface *pdata;
#define gda_lemon_postgres_parserARG_PDECL ,GdaSqlParserIface *pdata
#define gda_lemon_postgres_parserARG_FETCH GdaSqlParserIface *pdata = yypParser->pdata
#define gda_lemon_postgres_parserARG_STORE yypParser->pdata = pdata
#define YYNSTATE 361
#define YYNRULE 196
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (1397)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    39,   38,  169,  168,  167,  353,  353,   22,  360,  359,
 /*    10 */    36,   41,   41,   41,   41,   37,   37,   37,   37,   37,
 /*    20 */   361,   45,   45,  310,  141,   50,   50,   49,   47,   47,
 /*    30 */    42,  349,  269,  348,  347,  346,  345,  259,  276,  190,
 /*    40 */     6,   43,   44,  199,   13,  235,  335,   76,   40,   40,
 /*    50 */    36,   41,   41,   41,   41,   37,   37,   37,   37,   37,
 /*    60 */   223,   45,   45,  319,  132,   50,   50,   49,   47,   47,
 /*    70 */    42,  353,  318,  314,  225,  224,  196,  195,  194,  226,
 /*    80 */   261,  260,  189,  287,   39,   38,  324,   76,  285,   28,
 /*    90 */   315,   26,   80,  286,   21,   41,   41,   41,   41,   37,
 /*   100 */    37,   37,   37,   37,   48,   45,   45,  354,  354,   50,
 /*   110 */    50,   49,   47,   47,   42,  329,  209,  348,  347,  346,
 /*   120 */   345,  216,  362,  142,  192,   43,   44,  199,   13,  235,
 /*   130 */   335,   76,   40,   40,   36,   41,   41,   41,   41,   37,
 /*   140 */    37,   37,   37,   37,  167,   45,   45,  265,  264,   50,
 /*   150 */    50,   49,   47,   47,   42,   39,   38,  243,   37,  298,
 /*   160 */    45,   45,  352,  352,   50,   50,   49,   47,   47,   42,
 /*   170 */   243,   76,  301,  354,  558,  143,  193,  121,  308,  134,
 /*   180 */    50,   50,   49,   47,   47,   42,   76,  243,  297,  240,
 /*   190 */   133,  188,  278,  277,  357,  102,   43,   44,  199,   13,
 /*   200 */   235,  335,   76,   40,   40,   36,   41,   41,   41,   41,
 /*   210 */    37,   37,   37,   37,   37,  222,   45,   45,  241,  350,
 /*   220 */    50,   50,   49,   47,   47,   42,   39,   38,  352,  292,
 /*   230 */   243,  344,  240,   37,   37,   37,   37,   37,  101,   45,
 /*   240 */    45,  219,   76,   50,   50,   49,   47,   47,   42,  358,
 /*   250 */   289,  136,  127,  169,  168,  167,  276,  169,  168,  167,
 /*   260 */   274,  241,  350,  152,  161,   76,  276,   43,   44,  199,
 /*   270 */    13,  235,  335,    1,   40,   40,   36,   41,   41,   41,
 /*   280 */    41,   37,   37,   37,   37,   37,  171,   45,   45,  129,
 /*   290 */   179,   50,   50,   49,   47,   47,   42,  239,  243,  240,
 /*   300 */   137,  200,   39,   38,  243,  102,  240,  357,  243,  243,
 /*   310 */   301,  240,   61,   76,  185,  336,  180,   93,   49,   47,
 /*   320 */    47,   42,  156,  229,  169,  168,  167,  231,  241,  350,
 /*   330 */   227,  325,  232,   48,  299,  241,  350,   34,   76,  128,
 /*   340 */   241,  350,   75,   43,   44,  199,   13,  235,  335,   48,
 /*   350 */    40,   40,   36,   41,   41,   41,   41,   37,   37,   37,
 /*   360 */    37,   37,  339,   45,   45,  284,  283,   50,   50,   49,
 /*   370 */    47,   47,   42,  178,   46,   39,   38,  243,  306,  240,
 /*   380 */   243,  187,  240,  364,  198,  102,  343,   42,  102,   76,
 /*   390 */   357,  364,  364,  364,  169,  168,  167,  337,  280,  191,
 /*   400 */     3,  243,  215,  201,   76,  169,  168,  167,  241,  350,
 /*   410 */   135,  241,  350,  360,  359,  221,   43,   44,  199,   13,
 /*   420 */   235,  335,   27,   40,   40,   36,   41,   41,   41,   41,
 /*   430 */    37,   37,   37,   37,   37,  334,   45,   45,  263,  262,
 /*   440 */    50,   50,   49,   47,   47,   42,  177,  170,   39,   38,
 /*   450 */   243,  353,  240,  243,  186,  240,  326,  197,  102,  322,
 /*   460 */   353,  102,   76,  357,  169,  168,  167,  169,  168,  167,
 /*   470 */   154,  118,   57,    2,  243,   55,  355,   80,  169,  168,
 /*   480 */   167,  241,  350,  323,  241,  350,  397,   56,  125,   43,
 /*   490 */    44,  199,   13,  235,  335,   24,   40,   40,   36,   41,
 /*   500 */    41,   41,   41,   37,   37,   37,   37,   37,  142,   45,
 /*   510 */    45,  353,  353,   50,   50,   49,   47,   47,   42,  176,
 /*   520 */   353,  353,  181,   11,   39,   38,  243,  372,  240,  243,
 /*   530 */   302,  240,  371,  295,   88,   76,  357,   88,   10,  357,
 /*   540 */    82,  372,  372,  341,   20,  282,  371,  371,   74,  243,
 /*   550 */   282,  236,  340,  354,  243,  282,  303,  241,  350,   18,
 /*   560 */   241,  350,  354,   60,   55,   43,   44,  199,   13,  235,
 /*   570 */   335,  130,   40,   40,   36,   41,   41,   41,   41,   37,
 /*   580 */    37,   37,   37,   37,  353,   45,   45,  146,  252,   50,
 /*   590 */    50,   49,   47,   47,   42,   39,   38,  251,  250,   66,
 /*   600 */   313,  243,  217,  240,  182,   48,   48,   51,  352,  106,
 /*   610 */   218,   76,  312,  354,  354,   48,   74,  352,  182,  311,
 /*   620 */    77,  357,  354,  354,  275,  309,  243,  357,  147,  332,
 /*   630 */   276,  331,  241,  350,  397,  357,   43,   35,  199,   13,
 /*   640 */   235,  335,  123,   40,   40,   36,   41,   41,   41,   41,
 /*   650 */    37,   37,   37,   37,   37,  244,   45,   45,  333,  330,
 /*   660 */    50,   50,   49,   47,   47,   42,   39,   38,  352,  352,
 /*   670 */   356,  175,  357,  243,  307,  240,  183,  352,  352,  271,
 /*   680 */   305,  120,   76,   16,  290,  276,  354,  357,  357,  287,
 /*   690 */   268,  184,  279,  357,  285,  243,  276,  145,  243,  286,
 /*   700 */   203,   73,  267,  282,  241,  350,  213,   43,   33,  199,
 /*   710 */    13,  235,  335,  320,   40,   40,   36,   41,   41,   41,
 /*   720 */    41,   37,   37,   37,   37,   37,  338,   45,   45,  212,
 /*   730 */   192,   50,   50,   49,   47,   47,   42,   39,   38,  150,
 /*   740 */   239,  352,  240,  243,  243,  240,  202,  294,   63,  258,
 /*   750 */    70,  138,  338,   76,    9,  276,  317,  207,    8,    7,
 /*   760 */   249,   68,   58,   15,   14,  173,  172,   81,  160,  338,
 /*   770 */   293,  241,  350,  291,  241,  350,   79,   78,   51,   44,
 /*   780 */   199,   13,  235,  335,   76,   40,   40,   36,   41,   41,
 /*   790 */    41,   41,   37,   37,   37,   37,   37,  338,   45,   45,
 /*   800 */    25,  159,   50,   50,   49,   47,   47,   42,   39,   38,
 /*   810 */   140,  353,  228,  158,  243,   19,  240,  243,  157,  240,
 /*   820 */   237,  230,  105,  321,   76,  139,  353,   23,  155,   17,
 /*   830 */   220,  281,  304,   55,  216,  237,  273,   72,  270,  296,
 /*   840 */   205,  266,  174,   59,  210,  241,  350,   69,  241,  350,
 /*   850 */    65,  199,   13,  235,  335,  208,   40,   40,   36,   41,
 /*   860 */    41,   41,   41,   37,   37,   37,   37,   37,  206,   45,
 /*   870 */    45,   67,  248,   50,   50,   49,   47,   47,   42,   30,
 /*   880 */   353,  246,  166,  287,   83,  153,  247,  234,  285,  237,
 /*   890 */   126,  300,  242,  286,   30,   76,  351,  256,  327,  255,
 /*   900 */   254,   31,   32,  342,  243,  353,  240,  243,  238,  240,
 /*   910 */    29,    4,   87,  354,  288,  119,   31,   32,  353,  124,
 /*   920 */   272,  216,  316,  257,  192,   29,    5,  237,  354,  332,
 /*   930 */   253,  331,  245,  559,  559,  241,  350,  559,  241,  350,
 /*   940 */   559,  559,  142,  559,  332,  243,  331,  240,   30,  559,
 /*   950 */   559,  559,  559,  110,   12,  559,  353,  559,  333,  330,
 /*   960 */   233,  559,  174,  328,  559,  237,  211,  214,  352,   12,
 /*   970 */    31,   32,  342,  333,  330,  233,  241,  350,  328,   29,
 /*   980 */     5,  559,  354,  352,  559,  559,   30,  559,   52,  559,
 /*   990 */   559,  559,  559,  559,  559,  559,  559,  559,  332,  559,
 /*  1000 */   331,  559,  559,  559,  559,  559,  559,  354,   31,   32,
 /*  1010 */   559,  559,  559,  559,  559,  559,  559,   29,    4,  559,
 /*  1020 */   354,  559,   71,   12,   30,  559,  559,  333,  330,  233,
 /*  1030 */   559,  559,  328,  559,  559,  559,  332,  352,  331,  559,
 /*  1040 */   559,   64,  559,  559,  559,  559,   31,   32,  559,  142,
 /*  1050 */   151,  559,  559,  559,  559,   29,    5,  559,  354,  559,
 /*  1060 */   559,   12,  352,  559,  559,  333,  330,  233,  559,  243,
 /*  1070 */   328,  240,  559,  559,  332,  352,  331,  107,  243,  559,
 /*  1080 */   240,  559,   54,  149,  559,  559,  165,  559,  243,  559,
 /*  1090 */   240,  559,  559,  131,  122,  559,  116,  559,  559,   12,
 /*  1100 */   241,  350,  559,  333,  330,  233,  559,  559,  328,  241,
 /*  1110 */   350,  559,  559,  352,  559,  243,  559,  240,  559,  241,
 /*  1120 */   350,  559,  559,  114,  559,  559,  559,  559,  559,  243,
 /*  1130 */   559,  240,  559,  559,   53,  559,  243,  113,  240,  559,
 /*  1140 */   243,  559,  240,  243,  112,  240,  241,  350,  117,  559,
 /*  1150 */   243,  104,  240,  559,  559,  559,  148,  559,  115,  204,
 /*  1160 */   241,  350,  144,  559,  559,  142,  559,  241,  350,  559,
 /*  1170 */   559,  241,  350,  559,  241,  350,  559,  559,  243,  559,
 /*  1180 */   240,  241,  350,  559,  559,  559,  103,  559,  243,  559,
 /*  1190 */   240,  243,  559,  240,  559,  243,  109,  240,  243,  164,
 /*  1200 */   240,  559,  559,  163,  559,  559,  108,  559,  559,  241,
 /*  1210 */   350,  559,  559,  559,  559,  559,  559,  559,  559,  241,
 /*  1220 */   350,  559,  241,  350,  559,  559,  241,  350,  559,  241,
 /*  1230 */   350,  559,  243,  559,  240,  559,  243,  559,  240,  559,
 /*  1240 */   162,  243,  559,  240,   86,  243,  559,  240,  243,  100,
 /*  1250 */   240,  559,  559,   99,  559,  559,   85,  243,  559,  240,
 /*  1260 */   559,  559,  559,  241,  350,   98,  559,  241,  350,  559,
 /*  1270 */   559,  559,  241,  350,  559,  559,  241,  350,  559,  241,
 /*  1280 */   350,  559,  559,  559,  243,  559,  240,  559,  241,  350,
 /*  1290 */   559,  243,   84,  240,  243,  559,  240,  559,  559,   97,
 /*  1300 */   559,  559,   96,  559,  559,  243,  559,  240,  559,  243,
 /*  1310 */   559,  240,  559,   62,  559,  241,  350,   95,  559,  243,
 /*  1320 */   559,  240,  241,  350,  559,  241,  350,   94,  559,  559,
 /*  1330 */   243,  559,  240,  559,  559,  559,  241,  350,   92,  559,
 /*  1340 */   241,  350,  559,  559,  559,  243,  559,  240,  559,  559,
 /*  1350 */   241,  350,  243,   91,  240,  559,  559,  243,  559,  240,
 /*  1360 */    90,  241,  350,  559,  243,   89,  240,  559,  559,  559,
 /*  1370 */   559,  559,  111,  559,  559,  559,  241,  350,  559,  559,
 /*  1380 */   559,  559,  559,  241,  350,  559,  559,  559,  241,  350,
 /*  1390 */   559,  559,  559,  559,  559,  241,  350,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    26,   27,  110,  111,  112,    1,    1,   33,  116,  117,
 /*    10 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    20 */     0,   87,   88,  103,  183,   91,   92,   93,   94,   95,
 /*    30 */    96,  152,  164,  154,  155,  156,  157,  169,  170,   23,
 /*    40 */   199,   67,   68,   69,   70,   71,   72,  113,   74,   75,
 /*    50 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    60 */   140,   87,   88,    5,   60,   91,   92,   93,   94,   95,
 /*    70 */    96,    1,   14,  103,  104,  105,  106,  107,  108,  109,
 /*    80 */    64,   65,   66,   13,   26,   27,  102,  113,   18,  145,
 /*    90 */   120,  147,  101,   23,  120,   77,   78,   79,   80,   81,
 /*   100 */    82,   83,   84,   85,  120,   87,   88,  103,  103,   91,
 /*   110 */    92,   93,   94,   95,   96,  152,  125,  154,  155,  156,
 /*   120 */   157,   51,    0,  132,   54,   67,   68,   69,   70,   71,
 /*   130 */    72,  113,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   140 */    82,   83,   84,   85,  112,   87,   88,   64,   65,   91,
 /*   150 */    92,   93,   94,   95,   96,   26,   27,  170,   85,  172,
 /*   160 */    87,   88,  158,  158,   91,   92,   93,   94,   95,   96,
 /*   170 */   170,  113,  172,  103,  160,  161,  176,  163,  103,  141,
 /*   180 */    91,   92,   93,   94,   95,   96,  113,  170,  201,  172,
 /*   190 */   141,  174,   55,   56,  180,  178,   67,   68,   69,   70,
 /*   200 */    71,   72,  113,   74,   75,   76,   77,   78,   79,   80,
 /*   210 */    81,   82,   83,   84,   85,  140,   87,   88,  201,  202,
 /*   220 */    91,   92,   93,   94,   95,   96,   26,   27,  158,  131,
 /*   230 */   170,  102,  172,   81,   82,   83,   84,   85,  178,   87,
 /*   240 */    88,  143,  113,   91,   92,   93,   94,   95,   96,  102,
 /*   250 */   164,  165,  166,  110,  111,  112,  170,  110,  111,  112,
 /*   260 */   164,  201,  202,  167,  204,  113,  170,   67,   68,   69,
 /*   270 */    70,   71,   72,  101,   74,   75,   76,   77,   78,   79,
 /*   280 */    80,   81,   82,   83,   84,   85,  151,   87,   88,  141,
 /*   290 */   163,   91,   92,   93,   94,   95,   96,  170,  170,  172,
 /*   300 */   172,  174,   26,   27,  170,  178,  172,  180,  170,  170,
 /*   310 */   172,  172,  178,  113,  176,  102,  102,  178,   93,   94,
 /*   320 */    95,   96,  194,  189,  110,  111,  112,  200,  201,  202,
 /*   330 */   191,  102,   71,  120,    1,  201,  202,   76,  113,  141,
 /*   340 */   201,  202,  142,   67,   68,   69,   70,   71,   72,  120,
 /*   350 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   360 */    84,   85,  102,   87,   88,   58,   59,   91,   92,   93,
 /*   370 */    94,   95,   96,  163,  101,   26,   27,  170,  103,  172,
 /*   380 */   170,  174,  172,  102,  174,  178,  102,   96,  178,  113,
 /*   390 */   180,  110,  111,  112,  110,  111,  112,  102,   53,   54,
 /*   400 */   101,  170,   57,  172,  113,  110,  111,  112,  201,  202,
 /*   410 */   179,  201,  202,  116,  117,  140,   67,   68,   69,   70,
 /*   420 */    71,   72,  146,   74,   75,   76,   77,   78,   79,   80,
 /*   430 */    81,   82,   83,   84,   85,   17,   87,   88,   64,   65,
 /*   440 */    91,   92,   93,   94,   95,   96,  163,  151,   26,   27,
 /*   450 */   170,    1,  172,  170,  174,  172,  102,  174,  178,  102,
 /*   460 */     1,  178,  113,  180,  110,  111,  112,  110,  111,  112,
 /*   470 */   102,  192,  193,  101,  170,  142,  172,  101,  110,  111,
 /*   480 */   112,  201,  202,  102,  201,  202,   51,  165,  166,   67,
 /*   490 */    68,   69,   70,   71,   72,  146,   74,   75,   76,   77,
 /*   500 */    78,   79,   80,   81,   82,   83,   84,   85,  132,   87,
 /*   510 */    88,    1,    1,   91,   92,   93,   94,   95,   96,  163,
 /*   520 */     1,    1,  163,  135,   26,   27,  170,  102,  172,  170,
 /*   530 */   102,  172,  102,  120,  178,  113,  180,  178,  135,  180,
 /*   540 */   127,  116,  117,   93,  120,  120,  116,  117,  120,  170,
 /*   550 */   120,  172,   93,  103,  170,  120,  172,  201,  202,  120,
 /*   560 */   201,  202,  103,  101,  142,   67,   68,   69,   70,   71,
 /*   570 */    72,   60,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   580 */    82,   83,   84,   85,    1,   87,   88,  102,  102,   91,
 /*   590 */    92,   93,   94,   95,   96,   26,   27,  102,  102,  120,
 /*   600 */   103,  170,  161,  172,  163,  120,  120,  128,  158,  178,
 /*   610 */   163,  113,  103,  103,  103,  120,  120,  158,  163,  103,
 /*   620 */   101,  180,  103,  103,  164,  103,  170,  180,  172,  119,
 /*   630 */   170,  121,  201,  202,   51,  180,   67,   68,   69,   70,
 /*   640 */    71,   72,  122,   74,   75,   76,   77,   78,   79,   80,
 /*   650 */    81,   82,   83,   84,   85,  163,   87,   88,  148,  149,
 /*   660 */    91,   92,   93,   94,   95,   96,   26,   27,  158,  158,
 /*   670 */   163,  163,  180,  170,  103,  172,  163,  158,  158,  164,
 /*   680 */   103,  178,  113,  139,  102,  170,  103,  180,  180,   13,
 /*   690 */   164,   52,   54,  180,   18,  170,  170,  172,  170,   23,
 /*   700 */   172,  118,  121,  120,  201,  202,  119,   67,   68,   69,
 /*   710 */    70,   71,   72,  190,   74,   75,   76,   77,   78,   79,
 /*   720 */    80,   81,   82,   83,   84,   85,  203,   87,   88,  120,
 /*   730 */    54,   91,   92,   93,   94,   95,   96,   26,   27,  119,
 /*   740 */   170,  158,  172,  170,  170,  172,  172,  198,  178,  164,
 /*   750 */   124,  178,  203,  113,  101,  170,  190,  120,  101,  101,
 /*   760 */     1,  127,  130,   75,   75,  207,  207,  181,  177,  203,
 /*   770 */   200,  201,  202,  131,  201,  202,  181,  181,  128,   68,
 /*   780 */    69,   70,   71,   72,  113,   74,   75,   76,   77,   78,
 /*   790 */    79,   80,   81,   82,   83,   84,   85,  203,   87,   88,
 /*   800 */   145,  185,   91,   92,   93,   94,   95,   96,   26,   27,
 /*   810 */   205,    1,  137,  186,  170,  136,  172,  170,  187,  172,
 /*   820 */    10,  134,  178,  188,  113,  178,    1,  133,  195,  139,
 /*   830 */   138,  166,  196,  142,   51,   10,  166,  168,  118,  198,
 /*   840 */    67,  169,   58,  101,  171,  201,  202,  173,  201,  202,
 /*   850 */   168,   69,   70,   71,   72,  175,   74,   75,   76,   77,
 /*   860 */    78,   79,   80,   81,   82,   83,   84,   85,  120,   87,
 /*   870 */    88,  171,  177,   91,   92,   93,   94,   95,   96,   69,
 /*   880 */     1,  162,  184,   13,  182,  167,  177,  206,   18,   10,
 /*   890 */   167,  198,  170,   23,   69,  113,  170,  170,   73,  170,
 /*   900 */   170,   91,   92,   93,  170,    1,  172,  170,  170,  172,
 /*   910 */   100,  101,  178,  103,  165,  178,   91,   92,    1,  167,
 /*   920 */   165,   51,  197,  170,   54,  100,  101,   10,  103,  119,
 /*   930 */   170,  121,  162,  208,  208,  201,  202,  208,  201,  202,
 /*   940 */   208,  208,  132,  208,  119,  170,  121,  172,   69,  208,
 /*   950 */   208,  208,  208,  178,  144,  208,    1,  208,  148,  149,
 /*   960 */   150,  208,   58,  153,  208,   10,   62,   63,  158,  144,
 /*   970 */    91,   92,   93,  148,  149,  150,  201,  202,  153,  100,
 /*   980 */   101,  208,  103,  158,  208,  208,   69,  208,  118,  208,
 /*   990 */   208,  208,  208,  208,  208,  208,  208,  208,  119,  208,
 /*  1000 */   121,  208,  208,  208,  208,  208,  208,  103,   91,   92,
 /*  1010 */   208,  208,  208,  208,  208,  208,  208,  100,  101,  208,
 /*  1020 */   103,  208,  118,  144,   69,  208,  208,  148,  149,  150,
 /*  1030 */   208,  208,  153,  208,  208,  208,  119,  158,  121,  208,
 /*  1040 */   208,    8,  208,  208,  208,  208,   91,   92,  208,  132,
 /*  1050 */    17,  208,  208,  208,  208,  100,  101,  208,  103,  208,
 /*  1060 */   208,  144,  158,  208,  208,  148,  149,  150,  208,  170,
 /*  1070 */   153,  172,  208,  208,  119,  158,  121,  178,  170,  208,
 /*  1080 */   172,  208,   49,   50,  208,  208,  178,  208,  170,  208,
 /*  1090 */   172,  208,  208,   60,   61,  208,  178,  208,  208,  144,
 /*  1100 */   201,  202,  208,  148,  149,  150,  208,  208,  153,  201,
 /*  1110 */   202,  208,  208,  158,  208,  170,  208,  172,  208,  201,
 /*  1120 */   202,  208,  208,  178,  208,  208,  208,  208,  208,  170,
 /*  1130 */   208,  172,  208,  208,  101,  208,  170,  178,  172,  208,
 /*  1140 */   170,  208,  172,  170,  178,  172,  201,  202,  178,  208,
 /*  1150 */   170,  178,  172,  208,  208,  208,  123,  208,  178,  126,
 /*  1160 */   201,  202,  129,  208,  208,  132,  208,  201,  202,  208,
 /*  1170 */   208,  201,  202,  208,  201,  202,  208,  208,  170,  208,
 /*  1180 */   172,  201,  202,  208,  208,  208,  178,  208,  170,  208,
 /*  1190 */   172,  170,  208,  172,  208,  170,  178,  172,  170,  178,
 /*  1200 */   172,  208,  208,  178,  208,  208,  178,  208,  208,  201,
 /*  1210 */   202,  208,  208,  208,  208,  208,  208,  208,  208,  201,
 /*  1220 */   202,  208,  201,  202,  208,  208,  201,  202,  208,  201,
 /*  1230 */   202,  208,  170,  208,  172,  208,  170,  208,  172,  208,
 /*  1240 */   178,  170,  208,  172,  178,  170,  208,  172,  170,  178,
 /*  1250 */   172,  208,  208,  178,  208,  208,  178,  170,  208,  172,
 /*  1260 */   208,  208,  208,  201,  202,  178,  208,  201,  202,  208,
 /*  1270 */   208,  208,  201,  202,  208,  208,  201,  202,  208,  201,
 /*  1280 */   202,  208,  208,  208,  170,  208,  172,  208,  201,  202,
 /*  1290 */   208,  170,  178,  172,  170,  208,  172,  208,  208,  178,
 /*  1300 */   208,  208,  178,  208,  208,  170,  208,  172,  208,  170,
 /*  1310 */   208,  172,  208,  178,  208,  201,  202,  178,  208,  170,
 /*  1320 */   208,  172,  201,  202,  208,  201,  202,  178,  208,  208,
 /*  1330 */   170,  208,  172,  208,  208,  208,  201,  202,  178,  208,
 /*  1340 */   201,  202,  208,  208,  208,  170,  208,  172,  208,  208,
 /*  1350 */   201,  202,  170,  178,  172,  208,  208,  170,  208,  172,
 /*  1360 */   178,  201,  202,  208,  170,  178,  172,  208,  208,  208,
 /*  1370 */   208,  208,  178,  208,  208,  208,  201,  202,  208,  208,
 /*  1380 */   208,  208,  208,  201,  202,  208,  208,  208,  201,  202,
 /*  1390 */   208,  208,  208,  208,  208,  201,  202,
};
#define YY_SHIFT_USE_DFLT (-122)
#define YY_SHIFT_COUNT (246)
#define YY_SHIFT_MIN   (-121)
#define YY_SHIFT_MAX   (1033)
static const short yy_shift_ofst[] = {
 /*     0 */  1033,  810,  917,  917,  917,  917,  879,  955,  955,  955,
 /*    10 */   955,  955,  955,  825,  955,  955,  955,  955,  955,  955,
 /*    20 */   955,  955,  955,  955,  955,  955,  955,  955,  955,  955,
 /*    30 */   955,  955,  955,  955,  955,  955,  955,  955,  955,  955,
 /*    40 */   955,  955,  955,  955,  955,  955,  955,  955,  955,  955,
 /*    50 */   955,  955,   70, 1033,  904,  510,  583,  519,    5,    5,
 /*    60 */     5,   58,   58,  422,  870,  520,    5,    5,    5,   -9,
 /*    70 */     5,    5,    5,    5,    5,    5,    5,  376,  376,  376,
 /*    80 */   376,  376, -122, -122,  -26,  349,  276,  200,  129,  498,
 /*    90 */   498,  498,  498,  498,  498,  498,  498,  498,  498,  498,
 /*   100 */   498,  498,  498,  640,  569,  498,  498,  711,  782,  782,
 /*   110 */   782,  -66,  -66,  -66,  -66,   18,  152,   73,  -30,   89,
 /*   120 */   225, -108,  511,    4,  676,  430,  676,  425,  459,  450,
 /*   130 */     5,    5,    5,    5,    5,  479,  435,  333,  291,  291,
 /*   140 */   -56,  413,   98,  297,  773,  650,  748,  742,  773,  720,
 /*   150 */   784,  720,  783,  783,  691,  692,  690,  694,  687,  679,
 /*   160 */   675,  655,  671,  671,  671,  671,  650,  642,  642,  642,
 /*   170 */  -122, -122,  -37, -121,   16,  368,  357,  354,  295,  284,
 /*   180 */   281,  214,  147,  143,  345,  496,  495,  486,  485,  374,
 /*   190 */    83,  137,  307,  428,  275,   75,  -80,  229,  213,  261,
 /*   200 */   -16,  689,  688,  632,  634,  759,  658,  657,  637,  653,
 /*   210 */   626,  620,  581,  609,  587,  638,  639,  582,   32,  544,
 /*   220 */   462,  577,  571,  522,  516,  509,  497,  439,  403,  424,
 /*   230 */   388,  381,  372,  296,  418,  299,  260,  273,  198,  148,
 /*   240 */   172,  135,   49,   38,   32,  122,   20,
};
#define YY_REDUCE_USE_DFLT (-160)
#define YY_REDUCE_COUNT (171)
#define YY_REDUCE_MIN   (-159)
#define YY_REDUCE_MAX   (1194)
static const short yy_reduce_ofst[] = {
 /*     0 */    14,  127,  283,  210,  359,  356,  570,  280,  207,   17,
 /*    10 */   139,  134,   60, 1194, 1187, 1182, 1175, 1160, 1149, 1139,
 /*    20 */  1135, 1124, 1121, 1114, 1087, 1078, 1075, 1071, 1066, 1062,
 /*    30 */  1028, 1025, 1021, 1018, 1008,  980,  973,  970,  966,  959,
 /*    40 */   945,  918,  908,  899,  775,  737,  734,  647,  644,  573,
 /*    50 */   503,  431,   86,  441, -132,  -13,   96,  128,  231,  138,
 /*    60 */     0,  566,  523,  549,  322,  585,  574,  528,  525,  513,
 /*    70 */   456,  526,  515,  460,  384,  379,  304,  508,  507,  492,
 /*    80 */   455,  447,  279, -159,  594,  594,  594,  594,  594,  594,
 /*    90 */   594,  594,  594,  594,  594,  594,  594,  594,  594,  594,
 /*   100 */   594,  594,  594,  594,  594,  594,  594,  594,  594,  594,
 /*   110 */   594,  594,  594,  594,  594,  594,  594,  594,  725,  594,
 /*   120 */   594,  770,  760,  753,  755,  752,  749,  723,  726,  738,
 /*   130 */   730,  729,  727,  726,  722,  709,  718,  693,  594,  594,
 /*   140 */   681,  698,  702,  719,  700,  695,  680,  674,  673,  682,
 /*   150 */   672,  669,  670,  665,  641,  636,  633,  635,  631,  627,
 /*   160 */   616,  605,  594,  594,  594,  594,  591,  596,  595,  586,
 /*   170 */   559,  558,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   557,  493,  493,  493,  557,  557,  557,  493,  493,  493,
 /*    10 */   557,  557,  532,  557,  557,  557,  557,  557,  557,  557,
 /*    20 */   557,  557,  557,  557,  557,  557,  557,  557,  557,  557,
 /*    30 */   557,  557,  557,  557,  557,  557,  557,  557,  557,  557,
 /*    40 */   557,  557,  557,  557,  557,  557,  557,  557,  557,  557,
 /*    50 */   557,  557,  403,  557,  403,  557,  403,  557,  557,  557,
 /*    60 */   557,  449,  449,  486,  367,  403,  557,  557,  557,  557,
 /*    70 */   557,  403,  403,  403,  557,  557,  557,  557,  557,  557,
 /*    80 */   557,  557,  459,  478,  440,  557,  557,  557,  557,  431,
 /*    90 */   430,  490,  461,  492,  491,  451,  442,  441,  534,  535,
 /*   100 */   533,  531,  495,  557,  557,  494,  428,  512,  521,  520,
 /*   110 */   511,  524,  517,  516,  515,  519,  514,  518,  455,  508,
 /*   120 */   505,  557,  557,  557,  557,  397,  557,  397,  557,  557,
 /*   130 */   557,  557,  557,  557,  557,  427,  373,  486,  506,  507,
 /*   140 */   536,  454,  487,  557,  418,  427,  415,  422,  418,  395,
 /*   150 */   383,  395,  557,  557,  486,  458,  462,  439,  443,  450,
 /*   160 */   452,  557,  522,  510,  509,  513,  427,  436,  436,  436,
 /*   170 */   546,  546,  557,  557,  557,  557,  557,  557,  557,  557,
 /*   180 */   525,  557,  557,  417,  557,  557,  557,  557,  557,  388,
 /*   190 */   387,  557,  557,  557,  557,  557,  557,  557,  557,  557,
 /*   200 */   557,  557,  557,  557,  557,  557,  557,  557,  416,  557,
 /*   210 */   557,  557,  557,  381,  557,  557,  557,  557,  433,  489,
 /*   220 */   557,  557,  557,  557,  557,  557,  557,  453,  557,  444,
 /*   230 */   557,  557,  557,  557,  557,  557,  557,  557,  555,  554,
 /*   240 */   499,  497,  555,  554,  434,  557,  557,  429,  426,  419,
 /*   250 */   423,  421,  420,  412,  411,  410,  414,  413,  386,  385,
 /*   260 */   390,  389,  394,  393,  392,  391,  384,  382,  380,  379,
 /*   270 */   396,  378,  377,  376,  370,  369,  404,  402,  401,  400,
 /*   280 */   399,  374,  398,  409,  408,  407,  406,  405,  375,  368,
 /*   290 */   363,  437,  488,  480,  479,  477,  476,  485,  484,  475,
 /*   300 */   474,  425,  457,  424,  456,  473,  472,  471,  470,  469,
 /*   310 */   468,  467,  466,  465,  464,  463,  460,  446,  448,  447,
 /*   320 */   445,  438,  525,  502,  500,  528,  529,  538,  545,  543,
 /*   330 */   542,  541,  540,  539,  530,  537,  526,  527,  523,  503,
 /*   340 */   483,  482,  481,  501,  498,  550,  549,  548,  547,  544,
 /*   350 */   496,  556,  553,  552,  551,  504,  435,  432,  364,  366,
 /*   360 */   365,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         ID => nothing */
    1,  /*      ABORT => ID */
    1,  /*      AFTER => ID */
    1,  /*    ANALYZE => ID */
    1,  /*        ASC => ID */
    1,  /*     ATTACH => ID */
    1,  /*     BEFORE => ID */
    1,  /*      BEGIN => ID */
    1,  /*    CASCADE => ID */
    1,  /*       CAST => ID */
    1,  /*   CONFLICT => ID */
    1,  /*   DATABASE => ID */
    1,  /*   DEFERRED => ID */
    1,  /*       DESC => ID */
    1,  /*     DETACH => ID */
    1,  /*       EACH => ID */
    1,  /*        END => ID */
    1,  /*  EXCLUSIVE => ID */
    1,  /*    EXPLAIN => ID */
    1,  /*       FAIL => ID */
    1,  /*        FOR => ID */
    1,  /*     IGNORE => ID */
    1,  /*  IMMEDIATE => ID */
    1,  /*  INITIALLY => ID */
    1,  /*    INSTEAD => ID */
    1,  /*       LIKE => ID */
    1,  /*      ILIKE => ID */
    1,  /*      MATCH => ID */
    1,  /*       PLAN => ID */
    1,  /*      QUERY => ID */
    1,  /*        KEY => ID */
    1,  /*         OF => ID */
    1,  /*     OFFSET => ID */
    1,  /*     PRAGMA => ID */
    1,  /*      RAISE => ID */
    1,  /*    REPLACE => ID */
    1,  /*   RESTRICT => ID */
    1,  /*        ROW => ID */
    1,  /*       TEMP => ID */
    1,  /*    TRIGGER => ID */
    1,  /*     VACUUM => ID */
    1,  /*       VIEW => ID */
    1,  /*    VIRTUAL => ID */
    1,  /*    REINDEX => ID */
    1,  /*     RENAME => ID */
    1,  /*   CTIME_KW => ID */
    1,  /*         IF => ID */
    1,  /*  DELIMITER => ID */
    1,  /*     COMMIT => ID */
    1,  /*   ROLLBACK => ID */
    1,  /*  ISOLATION => ID */
    1,  /*      LEVEL => ID */
    1,  /* SERIALIZABLE => ID */
    1,  /*       READ => ID */
    1,  /*  COMMITTED => ID */
    1,  /* UNCOMMITTED => ID */
    1,  /* REPEATABLE => ID */
    1,  /*      WRITE => ID */
    1,  /*       ONLY => ID */
    1,  /*  SAVEPOINT => ID */
    1,  /*    RELEASE => ID */
    1,  /*    COMMENT => ID */
    1,  /*      FORCE => ID */
    1,  /*       WAIT => ID */
    1,  /*     NOWAIT => ID */
    1,  /*      BATCH => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  gda_lemon_postgres_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void gda_lemon_postgres_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "ID",            "ABORT",         "AFTER",       
  "ANALYZE",       "ASC",           "ATTACH",        "BEFORE",      
  "BEGIN",         "CASCADE",       "CAST",          "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "END",           "EXCLUSIVE",     "EXPLAIN",     
  "FAIL",          "FOR",           "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "ILIKE",       
  "MATCH",         "PLAN",          "QUERY",         "KEY",         
  "OF",            "OFFSET",        "PRAGMA",        "RAISE",       
  "REPLACE",       "RESTRICT",      "ROW",           "TEMP",        
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "IF",          
  "DELIMITER",     "COMMIT",        "ROLLBACK",      "ISOLATION",   
  "LEVEL",         "SERIALIZABLE",  "READ",          "COMMITTED",   
  "UNCOMMITTED",   "REPEATABLE",    "WRITE",         "ONLY",        
  "SAVEPOINT",     "RELEASE",       "COMMENT",       "FORCE",       
  "WAIT",          "NOWAIT",        "BATCH",         "OR",          
  "AND",           "NOT",           "IS",            "IN",          
  "ISNULL",        "NOTNULL",       "DIFF",          "EQ",          
  "BETWEEN",       "GT",            "LEQ",           "LT",          
  "GEQ",           "REGEXP",        "REGEXP_CI",     "NOT_REGEXP",  
  "NOT_REGEXP_CI",  "SIMILAR",       "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "COLLATE",       "UMINUS",        "UPLUS",       
  "BITNOT",        "LP",            "RP",            "JOIN",        
  "INNER",         "NATURAL",       "LEFT",          "RIGHT",       
  "FULL",          "CROSS",         "UNION",         "EXCEPT",      
  "INTERSECT",     "PGCAST",        "ILLEGAL",       "SQLCOMMENT",  
  "SEMI",          "END_OF_FILE",   "TRANSACTION",   "STRING",      
  "COMMA",         "INTEGER",       "TO",            "INSERT",      
  "INTO",          "VALUES",        "DELETE",        "FROM",        
  "WHERE",         "UPDATE",        "SET",           "ALL",         
  "SELECT",        "LIMIT",         "ORDER",         "BY",          
  "HAVING",        "GROUP",         "USING",         "ON",          
  "OUTER",         "DOT",           "AS",            "DISTINCT",    
  "CASE",          "WHEN",          "THEN",          "ELSE",        
  "NULL",          "FLOAT",         "UNSPECVAL",     "LSBRACKET",   
  "RSBRACKET",     "SIMPLEPARAM",   "PNAME",         "PDESCR",      
  "PTYPE",         "PNULLOK",       "TEXTUAL",       "error",       
  "stmt",          "cmd",           "eos",           "compound",    
  "nm_opt",        "transtype",     "transilev",     "opt_comma",   
  "trans_opt_kw",  "ora_commit_write",  "nm",            "opt_on_conflict",
  "fullname",      "inscollist_opt",  "exprlist",      "ins_extra_values",
  "inscollist",    "where_opt",     "expr",          "setlist",     
  "selectcmd",     "opt_compound_all",  "distinct",      "selcollist",  
  "from",          "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "sortlist",      "sortorder",     "nexprlist",   
  "seltablist",    "stl_prefix",    "seltarget",     "on_cond",     
  "using_opt",     "jointype",      "as",            "sclp",        
  "starname",      "value",         "pvalue",        "uni_op",      
  "case_operand",  "case_exprlist",  "case_else",     "paramspec",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "stmt ::= cmd eos",
 /*   1 */ "stmt ::= compound eos",
 /*   2 */ "cmd ::= LP cmd RP",
 /*   3 */ "compound ::= LP compound RP",
 /*   4 */ "eos ::= SEMI",
 /*   5 */ "eos ::= END_OF_FILE",
 /*   6 */ "cmd ::= BEGIN",
 /*   7 */ "cmd ::= BEGIN TRANSACTION nm_opt",
 /*   8 */ "cmd ::= BEGIN transtype TRANSACTION nm_opt",
 /*   9 */ "cmd ::= BEGIN transtype nm_opt",
 /*  10 */ "cmd ::= BEGIN transilev",
 /*  11 */ "cmd ::= BEGIN TRANSACTION transilev",
 /*  12 */ "cmd ::= BEGIN TRANSACTION transtype",
 /*  13 */ "cmd ::= BEGIN TRANSACTION transtype opt_comma transilev",
 /*  14 */ "cmd ::= BEGIN TRANSACTION transilev opt_comma transtype",
 /*  15 */ "cmd ::= BEGIN transtype opt_comma transilev",
 /*  16 */ "cmd ::= BEGIN transilev opt_comma transtype",
 /*  17 */ "cmd ::= END trans_opt_kw nm_opt",
 /*  18 */ "cmd ::= COMMIT nm_opt",
 /*  19 */ "cmd ::= COMMIT TRANSACTION nm_opt",
 /*  20 */ "cmd ::= COMMIT FORCE STRING",
 /*  21 */ "cmd ::= COMMIT FORCE STRING COMMA INTEGER",
 /*  22 */ "cmd ::= COMMIT COMMENT STRING",
 /*  23 */ "cmd ::= COMMIT COMMENT STRING ora_commit_write",
 /*  24 */ "cmd ::= COMMIT ora_commit_write",
 /*  25 */ "cmd ::= ROLLBACK trans_opt_kw nm_opt",
 /*  26 */ "ora_commit_write ::= WRITE IMMEDIATE",
 /*  27 */ "ora_commit_write ::= WRITE BATCH",
 /*  28 */ "ora_commit_write ::= WRITE WAIT",
 /*  29 */ "ora_commit_write ::= WRITE NOWAIT",
 /*  30 */ "ora_commit_write ::= WRITE IMMEDIATE WAIT",
 /*  31 */ "ora_commit_write ::= WRITE IMMEDIATE NOWAIT",
 /*  32 */ "ora_commit_write ::= WRITE BATCH WAIT",
 /*  33 */ "ora_commit_write ::= WRITE BATCH NOWAIT",
 /*  34 */ "trans_opt_kw ::=",
 /*  35 */ "trans_opt_kw ::= TRANSACTION",
 /*  36 */ "opt_comma ::=",
 /*  37 */ "opt_comma ::= COMMA",
 /*  38 */ "transilev ::= ISOLATION LEVEL SERIALIZABLE",
 /*  39 */ "transilev ::= ISOLATION LEVEL REPEATABLE READ",
 /*  40 */ "transilev ::= ISOLATION LEVEL READ COMMITTED",
 /*  41 */ "transilev ::= ISOLATION LEVEL READ UNCOMMITTED",
 /*  42 */ "nm_opt ::=",
 /*  43 */ "nm_opt ::= nm",
 /*  44 */ "transtype ::= DEFERRED",
 /*  45 */ "transtype ::= IMMEDIATE",
 /*  46 */ "transtype ::= EXCLUSIVE",
 /*  47 */ "transtype ::= READ WRITE",
 /*  48 */ "transtype ::= READ ONLY",
 /*  49 */ "cmd ::= SAVEPOINT nm",
 /*  50 */ "cmd ::= RELEASE SAVEPOINT nm",
 /*  51 */ "cmd ::= RELEASE nm",
 /*  52 */ "cmd ::= ROLLBACK trans_opt_kw TO nm",
 /*  53 */ "cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm",
 /*  54 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP",
 /*  55 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values",
 /*  56 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound",
 /*  57 */ "opt_on_conflict ::=",
 /*  58 */ "opt_on_conflict ::= OR ID",
 /*  59 */ "ins_extra_values ::= ins_extra_values COMMA LP exprlist RP",
 /*  60 */ "ins_extra_values ::= COMMA LP exprlist RP",
 /*  61 */ "inscollist_opt ::=",
 /*  62 */ "inscollist_opt ::= LP inscollist RP",
 /*  63 */ "inscollist ::= inscollist COMMA fullname",
 /*  64 */ "inscollist ::= fullname",
 /*  65 */ "cmd ::= DELETE FROM fullname where_opt",
 /*  66 */ "where_opt ::=",
 /*  67 */ "where_opt ::= WHERE expr",
 /*  68 */ "cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt",
 /*  69 */ "setlist ::= setlist COMMA fullname EQ expr",
 /*  70 */ "setlist ::= fullname EQ expr",
 /*  71 */ "compound ::= selectcmd",
 /*  72 */ "compound ::= compound UNION opt_compound_all compound",
 /*  73 */ "compound ::= compound EXCEPT opt_compound_all compound",
 /*  74 */ "compound ::= compound INTERSECT opt_compound_all compound",
 /*  75 */ "opt_compound_all ::=",
 /*  76 */ "opt_compound_all ::= ALL",
 /*  77 */ "selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /*  78 */ "limit_opt ::=",
 /*  79 */ "limit_opt ::= LIMIT expr",
 /*  80 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /*  81 */ "limit_opt ::= LIMIT expr COMMA expr",
 /*  82 */ "orderby_opt ::=",
 /*  83 */ "orderby_opt ::= ORDER BY sortlist",
 /*  84 */ "sortlist ::= sortlist COMMA expr sortorder",
 /*  85 */ "sortlist ::= expr sortorder",
 /*  86 */ "sortorder ::= ASC",
 /*  87 */ "sortorder ::= DESC",
 /*  88 */ "sortorder ::=",
 /*  89 */ "having_opt ::=",
 /*  90 */ "having_opt ::= HAVING expr",
 /*  91 */ "groupby_opt ::=",
 /*  92 */ "groupby_opt ::= GROUP BY nexprlist",
 /*  93 */ "from ::=",
 /*  94 */ "from ::= FROM seltablist",
 /*  95 */ "seltablist ::= stl_prefix seltarget on_cond using_opt",
 /*  96 */ "using_opt ::= USING LP inscollist RP",
 /*  97 */ "using_opt ::=",
 /*  98 */ "stl_prefix ::=",
 /*  99 */ "stl_prefix ::= seltablist jointype",
 /* 100 */ "on_cond ::= ON expr",
 /* 101 */ "on_cond ::=",
 /* 102 */ "jointype ::= COMMA",
 /* 103 */ "jointype ::= JOIN",
 /* 104 */ "jointype ::= CROSS JOIN",
 /* 105 */ "jointype ::= INNER JOIN",
 /* 106 */ "jointype ::= NATURAL JOIN",
 /* 107 */ "jointype ::= LEFT JOIN",
 /* 108 */ "jointype ::= LEFT OUTER JOIN",
 /* 109 */ "jointype ::= RIGHT JOIN",
 /* 110 */ "jointype ::= RIGHT OUTER JOIN",
 /* 111 */ "jointype ::= FULL JOIN",
 /* 112 */ "jointype ::= FULL OUTER JOIN",
 /* 113 */ "seltarget ::= fullname as",
 /* 114 */ "seltarget ::= fullname ID",
 /* 115 */ "seltarget ::= LP compound RP as",
 /* 116 */ "sclp ::= selcollist COMMA",
 /* 117 */ "sclp ::=",
 /* 118 */ "selcollist ::= sclp expr as",
 /* 119 */ "selcollist ::= sclp starname",
 /* 120 */ "starname ::= STAR",
 /* 121 */ "starname ::= nm DOT STAR",
 /* 122 */ "starname ::= nm DOT nm DOT STAR",
 /* 123 */ "as ::= AS fullname",
 /* 124 */ "as ::= AS value",
 /* 125 */ "as ::=",
 /* 126 */ "distinct ::=",
 /* 127 */ "distinct ::= ALL",
 /* 128 */ "distinct ::= DISTINCT",
 /* 129 */ "distinct ::= DISTINCT ON expr",
 /* 130 */ "nexprlist ::= nexprlist COMMA expr",
 /* 131 */ "nexprlist ::= expr",
 /* 132 */ "exprlist ::=",
 /* 133 */ "exprlist ::= exprlist COMMA expr",
 /* 134 */ "exprlist ::= expr",
 /* 135 */ "expr ::= pvalue",
 /* 136 */ "expr ::= value",
 /* 137 */ "expr ::= LP expr RP",
 /* 138 */ "expr ::= fullname",
 /* 139 */ "expr ::= fullname LP exprlist RP",
 /* 140 */ "expr ::= fullname LP compound RP",
 /* 141 */ "expr ::= fullname LP starname RP",
 /* 142 */ "expr ::= CAST LP expr AS fullname RP",
 /* 143 */ "expr ::= expr PGCAST fullname",
 /* 144 */ "expr ::= expr PLUS|MINUS expr",
 /* 145 */ "expr ::= expr STAR expr",
 /* 146 */ "expr ::= expr SLASH|REM expr",
 /* 147 */ "expr ::= expr BITAND|BITOR expr",
 /* 148 */ "expr ::= MINUS expr",
 /* 149 */ "expr ::= PLUS expr",
 /* 150 */ "expr ::= expr AND expr",
 /* 151 */ "expr ::= expr OR expr",
 /* 152 */ "expr ::= expr CONCAT expr",
 /* 153 */ "expr ::= expr GT|LEQ|GEQ|LT expr",
 /* 154 */ "expr ::= expr DIFF|EQ expr",
 /* 155 */ "expr ::= expr LIKE expr",
 /* 156 */ "expr ::= expr ILIKE expr",
 /* 157 */ "expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr",
 /* 158 */ "expr ::= expr BETWEEN expr AND expr",
 /* 159 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 160 */ "expr ::= NOT expr",
 /* 161 */ "expr ::= BITNOT expr",
 /* 162 */ "expr ::= expr uni_op",
 /* 163 */ "expr ::= expr IS expr",
 /* 164 */ "expr ::= LP compound RP",
 /* 165 */ "expr ::= expr IN LP exprlist RP",
 /* 166 */ "expr ::= expr IN LP compound RP",
 /* 167 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 168 */ "expr ::= expr NOT IN LP compound RP",
 /* 169 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 170 */ "case_operand ::= expr",
 /* 171 */ "case_operand ::=",
 /* 172 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 173 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 174 */ "case_else ::= ELSE expr",
 /* 175 */ "case_else ::=",
 /* 176 */ "uni_op ::= ISNULL",
 /* 177 */ "uni_op ::= IS NOTNULL",
 /* 178 */ "value ::= NULL",
 /* 179 */ "value ::= STRING",
 /* 180 */ "value ::= INTEGER",
 /* 181 */ "value ::= FLOAT",
 /* 182 */ "pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET",
 /* 183 */ "pvalue ::= value LSBRACKET paramspec RSBRACKET",
 /* 184 */ "pvalue ::= SIMPLEPARAM",
 /* 185 */ "paramspec ::=",
 /* 186 */ "paramspec ::= paramspec PNAME",
 /* 187 */ "paramspec ::= paramspec PDESCR",
 /* 188 */ "paramspec ::= paramspec PTYPE",
 /* 189 */ "paramspec ::= paramspec PNULLOK",
 /* 190 */ "nm ::= JOIN",
 /* 191 */ "nm ::= ID",
 /* 192 */ "nm ::= TEXTUAL",
 /* 193 */ "fullname ::= nm",
 /* 194 */ "fullname ::= nm DOT nm",
 /* 195 */ "fullname ::= nm DOT nm DOT nm",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to gda_lemon_postgres_parser and gda_lemon_postgres_parserFree.
*/
void *gda_lemon_postgres_parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  gda_lemon_postgres_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
      /* TERMINAL Destructor */
    case 1: /* ID */
    case 2: /* ABORT */
    case 3: /* AFTER */
    case 4: /* ANALYZE */
    case 5: /* ASC */
    case 6: /* ATTACH */
    case 7: /* BEFORE */
    case 8: /* BEGIN */
    case 9: /* CASCADE */
    case 10: /* CAST */
    case 11: /* CONFLICT */
    case 12: /* DATABASE */
    case 13: /* DEFERRED */
    case 14: /* DESC */
    case 15: /* DETACH */
    case 16: /* EACH */
    case 17: /* END */
    case 18: /* EXCLUSIVE */
    case 19: /* EXPLAIN */
    case 20: /* FAIL */
    case 21: /* FOR */
    case 22: /* IGNORE */
    case 23: /* IMMEDIATE */
    case 24: /* INITIALLY */
    case 25: /* INSTEAD */
    case 26: /* LIKE */
    case 27: /* ILIKE */
    case 28: /* MATCH */
    case 29: /* PLAN */
    case 30: /* QUERY */
    case 31: /* KEY */
    case 32: /* OF */
    case 33: /* OFFSET */
    case 34: /* PRAGMA */
    case 35: /* RAISE */
    case 36: /* REPLACE */
    case 37: /* RESTRICT */
    case 38: /* ROW */
    case 39: /* TEMP */
    case 40: /* TRIGGER */
    case 41: /* VACUUM */
    case 42: /* VIEW */
    case 43: /* VIRTUAL */
    case 44: /* REINDEX */
    case 45: /* RENAME */
    case 46: /* CTIME_KW */
    case 47: /* IF */
    case 48: /* DELIMITER */
    case 49: /* COMMIT */
    case 50: /* ROLLBACK */
    case 51: /* ISOLATION */
    case 52: /* LEVEL */
    case 53: /* SERIALIZABLE */
    case 54: /* READ */
    case 55: /* COMMITTED */
    case 56: /* UNCOMMITTED */
    case 57: /* REPEATABLE */
    case 58: /* WRITE */
    case 59: /* ONLY */
    case 60: /* SAVEPOINT */
    case 61: /* RELEASE */
    case 62: /* COMMENT */
    case 63: /* FORCE */
    case 64: /* WAIT */
    case 65: /* NOWAIT */
    case 66: /* BATCH */
    case 67: /* OR */
    case 68: /* AND */
    case 69: /* NOT */
    case 70: /* IS */
    case 71: /* IN */
    case 72: /* ISNULL */
    case 73: /* NOTNULL */
    case 74: /* DIFF */
    case 75: /* EQ */
    case 76: /* BETWEEN */
    case 77: /* GT */
    case 78: /* LEQ */
    case 79: /* LT */
    case 80: /* GEQ */
    case 81: /* REGEXP */
    case 82: /* REGEXP_CI */
    case 83: /* NOT_REGEXP */
    case 84: /* NOT_REGEXP_CI */
    case 85: /* SIMILAR */
    case 86: /* ESCAPE */
    case 87: /* BITAND */
    case 88: /* BITOR */
    case 89: /* LSHIFT */
    case 90: /* RSHIFT */
    case 91: /* PLUS */
    case 92: /* MINUS */
    case 93: /* STAR */
    case 94: /* SLASH */
    case 95: /* REM */
    case 96: /* CONCAT */
    case 97: /* COLLATE */
    case 98: /* UMINUS */
    case 99: /* UPLUS */
    case 100: /* BITNOT */
    case 101: /* LP */
    case 102: /* RP */
    case 103: /* JOIN */
    case 104: /* INNER */
    case 105: /* NATURAL */
    case 106: /* LEFT */
    case 107: /* RIGHT */
    case 108: /* FULL */
    case 109: /* CROSS */
    case 110: /* UNION */
    case 111: /* EXCEPT */
    case 112: /* INTERSECT */
    case 113: /* PGCAST */
    case 114: /* ILLEGAL */
    case 115: /* SQLCOMMENT */
    case 116: /* SEMI */
    case 117: /* END_OF_FILE */
    case 118: /* TRANSACTION */
    case 119: /* STRING */
    case 120: /* COMMA */
    case 121: /* INTEGER */
    case 122: /* TO */
    case 123: /* INSERT */
    case 124: /* INTO */
    case 125: /* VALUES */
    case 126: /* DELETE */
    case 127: /* FROM */
    case 128: /* WHERE */
    case 129: /* UPDATE */
    case 130: /* SET */
    case 131: /* ALL */
    case 132: /* SELECT */
    case 133: /* LIMIT */
    case 134: /* ORDER */
    case 135: /* BY */
    case 136: /* HAVING */
    case 137: /* GROUP */
    case 138: /* USING */
    case 139: /* ON */
    case 140: /* OUTER */
    case 141: /* DOT */
    case 142: /* AS */
    case 143: /* DISTINCT */
    case 144: /* CASE */
    case 145: /* WHEN */
    case 146: /* THEN */
    case 147: /* ELSE */
    case 148: /* NULL */
    case 149: /* FLOAT */
    case 150: /* UNSPECVAL */
    case 151: /* LSBRACKET */
    case 152: /* RSBRACKET */
    case 153: /* SIMPLEPARAM */
    case 154: /* PNAME */
    case 155: /* PDESCR */
    case 156: /* PTYPE */
    case 157: /* PNULLOK */
    case 158: /* TEXTUAL */
{
#line 9 "./parser.y"
if ((yypminor->yy0)) {
#ifdef GDA_DEBUG_NO
		 gchar *str = gda_sql_value_stringify ((yypminor->yy0));
		 g_print ("___ token destructor /%s/\n", str)
		 g_free (str);
#endif
		 g_value_unset ((yypminor->yy0)); g_free ((yypminor->yy0));}
#line 1397 "parser.c"
}
      break;
    case 160: /* stmt */
{
#line 280 "./parser.y"
g_print ("Statement destroyed by parser: %p\n", (yypminor->yy252)); gda_sql_statement_free ((yypminor->yy252));
#line 1404 "parser.c"
}
      break;
    case 161: /* cmd */
    case 163: /* compound */
    case 180: /* selectcmd */
{
#line 303 "./parser.y"
gda_sql_statement_free ((yypminor->yy252));
#line 1413 "parser.c"
}
      break;
    case 173: /* inscollist_opt */
    case 176: /* inscollist */
    case 196: /* using_opt */
{
#line 480 "./parser.y"
if ((yypminor->yy105)) {g_slist_foreach ((yypminor->yy105), (GFunc) gda_sql_field_free, NULL); g_slist_free ((yypminor->yy105));}
#line 1422 "parser.c"
}
      break;
    case 174: /* exprlist */
    case 191: /* nexprlist */
{
#line 766 "./parser.y"
if ((yypminor->yy33)) {g_slist_foreach ((yypminor->yy33), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy33));}
#line 1430 "parser.c"
}
      break;
    case 175: /* ins_extra_values */
{
#line 469 "./parser.y"
GSList *list;
		for (list = (yypminor->yy105); list; list = list->next) {
			g_slist_foreach ((GSList*) list->data, (GFunc) gda_sql_field_free, NULL); 
			g_slist_free ((GSList*) list->data);
		}
		g_slist_free ((yypminor->yy105));

#line 1443 "parser.c"
}
      break;
    case 177: /* where_opt */
    case 178: /* expr */
    case 186: /* having_opt */
    case 195: /* on_cond */
    case 202: /* pvalue */
{
#line 502 "./parser.y"
gda_sql_expr_free ((yypminor->yy302));
#line 1454 "parser.c"
}
      break;
    case 179: /* setlist */
{
#line 522 "./parser.y"
GSList *list;
	for (list = (yypminor->yy105); list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		g_value_reset (set->fname); g_free (set->fname);
		gda_sql_expr_free (set->expr);
		g_free (set);
	}
	g_slist_free ((yypminor->yy105));

#line 1469 "parser.c"
}
      break;
    case 182: /* distinct */
{
#line 752 "./parser.y"
if ((yypminor->yy249)) {if ((yypminor->yy249)->expr) gda_sql_expr_free ((yypminor->yy249)->expr); g_free ((yypminor->yy249));}
#line 1476 "parser.c"
}
      break;
    case 183: /* selcollist */
    case 199: /* sclp */
{
#line 709 "./parser.y"
g_slist_foreach ((yypminor->yy33), (GFunc) gda_sql_select_field_free, NULL); g_slist_free ((yypminor->yy33));
#line 1484 "parser.c"
}
      break;
    case 184: /* from */
    case 192: /* seltablist */
    case 193: /* stl_prefix */
{
#line 635 "./parser.y"
gda_sql_select_from_free ((yypminor->yy259));
#line 1493 "parser.c"
}
      break;
    case 185: /* groupby_opt */
{
#line 630 "./parser.y"
if ((yypminor->yy105)) {g_slist_foreach ((yypminor->yy105), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy105));}
#line 1500 "parser.c"
}
      break;
    case 187: /* orderby_opt */
    case 189: /* sortlist */
{
#line 599 "./parser.y"
if ((yypminor->yy33)) {g_slist_foreach ((yypminor->yy33), (GFunc) gda_sql_select_order_free, NULL); g_slist_free ((yypminor->yy33));}
#line 1508 "parser.c"
}
      break;
    case 188: /* limit_opt */
{
#line 592 "./parser.y"
gda_sql_expr_free ((yypminor->yy408).count); gda_sql_expr_free ((yypminor->yy408).offset);
#line 1515 "parser.c"
}
      break;
    case 194: /* seltarget */
{
#line 694 "./parser.y"
gda_sql_select_target_free ((yypminor->yy414));
#line 1522 "parser.c"
}
      break;
    case 204: /* case_operand */
    case 206: /* case_else */
{
#line 931 "./parser.y"
gda_sql_expr_free ((yypminor->yy354));
#line 1530 "parser.c"
}
      break;
    case 205: /* case_exprlist */
{
#line 936 "./parser.y"
g_slist_foreach ((yypminor->yy51).when_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy51).when_list);
	g_slist_foreach ((yypminor->yy51).then_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy51).then_list);
#line 1538 "parser.c"
}
      break;
    case 207: /* paramspec */
{
#line 974 "./parser.y"
gda_sql_param_spec_free ((yypminor->yy303));
#line 1545 "parser.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from gda_lemon_postgres_parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void gda_lemon_postgres_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int gda_lemon_postgres_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   gda_lemon_postgres_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 25 "./parser.y"

	gda_sql_parser_set_overflow_error (pdata->parser);
#line 1730 "parser.c"
   gda_lemon_postgres_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 160, 2 },
  { 160, 2 },
  { 161, 3 },
  { 163, 3 },
  { 162, 1 },
  { 162, 1 },
  { 161, 1 },
  { 161, 3 },
  { 161, 4 },
  { 161, 3 },
  { 161, 2 },
  { 161, 3 },
  { 161, 3 },
  { 161, 5 },
  { 161, 5 },
  { 161, 4 },
  { 161, 4 },
  { 161, 3 },
  { 161, 2 },
  { 161, 3 },
  { 161, 3 },
  { 161, 5 },
  { 161, 3 },
  { 161, 4 },
  { 161, 2 },
  { 161, 3 },
  { 169, 2 },
  { 169, 2 },
  { 169, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 168, 0 },
  { 168, 1 },
  { 167, 0 },
  { 167, 1 },
  { 166, 3 },
  { 166, 4 },
  { 166, 4 },
  { 166, 4 },
  { 164, 0 },
  { 164, 1 },
  { 165, 1 },
  { 165, 1 },
  { 165, 1 },
  { 165, 2 },
  { 165, 2 },
  { 161, 2 },
  { 161, 3 },
  { 161, 2 },
  { 161, 4 },
  { 161, 5 },
  { 161, 9 },
  { 161, 10 },
  { 161, 6 },
  { 171, 0 },
  { 171, 2 },
  { 175, 5 },
  { 175, 4 },
  { 173, 0 },
  { 173, 3 },
  { 176, 3 },
  { 176, 1 },
  { 161, 4 },
  { 177, 0 },
  { 177, 2 },
  { 161, 6 },
  { 179, 5 },
  { 179, 3 },
  { 163, 1 },
  { 163, 4 },
  { 163, 4 },
  { 163, 4 },
  { 181, 0 },
  { 181, 1 },
  { 180, 9 },
  { 188, 0 },
  { 188, 2 },
  { 188, 4 },
  { 188, 4 },
  { 187, 0 },
  { 187, 3 },
  { 189, 4 },
  { 189, 2 },
  { 190, 1 },
  { 190, 1 },
  { 190, 0 },
  { 186, 0 },
  { 186, 2 },
  { 185, 0 },
  { 185, 3 },
  { 184, 0 },
  { 184, 2 },
  { 192, 4 },
  { 196, 4 },
  { 196, 0 },
  { 193, 0 },
  { 193, 2 },
  { 195, 2 },
  { 195, 0 },
  { 197, 1 },
  { 197, 1 },
  { 197, 2 },
  { 197, 2 },
  { 197, 2 },
  { 197, 2 },
  { 197, 3 },
  { 197, 2 },
  { 197, 3 },
  { 197, 2 },
  { 197, 3 },
  { 194, 2 },
  { 194, 2 },
  { 194, 4 },
  { 199, 2 },
  { 199, 0 },
  { 183, 3 },
  { 183, 2 },
  { 200, 1 },
  { 200, 3 },
  { 200, 5 },
  { 198, 2 },
  { 198, 2 },
  { 198, 0 },
  { 182, 0 },
  { 182, 1 },
  { 182, 1 },
  { 182, 3 },
  { 191, 3 },
  { 191, 1 },
  { 174, 0 },
  { 174, 3 },
  { 174, 1 },
  { 178, 1 },
  { 178, 1 },
  { 178, 3 },
  { 178, 1 },
  { 178, 4 },
  { 178, 4 },
  { 178, 4 },
  { 178, 6 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 178, 5 },
  { 178, 6 },
  { 178, 2 },
  { 178, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 5 },
  { 178, 5 },
  { 178, 6 },
  { 178, 6 },
  { 178, 5 },
  { 204, 1 },
  { 204, 0 },
  { 205, 5 },
  { 205, 4 },
  { 206, 2 },
  { 206, 0 },
  { 203, 1 },
  { 203, 2 },
  { 201, 1 },
  { 201, 1 },
  { 201, 1 },
  { 201, 1 },
  { 202, 4 },
  { 202, 4 },
  { 202, 1 },
  { 207, 0 },
  { 207, 2 },
  { 207, 2 },
  { 207, 2 },
  { 207, 2 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 172, 1 },
  { 172, 3 },
  { 172, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  gda_lemon_postgres_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* stmt ::= cmd eos */
#line 281 "./parser.y"
{pdata->parsed_statement = yymsp[-1].minor.yy252;}
#line 2040 "parser.c"
        break;
      case 1: /* stmt ::= compound eos */
#line 282 "./parser.y"
{
	GdaSqlStatementCompound *scompound = (GdaSqlStatementCompound *) yymsp[-1].minor.yy252->contents;
	if (scompound->stmt_list->next)
		/* real compound (multiple statements) */
		pdata->parsed_statement = yymsp[-1].minor.yy252;
	else {
		/* false compound (only 1 select) */
		pdata->parsed_statement = (GdaSqlStatement*) scompound->stmt_list->data;
		GDA_SQL_ANY_PART (pdata->parsed_statement->contents)->parent = NULL;
		g_slist_free (scompound->stmt_list);
		scompound->stmt_list = NULL;
		gda_sql_statement_free (yymsp[-1].minor.yy252);
	}
}
#line 2058 "parser.c"
        break;
      case 2: /* cmd ::= LP cmd RP */
      case 3: /* compound ::= LP compound RP */ yytestcase(yyruleno==3);
#line 296 "./parser.y"
{yygotominor.yy252 = yymsp[-1].minor.yy252;  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2066 "parser.c"
        break;
      case 4: /* eos ::= SEMI */
#line 299 "./parser.y"
{
  yy_destructor(yypParser,116,&yymsp[0].minor);
}
#line 2073 "parser.c"
        break;
      case 5: /* eos ::= END_OF_FILE */
#line 300 "./parser.y"
{
  yy_destructor(yypParser,117,&yymsp[0].minor);
}
#line 2080 "parser.c"
        break;
      case 6: /* cmd ::= BEGIN */
#line 308 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);  yy_destructor(yypParser,8,&yymsp[0].minor);
}
#line 2086 "parser.c"
        break;
      case 7: /* cmd ::= BEGIN TRANSACTION nm_opt */
#line 309 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					 gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,118,&yymsp[-1].minor);
}
#line 2095 "parser.c"
        break;
      case 8: /* cmd ::= BEGIN transtype TRANSACTION nm_opt */
#line 313 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						      gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[-2].minor.yy0);
						      gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
  yy_destructor(yypParser,118,&yymsp[-1].minor);
}
#line 2105 "parser.c"
        break;
      case 9: /* cmd ::= BEGIN transtype nm_opt */
#line 318 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					  gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[-1].minor.yy0);
					  gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
}
#line 2114 "parser.c"
        break;
      case 10: /* cmd ::= BEGIN transilev */
#line 323 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
				gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[0].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-1].minor);
}
#line 2122 "parser.c"
        break;
      case 11: /* cmd ::= BEGIN TRANSACTION transilev */
#line 327 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[0].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,118,&yymsp[-1].minor);
}
#line 2131 "parser.c"
        break;
      case 12: /* cmd ::= BEGIN TRANSACTION transtype */
#line 331 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,118,&yymsp[-1].minor);
}
#line 2140 "parser.c"
        break;
      case 13: /* cmd ::= BEGIN TRANSACTION transtype opt_comma transilev */
#line 335 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[-2].minor.yy0);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[0].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-4].minor);
  yy_destructor(yypParser,118,&yymsp[-3].minor);
}
#line 2150 "parser.c"
        break;
      case 14: /* cmd ::= BEGIN TRANSACTION transilev opt_comma transtype */
#line 340 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[0].minor.yy0);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[-2].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-4].minor);
  yy_destructor(yypParser,118,&yymsp[-3].minor);
}
#line 2160 "parser.c"
        break;
      case 15: /* cmd ::= BEGIN transtype opt_comma transilev */
#line 345 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[-2].minor.yy0);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[0].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
}
#line 2169 "parser.c"
        break;
      case 16: /* cmd ::= BEGIN transilev opt_comma transtype */
#line 350 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy252, yymsp[0].minor.yy0);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy252, yymsp[-2].minor.yy197);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
}
#line 2178 "parser.c"
        break;
      case 17: /* cmd ::= END trans_opt_kw nm_opt */
#line 355 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,17,&yymsp[-2].minor);
}
#line 2186 "parser.c"
        break;
      case 18: /* cmd ::= COMMIT nm_opt */
#line 359 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
			      gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-1].minor);
}
#line 2194 "parser.c"
        break;
      case 19: /* cmd ::= COMMIT TRANSACTION nm_opt */
#line 363 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					  gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-2].minor);
  yy_destructor(yypParser,118,&yymsp[-1].minor);
}
#line 2203 "parser.c"
        break;
      case 20: /* cmd ::= COMMIT FORCE STRING */
#line 367 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-2].minor);
  yy_destructor(yypParser,63,&yymsp[-1].minor);
  yy_destructor(yypParser,119,&yymsp[0].minor);
}
#line 2211 "parser.c"
        break;
      case 21: /* cmd ::= COMMIT FORCE STRING COMMA INTEGER */
#line 368 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-4].minor);
  yy_destructor(yypParser,63,&yymsp[-3].minor);
  yy_destructor(yypParser,119,&yymsp[-2].minor);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
  yy_destructor(yypParser,121,&yymsp[0].minor);
}
#line 2221 "parser.c"
        break;
      case 22: /* cmd ::= COMMIT COMMENT STRING */
#line 369 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-2].minor);
  yy_destructor(yypParser,62,&yymsp[-1].minor);
  yy_destructor(yypParser,119,&yymsp[0].minor);
}
#line 2229 "parser.c"
        break;
      case 23: /* cmd ::= COMMIT COMMENT STRING ora_commit_write */
#line 370 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-3].minor);
  yy_destructor(yypParser,62,&yymsp[-2].minor);
  yy_destructor(yypParser,119,&yymsp[-1].minor);
}
#line 2237 "parser.c"
        break;
      case 24: /* cmd ::= COMMIT ora_commit_write */
#line 371 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-1].minor);
}
#line 2243 "parser.c"
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt_kw nm_opt */
#line 373 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK);
					     gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,50,&yymsp[-2].minor);
}
#line 2251 "parser.c"
        break;
      case 26: /* ora_commit_write ::= WRITE IMMEDIATE */
#line 377 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,23,&yymsp[0].minor);
}
#line 2259 "parser.c"
        break;
      case 27: /* ora_commit_write ::= WRITE BATCH */
#line 378 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,66,&yymsp[0].minor);
}
#line 2267 "parser.c"
        break;
      case 28: /* ora_commit_write ::= WRITE WAIT */
#line 379 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2275 "parser.c"
        break;
      case 29: /* ora_commit_write ::= WRITE NOWAIT */
#line 380 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2283 "parser.c"
        break;
      case 30: /* ora_commit_write ::= WRITE IMMEDIATE WAIT */
#line 381 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2292 "parser.c"
        break;
      case 31: /* ora_commit_write ::= WRITE IMMEDIATE NOWAIT */
#line 382 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2301 "parser.c"
        break;
      case 32: /* ora_commit_write ::= WRITE BATCH WAIT */
#line 383 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,66,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2310 "parser.c"
        break;
      case 33: /* ora_commit_write ::= WRITE BATCH NOWAIT */
#line 384 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,66,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2319 "parser.c"
        break;
      case 35: /* trans_opt_kw ::= TRANSACTION */
#line 387 "./parser.y"
{
  yy_destructor(yypParser,118,&yymsp[0].minor);
}
#line 2326 "parser.c"
        break;
      case 37: /* opt_comma ::= COMMA */
#line 390 "./parser.y"
{
  yy_destructor(yypParser,120,&yymsp[0].minor);
}
#line 2333 "parser.c"
        break;
      case 38: /* transilev ::= ISOLATION LEVEL SERIALIZABLE */
#line 393 "./parser.y"
{yygotominor.yy197 = GDA_TRANSACTION_ISOLATION_SERIALIZABLE;  yy_destructor(yypParser,51,&yymsp[-2].minor);
  yy_destructor(yypParser,52,&yymsp[-1].minor);
  yy_destructor(yypParser,53,&yymsp[0].minor);
}
#line 2341 "parser.c"
        break;
      case 39: /* transilev ::= ISOLATION LEVEL REPEATABLE READ */
#line 394 "./parser.y"
{yygotominor.yy197 = GDA_TRANSACTION_ISOLATION_REPEATABLE_READ;  yy_destructor(yypParser,51,&yymsp[-3].minor);
  yy_destructor(yypParser,52,&yymsp[-2].minor);
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,54,&yymsp[0].minor);
}
#line 2350 "parser.c"
        break;
      case 40: /* transilev ::= ISOLATION LEVEL READ COMMITTED */
#line 395 "./parser.y"
{yygotominor.yy197 = GDA_TRANSACTION_ISOLATION_READ_COMMITTED;  yy_destructor(yypParser,51,&yymsp[-3].minor);
  yy_destructor(yypParser,52,&yymsp[-2].minor);
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,55,&yymsp[0].minor);
}
#line 2359 "parser.c"
        break;
      case 41: /* transilev ::= ISOLATION LEVEL READ UNCOMMITTED */
#line 396 "./parser.y"
{yygotominor.yy197 = GDA_TRANSACTION_ISOLATION_READ_UNCOMMITTED;  yy_destructor(yypParser,51,&yymsp[-3].minor);
  yy_destructor(yypParser,52,&yymsp[-2].minor);
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,56,&yymsp[0].minor);
}
#line 2368 "parser.c"
        break;
      case 42: /* nm_opt ::= */
      case 57: /* opt_on_conflict ::= */ yytestcase(yyruleno==57);
      case 125: /* as ::= */ yytestcase(yyruleno==125);
#line 398 "./parser.y"
{yygotominor.yy0 = NULL;}
#line 2375 "parser.c"
        break;
      case 43: /* nm_opt ::= nm */
      case 44: /* transtype ::= DEFERRED */ yytestcase(yyruleno==44);
      case 45: /* transtype ::= IMMEDIATE */ yytestcase(yyruleno==45);
      case 46: /* transtype ::= EXCLUSIVE */ yytestcase(yyruleno==46);
      case 120: /* starname ::= STAR */ yytestcase(yyruleno==120);
      case 179: /* value ::= STRING */ yytestcase(yyruleno==179);
      case 180: /* value ::= INTEGER */ yytestcase(yyruleno==180);
      case 181: /* value ::= FLOAT */ yytestcase(yyruleno==181);
      case 190: /* nm ::= JOIN */ yytestcase(yyruleno==190);
      case 191: /* nm ::= ID */ yytestcase(yyruleno==191);
      case 192: /* nm ::= TEXTUAL */ yytestcase(yyruleno==192);
      case 193: /* fullname ::= nm */ yytestcase(yyruleno==193);
#line 399 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2391 "parser.c"
        break;
      case 47: /* transtype ::= READ WRITE */
#line 404 "./parser.y"
{yygotominor.yy0 = g_new0 (GValue, 1);
			      g_value_init (yygotominor.yy0, G_TYPE_STRING);
			      g_value_set_string (yygotominor.yy0, "READ_WRITE");
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,58,&yymsp[0].minor);
}
#line 2401 "parser.c"
        break;
      case 48: /* transtype ::= READ ONLY */
#line 408 "./parser.y"
{yygotominor.yy0 = g_new0 (GValue, 1);
			     g_value_init (yygotominor.yy0, G_TYPE_STRING);
			     g_value_set_string (yygotominor.yy0, "READ_ONLY");
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,59,&yymsp[0].minor);
}
#line 2411 "parser.c"
        break;
      case 49: /* cmd ::= SAVEPOINT nm */
#line 416 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_SAVEPOINT);
				    gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2419 "parser.c"
        break;
      case 50: /* cmd ::= RELEASE SAVEPOINT nm */
#line 420 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
				     gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,61,&yymsp[-2].minor);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2428 "parser.c"
        break;
      case 51: /* cmd ::= RELEASE nm */
#line 424 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
			   gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,61,&yymsp[-1].minor);
}
#line 2436 "parser.c"
        break;
      case 52: /* cmd ::= ROLLBACK trans_opt_kw TO nm */
#line 428 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
					    gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,50,&yymsp[-3].minor);
  yy_destructor(yypParser,122,&yymsp[-1].minor);
}
#line 2445 "parser.c"
        break;
      case 53: /* cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm */
#line 432 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
						      gda_sql_statement_trans_take_name (yygotominor.yy252, yymsp[0].minor.yy0);
  yy_destructor(yypParser,50,&yymsp[-4].minor);
  yy_destructor(yypParser,122,&yymsp[-2].minor);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2455 "parser.c"
        break;
      case 54: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP */
#line 439 "./parser.y"
{
	yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy252, yymsp[-5].minor.yy0);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy252, yymsp[-4].minor.yy105);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy252, yymsp[-1].minor.yy33);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy252, yymsp[-7].minor.yy0);
  yy_destructor(yypParser,123,&yymsp[-8].minor);
  yy_destructor(yypParser,124,&yymsp[-6].minor);
  yy_destructor(yypParser,125,&yymsp[-3].minor);
  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2471 "parser.c"
        break;
      case 55: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values */
#line 447 "./parser.y"
{
	yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy252, yymsp[-6].minor.yy0);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy252, yymsp[-5].minor.yy105);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy252, yymsp[-2].minor.yy33);
	gda_sql_statement_insert_take_extra_values_list (yygotominor.yy252, yymsp[0].minor.yy105);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy252, yymsp[-8].minor.yy0);
  yy_destructor(yypParser,123,&yymsp[-9].minor);
  yy_destructor(yypParser,124,&yymsp[-7].minor);
  yy_destructor(yypParser,125,&yymsp[-4].minor);
  yy_destructor(yypParser,101,&yymsp[-3].minor);
  yy_destructor(yypParser,102,&yymsp[-1].minor);
}
#line 2488 "parser.c"
        break;
      case 56: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound */
#line 456 "./parser.y"
{
        yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
        gda_sql_statement_insert_take_table_name (yygotominor.yy252, yymsp[-2].minor.yy0);
        gda_sql_statement_insert_take_fields_list (yygotominor.yy252, yymsp[-1].minor.yy105);
        gda_sql_statement_insert_take_select (yygotominor.yy252, yymsp[0].minor.yy252);
        gda_sql_statement_insert_take_on_conflict (yygotominor.yy252, yymsp[-4].minor.yy0);
  yy_destructor(yypParser,123,&yymsp[-5].minor);
  yy_destructor(yypParser,124,&yymsp[-3].minor);
}
#line 2501 "parser.c"
        break;
      case 58: /* opt_on_conflict ::= OR ID */
#line 466 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;  yy_destructor(yypParser,67,&yymsp[-1].minor);
}
#line 2507 "parser.c"
        break;
      case 59: /* ins_extra_values ::= ins_extra_values COMMA LP exprlist RP */
#line 476 "./parser.y"
{yygotominor.yy105 = g_slist_append (yymsp[-4].minor.yy105, yymsp[-1].minor.yy33);  yy_destructor(yypParser,120,&yymsp[-3].minor);
  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2515 "parser.c"
        break;
      case 60: /* ins_extra_values ::= COMMA LP exprlist RP */
#line 477 "./parser.y"
{yygotominor.yy105 = g_slist_append (NULL, yymsp[-1].minor.yy33);  yy_destructor(yypParser,120,&yymsp[-3].minor);
  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2523 "parser.c"
        break;
      case 61: /* inscollist_opt ::= */
      case 97: /* using_opt ::= */ yytestcase(yyruleno==97);
#line 481 "./parser.y"
{yygotominor.yy105 = NULL;}
#line 2529 "parser.c"
        break;
      case 62: /* inscollist_opt ::= LP inscollist RP */
#line 482 "./parser.y"
{yygotominor.yy105 = yymsp[-1].minor.yy105;  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2536 "parser.c"
        break;
      case 63: /* inscollist ::= inscollist COMMA fullname */
#line 486 "./parser.y"
{GdaSqlField *field;
						    field = gda_sql_field_new (NULL);
						    gda_sql_field_take_name (field, yymsp[0].minor.yy0);
						    yygotominor.yy105 = g_slist_append (yymsp[-2].minor.yy105, field);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 2546 "parser.c"
        break;
      case 64: /* inscollist ::= fullname */
#line 491 "./parser.y"
{GdaSqlField *field = gda_sql_field_new (NULL);
				gda_sql_field_take_name (field, yymsp[0].minor.yy0);
				yygotominor.yy105 = g_slist_prepend (NULL, field);
}
#line 2554 "parser.c"
        break;
      case 65: /* cmd ::= DELETE FROM fullname where_opt */
#line 497 "./parser.y"
{yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE); 
						  gda_sql_statement_delete_take_table_name (yygotominor.yy252, yymsp[-1].minor.yy0);
						  gda_sql_statement_delete_take_condition (yygotominor.yy252, yymsp[0].minor.yy302);  yy_destructor(yypParser,126,&yymsp[-3].minor);
  yy_destructor(yypParser,127,&yymsp[-2].minor);
}
#line 2563 "parser.c"
        break;
      case 66: /* where_opt ::= */
      case 89: /* having_opt ::= */ yytestcase(yyruleno==89);
      case 101: /* on_cond ::= */ yytestcase(yyruleno==101);
#line 503 "./parser.y"
{yygotominor.yy302 = NULL;}
#line 2570 "parser.c"
        break;
      case 67: /* where_opt ::= WHERE expr */
#line 504 "./parser.y"
{yygotominor.yy302 = yymsp[0].minor.yy302;  yy_destructor(yypParser,128,&yymsp[-1].minor);
}
#line 2576 "parser.c"
        break;
      case 68: /* cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt */
#line 507 "./parser.y"
{
	GSList *list;
	yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_UPDATE);
	gda_sql_statement_update_take_table_name (yygotominor.yy252, yymsp[-3].minor.yy0);
	gda_sql_statement_update_take_on_conflict (yygotominor.yy252, yymsp[-4].minor.yy0);
	gda_sql_statement_update_take_condition (yygotominor.yy252, yymsp[0].minor.yy302);
	for (list = yymsp[-1].minor.yy105; list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		gda_sql_statement_update_take_set_value (yygotominor.yy252, set->fname, set->expr);
		g_free (set);
	}
	g_slist_free (yymsp[-1].minor.yy105);
  yy_destructor(yypParser,129,&yymsp[-5].minor);
  yy_destructor(yypParser,130,&yymsp[-2].minor);
}
#line 2595 "parser.c"
        break;
      case 69: /* setlist ::= setlist COMMA fullname EQ expr */
#line 531 "./parser.y"
{UpdateSet *set;
							 set = g_new (UpdateSet, 1);
							 set->fname = yymsp[-2].minor.yy0;
							 set->expr = yymsp[0].minor.yy302;
							 yygotominor.yy105 = g_slist_append (yymsp[-4].minor.yy105, set);
  yy_destructor(yypParser,120,&yymsp[-3].minor);
  yy_destructor(yypParser,75,&yymsp[-1].minor);
}
#line 2607 "parser.c"
        break;
      case 70: /* setlist ::= fullname EQ expr */
#line 537 "./parser.y"
{UpdateSet *set;
					set = g_new (UpdateSet, 1);
					set->fname = yymsp[-2].minor.yy0;
					set->expr = yymsp[0].minor.yy302;
					yygotominor.yy105 = g_slist_append (NULL, set);
  yy_destructor(yypParser,75,&yymsp[-1].minor);
}
#line 2618 "parser.c"
        break;
      case 71: /* compound ::= selectcmd */
#line 548 "./parser.y"
{
	yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
	gda_sql_statement_compound_take_stmt (yygotominor.yy252, yymsp[0].minor.yy252);
}
#line 2626 "parser.c"
        break;
      case 72: /* compound ::= compound UNION opt_compound_all compound */
#line 552 "./parser.y"
{
	yygotominor.yy252 = compose_multiple_compounds (yymsp[-1].minor.yy100 ? GDA_SQL_STATEMENT_COMPOUND_UNION_ALL : GDA_SQL_STATEMENT_COMPOUND_UNION,
					yymsp[-3].minor.yy252, yymsp[0].minor.yy252);
  yy_destructor(yypParser,110,&yymsp[-2].minor);
}
#line 2635 "parser.c"
        break;
      case 73: /* compound ::= compound EXCEPT opt_compound_all compound */
#line 557 "./parser.y"
{
	yygotominor.yy252 = compose_multiple_compounds (yymsp[-1].minor.yy100 ? GDA_SQL_STATEMENT_COMPOUND_EXCEPT_ALL : GDA_SQL_STATEMENT_COMPOUND_EXCEPT,
					yymsp[-3].minor.yy252, yymsp[0].minor.yy252);
  yy_destructor(yypParser,111,&yymsp[-2].minor);
}
#line 2644 "parser.c"
        break;
      case 74: /* compound ::= compound INTERSECT opt_compound_all compound */
#line 562 "./parser.y"
{
	yygotominor.yy252 = compose_multiple_compounds (yymsp[-1].minor.yy100 ? GDA_SQL_STATEMENT_COMPOUND_INTERSECT_ALL : GDA_SQL_STATEMENT_COMPOUND_INTERSECT,
					yymsp[-3].minor.yy252, yymsp[0].minor.yy252);
  yy_destructor(yypParser,112,&yymsp[-2].minor);
}
#line 2653 "parser.c"
        break;
      case 75: /* opt_compound_all ::= */
#line 568 "./parser.y"
{yygotominor.yy100 = FALSE;}
#line 2658 "parser.c"
        break;
      case 76: /* opt_compound_all ::= ALL */
#line 569 "./parser.y"
{yygotominor.yy100 = TRUE;  yy_destructor(yypParser,131,&yymsp[0].minor);
}
#line 2664 "parser.c"
        break;
      case 77: /* selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 576 "./parser.y"
{
	yygotominor.yy252 = gda_sql_statement_new (GDA_SQL_STATEMENT_SELECT);
	if (yymsp[-7].minor.yy249) {
		gda_sql_statement_select_take_distinct (yygotominor.yy252, yymsp[-7].minor.yy249->distinct, yymsp[-7].minor.yy249->expr);
		g_free (yymsp[-7].minor.yy249);
	}
	gda_sql_statement_select_take_expr_list (yygotominor.yy252, yymsp[-6].minor.yy33);
	gda_sql_statement_select_take_from (yygotominor.yy252, yymsp[-5].minor.yy259);
	gda_sql_statement_select_take_where_cond (yygotominor.yy252, yymsp[-4].minor.yy302);
	gda_sql_statement_select_take_group_by (yygotominor.yy252, yymsp[-3].minor.yy105);
	gda_sql_statement_select_take_having_cond (yygotominor.yy252, yymsp[-2].minor.yy302);
	gda_sql_statement_select_take_order_by (yygotominor.yy252, yymsp[-1].minor.yy33);
	gda_sql_statement_select_take_limits (yygotominor.yy252, yymsp[0].minor.yy408.count, yymsp[0].minor.yy408.offset);
  yy_destructor(yypParser,132,&yymsp[-8].minor);
}
#line 2683 "parser.c"
        break;
      case 78: /* limit_opt ::= */
#line 593 "./parser.y"
{yygotominor.yy408.count = NULL; yygotominor.yy408.offset = NULL;}
#line 2688 "parser.c"
        break;
      case 79: /* limit_opt ::= LIMIT expr */
#line 594 "./parser.y"
{yygotominor.yy408.count = yymsp[0].minor.yy302; yygotominor.yy408.offset = NULL;  yy_destructor(yypParser,133,&yymsp[-1].minor);
}
#line 2694 "parser.c"
        break;
      case 80: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 595 "./parser.y"
{yygotominor.yy408.count = yymsp[-2].minor.yy302; yygotominor.yy408.offset = yymsp[0].minor.yy302;  yy_destructor(yypParser,133,&yymsp[-3].minor);
  yy_destructor(yypParser,33,&yymsp[-1].minor);
}
#line 2701 "parser.c"
        break;
      case 81: /* limit_opt ::= LIMIT expr COMMA expr */
#line 596 "./parser.y"
{yygotominor.yy408.count = yymsp[-2].minor.yy302; yygotominor.yy408.offset = yymsp[0].minor.yy302;  yy_destructor(yypParser,133,&yymsp[-3].minor);
  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 2708 "parser.c"
        break;
      case 82: /* orderby_opt ::= */
#line 600 "./parser.y"
{yygotominor.yy33 = 0;}
#line 2713 "parser.c"
        break;
      case 83: /* orderby_opt ::= ORDER BY sortlist */
#line 601 "./parser.y"
{yygotominor.yy33 = yymsp[0].minor.yy33;  yy_destructor(yypParser,134,&yymsp[-2].minor);
  yy_destructor(yypParser,135,&yymsp[-1].minor);
}
#line 2720 "parser.c"
        break;
      case 84: /* sortlist ::= sortlist COMMA expr sortorder */
#line 605 "./parser.y"
{GdaSqlSelectOrder *order;
							 order = gda_sql_select_order_new (NULL);
							 order->expr = yymsp[-1].minor.yy302;
							 order->asc = yymsp[0].minor.yy100;
							 yygotominor.yy33 = g_slist_append (yymsp[-3].minor.yy33, order);
  yy_destructor(yypParser,120,&yymsp[-2].minor);
}
#line 2731 "parser.c"
        break;
      case 85: /* sortlist ::= expr sortorder */
#line 611 "./parser.y"
{GdaSqlSelectOrder *order;
				       order = gda_sql_select_order_new (NULL);
				       order->expr = yymsp[-1].minor.yy302;
				       order->asc = yymsp[0].minor.yy100;
				       yygotominor.yy33 = g_slist_prepend (NULL, order);
}
#line 2741 "parser.c"
        break;
      case 86: /* sortorder ::= ASC */
#line 619 "./parser.y"
{yygotominor.yy100 = TRUE;  yy_destructor(yypParser,5,&yymsp[0].minor);
}
#line 2747 "parser.c"
        break;
      case 87: /* sortorder ::= DESC */
#line 620 "./parser.y"
{yygotominor.yy100 = FALSE;  yy_destructor(yypParser,14,&yymsp[0].minor);
}
#line 2753 "parser.c"
        break;
      case 88: /* sortorder ::= */
#line 621 "./parser.y"
{yygotominor.yy100 = TRUE;}
#line 2758 "parser.c"
        break;
      case 90: /* having_opt ::= HAVING expr */
#line 627 "./parser.y"
{yygotominor.yy302 = yymsp[0].minor.yy302;  yy_destructor(yypParser,136,&yymsp[-1].minor);
}
#line 2764 "parser.c"
        break;
      case 91: /* groupby_opt ::= */
#line 631 "./parser.y"
{yygotominor.yy105 = 0;}
#line 2769 "parser.c"
        break;
      case 92: /* groupby_opt ::= GROUP BY nexprlist */
#line 632 "./parser.y"
{yygotominor.yy105 = yymsp[0].minor.yy33;  yy_destructor(yypParser,137,&yymsp[-2].minor);
  yy_destructor(yypParser,135,&yymsp[-1].minor);
}
#line 2776 "parser.c"
        break;
      case 93: /* from ::= */
      case 98: /* stl_prefix ::= */ yytestcase(yyruleno==98);
#line 636 "./parser.y"
{yygotominor.yy259 = NULL;}
#line 2782 "parser.c"
        break;
      case 94: /* from ::= FROM seltablist */
#line 637 "./parser.y"
{yygotominor.yy259 = yymsp[0].minor.yy259;  yy_destructor(yypParser,127,&yymsp[-1].minor);
}
#line 2788 "parser.c"
        break;
      case 95: /* seltablist ::= stl_prefix seltarget on_cond using_opt */
#line 644 "./parser.y"
{
	GSList *last;
	if (yymsp[-3].minor.yy259)
		yygotominor.yy259 = yymsp[-3].minor.yy259;
	else 
		yygotominor.yy259 = gda_sql_select_from_new (NULL);
	gda_sql_select_from_take_new_target (yygotominor.yy259, yymsp[-2].minor.yy414);
	last = g_slist_last (yygotominor.yy259->joins);
	if (last) {
		GdaSqlSelectJoin *join = (GdaSqlSelectJoin *) (last->data);
		join->expr = yymsp[-1].minor.yy302;
		join->position = g_slist_length (yygotominor.yy259->targets) - 1;
		join->use = yymsp[0].minor.yy105;
	}
}
#line 2807 "parser.c"
        break;
      case 96: /* using_opt ::= USING LP inscollist RP */
#line 662 "./parser.y"
{yygotominor.yy105 = yymsp[-1].minor.yy105;  yy_destructor(yypParser,138,&yymsp[-3].minor);
  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 2815 "parser.c"
        break;
      case 99: /* stl_prefix ::= seltablist jointype */
#line 666 "./parser.y"
{GdaSqlSelectJoin *join;
					      yygotominor.yy259 = yymsp[-1].minor.yy259;
					      join = gda_sql_select_join_new (GDA_SQL_ANY_PART (yygotominor.yy259));
					      join->type = yymsp[0].minor.yy367;
					      gda_sql_select_from_take_new_join (yygotominor.yy259, join);
}
#line 2825 "parser.c"
        break;
      case 100: /* on_cond ::= ON expr */
#line 676 "./parser.y"
{yygotominor.yy302 = yymsp[0].minor.yy302;  yy_destructor(yypParser,139,&yymsp[-1].minor);
}
#line 2831 "parser.c"
        break;
      case 102: /* jointype ::= COMMA */
#line 680 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(yypParser,120,&yymsp[0].minor);
}
#line 2837 "parser.c"
        break;
      case 103: /* jointype ::= JOIN */
#line 681 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2843 "parser.c"
        break;
      case 104: /* jointype ::= CROSS JOIN */
#line 682 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(yypParser,109,&yymsp[-1].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2850 "parser.c"
        break;
      case 105: /* jointype ::= INNER JOIN */
#line 683 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(yypParser,104,&yymsp[-1].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2857 "parser.c"
        break;
      case 106: /* jointype ::= NATURAL JOIN */
#line 684 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_NATURAL;  yy_destructor(yypParser,105,&yymsp[-1].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2864 "parser.c"
        break;
      case 107: /* jointype ::= LEFT JOIN */
#line 685 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(yypParser,106,&yymsp[-1].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2871 "parser.c"
        break;
      case 108: /* jointype ::= LEFT OUTER JOIN */
#line 686 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(yypParser,106,&yymsp[-2].minor);
  yy_destructor(yypParser,140,&yymsp[-1].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2879 "parser.c"
        break;
      case 109: /* jointype ::= RIGHT JOIN */
#line 687 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(yypParser,107,&yymsp[-1].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2886 "parser.c"
        break;
      case 110: /* jointype ::= RIGHT OUTER JOIN */
#line 688 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(yypParser,107,&yymsp[-2].minor);
  yy_destructor(yypParser,140,&yymsp[-1].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2894 "parser.c"
        break;
      case 111: /* jointype ::= FULL JOIN */
#line 689 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(yypParser,108,&yymsp[-1].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2901 "parser.c"
        break;
      case 112: /* jointype ::= FULL OUTER JOIN */
#line 690 "./parser.y"
{yygotominor.yy367 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(yypParser,108,&yymsp[-2].minor);
  yy_destructor(yypParser,140,&yymsp[-1].minor);
  yy_destructor(yypParser,103,&yymsp[0].minor);
}
#line 2909 "parser.c"
        break;
      case 113: /* seltarget ::= fullname as */
#line 695 "./parser.y"
{yygotominor.yy414 = gda_sql_select_target_new (NULL);
				     gda_sql_select_target_take_alias (yygotominor.yy414, yymsp[0].minor.yy0);
				     gda_sql_select_target_take_table_name (yygotominor.yy414, yymsp[-1].minor.yy0);
}
#line 2917 "parser.c"
        break;
      case 114: /* seltarget ::= fullname ID */
#line 699 "./parser.y"
{yygotominor.yy414 = gda_sql_select_target_new (NULL);
                                     gda_sql_select_target_take_alias (yygotominor.yy414, yymsp[0].minor.yy0);
                                     gda_sql_select_target_take_table_name (yygotominor.yy414, yymsp[-1].minor.yy0);
}
#line 2925 "parser.c"
        break;
      case 115: /* seltarget ::= LP compound RP as */
#line 703 "./parser.y"
{yygotominor.yy414 = gda_sql_select_target_new (NULL);
					     gda_sql_select_target_take_alias (yygotominor.yy414, yymsp[0].minor.yy0);
					     gda_sql_select_target_take_select (yygotominor.yy414, yymsp[-2].minor.yy252);
  yy_destructor(yypParser,101,&yymsp[-3].minor);
  yy_destructor(yypParser,102,&yymsp[-1].minor);
}
#line 2935 "parser.c"
        break;
      case 116: /* sclp ::= selcollist COMMA */
#line 713 "./parser.y"
{yygotominor.yy33 = yymsp[-1].minor.yy33;  yy_destructor(yypParser,120,&yymsp[0].minor);
}
#line 2941 "parser.c"
        break;
      case 117: /* sclp ::= */
      case 132: /* exprlist ::= */ yytestcase(yyruleno==132);
#line 714 "./parser.y"
{yygotominor.yy33 = NULL;}
#line 2947 "parser.c"
        break;
      case 118: /* selcollist ::= sclp expr as */
#line 716 "./parser.y"
{GdaSqlSelectField *field;
					  field = gda_sql_select_field_new (NULL);
					  gda_sql_select_field_take_expr (field, yymsp[-1].minor.yy302);
					  gda_sql_select_field_take_alias (field, yymsp[0].minor.yy0); 
					  yygotominor.yy33 = g_slist_append (yymsp[-2].minor.yy33, field);}
#line 2956 "parser.c"
        break;
      case 119: /* selcollist ::= sclp starname */
#line 721 "./parser.y"
{GdaSqlSelectField *field;
					field = gda_sql_select_field_new (NULL);
					gda_sql_select_field_take_star_value (field, yymsp[0].minor.yy0);
					yygotominor.yy33 = g_slist_append (yymsp[-1].minor.yy33, field);}
#line 2964 "parser.c"
        break;
      case 121: /* starname ::= nm DOT STAR */
      case 194: /* fullname ::= nm DOT nm */ yytestcase(yyruleno==194);
#line 727 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy0), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy0 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy0, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy0, str);
				  g_value_reset (yymsp[-2].minor.yy0); g_free (yymsp[-2].minor.yy0);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(yypParser,141,&yymsp[-1].minor);
}
#line 2978 "parser.c"
        break;
      case 122: /* starname ::= nm DOT nm DOT STAR */
      case 195: /* fullname ::= nm DOT nm DOT nm */ yytestcase(yyruleno==195);
#line 736 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy0), 
							 g_value_get_string (yymsp[-2].minor.yy0), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy0 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy0, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy0, str);
				  g_value_reset (yymsp[-4].minor.yy0); g_free (yymsp[-4].minor.yy0);
				  g_value_reset (yymsp[-2].minor.yy0); g_free (yymsp[-2].minor.yy0);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(yypParser,141,&yymsp[-3].minor);
  yy_destructor(yypParser,141,&yymsp[-1].minor);
}
#line 2995 "parser.c"
        break;
      case 123: /* as ::= AS fullname */
      case 124: /* as ::= AS value */ yytestcase(yyruleno==124);
#line 747 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;  yy_destructor(yypParser,142,&yymsp[-1].minor);
}
#line 3002 "parser.c"
        break;
      case 126: /* distinct ::= */
#line 753 "./parser.y"
{yygotominor.yy249 = NULL;}
#line 3007 "parser.c"
        break;
      case 127: /* distinct ::= ALL */
#line 754 "./parser.y"
{yygotominor.yy249 = NULL;  yy_destructor(yypParser,131,&yymsp[0].minor);
}
#line 3013 "parser.c"
        break;
      case 128: /* distinct ::= DISTINCT */
#line 755 "./parser.y"
{yygotominor.yy249 = g_new0 (Distinct, 1); yygotominor.yy249->distinct = TRUE;  yy_destructor(yypParser,143,&yymsp[0].minor);
}
#line 3019 "parser.c"
        break;
      case 129: /* distinct ::= DISTINCT ON expr */
#line 756 "./parser.y"
{yygotominor.yy249 = g_new0 (Distinct, 1); yygotominor.yy249->distinct = TRUE; yygotominor.yy249->expr = yymsp[0].minor.yy302;  yy_destructor(yypParser,143,&yymsp[-2].minor);
  yy_destructor(yypParser,139,&yymsp[-1].minor);
}
#line 3026 "parser.c"
        break;
      case 130: /* nexprlist ::= nexprlist COMMA expr */
      case 133: /* exprlist ::= exprlist COMMA expr */ yytestcase(yyruleno==133);
#line 761 "./parser.y"
{yygotominor.yy33 = g_slist_append (yymsp[-2].minor.yy33, yymsp[0].minor.yy302);  yy_destructor(yypParser,120,&yymsp[-1].minor);
}
#line 3033 "parser.c"
        break;
      case 131: /* nexprlist ::= expr */
      case 134: /* exprlist ::= expr */ yytestcase(yyruleno==134);
#line 762 "./parser.y"
{yygotominor.yy33 = g_slist_append (NULL, yymsp[0].minor.yy302);}
#line 3039 "parser.c"
        break;
      case 135: /* expr ::= pvalue */
#line 774 "./parser.y"
{yygotominor.yy302 = yymsp[0].minor.yy302;}
#line 3044 "parser.c"
        break;
      case 136: /* expr ::= value */
      case 138: /* expr ::= fullname */ yytestcase(yyruleno==138);
#line 775 "./parser.y"
{yygotominor.yy302 = gda_sql_expr_new (NULL); yygotominor.yy302->value = yymsp[0].minor.yy0;}
#line 3050 "parser.c"
        break;
      case 137: /* expr ::= LP expr RP */
#line 776 "./parser.y"
{yygotominor.yy302 = yymsp[-1].minor.yy302;  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 3057 "parser.c"
        break;
      case 139: /* expr ::= fullname LP exprlist RP */
#line 778 "./parser.y"
{GdaSqlFunction *func;
					    yygotominor.yy302 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy302)); 
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					    gda_sql_function_take_args_list (func, yymsp[-1].minor.yy33);
					    yygotominor.yy302->func = func;  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 3069 "parser.c"
        break;
      case 140: /* expr ::= fullname LP compound RP */
#line 784 "./parser.y"
{GdaSqlFunction *func;
					     GdaSqlExpr *expr;
					     yygotominor.yy302 = gda_sql_expr_new (NULL); 
					     func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy302)); 
					     gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					     expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					     gda_sql_expr_take_select (expr, yymsp[-1].minor.yy252);
					     gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					     yygotominor.yy302->func = func;  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 3084 "parser.c"
        break;
      case 141: /* expr ::= fullname LP starname RP */
#line 793 "./parser.y"
{GdaSqlFunction *func;
					    GdaSqlExpr *expr;
					    yygotominor.yy302 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy302));
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					    expr->value = yymsp[-1].minor.yy0;
					    gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					    yygotominor.yy302->func = func;  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 3099 "parser.c"
        break;
      case 142: /* expr ::= CAST LP expr AS fullname RP */
#line 802 "./parser.y"
{yygotominor.yy302 = yymsp[-3].minor.yy302;
						yymsp[-3].minor.yy302->cast_as = g_value_dup_string (yymsp[-1].minor.yy0);
						g_value_reset (yymsp[-1].minor.yy0);
						g_free (yymsp[-1].minor.yy0);  yy_destructor(yypParser,10,&yymsp[-5].minor);
  yy_destructor(yypParser,101,&yymsp[-4].minor);
  yy_destructor(yypParser,142,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 3111 "parser.c"
        break;
      case 143: /* expr ::= expr PGCAST fullname */
#line 806 "./parser.y"
{yygotominor.yy302 = yymsp[-2].minor.yy302;
					 yymsp[-2].minor.yy302->cast_as = g_value_dup_string (yymsp[0].minor.yy0);
					 g_value_reset (yymsp[0].minor.yy0);
					 g_free (yymsp[0].minor.yy0);  yy_destructor(yypParser,113,&yymsp[-1].minor);
}
#line 3120 "parser.c"
        break;
      case 144: /* expr ::= expr PLUS|MINUS expr */
#line 811 "./parser.y"
{yygotominor.yy302 = compose_multiple_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy302, yymsp[0].minor.yy302);}
#line 3125 "parser.c"
        break;
      case 145: /* expr ::= expr STAR expr */
#line 812 "./parser.y"
{yygotominor.yy302 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_STAR, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,93,&yymsp[-1].minor);
}
#line 3131 "parser.c"
        break;
      case 146: /* expr ::= expr SLASH|REM expr */
      case 147: /* expr ::= expr BITAND|BITOR expr */ yytestcase(yyruleno==147);
      case 153: /* expr ::= expr GT|LEQ|GEQ|LT expr */ yytestcase(yyruleno==153);
      case 154: /* expr ::= expr DIFF|EQ expr */ yytestcase(yyruleno==154);
      case 157: /* expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr */ yytestcase(yyruleno==157);
#line 813 "./parser.y"
{yygotominor.yy302 = create_two_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy302, yymsp[0].minor.yy302);}
#line 3140 "parser.c"
        break;
      case 148: /* expr ::= MINUS expr */
#line 816 "./parser.y"
{yygotominor.yy302 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_MINUS, yymsp[0].minor.yy302);  yy_destructor(yypParser,92,&yymsp[-1].minor);
}
#line 3146 "parser.c"
        break;
      case 149: /* expr ::= PLUS expr */
#line 817 "./parser.y"
{yygotominor.yy302 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_PLUS, yymsp[0].minor.yy302);  yy_destructor(yypParser,91,&yymsp[-1].minor);
}
#line 3152 "parser.c"
        break;
      case 150: /* expr ::= expr AND expr */
#line 819 "./parser.y"
{yygotominor.yy302 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_AND, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,68,&yymsp[-1].minor);
}
#line 3158 "parser.c"
        break;
      case 151: /* expr ::= expr OR expr */
#line 820 "./parser.y"
{yygotominor.yy302 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_OR, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,67,&yymsp[-1].minor);
}
#line 3164 "parser.c"
        break;
      case 152: /* expr ::= expr CONCAT expr */
#line 821 "./parser.y"
{yygotominor.yy302 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_CONCAT, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,96,&yymsp[-1].minor);
}
#line 3170 "parser.c"
        break;
      case 155: /* expr ::= expr LIKE expr */
#line 825 "./parser.y"
{yygotominor.yy302 = create_two_expr (GDA_SQL_OPERATOR_TYPE_LIKE, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,26,&yymsp[-1].minor);
}
#line 3176 "parser.c"
        break;
      case 156: /* expr ::= expr ILIKE expr */
#line 826 "./parser.y"
{yygotominor.yy302 = create_two_expr (GDA_SQL_OPERATOR_TYPE_ILIKE, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,27,&yymsp[-1].minor);
}
#line 3182 "parser.c"
        break;
      case 158: /* expr ::= expr BETWEEN expr AND expr */
#line 828 "./parser.y"
{GdaSqlOperation *cond;
						  yygotominor.yy302 = gda_sql_expr_new (NULL);
						  cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
						  yygotominor.yy302->cond = cond;
						  cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						  cond->operands = g_slist_append (NULL, yymsp[-4].minor.yy302);
						  GDA_SQL_ANY_PART (yymsp[-4].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy302);
						  GDA_SQL_ANY_PART (yymsp[-2].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy302);
						  GDA_SQL_ANY_PART (yymsp[0].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,76,&yymsp[-3].minor);
  yy_destructor(yypParser,68,&yymsp[-1].minor);
}
#line 3200 "parser.c"
        break;
      case 159: /* expr ::= expr NOT BETWEEN expr AND expr */
#line 841 "./parser.y"
{GdaSqlOperation *cond;
						      GdaSqlExpr *expr;
						      expr = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (expr));
						      expr->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						      cond->operands = g_slist_append (NULL, yymsp[-5].minor.yy302);
						      GDA_SQL_ANY_PART (yymsp[-5].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy302);
						      GDA_SQL_ANY_PART (yymsp[-2].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy302);
						      GDA_SQL_ANY_PART (yymsp[0].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);

						      yygotominor.yy302 = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
						      yygotominor.yy302->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOT;
						      cond->operands = g_slist_prepend (NULL, expr);
						      GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,69,&yymsp[-4].minor);
  yy_destructor(yypParser,76,&yymsp[-3].minor);
  yy_destructor(yypParser,68,&yymsp[-1].minor);
}
#line 3227 "parser.c"
        break;
      case 160: /* expr ::= NOT expr */
#line 862 "./parser.y"
{yygotominor.yy302 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_NOT, yymsp[0].minor.yy302);  yy_destructor(yypParser,69,&yymsp[-1].minor);
}
#line 3233 "parser.c"
        break;
      case 161: /* expr ::= BITNOT expr */
#line 863 "./parser.y"
{yygotominor.yy302 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_BITNOT, yymsp[0].minor.yy302);  yy_destructor(yypParser,100,&yymsp[-1].minor);
}
#line 3239 "parser.c"
        break;
      case 162: /* expr ::= expr uni_op */
#line 864 "./parser.y"
{yygotominor.yy302 = create_uni_expr (yymsp[0].minor.yy295, yymsp[-1].minor.yy302);}
#line 3244 "parser.c"
        break;
      case 163: /* expr ::= expr IS expr */
#line 866 "./parser.y"
{yygotominor.yy302 = create_two_expr (GDA_SQL_OPERATOR_TYPE_IS, yymsp[-2].minor.yy302, yymsp[0].minor.yy302);  yy_destructor(yypParser,70,&yymsp[-1].minor);
}
#line 3250 "parser.c"
        break;
      case 164: /* expr ::= LP compound RP */
#line 867 "./parser.y"
{yygotominor.yy302 = gda_sql_expr_new (NULL); gda_sql_expr_take_select (yygotominor.yy302, yymsp[-1].minor.yy252);  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 3257 "parser.c"
        break;
      case 165: /* expr ::= expr IN LP exprlist RP */
#line 868 "./parser.y"
{GdaSqlOperation *cond;
					   GSList *list;
					   yygotominor.yy302 = gda_sql_expr_new (NULL);
					   cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
					   yygotominor.yy302->cond = cond;
					   cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					   cond->operands = g_slist_prepend (yymsp[-1].minor.yy33, yymsp[-4].minor.yy302);
					   for (list = cond->operands; list; list = list->next)
						   GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,71,&yymsp[-3].minor);
  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 3274 "parser.c"
        break;
      case 166: /* expr ::= expr IN LP compound RP */
#line 878 "./parser.y"
{GdaSqlOperation *cond;
					    GdaSqlExpr *expr;
					    yygotominor.yy302 = gda_sql_expr_new (NULL);
					    cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
					    yygotominor.yy302->cond = cond;
					    cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					    
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					    gda_sql_expr_take_select (expr, yymsp[-1].minor.yy252);
					    cond->operands = g_slist_prepend (NULL, expr);
					    cond->operands = g_slist_prepend (cond->operands, yymsp[-4].minor.yy302);
					    GDA_SQL_ANY_PART (yymsp[-4].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,71,&yymsp[-3].minor);
  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 3294 "parser.c"
        break;
      case 167: /* expr ::= expr NOT IN LP exprlist RP */
#line 891 "./parser.y"
{GdaSqlOperation *cond;
					       GSList *list;
					       yygotominor.yy302 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
					       yygotominor.yy302->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       cond->operands = g_slist_prepend (yymsp[-1].minor.yy33, yymsp[-5].minor.yy302);
					       for (list = cond->operands; list; list = list->next)
						       GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,69,&yymsp[-4].minor);
  yy_destructor(yypParser,71,&yymsp[-3].minor);
  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 3312 "parser.c"
        break;
      case 168: /* expr ::= expr NOT IN LP compound RP */
#line 901 "./parser.y"
{GdaSqlOperation *cond;
					       GdaSqlExpr *expr;
					       yygotominor.yy302 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy302));
					       yygotominor.yy302->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       
					       expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					       gda_sql_expr_take_select (expr, yymsp[-1].minor.yy252);
					       cond->operands = g_slist_prepend (NULL, expr);
					       cond->operands = g_slist_prepend (cond->operands, yymsp[-5].minor.yy302);
					       GDA_SQL_ANY_PART (yymsp[-5].minor.yy302)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,69,&yymsp[-4].minor);
  yy_destructor(yypParser,71,&yymsp[-3].minor);
  yy_destructor(yypParser,101,&yymsp[-2].minor);
  yy_destructor(yypParser,102,&yymsp[0].minor);
}
#line 3333 "parser.c"
        break;
      case 169: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 914 "./parser.y"
{
	GdaSqlCase *sc;
	GSList *list;
	yygotominor.yy302 = gda_sql_expr_new (NULL);
	sc = gda_sql_case_new (GDA_SQL_ANY_PART (yygotominor.yy302));
	sc->base_expr = yymsp[-3].minor.yy354;
	sc->else_expr = yymsp[-1].minor.yy354;
	sc->when_expr_list = yymsp[-2].minor.yy51.when_list;
	sc->then_expr_list = yymsp[-2].minor.yy51.then_list;
	yygotominor.yy302->case_s = sc;
	for (list = sc->when_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
	for (list = sc->then_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
  yy_destructor(yypParser,144,&yymsp[-4].minor);
  yy_destructor(yypParser,17,&yymsp[0].minor);
}
#line 3354 "parser.c"
        break;
      case 170: /* case_operand ::= expr */
#line 932 "./parser.y"
{yygotominor.yy354 = yymsp[0].minor.yy302;}
#line 3359 "parser.c"
        break;
      case 171: /* case_operand ::= */
      case 175: /* case_else ::= */ yytestcase(yyruleno==175);
#line 933 "./parser.y"
{yygotominor.yy354 = NULL;}
#line 3365 "parser.c"
        break;
      case 172: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 939 "./parser.y"
{
	yygotominor.yy51.when_list = g_slist_append (yymsp[-4].minor.yy51.when_list, yymsp[-2].minor.yy302);
	yygotominor.yy51.then_list = g_slist_append (yymsp[-4].minor.yy51.then_list, yymsp[0].minor.yy302);
  yy_destructor(yypParser,145,&yymsp[-3].minor);
  yy_destructor(yypParser,146,&yymsp[-1].minor);
}
#line 3375 "parser.c"
        break;
      case 173: /* case_exprlist ::= WHEN expr THEN expr */
#line 943 "./parser.y"
{
	yygotominor.yy51.when_list = g_slist_prepend (NULL, yymsp[-2].minor.yy302);
	yygotominor.yy51.then_list = g_slist_prepend (NULL, yymsp[0].minor.yy302);
  yy_destructor(yypParser,145,&yymsp[-3].minor);
  yy_destructor(yypParser,146,&yymsp[-1].minor);
}
#line 3385 "parser.c"
        break;
      case 174: /* case_else ::= ELSE expr */
#line 950 "./parser.y"
{yygotominor.yy354 = yymsp[0].minor.yy302;  yy_destructor(yypParser,147,&yymsp[-1].minor);
}
#line 3391 "parser.c"
        break;
      case 176: /* uni_op ::= ISNULL */
#line 954 "./parser.y"
{yygotominor.yy295 = GDA_SQL_OPERATOR_TYPE_ISNULL;  yy_destructor(yypParser,72,&yymsp[0].minor);
}
#line 3397 "parser.c"
        break;
      case 177: /* uni_op ::= IS NOTNULL */
#line 955 "./parser.y"
{yygotominor.yy295 = GDA_SQL_OPERATOR_TYPE_ISNOTNULL;  yy_destructor(yypParser,70,&yymsp[-1].minor);
  yy_destructor(yypParser,73,&yymsp[0].minor);
}
#line 3404 "parser.c"
        break;
      case 178: /* value ::= NULL */
#line 959 "./parser.y"
{yygotominor.yy0 = NULL;  yy_destructor(yypParser,148,&yymsp[0].minor);
}
#line 3410 "parser.c"
        break;
      case 182: /* pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET */
#line 968 "./parser.y"
{yygotominor.yy302 = gda_sql_expr_new (NULL); yygotominor.yy302->param_spec = yymsp[-1].minor.yy303;  yy_destructor(yypParser,150,&yymsp[-3].minor);
  yy_destructor(yypParser,151,&yymsp[-2].minor);
  yy_destructor(yypParser,152,&yymsp[0].minor);
}
#line 3418 "parser.c"
        break;
      case 183: /* pvalue ::= value LSBRACKET paramspec RSBRACKET */
#line 969 "./parser.y"
{yygotominor.yy302 = gda_sql_expr_new (NULL); yygotominor.yy302->value = yymsp[-3].minor.yy0; yygotominor.yy302->param_spec = yymsp[-1].minor.yy303;  yy_destructor(yypParser,151,&yymsp[-2].minor);
  yy_destructor(yypParser,152,&yymsp[0].minor);
}
#line 3425 "parser.c"
        break;
      case 184: /* pvalue ::= SIMPLEPARAM */
#line 970 "./parser.y"
{yygotominor.yy302 = gda_sql_expr_new (NULL); yygotominor.yy302->param_spec = gda_sql_param_spec_new (yymsp[0].minor.yy0);}
#line 3430 "parser.c"
        break;
      case 185: /* paramspec ::= */
#line 975 "./parser.y"
{yygotominor.yy303 = NULL;}
#line 3435 "parser.c"
        break;
      case 186: /* paramspec ::= paramspec PNAME */
#line 976 "./parser.y"
{if (!yymsp[-1].minor.yy303) yygotominor.yy303 = gda_sql_param_spec_new (NULL); else yygotominor.yy303 = yymsp[-1].minor.yy303; 
					 gda_sql_param_spec_take_name (yygotominor.yy303, yymsp[0].minor.yy0);}
#line 3441 "parser.c"
        break;
      case 187: /* paramspec ::= paramspec PDESCR */
#line 978 "./parser.y"
{if (!yymsp[-1].minor.yy303) yygotominor.yy303 = gda_sql_param_spec_new (NULL); else yygotominor.yy303 = yymsp[-1].minor.yy303; 
					 gda_sql_param_spec_take_descr (yygotominor.yy303, yymsp[0].minor.yy0);}
#line 3447 "parser.c"
        break;
      case 188: /* paramspec ::= paramspec PTYPE */
#line 980 "./parser.y"
{if (!yymsp[-1].minor.yy303) yygotominor.yy303 = gda_sql_param_spec_new (NULL); else yygotominor.yy303 = yymsp[-1].minor.yy303; 
					 gda_sql_param_spec_take_type (yygotominor.yy303, yymsp[0].minor.yy0);}
#line 3453 "parser.c"
        break;
      case 189: /* paramspec ::= paramspec PNULLOK */
#line 982 "./parser.y"
{if (!yymsp[-1].minor.yy303) yygotominor.yy303 = gda_sql_param_spec_new (NULL); else yygotominor.yy303 = yymsp[-1].minor.yy303; 
					   gda_sql_param_spec_take_nullok (yygotominor.yy303, yymsp[0].minor.yy0);}
#line 3459 "parser.c"
        break;
      default:
      /* (34) trans_opt_kw ::= */ yytestcase(yyruleno==34);
      /* (36) opt_comma ::= */ yytestcase(yyruleno==36);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  gda_lemon_postgres_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  gda_lemon_postgres_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  gda_lemon_postgres_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 22 "./parser.y"

	gda_sql_parser_set_syntax_error (pdata->parser);
#line 3526 "parser.c"
  gda_lemon_postgres_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  gda_lemon_postgres_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  gda_lemon_postgres_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "gda_lemon_postgres_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void gda_lemon_postgres_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  gda_lemon_postgres_parserTOKENTYPE yyminor       /* The value for the token */
  gda_lemon_postgres_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  gda_lemon_postgres_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
