// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_QUERY_H
#define _LIBGDAMM_QUERY_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* query.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/dict.h>
#include <libgdamm/datamodel.h>

#include <libgdamm/xmlstorage.h>
#include <libgdamm/referer.h>
#include <libgdamm/renderer.h>
#include <libgdamm/entity.h>
#include <libgdamm/queryobject.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaQuery GdaQuery;
typedef struct _GdaQueryClass GdaQueryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Query_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum QueryType
{
  QUERY_TYPE_SELECT,
  QUERY_TYPE_INSERT,
  QUERY_TYPE_UPDATE,
  QUERY_TYPE_DELETE,
  QUERY_TYPE_UNION,
  QUERY_TYPE_INTERSECT,
  QUERY_TYPE_EXCEPT,
  QUERY_TYPE_NON_PARSED_SQL
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::QueryType> : public Glib::Value_Enum<Gnome::Gda::QueryType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


// TODO: Functions requiring GdaQuery* classes are still unwrapped because
// they do not yet exist, however, we need GdaQuery to create gnome-db
// examples.

class Query
 : public QueryObject,
   public XmlStorage,
   public Referer,
   public Renderer,
   public Entity
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Query CppObjectType;
  typedef Query_Class CppClassType;
  typedef GdaQuery BaseObjectType;
  typedef GdaQueryClass BaseClassType;

private:  friend class Query_Class;
  static CppClassType query_class_;

private:
  // noncopyable
  Query(const Query&);
  Query& operator=(const Query&);

protected:
  explicit Query(const Glib::ConstructParams& construct_params);
  explicit Query(GdaQuery* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Query();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaQuery*       gobj()       { return reinterpret_cast<GdaQuery*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaQuery* gobj() const { return reinterpret_cast<GdaQuery*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaQuery* gobj_copy();

private:


protected:
  explicit Query(const Glib::RefPtr<Dict>& dict);

public:
  
  static Glib::RefPtr<Query> create(const Glib::RefPtr<Dict>& dict);


  // TODO: How to wrap GHashTable in g*mm? armin.
  

  // Not wrapped because it does only call gda_query_set_sql_text. However,
  // gda_query_set_sql_text might throw an exception and if this was a
  // constructor, it would prevent the object from being constructed, but in
  // C a new object is returned. This is why the caller should call
  // gda_query_set_sql_text her/himself.
  

  /** Sets the type of @a query 
   * @param type The new type of query.
   */
  void set_query_type(QueryType type);
  
  /** Get the type of a query
   * @return The type of @a query .
   */
  QueryType get_query_type() const;
  
  /** Get the type of a query as a human readable string
   * @return A string for the type of @a query .
   */
  Glib::ustring get_query_type_string() const;
  
  /** Tells if @a query  is a SELECTION query (a simple SELECT, UNION, INTERSECT or EXCEPT);
   * @return <tt>true</tt> if @a query  is a selection query.
   */
  bool is_select_query() const;
  
  /** Tells if @a query  is a INSERT query.
   * @return <tt>true</tt> if @a query  is an insertion query.
   */
  bool is_insert_query() const;
  
  /** Tells if @a query  is a UPDATE query.
   * @return <tt>true</tt> if @a query  is an update query.
   */
  bool is_update_query() const;
  
  /** Tells if @a query  is a DELETE query.
   * @return <tt>true</tt> if @a query  is an delete query.
   */
  bool is_delete_query() const;
  
  /** Tells if @a query  is a modification query (a simple UPDATE, DELETE, INSERT).; pure SQL
   * queries are not handled and will always return <tt>false</tt>.
   * @return <tt>true</tt> if @a query  is a modification query.
   */
  bool is_modif_query() const;

  
  /** Defines @a query 's contents from an SQL statement. The SQL text is parsed and the internal query structured
   * is built from that; the query type is also set. If the SQL text cannot be parsed, then the internal structure
   * of the query is emptied and the query type is set to GDA_QUERY_TYPE_NON_PARSED_SQL.
   * 
   * To be parsed successfully, the expected SQL must respect the SQL standard; some extensions have been
   * added to be able to define variables within the SQL statement. See the introduction to the Gda::Query
   * for more information.
   * @param sql The SQL statement.
   * @param error Location to store parsing error, or <tt>0</tt>.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void set_sql_text(const Glib::ustring& sql);
#else
  void set_sql_text(const Glib::ustring& sql, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Obtain a new string representing the SQL version of the query.
   * 
   * WARNING: the returned SQL statement may contain some extensions which allow for the definition of
   * variables (see the introduction to the Gda::Query for more information). As such the returned SQL cannot
   * be executed as it may provoque errors. To get an executable statement, use the Gda::Renderer interface's
   * methods.
   * @return The new string.
   */
  Glib::ustring get_sql_text() const;

   
  /** Get a list of parameters which the query accepts.
   * @return A list of Gda::Parameter objects (the list and objects must be freed by the caller).
   */
  Glib::SListHandle<Glib::RefPtr<Parameter> > get_parameters();
  
  /** Like the get_parameters() method, get a list of parameters which the query accepts,
   * except that the parameters are stored within a Gda::ParameterList object, and can be used as an argument
   * to the execute() method.
   * @return A new Gda::ParameterList object, or <tt>0</tt> if @a query  does not accept any parameter.
   */
  Glib::RefPtr<ParameterList> get_parameter_list();
  
  /** Like the get_parameters() method, get a list of parameters which the query accepts,
   * except that the parameters are stored within a Gda::ParameterList object, and can be used as an argument
   * to the execute() method.
   * @return A new Gda::ParameterList object, or <tt>0</tt> if @a query  does not accept any parameter.
   */
  Glib::RefPtr<const ParameterList> get_parameter_list() const;

//TODO: Add a suitable default value for the bool - look at the docs to choose a value?
  
  /** Executes @a query  and optionnaly returns a Gda::DataModel as a result.
   * @param params A Gda::ParameterList object obtained using get_parameter_list().
   * @param iter_model_only_requested Set to <tt>true</tt> if the returned data model will only be accessed using an iterator.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return A Gda::DataModel pointer or <tt>0</tt> if no error occurred, or GDA_QUERY_EXEC_FAILED if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<Object> execute(const Glib::RefPtr<ParameterList>& params, bool iter_model_only_requested);
#else
  Glib::RefPtr<Object> execute(const Glib::RefPtr<ParameterList>& params, bool iter_model_only_requested, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  //I don't think that an exectute() function should be const. We can add it later if necessary. murrayc: _WRAP_METHOD(Glib::RefPtr<const Object> execute(const Glib::RefPtr<ParameterList>& params, bool iter_model_only_requested) const, gda_query_execute, errthrow, constversion)
  
  /** Get the parent query of @a query 
   * @return The parent query, or <tt>0</tt> if @a query  does not have any parent.
   */
  Glib::RefPtr<Query> get_parent_query();
  
  /** Get the parent query of @a query 
   * @return The parent query, or <tt>0</tt> if @a query  does not have any parent.
   */
  Glib::RefPtr<const Query> get_parent_query() const;

   
  /** Get a list of all the sub-queries managed by @a query 
   * @return A new list of the sub-queries.
   */
  Glib::SListHandle<Glib::RefPtr<Query> > get_sub_queries();
  
  /** Tells @a query  that @a param_source  is a query which potentially will constraint the possible values
   * of one or more of @a query 's parameters. This implies that @a query  keeps a reference on @a param_source .
   * @param param_source A Gda::DataModel object.
   */
  void add_param_source(const Glib::RefPtr<DataModel>& param_source);
  
  /** Tells @a query  that it should no longer take care of @a param_source .
   * The parameters which depend on @a param_source  will still depend on it, though.
   * @param param_source A Gda::DataModel object.
   */
  void del_param_source(const Glib::RefPtr<DataModel>& param_source);

   
  /** Get a list of the parameter source queries that are references as such by @a query .
   * @return The list of Gda::Query objects.
   */
  Glib::SListHandle<Glib::RefPtr<const Query> > get_param_sources() const;

  
  /** Add @a sub_query  to @a query . Sub queries are managed by their parent query, and as such they
   * are destroyed when their parent query is destroyed.
   * @param sub_query A Gda::Query object.
   */
  void add_sub_query(const Glib::RefPtr<Query>& sub_query);
  
  /** Removes @a sub_query  from @a query . @a sub_query  MUST be present within @a query .
   * @param sub_query A Gda::Query object.
   */
  void del_sub_query(const Glib::RefPtr<Query>& sub_query);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::Query
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::Query> wrap(GdaQuery* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_QUERY_H */

