// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_SERVERPROVIDER_H
#define _LIBGDAMM_SERVERPROVIDER_H


#include <glibmm.h>

/* $Id: serverprovider.hg,v 1.16 2006/11/30 06:58:55 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* serverprovider.h
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//#include <libgdamm/connection.h>
#include <libgdamm/command.h>
#include <libgdamm/datamodelindex.h>
#include <libgdamm/client.h>
#include <libgdamm/serveroperation.h>
#include <libgdamm/query.h>
#include <libgdamm/datahandler.h>


#include <libgdamm/blob.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaServerProvider GdaServerProvider;
typedef struct _GdaServerProviderClass GdaServerProviderClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class ServerProvider_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{


class Connection;

//_WRAP_ENUM(ClientSpecsType, GdaClientSpecsType)
/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum ServerOperationType
{
  SERVER_OPERATION_CREATE_DB,
  SERVER_OPERATION_DROP_DB,
  SERVER_OPERATION_CREATE_TABLE,
  SERVER_OPERATION_DROP_TABLE,
  SERVER_OPERATION_RENAME_TABLE,
  SERVER_OPERATION_ADD_COLUMN,
  SERVER_OPERATION_DROP_COLUMN,
  SERVER_OPERATION_CREATE_INDEX,
  SERVER_OPERATION_DROP_INDEX,
  SERVER_OPERATION_NB
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ServerOperationType> : public Glib::Value_Enum<Gnome::Gda::ServerOperationType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/* TODO: Is this appropriate. Investigate how it is used. */
typedef GdaServerProviderInfo ServerProviderInfo;

//TODO:

class ServerProvider : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ServerProvider CppObjectType;
  typedef ServerProvider_Class CppClassType;
  typedef GdaServerProvider BaseObjectType;
  typedef GdaServerProviderClass BaseClassType;

private:  friend class ServerProvider_Class;
  static CppClassType serverprovider_class_;

private:
  // noncopyable
  ServerProvider(const ServerProvider&);
  ServerProvider& operator=(const ServerProvider&);

protected:
  explicit ServerProvider(const Glib::ConstructParams& construct_params);
  explicit ServerProvider(GdaServerProvider* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ServerProvider();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaServerProvider*       gobj()       { return reinterpret_cast<GdaServerProvider*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaServerProvider* gobj() const { return reinterpret_cast<GdaServerProvider*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaServerProvider* gobj_copy();

private:


  /** Get the version of the given provider.
   * @return A string containing the version identification.
   */
  Glib::ustring get_version() const;
  
  /** Tries to open a new connection on the given Gda::ServerProvider
   * object.
   * @param cnc A Gda::Connection object.
   * @param username User name for logging in.
   * @param password Password for authentication.
   * @return A newly-allocated Gda::ServerConnection object, or <tt>0</tt>
   * if it fails.
   */
  bool open_connection(const Glib::RefPtr<Connection>& cnc, GdaQuarkList *params, const Glib::ustring& username, const Glib::ustring& password);
  //TODO: Not implemented: _WRAP_METHOD(bool reset_connection(const Glib::RefPtr<Connection>& cnc), gda_server_provider_reset_connection)
  
  /** 
   */
  bool close_connection(const Glib::RefPtr<Connection>& cnc);

  
  /** 
   */
  Glib::ustring get_server_version(const Glib::RefPtr<Connection>& cnc) const;
  
  /** Proxy the call to the get_database method on the
   * Gda::ServerProvider class to the corresponding provider.
   * @param cnc A Gda::Connection object.
   * @return The name of the current database.
   */
  Glib::ustring get_database(const Glib::RefPtr<Connection>& cnc) const;
  
  /** Proxy the call to the change_database method on the
   *  " Gda::ServerProvider class to the corresponding provider.
   * @param cnc A Gda::Connection object.
   * @param name Database name.
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
  bool change_database(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name);

  //TODO: Copy-by-value somehow?
   

  /** Retreive some information specific to the provider. The returned Gda::ServerProviderInfo
   * structure must not be modified
   * @param cnc A Gda::Connection, or <tt>0</tt>.
   * @return A Gda::ServerProviderInfo pointer or <tt>0</tt> if an error occurred.
   */
  const ServerProviderInfo* get_info(const Glib::RefPtr<Connection>& cnc) const;

  //TODO: options may be NULL: Add a method overload.
  
  /** Tells if @a provider  supports the @a type  of operation on the @a cnc  connection, using the
   * (optional) @a options  parameters.
   * @param cnc A Gda::Connection object which would be used to perform an action.
   * @param type The type of operation requested.
   * @param options A list of named parameters, or <tt>0</tt>.
   * @return <tt>true</tt> if the operation is supported.
   */
  bool supports_operation(const Glib::RefPtr<Connection>& cnc, ServerOperationType type, const Glib::RefPtr<ParameterList>& options) const;

  
  /** Creates a new Gda::ServerOperation object which can be modified in order to perform the @a type  type of
   * action. The @a options  can contain:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;parameters which ID is a path in the resulting GdaServerOperation object, to initialize some value&lt;/listitem&gt;
   * &lt;listitem&gt;parameters which may change the contents of the GdaServerOperation, see this section for more information&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * @param cnc A Gda::Connection object which will be used to perform an action.
   * @param type The type of operation requested.
   * @param options An optional list of parameters.
   * @param error A place to store an error, or <tt>0</tt>.
   * @return A new Gda::ServerOperation object, or <tt>0</tt> in the provider does not support the @a type  type
   * of operation or if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<ServerOperation> create_operation (const Glib::RefPtr<Connection>& cnc,ServerOperationType type, const Glib::RefPtr<ParameterList>& options);
#else
  Glib::RefPtr<ServerOperation> create_operation(const Glib::RefPtr<Connection>& cnc, ServerOperationType type, const Glib::RefPtr<ParameterList>& options, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Creates an SQL statement (possibly using some specific extensions of the DBMS) corresponding to the
   *  @a op  operation.
   * @param cnc A Gda::Connection object which will be used to perform an action.
   * @param op A Gda::ServerOperation object.
   * @param error A place to store an error, or <tt>0</tt>.
   * @return A new string, or <tt>0</tt> if an error occurred or operation cannot be rendered as SQL.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring render_operation(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<ServerOperation>& op);
#else
  Glib::ustring render_operation(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<ServerOperation>& op, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Performs the operation described by @a op .
   * @param cnc A Gda::Connection object which will be used to perform an action.
   * @param op A Gda::ServerOperation object.
   * @param error A place to store an error, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool perform_operation(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<ServerOperation>& op);
#else
  bool perform_operation(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<ServerOperation>& op, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


   //Use deep ownership because we own both the list and its elements;
   

  /** Executes one or more SQL statements stored in @a command , and returns a list of
   * Gda::DataModel and/or Gda::ParameterList (or <tt>0</tt>) objects for each SQL statement
   * in @a command  following the rule (the number and order of items contained in the returned list is the 
   * same as the number and order of SQL queries in @a command  if there is no error, 
   * otherwise it depends on the execution options in @a params ):
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;A Gda::DataModel is in the list if the statement was a SELECT statement and the statement was successufully executed&lt;/listitem&gt;
   * &lt;listitem&gt;A Gda::ParameterList is in the list if the statement was not a SELECT 
   * statement and the statement was successufully executed. In this case
   * (if the provider supports it), then the Gda::ParameterList may contain:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;a (<tt>int</tt>) Gda::Parameter named "IMPACTED_ROWS"&lt;/listitem&gt;
   * &lt;listitem&gt;a (GObject) Gda::Parameter named "EVENT" which contains a GdaConnectionEvent&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * &lt;/listitem&gt;
   * &lt;listitem&gt;<tt>0</tt> is in the list if the correcponding statement could not be executed&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * 
   * For every executed statement, a Gda::DataModel, a Gda::ParameterList or <tt>0</tt> will be appended to the returned list.
   * The returned list may contain fewer items than the @a cmd  command contained statements depending on the
   * options of @a command  (see gda_command_set_options()).
   * @param cnc A Gda::Connection object using.
   * @param cmd A Gda::Command.
   * @param params A Gda::ParameterList containing a list of optional parameters.
   * @return A new list, or <tt>0</tt>.
   */
  Glib::ListHandle< Glib::RefPtr<DataModel> > execute_command(const Glib::RefPtr<Connection>& cnc, const Command& cmd, const Glib::RefPtr<ParameterList>& params);

  
  /** 
   * @param name The name of the transation to start.
   * @param error A place to store errors, or <tt>0</tt>.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool begin_transaction(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name, TransactionIsolation level);
#else
  bool begin_transaction(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name, TransactionIsolation level, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** 
   * @param name The name of the transation to commit.
   * @param error A place to store errors, or <tt>0</tt>.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool commit_transaction(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name);
#else
  bool commit_transaction(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** 
   * @param name The name of the transation to commit.
   * @param error A place to store errors, or <tt>0</tt>.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool rollback_transaction(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name);
#else
  bool rollback_transaction(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** 
   * @param cnc A Gda::Connection object.
   * @param name Name of the savepoint to add.
   * @param error A place to store errors or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool add_savepoint(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name);
#else
  bool add_savepoint(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** 
   * @param cnc A Gda::Connection object.
   * @param name Name of the savepoint to rollback to.
   * @param error A place to store errors or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool rollback_savepoint(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name);
#else
  bool rollback_savepoint(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** 
   * @param cnc A Gda::Connection object.
   * @param name Name of the savepoint to delete.
   * @param error A place to store errors or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool delete_savepoint(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name);
#else
  bool delete_savepoint(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** 
   */
  bool supports_feature(const Glib::RefPtr<Connection>& cnc, ConnectionFeature feature) const;

  //TODO: Use C++ parameters, and add const version:
  
  /** Get a Gda::DataModel containing the requested information. See this section for more 
   * information on the columns of the returned Gda::DataModel depending on requested @a schema , and for the possible
   * parameters of @a params , see the
   * get_schema() virtual method for providers for more details.
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @param schema The requested kind of information.
   * @param params Optional parameters.
   * @return A new Gda::DataModel, or <tt>0</tt> if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<DataModel> get_schema(const Glib::RefPtr<Connection>& cnc, ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params);
#else
  Glib::RefPtr<DataModel> get_schema(const Glib::RefPtr<Connection>& cnc, ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Get a Gda::DataModel containing the requested information. See this section for more 
   * information on the columns of the returned Gda::DataModel depending on requested @a schema , and for the possible
   * parameters of @a params , see the
   * get_schema() virtual method for providers for more details.
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @param schema The requested kind of information.
   * @param params Optional parameters.
   * @return A new Gda::DataModel, or <tt>0</tt> if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<const DataModel> get_schema(const Glib::RefPtr<Connection>& cnc, ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params) const;
#else
  Glib::RefPtr<const DataModel> get_schema(const Glib::RefPtr<Connection>& cnc, ConnectionSchema schema, const Glib::RefPtr<ParameterList>& params, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  //TODO: Check that these take a reference, like the generated ones:
  Glib::RefPtr<DataModel> get_schema(const Glib::RefPtr<Connection>& cnc, ConnectionSchema schema);
  Glib::RefPtr<const DataModel> get_schema(const Glib::RefPtr<Connection>& cnc, ConnectionSchema schema) const;

  
  /** Produces a fully quoted and escaped string from a GValue
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @param from G::Value to convert from.
   * @return Escaped and quoted value or <tt>0</tt> if not supported.
   */
  Glib::ustring value_to_sql_string(const Glib::RefPtr<Connection>& cnc, const Value& from) const;

  
  /** Retrieve from the given Gda::ServerProvider the ID of the last inserted row.
   * A connection must be specified, and, optionally, a result set. If not <tt>0</tt>,
   * the provider should try to get the last insert ID for the given result set.
   * @param cnc Connection to act upon.
   * @param recset Resultset to get the last insert ID from.
   * @return A string representing the ID of the last inserted row, or <tt>0</tt>
   * if an error occurred or no row has been inserted. It is the caller's
   * reponsibility to free the returned string.
   */
  Glib::ustring get_last_insert_id(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<DataModel>& recset) const;

  
  /** Escapes @a str  for use within an SQL command (to avoid SQL injection attacks). Note that the returned value still needs
   * to be enclosed in single quotes before being used in an SQL statement.
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @param str A string to escape.
   * @return A new string suitable to use in SQL statements.
   */
  Glib::ustring escape_string(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& str);
  
  /** Unescapes @a str  for use within an SQL command. This is the exact opposite of escape_string().
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @param str A string to escape.
   * @return A new string.
   */
  Glib::ustring unescape_string(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& str);
  
  /** Executes the @a query  query, and returns:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;A Gda::DataModel if the query was a SELECT statement and the statement was successufully executed&lt;/listitem&gt;
   * &lt;listitem&gt;A Gda::ParameterList if the query was not a SELECT 
   * query and the query was successufully executed. In this case
   * (if the provider supports it), then the Gda::ParameterList may contain:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;a (<tt>int</tt>) Gda::Parameter named "IMPACTED_ROWS"&lt;/listitem&gt;
   * &lt;listitem&gt;a (GObject) Gda::Parameter named "EVENT" which contains a GdaConnectionEvent&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * &lt;/listitem&gt;
   * &lt;listitem&gt;<tt>0</tt> is in the list if the query could not be executed&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * 
   * The differences between this function and execute_command() are:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;Only one query can be executed at a time&lt;/listitem&gt;
   * &lt;listitem&gt;If the database provider supports it, prepared statements can be used&lt;/listitem&gt;
   * &lt;listitem&gt;Blobs are handled correctly (because blobs are usually not handled using SQL)&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * @param cnc A Gda::Connection object using.
   * @param query A Gda::Query.
   * @param params A Gda::ParameterList object obtained using gda_query_get_parameter_list( @a query ).
   * @return A new (Gda::DataModel or Gda::ParameterList) object, or <tt>0</tt>.
   */
  Glib::RefPtr<Gda::Object> execute_query(const Glib::RefPtr<Connection>& cnc, const Glib::RefPtr<Query>& query, const Glib::RefPtr<ParameterList>& options);

  
  /** Find a Gda::DataHandler object to manipulate data of type @a for_type .
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @param for_type A DBMS type definition.
   * @return A Gda::DataHandler, or <tt>0</tt> if the provider does not know about the @a for_type  type.
   */
  Glib::RefPtr<DataHandler> get_data_handler_dbms(const Glib::RefPtr<Connection>& cnc,  const Glib::ustring& for_type);
  
  /** Find a Gda::DataHandler object to manipulate data of type @a for_type .
   * @param cnc A Gda::Connection object, or <tt>0</tt>.
   * @param for_type A DBMS type definition.
   * @return A Gda::DataHandler, or <tt>0</tt> if the provider does not know about the @a for_type  type.
   */
  Glib::RefPtr<const DataHandler> get_data_handler_dbms(const Glib::RefPtr<Connection>& cnc,  const Glib::ustring& for_type) const;

  //TODO: What about the methods that take a GType argument? Johannes

 //TODO: vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::ServerProvider
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::ServerProvider> wrap(GdaServerProvider* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_SERVERPROVIDER_H */

