// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DATAMODELQUERY_H
#define _LIBGDAMM_DATAMODELQUERY_H


#include <glibmm.h>

/* $Id: datamodelquery.hg,v 1.1 2006/12/15 15:02:27 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* datamodel.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/object.h>
#include <libgdamm/datamodel.h>
#include <libgdamm/parameterlist.h>
#include <libgdamm/query.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDataModelQuery GdaDataModelQuery;
typedef struct _GdaDataModelQueryClass GdaDataModelQueryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DataModelQuery_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Exception class for DataModelQuery errors.
 */
class DataModelQueryError : public Glib::Error
{
public:
  enum Code
  {
    DATA_MODEL_QUERY_XML_LOAD_ERROR,
    DATA_MODEL_QUERY_COMPUTE_MODIF_QUERIES_ERROR
  };

  DataModelQueryError(Code error_code, const Glib::ustring& error_message);
  explicit DataModelQueryError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::DataModelQueryError::Code> : public Glib::Value_Enum<Gnome::Gda::DataModelQueryError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%DataModelQueryOptions operator|(DataModelQueryOptions, DataModelQueryOptions)</tt><br>
 * <tt>%DataModelQueryOptions operator&(DataModelQueryOptions, DataModelQueryOptions)</tt><br>
 * <tt>%DataModelQueryOptions operator^(DataModelQueryOptions, DataModelQueryOptions)</tt><br>
 * <tt>%DataModelQueryOptions operator~(DataModelQueryOptions)</tt><br>
 * <tt>%DataModelQueryOptions& operator|=(DataModelQueryOptions&, DataModelQueryOptions)</tt><br>
 * <tt>%DataModelQueryOptions& operator&=(DataModelQueryOptions&, DataModelQueryOptions)</tt><br>
 * <tt>%DataModelQueryOptions& operator^=(DataModelQueryOptions&, DataModelQueryOptions)</tt><br>
 */
enum DataModelQueryOptions
{
  DATA_MODEL_QUERY_OPTION_USE_ALL_FIELDS_IF_NO_PK = 1 << 0
};

/** @ingroup libgdammEnums */
inline DataModelQueryOptions operator|(DataModelQueryOptions lhs, DataModelQueryOptions rhs)
  { return static_cast<DataModelQueryOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline DataModelQueryOptions operator&(DataModelQueryOptions lhs, DataModelQueryOptions rhs)
  { return static_cast<DataModelQueryOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline DataModelQueryOptions operator^(DataModelQueryOptions lhs, DataModelQueryOptions rhs)
  { return static_cast<DataModelQueryOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline DataModelQueryOptions operator~(DataModelQueryOptions flags)
  { return static_cast<DataModelQueryOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline DataModelQueryOptions& operator|=(DataModelQueryOptions& lhs, DataModelQueryOptions rhs)
  { return (lhs = static_cast<DataModelQueryOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline DataModelQueryOptions& operator&=(DataModelQueryOptions& lhs, DataModelQueryOptions rhs)
  { return (lhs = static_cast<DataModelQueryOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline DataModelQueryOptions& operator^=(DataModelQueryOptions& lhs, DataModelQueryOptions rhs)
  { return (lhs = static_cast<DataModelQueryOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::DataModelQueryOptions> : public Glib::Value_Flags<Gnome::Gda::DataModelQueryOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** An implementation of DataModel based on a SELECT query.
 * The DataModelQuery data model simply stores the values returned by a SELECT query. 
 * The connection used to execute the SELECT query (given when the object is constructed) 
 * is the same as the one provided the Dict object to which the query relates.
 *
 * @ingroup DataModels
 */

class DataModelQuery
 : public Object,
   public DataModel
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataModelQuery CppObjectType;
  typedef DataModelQuery_Class CppClassType;
  typedef GdaDataModelQuery BaseObjectType;
  typedef GdaDataModelQueryClass BaseClassType;

private:  friend class DataModelQuery_Class;
  static CppClassType datamodelquery_class_;

private:
  // noncopyable
  DataModelQuery(const DataModelQuery&);
  DataModelQuery& operator=(const DataModelQuery&);

protected:
  explicit DataModelQuery(const Glib::ConstructParams& construct_params);
  explicit DataModelQuery(GdaDataModelQuery* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataModelQuery();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDataModelQuery*       gobj()       { return reinterpret_cast<GdaDataModelQuery*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaDataModelQuery* gobj() const { return reinterpret_cast<GdaDataModelQuery*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaDataModelQuery* gobj_copy();

private:

  
protected:
  // Hand-coded to also set dict property
  //TODO: Documentation.
  explicit DataModelQuery(const Glib::RefPtr<Query>& query);
  

public:
  
  static Glib::RefPtr<DataModelQuery> create(Glib::RefPtr<Query>& query);


  /** If some parameters are required to execute the SELECT query used in the @a model  data model, then
   * Returns: a Gda::ParameterList object, or <tt>0</tt>
   * @return A Gda::ParameterList object, or <tt>0</tt>.
   */
  Glib::RefPtr<ParameterList> get_parameter_list();
  
  /** If some parameters are required to execute the SELECT query used in the @a model  data model, then
   * Returns: a Gda::ParameterList object, or <tt>0</tt>
   * @return A Gda::ParameterList object, or <tt>0</tt>.
   */
  Glib::RefPtr<const ParameterList> get_parameter_list() const;

  
  /** (Re)-runs the SELECT query to update the contents of @a model 
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool query_refresh();
#else
  bool query_refresh(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Sets the modification query to be used by @a model  to actually perform any change
   * to the dataset in the database.
   * 
   * The provided query (the @a query  SQL) must be either a INSERT, UPDATE or DELETE query. It can contain
   * parameters, and the parameters named '[+-]&lt;num&gt;' will be replaced when the query is run:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;a parameter named +&lt;num&gt; will take the new value set at the 
   * &lt;num&gt;th column in @a model &lt;/listitem&gt;
   * &lt;listitem&gt;a parameter named -&lt;num&gt; will take the old value set at the
   * &lt;num&gt;th column in @a model &lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * Please note that the "+0" and "-0" parameters names are valid and will respectively 
   * take the new and old values of the first column of @a model .
   * 
   * Examples of queries are: "INSERT INTO orders (customer, creation_date, delivery_before, delivery_date) VALUES (## / *name:'Customer' type:integer* /, date('now'), ## / *name:"+2" type:date nullok:<tt>true</tt> * /, <tt>0</tt>)", "DELETE FROM orders WHERE id = ## / *name:"-0" type:integer* /" and "UPDATE orders set id=## / *name:"+0" type:integer* /, delivery_before=## / *name:"+2" type:date nullok:<tt>true</tt>* /, delivery_date=## / *name:"+3" type:date nullok:<tt>true</tt>* / WHERE id=## / *name:"-0" type:integer* /"
   * @param query The SQL code for a query.
   * @param error A place to store errors, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_modification_query(const Glib::ustring& query);
#else
  bool set_modification_query(const Glib::ustring& query, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Try to compute the INSERT, DELETE and UPDATE queries; any previous modification query
   * will be discarded.
   * 
   * If specified, the table which will be updated is the one represented by the @a target .
   * 
   * If @a target  is <tt>0</tt>, then an error will be returned if @a model 's SELECT query has more than
   * one target.
   * @param target The target table to modify, or <tt>0</tt>.
   * @param options Options to specify how the queries must be built in some special cases.
   * @param error A place to store errors or <tt>0</tt>.
   * @return <tt>true</tt> if the INSERT, DELETE and UPDATE queries have been computed.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool compute_modification_queries(const Glib::ustring& target, DataModelQueryOptions options);
#else
  bool compute_modification_queries(const Glib::ustring& target, DataModelQueryOptions options, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::DataModelQuery
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::DataModelQuery> wrap(GdaDataModelQuery* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_DATAMODELQUERY_H */

