// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_DATAMODELFILTERSQL_H
#define _LIBGDAMM_DATAMODELFILTERSQL_H


#include <glibmm.h>

// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* datamodelfiltersql.h
 *
 * Copyright 2007 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/datamodelrow.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaDataModelFilterSQL GdaDataModelFilterSQL;
typedef struct _GdaDataModelFilterSQLClass GdaDataModelFilterSQLClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class DataModelFilterSQL_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Filtering data from one or several DataModel objects.
 * This object implements simple SQL "SELECT" queries accessing data stored in various DataModel objects which it is instructed to use.
 *
 * @ingroup DataModels
 */

class DataModelFilterSQL
 : public DataModelRow
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataModelFilterSQL CppObjectType;
  typedef DataModelFilterSQL_Class CppClassType;
  typedef GdaDataModelFilterSQL BaseObjectType;
  typedef GdaDataModelFilterSQLClass BaseClassType;

private:  friend class DataModelFilterSQL_Class;
  static CppClassType datamodelfiltersql_class_;

private:
  // noncopyable
  DataModelFilterSQL(const DataModelFilterSQL&);
  DataModelFilterSQL& operator=(const DataModelFilterSQL&);

protected:
  explicit DataModelFilterSQL(const Glib::ConstructParams& construct_params);
  explicit DataModelFilterSQL(GdaDataModelFilterSQL* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataModelFilterSQL();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaDataModelFilterSQL*       gobj()       { return reinterpret_cast<GdaDataModelFilterSQL*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaDataModelFilterSQL* gobj() const { return reinterpret_cast<GdaDataModelFilterSQL*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaDataModelFilterSQL* gobj_copy();

private:

protected:
  DataModelFilterSQL();
  

public:
  
  static Glib::RefPtr<DataModelFilterSQL> create();


  /** Adds a data model as a source of data for the Gda::DataModelFilterSQL object. When
   * the select object is run (via #gda_data_model_filter_sql_run), it will parse the SQL
   * and get the required data from the source data models.
   * @param name Name to identify the data model (usually a table name).
   * @param source A Gda::DataModel from which to get data.
   */
  void add_source(const Glib::ustring& name, const Glib::RefPtr<DataModel>& source);
  
  /** Sets the SQL command to be used on the given Gda::DataModelFilterSQL object
   * for filtering rows from the source data model (which is
   * set with #gda_data_model_filter_sql_set_source).
   * @param sql The SQL command to be used for filtering rows.
   */
  void set_sql(const Glib::ustring& sql);
  
  /** Runs the query and fills in the Gda::DataModelFilterSQL object with the
   * rows that matched the SQL command (which can be set with
   * #gda_data_model_filter_sql_set_sql) associated with this Gda::DataModelFilterSQL
   * object.
   * 
   * After calling this function, if everything is successful,
   * the Gda::DataModelFilterSQL object will contain the matched rows, which
   * can then be accessed like a normal Gda::DataModel.
   * @return <tt>true</tt> if successful, <tt>false</tt> if there was an error.
   */
  bool run();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::DataModelFilterSQL
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::DataModelFilterSQL> wrap(GdaDataModelFilterSQL* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_DATAMODELFILTERSQL_H */

