/* iterator.c generated by valac 0.10.0, the Vala compiler
 * generated from iterator.vala, do not modify */

/* iterator.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};



GType gee_iterator_get_type (void) G_GNUC_CONST;
gboolean gee_iterator_next (GeeIterator* self);
gboolean gee_iterator_has_next (GeeIterator* self);
gboolean gee_iterator_first (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
void gee_iterator_remove (GeeIterator* self);



/**
 * Advances to the next element in the iteration.
 *
 * @return `true` if the iterator has a next element
 */
gboolean gee_iterator_next (GeeIterator* self) {
	return GEE_ITERATOR_GET_INTERFACE (self)->next (self);
}


/**
 * Checks whether there is a next element in the iteration.
 *
 * @return `true` if the iterator has a next element
 */
gboolean gee_iterator_has_next (GeeIterator* self) {
	return GEE_ITERATOR_GET_INTERFACE (self)->has_next (self);
}


/**
 * Rewinds to the first element in the iteration.
 *
 * @return `true` if the iterator has a first element
 */
gboolean gee_iterator_first (GeeIterator* self) {
	return GEE_ITERATOR_GET_INTERFACE (self)->first (self);
}


/**
 * Returns the current element in the iteration.
 *
 * @return the current element in the iteration
 */
gpointer gee_iterator_get (GeeIterator* self) {
	return GEE_ITERATOR_GET_INTERFACE (self)->get (self);
}


/**
 * Removes the current element in the iteration. The cursor is set in an
 * in-between state. Both {@link get} and {@link remove} will fail until
 * the next move of the cursor (calling {@link next} or {@link first}).
 */
void gee_iterator_remove (GeeIterator* self) {
	GEE_ITERATOR_GET_INTERFACE (self)->remove (self);
}


static void gee_iterator_base_init (GeeIteratorIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
 * An iterator over a collection.
 *
 * Gee's iterators are "on-track" iterators. They always point to an item
 * except before the first call to {@link next} or {@link first}, or, when an
 * item has been removed, until the next call to {@link next} or {@link first}.
 *
 * Please note that when the iterator is out of track, neither {@link get} nor
 * {@link remove} are defined and both will fail. After the next call to
 * {@link next} or {@link first}, they will be defined again.
 */
GType gee_iterator_get_type (void) {
	static volatile gsize gee_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeIteratorIface), (GBaseInitFunc) gee_iterator_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_iterator_type_id;
		gee_iterator_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeIterator", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_iterator_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_iterator_type_id__volatile, gee_iterator_type_id);
	}
	return gee_iterator_type_id__volatile;
}




