/* timsort.c generated by valac 0.11.5, the Vala compiler
 * generated from timsort.vala, do not modify */

/* timsort.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_TIM_SORT (gee_tim_sort_get_type ())
#define GEE_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TIM_SORT, GeeTimSort))
#define GEE_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TIM_SORT, GeeTimSortClass))
#define GEE_IS_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TIM_SORT))
#define GEE_IS_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TIM_SORT))
#define GEE_TIM_SORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TIM_SORT, GeeTimSortClass))

typedef struct _GeeTimSort GeeTimSort;
typedef struct _GeeTimSortClass GeeTimSortClass;
typedef struct _GeeTimSortPrivate GeeTimSortPrivate;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;
typedef struct _GeeTimSortSlice GeeTimSortSlice;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;
typedef struct _GeeArrayListPrivate GeeArrayListPrivate;
#define _gee_tim_sort_slice_free0(var) ((var == NULL) ? NULL : (var = (gee_tim_sort_slice_free (var), NULL)))

struct _GeeTimSort {
	GObject parent_instance;
	GeeTimSortPrivate * priv;
};

struct _GeeTimSortClass {
	GObjectClass parent_class;
};

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*insert) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareFunc compare_func);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeTimSortPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeList* list_collection;
	gpointer* array;
	gint array_length1;
	gint _array_size_;
	void** list;
	gint index;
	gint size;
	GeeTimSortSlice** pending;
	gint pending_length1;
	gint _pending_size_;
	gint minimum_gallop;
	GCompareFunc compare;
	GCompareDataFunc compare_data;
	gpointer compare_data_target;
	GDestroyNotify compare_data_target_destroy_notify;
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	gpointer (*first) (GeeAbstractList* self);
	gpointer (*last) (GeeAbstractList* self);
	void (*insert_all) (GeeAbstractList* self, gint index, GeeCollection* collection);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeArrayList {
	GeeAbstractList parent_instance;
	GeeArrayListPrivate * priv;
	gpointer* _items;
	gint _items_length1;
	gint __items_size_;
	gint _size;
};

struct _GeeArrayListClass {
	GeeAbstractListClass parent_class;
};

struct _GeeTimSortSlice {
	void** list;
	void** new_list;
	gint index;
	gint length;
};

typedef gboolean (*GeeTimSortLowerFunc) (gconstpointer left, gconstpointer right, void* user_data);

static gpointer gee_tim_sort_parent_class = NULL;

GType gee_tim_sort_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
static void gee_tim_sort_slice_free (GeeTimSortSlice* self);
#define GEE_TIM_SORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_TIM_SORT, GeeTimSortPrivate))
enum  {
	GEE_TIM_SORT_DUMMY_PROPERTY,
	GEE_TIM_SORT_G_TYPE,
	GEE_TIM_SORT_G_DUP_FUNC,
	GEE_TIM_SORT_G_DESTROY_FUNC
};
#define GEE_TIM_SORT_MINIMUM_GALLOP 7
void gee_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare);
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_array_list_get_type (void) G_GNUC_CONST;
static void gee_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareFunc compare, GCompareDataFunc compare_data, void* compare_data_target);
static void gee_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare, GCompareDataFunc compare_data, void* compare_data_target);
void gee_tim_sort_sort_with_data (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare_data, void* compare_data_target);
GeeTimSort* gee_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeTimSort* gee_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
static void gee_tim_sort_do_sort (GeeTimSort* self);
void gee_collection_clear (GeeCollection* self);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length);
static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length);
static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self, gint length);
static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self, GeeTimSortSlice* a, gboolean* descending);
static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self);
static void gee_tim_sort_insertion_sort (GeeTimSort* self, GeeTimSortSlice* a, gint offset);
static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self, gint n);
static void _vala_array_add1 (GeeTimSortSlice*** array, int* length, int* size, GeeTimSortSlice* value);
static void gee_tim_sort_merge_collapse (GeeTimSort* self);
static void gee_tim_sort_merge_force_collapse (GeeTimSort* self);
static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self, gconstpointer left, gconstpointer right);
static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self, gconstpointer left, gconstpointer right);
static void gee_tim_sort_merge_at (GeeTimSort* self, gint index);
static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint);
static inline void* gee_tim_sort_slice_peek_first (GeeTimSortSlice* self);
static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint);
static inline void* gee_tim_sort_slice_peek_last (GeeTimSortSlice* self);
static void gee_tim_sort_merge_low (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b);
static void gee_tim_sort_merge_high (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b);
static void gee_tim_sort_slice_copy (GeeTimSortSlice* self);
static inline void* gee_tim_sort_slice_pop_first (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count);
static inline void* gee_tim_sort_slice_pop_last (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count);
static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self, gint n);
static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self);
static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self, gint i, gint j);
static void gee_tim_sort_finalize (GObject* obj);
static void _vala_gee_tim_sort_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_tim_sort_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);


void gee_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare) {
	g_return_if_fail (list != NULL);
	if (GEE_IS_ARRAY_LIST (list)) {
		gee_tim_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, GEE_ARRAY_LIST (list), compare, NULL, NULL);
	} else {
		gee_tim_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, list, compare, NULL, NULL);
	}
}


void gee_tim_sort_sort_with_data (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare_data, void* compare_data_target) {
	g_return_if_fail (list != NULL);
	if (GEE_IS_ARRAY_LIST (list)) {
		gee_tim_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, GEE_ARRAY_LIST (list), NULL, compare_data, compare_data_target);
	} else {
		gee_tim_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, list, NULL, compare_data, compare_data_target);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gee_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare, GCompareDataFunc compare_data, void* compare_data_target) {
	gboolean _tmp0_ = FALSE;
	GeeTimSort* _tmp1_ = NULL;
	GeeTimSort* helper;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gpointer* _tmp5_ = NULL;
	gpointer* _tmp6_;
	gint _tmp7_;
	GCompareDataFunc _tmp8_;
	GCompareDataFunc _tmp9_;
	g_return_if_fail (list != NULL);
	if (compare != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = compare_data != NULL;
	}
	g_assert (_tmp0_);
	_tmp1_ = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	helper = _tmp1_;
	_tmp2_ = _g_object_ref0 (list);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (helper->priv->list_collection);
	helper->priv->list_collection = _tmp3_;
	_tmp5_ = gee_collection_to_array ((GeeCollection*) list, &_tmp4_);
	_tmp6_ = _tmp5_;
	helper->priv->array = (_vala_array_free (helper->priv->array, helper->priv->array_length1, (GDestroyNotify) g_destroy_func), NULL);
	helper->priv->array_length1 = _tmp4_;
	helper->priv->_array_size_ = helper->priv->array_length1;
	helper->priv->array = _tmp6_;
	helper->priv->list = helper->priv->array;
	helper->priv->index = 0;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) list);
	helper->priv->size = _tmp7_;
	helper->priv->compare = compare;
	_tmp8_ = compare_data;
	_tmp9_ = _tmp8_;
	(helper->priv->compare_data_target_destroy_notify == NULL) ? NULL : (helper->priv->compare_data_target_destroy_notify (helper->priv->compare_data_target), NULL);
	helper->priv->compare_data = NULL;
	helper->priv->compare_data_target = NULL;
	helper->priv->compare_data_target_destroy_notify = NULL;
	helper->priv->compare_data_target = compare_data_target;
	helper->priv->compare_data_target_destroy_notify = NULL;
	helper->priv->compare_data = _tmp9_;
	gee_tim_sort_do_sort (helper);
	gee_collection_clear ((GeeCollection*) list);
	{
		gpointer* item_collection;
		int item_collection_length1;
		int item_it;
		item_collection = helper->priv->array;
		item_collection_length1 = helper->priv->array_length1;
		for (item_it = 0; item_it < helper->priv->array_length1; item_it = item_it + 1) {
			gpointer _tmp10_;
			gconstpointer _tmp11_;
			gpointer item;
			_tmp10_ = (_tmp11_ = item_collection[item_it], ((_tmp11_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp11_) : g_dup_func ((gpointer) _tmp11_));
			item = _tmp10_;
			{
				gee_collection_add ((GeeCollection*) list, item);
				_g_destroy_func0 (item);
			}
		}
	}
	_g_object_unref0 (helper);
}


static void gee_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareFunc compare, GCompareDataFunc compare_data, void* compare_data_target) {
	gboolean _tmp0_ = FALSE;
	GeeTimSort* _tmp1_ = NULL;
	GeeTimSort* helper;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GCompareDataFunc _tmp4_;
	GCompareDataFunc _tmp5_;
	g_return_if_fail (list != NULL);
	if (compare != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = compare_data != NULL;
	}
	g_assert (_tmp0_);
	_tmp1_ = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	helper = _tmp1_;
	_tmp2_ = _g_object_ref0 ((GeeList*) list);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (helper->priv->list_collection);
	helper->priv->list_collection = _tmp3_;
	helper->priv->list = list->_items;
	helper->priv->index = 0;
	helper->priv->size = list->_size;
	helper->priv->compare = compare;
	_tmp4_ = compare_data;
	_tmp5_ = _tmp4_;
	(helper->priv->compare_data_target_destroy_notify == NULL) ? NULL : (helper->priv->compare_data_target_destroy_notify (helper->priv->compare_data_target), NULL);
	helper->priv->compare_data = NULL;
	helper->priv->compare_data_target = NULL;
	helper->priv->compare_data_target_destroy_notify = NULL;
	helper->priv->compare_data_target = compare_data_target;
	helper->priv->compare_data_target_destroy_notify = NULL;
	helper->priv->compare_data = _tmp5_;
	gee_tim_sort_do_sort (helper);
	_g_object_unref0 (helper);
}


static void _vala_array_add1 (GeeTimSortSlice*** array, int* length, int* size, GeeTimSortSlice* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GeeTimSortSlice*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void gee_tim_sort_do_sort (GeeTimSort* self) {
	GeeTimSortSlice** _tmp0_ = NULL;
	GeeTimSortSlice** _tmp1_;
	GeeTimSortSlice* _tmp2_ = NULL;
	GeeTimSortSlice* remaining;
	gint _tmp3_;
	gint minimum_length;
	g_return_if_fail (self != NULL);
	if (self->priv->size < 2) {
		return;
	}
	_tmp0_ = g_new0 (GeeTimSortSlice*, 0 + 1);
	_tmp1_ = _tmp0_;
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) gee_tim_sort_slice_free), NULL);
	self->priv->pending_length1 = 0;
	self->priv->_pending_size_ = self->priv->pending_length1;
	self->priv->pending = _tmp1_;
	self->priv->minimum_gallop = GEE_TIM_SORT_MINIMUM_GALLOP;
	_tmp2_ = gee_tim_sort_slice_new (self->priv->list, self->priv->index, self->priv->size);
	remaining = _tmp2_;
	_tmp3_ = gee_tim_sort_compute_minimum_run_length (self, remaining->length);
	minimum_length = _tmp3_;
	while (TRUE) {
		gboolean descending = FALSE;
		gboolean _tmp4_;
		GeeTimSortSlice* _tmp5_ = NULL;
		GeeTimSortSlice* run;
		GeeTimSortSlice* _tmp7_;
		if (!(remaining->length > 0)) {
			break;
		}
		_tmp5_ = gee_tim_sort_compute_longest_run (self, remaining, &_tmp4_);
		descending = _tmp4_;
		run = _tmp5_;
		if (descending) {
			gee_tim_sort_slice_reverse (run);
		}
		if (run->length < minimum_length) {
			gint sorted_count;
			gint _tmp6_;
			sorted_count = run->length;
			_tmp6_ = MIN (minimum_length, remaining->length);
			run->length = _tmp6_;
			gee_tim_sort_insertion_sort (self, run, sorted_count);
		}
		gee_tim_sort_slice_shorten_start (remaining, run->length);
		_tmp7_ = run;
		run = NULL;
		_vala_array_add1 (&self->priv->pending, &self->priv->pending_length1, &self->priv->_pending_size_, _tmp7_);
		gee_tim_sort_merge_collapse (self);
		_gee_tim_sort_slice_free0 (run);
	}
	g_assert (remaining->index == self->priv->size);
	gee_tim_sort_merge_force_collapse (self);
	g_assert (self->priv->pending_length1 == 1);
	g_assert (self->priv->pending[0]->index == 0);
	g_assert (self->priv->pending[0]->length == self->priv->size);
	_gee_tim_sort_slice_free0 (remaining);
}


static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self, gconstpointer left, gconstpointer right) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->compare != NULL) {
		gint _tmp0_;
		_tmp0_ = self->priv->compare (left, right);
		result = _tmp0_ < 0;
		return result;
	} else {
		gint _tmp1_;
		_tmp1_ = self->priv->compare_data (left, right, self->priv->compare_data_target);
		result = _tmp1_ < 0;
		return result;
	}
}


static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self, gconstpointer left, gconstpointer right) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->compare != NULL) {
		gint _tmp0_;
		_tmp0_ = self->priv->compare (left, right);
		result = _tmp0_ <= 0;
		return result;
	} else {
		gint _tmp1_;
		_tmp1_ = self->priv->compare_data (left, right, self->priv->compare_data_target);
		result = _tmp1_ <= 0;
		return result;
	}
}


static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self, gint length) {
	gint result = 0;
	gint run_length;
	g_return_val_if_fail (self != NULL, 0);
	run_length = 0;
	while (TRUE) {
		if (!(length >= 64)) {
			break;
		}
		run_length = run_length | (length & 1);
		length = length >> 1;
	}
	result = length + run_length;
	return result;
}


static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self, GeeTimSortSlice* a, gboolean* descending) {
	gboolean _descending = FALSE;
	GeeTimSortSlice* result = NULL;
	gint run_length = 0;
	GeeTimSortSlice* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (a != NULL, NULL);
	if (a->length <= 1) {
		run_length = a->length;
		_descending = FALSE;
	} else {
		gboolean _tmp0_;
		run_length = 2;
		_tmp0_ = gee_tim_sort_lower_than (self, a->list[a->index + 1], a->list[a->index]);
		if (_tmp0_) {
			_descending = TRUE;
			{
				gint i;
				i = a->index + 2;
				{
					gboolean _tmp1_;
					_tmp1_ = TRUE;
					while (TRUE) {
						gboolean _tmp2_;
						if (!_tmp1_) {
							i++;
						}
						_tmp1_ = FALSE;
						if (!(i < (a->index + a->length))) {
							break;
						}
						_tmp2_ = gee_tim_sort_lower_than (self, a->list[i], a->list[i - 1]);
						if (_tmp2_) {
							run_length++;
						} else {
							break;
						}
					}
				}
			}
		} else {
			_descending = FALSE;
			{
				gint i;
				i = a->index + 2;
				{
					gboolean _tmp3_;
					_tmp3_ = TRUE;
					while (TRUE) {
						gboolean _tmp4_;
						if (!_tmp3_) {
							i++;
						}
						_tmp3_ = FALSE;
						if (!(i < (a->index + a->length))) {
							break;
						}
						_tmp4_ = gee_tim_sort_lower_than (self, a->list[i], a->list[i - 1]);
						if (_tmp4_) {
							break;
						} else {
							run_length++;
						}
					}
				}
			}
		}
	}
	_tmp5_ = gee_tim_sort_slice_new (a->list, a->index, run_length);
	result = _tmp5_;
	if (descending) {
		*descending = _descending;
	}
	return result;
}


static void gee_tim_sort_insertion_sort (GeeTimSort* self, GeeTimSortSlice* a, gint offset) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	{
		gint start;
		start = a->index + offset;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint left;
				gint right;
				void* pivot;
				if (!_tmp0_) {
					start++;
				}
				_tmp0_ = FALSE;
				if (!(start < (a->index + a->length))) {
					break;
				}
				left = a->index;
				right = start;
				pivot = a->list[right];
				while (TRUE) {
					gint p;
					gboolean _tmp1_;
					if (!(left < right)) {
						break;
					}
					p = left + ((right - left) >> 1);
					_tmp1_ = gee_tim_sort_lower_than (self, pivot, a->list[p]);
					if (_tmp1_) {
						right = p;
					} else {
						left = p + 1;
					}
				}
				g_assert (left == right);
				g_memmove (&a->list[left + 1], &a->list[left], (gsize) (sizeof (gpointer) * (start - left)));
				a->list[left] = pivot;
			}
		}
	}
}


static void gee_tim_sort_merge_collapse (GeeTimSort* self) {
	gint count;
	g_return_if_fail (self != NULL);
	count = self->priv->pending_length1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (!(count > 1)) {
			break;
		}
		if (count >= 3) {
			_tmp0_ = self->priv->pending[count - 3]->length <= (self->priv->pending[count - 2]->length + self->priv->pending[count - 1]->length);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			if (self->priv->pending[count - 3]->length < self->priv->pending[count - 1]->length) {
				gee_tim_sort_merge_at (self, count - 3);
			} else {
				gee_tim_sort_merge_at (self, count - 2);
			}
		} else {
			if (self->priv->pending[count - 2]->length <= self->priv->pending[count - 1]->length) {
				gee_tim_sort_merge_at (self, count - 2);
			} else {
				break;
			}
		}
		count = self->priv->pending_length1;
	}
}


static void gee_tim_sort_merge_force_collapse (GeeTimSort* self) {
	gint count;
	g_return_if_fail (self != NULL);
	count = self->priv->pending_length1;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (!(count > 1)) {
			break;
		}
		if (count >= 3) {
			_tmp0_ = self->priv->pending[count - 3]->length < self->priv->pending[count - 1]->length;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gee_tim_sort_merge_at (self, count - 3);
		} else {
			gee_tim_sort_merge_at (self, count - 2);
		}
		count = self->priv->pending_length1;
	}
}


static void gee_tim_sort_merge_at (GeeTimSort* self, gint index) {
	GeeTimSortSlice* _tmp0_;
	GeeTimSortSlice* a;
	GeeTimSortSlice* _tmp1_;
	GeeTimSortSlice* b;
	GeeTimSortSlice* _tmp2_ = NULL;
	GeeTimSortSlice* _tmp3_;
	void* _tmp4_ = NULL;
	gint _tmp5_;
	gint sorted_count;
	void* _tmp6_ = NULL;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending[index];
	self->priv->pending[index] = NULL;
	a = _tmp0_;
	_tmp1_ = self->priv->pending[index + 1];
	self->priv->pending[index + 1] = NULL;
	b = _tmp1_;
	g_assert (a->length > 0);
	g_assert (b->length > 0);
	g_assert ((a->index + a->length) == b->index);
	_tmp2_ = gee_tim_sort_slice_new (self->priv->list, a->index, a->length + b->length);
	_tmp3_ = _tmp2_;
	_gee_tim_sort_slice_free0 (self->priv->pending[index]);
	self->priv->pending[index] = _tmp3_;
	_vala_array_move (self->priv->pending, sizeof (GeeTimSortSlice*), index + 2, index + 1, (self->priv->pending_length1 - index) - 2);
	self->priv->pending_length1 = self->priv->pending_length1 - 1;
	_tmp4_ = gee_tim_sort_slice_peek_first (b);
	_tmp5_ = gee_tim_sort_gallop_rightmost (self, _tmp4_, a, 0);
	sorted_count = _tmp5_;
	gee_tim_sort_slice_shorten_start (a, sorted_count);
	if (a->length == 0) {
		_gee_tim_sort_slice_free0 (b);
		_gee_tim_sort_slice_free0 (a);
		return;
	}
	_tmp6_ = gee_tim_sort_slice_peek_last (a);
	_tmp7_ = gee_tim_sort_gallop_leftmost (self, _tmp6_, b, b->length - 1);
	b->length = _tmp7_;
	if (b->length == 0) {
		_gee_tim_sort_slice_free0 (b);
		_gee_tim_sort_slice_free0 (a);
		return;
	}
	if (a->length <= b->length) {
		GeeTimSortSlice* _tmp8_;
		GeeTimSortSlice* _tmp9_;
		_tmp8_ = a;
		a = NULL;
		_tmp9_ = b;
		b = NULL;
		gee_tim_sort_merge_low (self, _tmp8_, _tmp9_);
	} else {
		GeeTimSortSlice* _tmp10_;
		GeeTimSortSlice* _tmp11_;
		_tmp10_ = a;
		a = NULL;
		_tmp11_ = b;
		b = NULL;
		gee_tim_sort_merge_high (self, _tmp10_, _tmp11_);
	}
	_gee_tim_sort_slice_free0 (b);
	_gee_tim_sort_slice_free0 (a);
}


static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint) {
	gint result = 0;
	gint p;
	gint last_offset;
	gint offset;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_assert (0 <= hint);
	g_assert (hint < a->length);
	p = a->index + hint;
	last_offset = 0;
	offset = 1;
	_tmp0_ = gee_tim_sort_lower_than (self, a->list[p], key);
	if (_tmp0_) {
		gint max_offset;
		max_offset = a->length - hint;
		while (TRUE) {
			gboolean _tmp1_;
			if (!(offset < max_offset)) {
				break;
			}
			_tmp1_ = gee_tim_sort_lower_than (self, a->list[p + offset], key);
			if (_tmp1_) {
				last_offset = offset;
				offset = offset << 1;
				offset++;
			} else {
				break;
			}
		}
		if (offset > max_offset) {
			offset = max_offset;
		}
		last_offset = hint + last_offset;
		offset = hint + offset;
	} else {
		gint max_offset;
		gint temp_last_offset;
		gint temp_offset;
		max_offset = hint + 1;
		while (TRUE) {
			gboolean _tmp2_;
			if (!(offset < max_offset)) {
				break;
			}
			_tmp2_ = gee_tim_sort_lower_than (self, a->list[p - offset], key);
			if (_tmp2_) {
				break;
			} else {
				last_offset = offset;
				offset = offset << 1;
				offset++;
			}
		}
		if (offset > max_offset) {
			offset = max_offset;
		}
		temp_last_offset = last_offset;
		temp_offset = offset;
		last_offset = hint - temp_offset;
		offset = hint - temp_last_offset;
	}
	g_assert ((-1) <= last_offset);
	g_assert (last_offset < offset);
	g_assert (offset <= a->length);
	last_offset = last_offset + 1;
	while (TRUE) {
		gint m;
		gboolean _tmp3_;
		if (!(last_offset < offset)) {
			break;
		}
		m = last_offset + ((offset - last_offset) >> 1);
		_tmp3_ = gee_tim_sort_lower_than (self, a->list[a->index + m], key);
		if (_tmp3_) {
			last_offset = m + 1;
		} else {
			offset = m;
		}
	}
	g_assert (last_offset == offset);
	result = offset;
	return result;
}


static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint) {
	gint result = 0;
	gint p;
	gint last_offset;
	gint offset;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_assert (0 <= hint);
	g_assert (hint < a->length);
	p = a->index + hint;
	last_offset = 0;
	offset = 1;
	_tmp0_ = gee_tim_sort_lower_than_or_equal_to (self, a->list[p], key);
	if (_tmp0_) {
		gint max_offset;
		max_offset = a->length - hint;
		while (TRUE) {
			gboolean _tmp1_;
			if (!(offset < max_offset)) {
				break;
			}
			_tmp1_ = gee_tim_sort_lower_than_or_equal_to (self, a->list[p + offset], key);
			if (_tmp1_) {
				last_offset = offset;
				offset = offset << 1;
				offset++;
			} else {
				break;
			}
		}
		if (offset > max_offset) {
			offset = max_offset;
		}
		last_offset = hint + last_offset;
		offset = hint + offset;
	} else {
		gint max_offset;
		gint temp_last_offset;
		gint temp_offset;
		max_offset = hint + 1;
		while (TRUE) {
			gboolean _tmp2_;
			if (!(offset < max_offset)) {
				break;
			}
			_tmp2_ = gee_tim_sort_lower_than_or_equal_to (self, a->list[p - offset], key);
			if (_tmp2_) {
				break;
			} else {
				last_offset = offset;
				offset = offset << 1;
				offset++;
			}
		}
		if (offset > max_offset) {
			offset = max_offset;
		}
		temp_last_offset = last_offset;
		temp_offset = offset;
		last_offset = hint - temp_offset;
		offset = hint - temp_last_offset;
	}
	g_assert ((-1) <= last_offset);
	g_assert (last_offset < offset);
	g_assert (offset <= a->length);
	last_offset = last_offset + 1;
	while (TRUE) {
		gint m;
		gboolean _tmp3_;
		if (!(last_offset < offset)) {
			break;
		}
		m = last_offset + ((offset - last_offset) >> 1);
		_tmp3_ = gee_tim_sort_lower_than_or_equal_to (self, a->list[a->index + m], key);
		if (_tmp3_) {
			last_offset = m + 1;
		} else {
			offset = m;
		}
	}
	g_assert (last_offset == offset);
	result = offset;
	return result;
}


static void gee_tim_sort_merge_low (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b) {
	gint minimum_gallop;
	gint dest;
	gint _tmp0_;
	void* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	g_assert (a->length > 0);
	g_assert (b->length > 0);
	g_assert ((a->index + a->length) == b->index);
	minimum_gallop = self->priv->minimum_gallop;
	dest = a->index;
	gee_tim_sort_slice_copy (a);
	_tmp0_ = dest;
	dest = _tmp0_ + 1;
	_tmp1_ = gee_tim_sort_slice_pop_first (b);
	self->priv->list[_tmp0_] = _tmp1_;
	if (a->length == 1) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = b->length == 0;
	}
	if (_tmp2_) {
		g_assert (a->length >= 0);
		g_assert (b->length >= 0);
		gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
		gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
		return;
	}
	while (TRUE) {
		gint a_count;
		gint b_count;
		a_count = 0;
		b_count = 0;
		while (TRUE) {
			void* _tmp3_ = NULL;
			void* _tmp4_ = NULL;
			gboolean _tmp5_;
			_tmp3_ = gee_tim_sort_slice_peek_first (b);
			_tmp4_ = gee_tim_sort_slice_peek_first (a);
			_tmp5_ = gee_tim_sort_lower_than (self, _tmp3_, _tmp4_);
			if (_tmp5_) {
				gint _tmp6_;
				void* _tmp7_ = NULL;
				_tmp6_ = dest;
				dest = _tmp6_ + 1;
				_tmp7_ = gee_tim_sort_slice_pop_first (b);
				self->priv->list[_tmp6_] = _tmp7_;
				if (b->length == 0) {
					g_assert (a->length >= 0);
					g_assert (b->length >= 0);
					gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
					gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
					return;
				}
				b_count++;
				a_count = 0;
				if (b_count >= minimum_gallop) {
					break;
				}
			} else {
				gint _tmp8_;
				void* _tmp9_ = NULL;
				_tmp8_ = dest;
				dest = _tmp8_ + 1;
				_tmp9_ = gee_tim_sort_slice_pop_first (a);
				self->priv->list[_tmp8_] = _tmp9_;
				if (a->length == 1) {
					g_assert (a->length >= 0);
					g_assert (b->length >= 0);
					gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
					gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
					return;
				}
				a_count++;
				b_count = 0;
				if (a_count >= minimum_gallop) {
					break;
				}
			}
		}
		minimum_gallop++;
		while (TRUE) {
			gint _tmp10_ = 0;
			void* _tmp11_ = NULL;
			gint _tmp12_;
			gint _tmp13_;
			void* _tmp14_ = NULL;
			void* _tmp15_ = NULL;
			gint _tmp16_;
			gint _tmp17_;
			void* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			if (minimum_gallop > 1) {
				_tmp10_ = 1;
			} else {
				_tmp10_ = 0;
			}
			minimum_gallop = minimum_gallop - _tmp10_;
			self->priv->minimum_gallop = minimum_gallop;
			_tmp11_ = gee_tim_sort_slice_peek_first (b);
			_tmp12_ = gee_tim_sort_gallop_rightmost (self, _tmp11_, a, 0);
			a_count = _tmp12_;
			gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest, a_count);
			dest = dest + a_count;
			gee_tim_sort_slice_shorten_start (a, a_count);
			if (a->length <= 1) {
				g_assert (a->length >= 0);
				g_assert (b->length >= 0);
				gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
				gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
				return;
			}
			_tmp13_ = dest;
			dest = _tmp13_ + 1;
			_tmp14_ = gee_tim_sort_slice_pop_first (b);
			self->priv->list[_tmp13_] = _tmp14_;
			if (b->length == 0) {
				g_assert (a->length >= 0);
				g_assert (b->length >= 0);
				gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
				gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
				return;
			}
			_tmp15_ = gee_tim_sort_slice_peek_first (a);
			_tmp16_ = gee_tim_sort_gallop_leftmost (self, _tmp15_, b, 0);
			b_count = _tmp16_;
			gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b_count);
			dest = dest + b_count;
			gee_tim_sort_slice_shorten_start (b, b_count);
			if (b->length == 0) {
				g_assert (a->length >= 0);
				g_assert (b->length >= 0);
				gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
				gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
				return;
			}
			_tmp17_ = dest;
			dest = _tmp17_ + 1;
			_tmp18_ = gee_tim_sort_slice_pop_first (a);
			self->priv->list[_tmp17_] = _tmp18_;
			if (a->length == 1) {
				g_assert (a->length >= 0);
				g_assert (b->length >= 0);
				gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
				gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
				return;
			}
			if (a_count < GEE_TIM_SORT_MINIMUM_GALLOP) {
				_tmp19_ = b_count < GEE_TIM_SORT_MINIMUM_GALLOP;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				break;
			}
		}
		minimum_gallop++;
		self->priv->minimum_gallop = minimum_gallop;
	}
	__finally0:
	g_assert (a->length >= 0);
	g_assert (b->length >= 0);
	gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
	gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return;
}


static void gee_tim_sort_merge_high (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b) {
	gint minimum_gallop;
	gint dest;
	void* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	g_assert (a->length > 0);
	g_assert (b->length > 0);
	g_assert ((a->index + a->length) == b->index);
	minimum_gallop = self->priv->minimum_gallop;
	dest = b->index + b->length;
	gee_tim_sort_slice_copy (b);
	dest = dest - 1;
	_tmp0_ = gee_tim_sort_slice_pop_last (a);
	self->priv->list[dest] = _tmp0_;
	if (a->length == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = b->length == 1;
	}
	if (_tmp1_) {
		g_assert (a->length >= 0);
		g_assert (b->length >= 0);
		gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
		gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
		return;
	}
	while (TRUE) {
		gint a_count;
		gint b_count;
		a_count = 0;
		b_count = 0;
		while (TRUE) {
			void* _tmp2_ = NULL;
			void* _tmp3_ = NULL;
			gboolean _tmp4_;
			_tmp2_ = gee_tim_sort_slice_peek_last (b);
			_tmp3_ = gee_tim_sort_slice_peek_last (a);
			_tmp4_ = gee_tim_sort_lower_than (self, _tmp2_, _tmp3_);
			if (_tmp4_) {
				void* _tmp5_ = NULL;
				dest = dest - 1;
				_tmp5_ = gee_tim_sort_slice_pop_last (a);
				self->priv->list[dest] = _tmp5_;
				if (a->length == 0) {
					g_assert (a->length >= 0);
					g_assert (b->length >= 0);
					gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
					gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
					return;
				}
				a_count++;
				b_count = 0;
				if (a_count >= minimum_gallop) {
					break;
				}
			} else {
				void* _tmp6_ = NULL;
				dest = dest - 1;
				_tmp6_ = gee_tim_sort_slice_pop_last (b);
				self->priv->list[dest] = _tmp6_;
				if (b->length == 1) {
					g_assert (a->length >= 0);
					g_assert (b->length >= 0);
					gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
					gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
					return;
				}
				b_count++;
				a_count = 0;
				if (b_count >= minimum_gallop) {
					break;
				}
			}
		}
		minimum_gallop++;
		while (TRUE) {
			gint _tmp7_ = 0;
			void* _tmp8_ = NULL;
			gint _tmp9_;
			gint k;
			void* _tmp10_ = NULL;
			void* _tmp11_ = NULL;
			gint _tmp12_;
			void* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			if (minimum_gallop > 1) {
				_tmp7_ = 1;
			} else {
				_tmp7_ = 0;
			}
			minimum_gallop = minimum_gallop - _tmp7_;
			self->priv->minimum_gallop = minimum_gallop;
			_tmp8_ = gee_tim_sort_slice_peek_last (b);
			_tmp9_ = gee_tim_sort_gallop_rightmost (self, _tmp8_, a, a->length - 1);
			k = _tmp9_;
			a_count = a->length - k;
			gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index + k, dest - a_count, a_count);
			dest = dest - a_count;
			gee_tim_sort_slice_shorten_end (a, a_count);
			if (a->length == 0) {
				g_assert (a->length >= 0);
				g_assert (b->length >= 0);
				gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
				gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
				return;
			}
			dest = dest - 1;
			_tmp10_ = gee_tim_sort_slice_pop_last (b);
			self->priv->list[dest] = _tmp10_;
			if (b->length == 1) {
				g_assert (a->length >= 0);
				g_assert (b->length >= 0);
				gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
				gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
				return;
			}
			_tmp11_ = gee_tim_sort_slice_peek_last (a);
			_tmp12_ = gee_tim_sort_gallop_leftmost (self, _tmp11_, b, b->length - 1);
			k = _tmp12_;
			b_count = b->length - k;
			gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index + k, dest - b_count, b_count);
			dest = dest - b_count;
			gee_tim_sort_slice_shorten_end (b, b_count);
			if (b->length <= 1) {
				g_assert (a->length >= 0);
				g_assert (b->length >= 0);
				gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
				gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
				return;
			}
			dest = dest - 1;
			_tmp13_ = gee_tim_sort_slice_pop_last (a);
			self->priv->list[dest] = _tmp13_;
			if (a->length == 0) {
				g_assert (a->length >= 0);
				g_assert (b->length >= 0);
				gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
				gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
				return;
			}
			if (a_count < GEE_TIM_SORT_MINIMUM_GALLOP) {
				_tmp14_ = b_count < GEE_TIM_SORT_MINIMUM_GALLOP;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				break;
			}
		}
		minimum_gallop++;
		self->priv->minimum_gallop = minimum_gallop;
	}
	__finally1:
	g_assert (a->length >= 0);
	g_assert (b->length >= 0);
	gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
	gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return;
}


GeeTimSort* gee_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeTimSort * self = NULL;
	self = (GeeTimSort*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


GeeTimSort* gee_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return gee_tim_sort_construct (GEE_TYPE_TIM_SORT, g_type, g_dup_func, g_destroy_func);
}


static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length) {
	GeeTimSortSlice* self;
	self = g_slice_new0 (GeeTimSortSlice);
	gee_tim_sort_slice_instance_init (self);
	self->list = list;
	self->index = index;
	self->length = length;
	return self;
}


static void gee_tim_sort_slice_copy (GeeTimSortSlice* self) {
	void* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_memdup (&self->list[self->index], ((guint) sizeof (gpointer)) * self->length);
	self->new_list = _tmp0_;
	self->list = self->new_list;
	self->index = 0;
}


static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count) {
	g_return_if_fail (self != NULL);
	g_memmove (&dest_array[dest_index], &self->list[index], (gsize) (sizeof (gpointer) * count));
}


static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count) {
	g_return_if_fail (self != NULL);
	g_memmove (&dest_array[dest_index], &self->list[index], (gsize) (sizeof (gpointer) * count));
}


static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self, gint n) {
	g_return_if_fail (self != NULL);
	self->index = self->index + n;
	self->length = self->length - n;
}


static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self, gint n) {
	g_return_if_fail (self != NULL);
	self->length = self->length - n;
}


static inline void* gee_tim_sort_slice_pop_first (GeeTimSortSlice* self) {
	void* result = NULL;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	self->length--;
	_tmp0_ = self->index;
	self->index = _tmp0_ + 1;
	result = self->list[_tmp0_];
	return result;
}


static inline void* gee_tim_sort_slice_pop_last (GeeTimSortSlice* self) {
	void* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	self->length--;
	result = self->list[self->index + self->length];
	return result;
}


static inline void* gee_tim_sort_slice_peek_first (GeeTimSortSlice* self) {
	void* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->list[self->index];
	return result;
}


static inline void* gee_tim_sort_slice_peek_last (GeeTimSortSlice* self) {
	void* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->list[(self->index + self->length) - 1];
	return result;
}


static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self) {
	gint low;
	gint high;
	g_return_if_fail (self != NULL);
	low = self->index;
	high = (self->index + self->length) - 1;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		if (!(low < high)) {
			break;
		}
		_tmp0_ = low;
		low = _tmp0_ + 1;
		_tmp1_ = high;
		high = _tmp1_ - 1;
		gee_tim_sort_slice_swap (self, _tmp0_, _tmp1_);
	}
}


static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self, gint i, gint j) {
	void* temp;
	g_return_if_fail (self != NULL);
	temp = self->list[i];
	self->list[i] = self->list[j];
	self->list[j] = temp;
}


static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self) {
}


static void gee_tim_sort_slice_free (GeeTimSortSlice* self) {
	if (self->new_list != NULL) {
		g_free (self->new_list);
	}
	g_slice_free (GeeTimSortSlice, self);
}


static void gee_tim_sort_class_init (GeeTimSortClass * klass) {
	gee_tim_sort_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTimSortPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_tim_sort_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_tim_sort_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tim_sort_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tim_sort_instance_init (GeeTimSort * self) {
	self->priv = GEE_TIM_SORT_GET_PRIVATE (self);
}


static void gee_tim_sort_finalize (GObject* obj) {
	GeeTimSort * self;
	self = GEE_TIM_SORT (obj);
	_g_object_unref0 (self->priv->list_collection);
	self->priv->array = (_vala_array_free (self->priv->array, self->priv->array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) gee_tim_sort_slice_free), NULL);
	(self->priv->compare_data_target_destroy_notify == NULL) ? NULL : (self->priv->compare_data_target_destroy_notify (self->priv->compare_data_target), NULL);
	self->priv->compare_data = NULL;
	self->priv->compare_data_target = NULL;
	self->priv->compare_data_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gee_tim_sort_parent_class)->finalize (obj);
}


/**
 * A stable, adaptive, iterative mergesort that requires far fewer than n*lg(n)
 * comparisons when running on partially sorted arrays, while offering
 * performance comparable to a traditional mergesort when run on random arrays.
 * Like all proper mergesorts, this sort is stable and runs O(n*log(n)) time
 * (worst case). In the worst case, this sort requires temporary storage space
 * for n/2 object references; in the best case, it requires only a small
 * constant amount of space.
 *
 * This implementation was adapted from Tim Peters's list sort for Python,
 * which is described in detail here:
 *   [[http://svn.python.org/projects/python/trunk/Objects/listsort.txt]]
 *
 * Tim's C code may be found here:
 *   [[http://svn.python.org/projects/python/trunk/Objects/listobject.c]]
 *
 * The underlying techniques are described in this paper (and may have even
 * earlier origins):
 *
 *   "Optimistic Sorting and Information Theoretic Complexity"
 *   Peter McIlroy
 *   SODA (Fourth Annual ACM-SIAM Symposium on Discrete Algorithms), pp
 *   467-474, Austin, Texas, 25-27 January 1993.
 */
GType gee_tim_sort_get_type (void) {
	static volatile gsize gee_tim_sort_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tim_sort_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTimSortClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tim_sort_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTimSort), 0, (GInstanceInitFunc) gee_tim_sort_instance_init, NULL };
		GType gee_tim_sort_type_id;
		gee_tim_sort_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTimSort", &g_define_type_info, 0);
		g_once_init_leave (&gee_tim_sort_type_id__volatile, gee_tim_sort_type_id);
	}
	return gee_tim_sort_type_id__volatile;
}


static void _vala_gee_tim_sort_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTimSort * self;
	self = GEE_TIM_SORT (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_tim_sort_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTimSort * self;
	self = GEE_TIM_SORT (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TIM_SORT_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TIM_SORT_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TIM_SORT_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if (src < dest) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	}
}



