/* testcollection.c generated by valac 0.13.2, the Vala compiler
 * generated from testcollection.vala, do not modify */

/* testcollection.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 * Copyright (C) 2011  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 *      Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);
struct _Block1Data {
	int _ref_count_;
	CollectionTests * self;
	gint count;
};

struct _Block2Data {
	int _ref_count_;
	CollectionTests * self;
	gboolean one;
	gboolean two;
	gboolean three;
	gint i;
};

struct _Block3Data {
	int _ref_count_;
	CollectionTests * self;
	gboolean one;
	gboolean two;
	gboolean three;
};

struct _Block4Data {
	int _ref_count_;
	CollectionTests * self;
	gboolean one;
	gboolean two;
	gboolean three;
};


static gpointer collection_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
enum  {
	COLLECTION_TESTS_DUMMY_PROPERTY
};
CollectionTests* collection_tests_construct (GType object_type, const gchar* name);
GeeTestCase* gee_test_case_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void collection_tests_test_type_correctness (CollectionTests* self);
static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self);
void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self);
static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self);
void collection_tests_test_mutable_iterator (CollectionTests* self);
static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_size_and_is_empty (CollectionTests* self);
static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_remove (CollectionTests* self);
static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self);
void collection_tests_test_clear (CollectionTests* self);
static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self);
void collection_tests_test_add_all (CollectionTests* self);
static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_contains_all (CollectionTests* self);
static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_remove_all (CollectionTests* self);
static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_retain_all (CollectionTests* self);
static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self);
void collection_tests_test_to_array (CollectionTests* self);
static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self);
void collection_tests_test_gobject_properties (CollectionTests* self);
static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
void collection_tests_test_fold (CollectionTests* self);
static void _collection_tests_test_fold_gee_test_case_test_method (gpointer self);
void collection_tests_test_foreach (CollectionTests* self);
static void _collection_tests_test_foreach_gee_test_case_test_method (gpointer self);
void collection_tests_test_map (CollectionTests* self);
static void _collection_tests_test_map_gee_test_case_test_method (gpointer self);
void collection_tests_test_scan (CollectionTests* self);
static void _collection_tests_test_scan_gee_test_case_test_method (gpointer self);
void collection_tests_test_filter (CollectionTests* self);
static void _collection_tests_test_filter_gee_test_case_test_method (gpointer self);
void collection_tests_test_chop (CollectionTests* self);
static void _collection_tests_test_chop_gee_test_case_test_method (gpointer self);
static gint __lambda0_ (CollectionTests* self, gchar* x, gint y);
static gpointer ___lambda0__gee_fold_func (gpointer g, gpointer a, gpointer self);
static gint __lambda1_ (CollectionTests* self, gchar* x, gint y);
static gpointer ___lambda1__gee_fold_func (gpointer g, gpointer a, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void __lambda2_ (Block1Data* _data1_, gchar* x);
static void ___lambda2__gee_forall_func (gpointer g, gpointer self);
static void __lambda3_ (Block1Data* _data1_, gchar* x);
static void ___lambda3__gee_forall_func (gpointer g, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gint __lambda4_ (Block2Data* _data2_, gchar* str);
static gpointer ___lambda4__gee_map_func (gpointer g, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gint __lambda5_ (Block3Data* _data3_, gchar* str, gint cur);
static gpointer ___lambda5__gee_fold_func (gpointer g, gpointer a, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean __lambda6_ (Block4Data* _data4_, const gchar* str);
static gboolean ___lambda6__gee_predicate (gconstpointer g, gpointer self);
static void collection_tests_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _collection_tests_test_type_correctness_gee_test_case_test_method (gpointer self) {
	collection_tests_test_type_correctness (self);
}


static void _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method (gpointer self) {
	collection_tests_test_iterator_returns_all_elements_once (self);
}


static void _collection_tests_test_mutable_iterator_gee_test_case_test_method (gpointer self) {
	collection_tests_test_mutable_iterator (self);
}


static void _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method (gpointer self) {
	collection_tests_test_contains_size_and_is_empty (self);
}


static void _collection_tests_test_add_remove_gee_test_case_test_method (gpointer self) {
	collection_tests_test_add_remove (self);
}


static void _collection_tests_test_clear_gee_test_case_test_method (gpointer self) {
	collection_tests_test_clear (self);
}


static void _collection_tests_test_add_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_add_all (self);
}


static void _collection_tests_test_contains_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_contains_all (self);
}


static void _collection_tests_test_remove_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_remove_all (self);
}


static void _collection_tests_test_retain_all_gee_test_case_test_method (gpointer self) {
	collection_tests_test_retain_all (self);
}


static void _collection_tests_test_to_array_gee_test_case_test_method (gpointer self) {
	collection_tests_test_to_array (self);
}


static void _collection_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	collection_tests_test_gobject_properties (self);
}


static void _collection_tests_test_fold_gee_test_case_test_method (gpointer self) {
	collection_tests_test_fold (self);
}


static void _collection_tests_test_foreach_gee_test_case_test_method (gpointer self) {
	collection_tests_test_foreach (self);
}


static void _collection_tests_test_map_gee_test_case_test_method (gpointer self) {
	collection_tests_test_map (self);
}


static void _collection_tests_test_scan_gee_test_case_test_method (gpointer self) {
	collection_tests_test_scan (self);
}


static void _collection_tests_test_filter_gee_test_case_test_method (gpointer self) {
	collection_tests_test_filter (self);
}


static void _collection_tests_test_chop_gee_test_case_test_method (gpointer self) {
	collection_tests_test_chop (self);
}


CollectionTests* collection_tests_construct (GType object_type, const gchar* name) {
	CollectionTests * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	self = (CollectionTests*) gee_test_case_construct (object_type, _tmp0_);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] type correctness", _collection_tests_test_type_correctness_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] iterator returns all elements once", _collection_tests_test_iterator_returns_all_elements_once_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] mutable iterator", _collection_tests_test_mutable_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains, size and is_empty", _collection_tests_test_contains_size_and_is_empty_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add and remove", _collection_tests_test_add_remove_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] clear", _collection_tests_test_clear_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add_all", _collection_tests_test_add_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains_all", _collection_tests_test_contains_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] remove_all", _collection_tests_test_remove_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] retain_all", _collection_tests_test_retain_all_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] to_array", _collection_tests_test_to_array_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] GObject properties", _collection_tests_test_gobject_properties_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] fold", _collection_tests_test_fold_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] foreach", _collection_tests_test_foreach_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] map", _collection_tests_test_map_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] scan", _collection_tests_test_scan_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] filter", _collection_tests_test_filter_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] chop", _collection_tests_test_chop_gee_test_case_test_method, self);
	return self;
}


void collection_tests_test_type_correctness (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GType _tmp2_;
	GType _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_iterable_get_element_type ((GeeIterable*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_assert (_tmp3_ == G_TYPE_STRING);
}


void collection_tests_test_iterator_returns_all_elements_once (CollectionTests* self) {
	GeeCollection* _tmp0_;
	gboolean has_next = FALSE;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iterator;
	GeeIterator* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeIterator* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GeeCollection* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeCollection* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean one_found;
	gboolean two_found;
	gboolean three_found;
	gboolean one_found_once;
	gboolean two_found_once;
	gboolean three_found_once;
	GeeCollection* _tmp13_;
	GeeIterator* _tmp14_ = NULL;
	GeeIterator* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean valid;
	gboolean _tmp18_;
	GeeIterator* _tmp44_;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_;
	GeeIterator* _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	GeeIterator* _tmp51_;
	gboolean _tmp52_ = FALSE;
	GeeIterator* _tmp53_;
	gboolean _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	gboolean _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	gboolean _tmp61_;
	GeeCollection* _tmp62_;
	GeeIterator* _tmp63_ = NULL;
	GeeIterator* _tmp64_;
	gboolean _tmp65_ = FALSE;
	GeeIterator* _tmp66_;
	gboolean _tmp67_;
	gboolean _tmp68_;
	GeeIterator* _tmp69_;
	gboolean _tmp70_ = FALSE;
	GeeIterator* _tmp85_;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp87_;
	gboolean _tmp88_;
	GeeIterator* _tmp89_;
	gboolean _tmp90_ = FALSE;
	gboolean _tmp91_;
	gboolean _tmp92_;
	gboolean _tmp93_;
	gboolean _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp96_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	iterator = _tmp2_;
	_tmp3_ = iterator;
	_tmp4_ = gee_iterator_has_next (_tmp3_);
	g_assert (!_tmp4_);
	_tmp5_ = iterator;
	_tmp6_ = gee_iterator_next (_tmp5_);
	g_assert (!_tmp6_);
	_tmp7_ = self->test_collection;
	_tmp8_ = gee_collection_add (_tmp7_, "one");
	g_assert (_tmp8_);
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_collection_add (_tmp9_, "two");
	g_assert (_tmp10_);
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_add (_tmp11_, "three");
	g_assert (_tmp12_);
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
	_g_object_unref0 (iterator);
	iterator = _tmp14_;
	_tmp15_ = iterator;
	_tmp16_ = gee_iterator_get_valid (_tmp15_);
	_tmp17_ = _tmp16_;
	valid = _tmp17_;
	_tmp18_ = valid;
	g_assert (!_tmp18_);
	while (TRUE) {
		GeeIterator* _tmp19_;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_;
		GeeIterator* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		gboolean _tmp25_;
		GeeIterator* _tmp26_;
		gboolean _tmp27_ = FALSE;
		GeeIterator* _tmp28_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp32_;
		GeeIterator* _tmp33_;
		gpointer _tmp34_ = NULL;
		gchar* element;
		GeeIterator* _tmp35_;
		gboolean _tmp36_;
		gboolean _tmp37_;
		const gchar* _tmp38_;
		_tmp19_ = iterator;
		_tmp20_ = gee_iterator_has_next (_tmp19_);
		has_next = _tmp20_;
		_tmp21_ = valid;
		_tmp22_ = iterator;
		_tmp23_ = gee_iterator_get_valid (_tmp22_);
		_tmp24_ = _tmp23_;
		g_assert (_tmp21_ == _tmp24_);
		_tmp25_ = has_next;
		_tmp26_ = iterator;
		_tmp27_ = gee_iterator_next (_tmp26_);
		g_assert (_tmp25_ == _tmp27_);
		_tmp28_ = iterator;
		_tmp29_ = gee_iterator_get_valid (_tmp28_);
		_tmp30_ = _tmp29_;
		valid = _tmp30_;
		_tmp31_ = valid;
		g_assert (_tmp31_);
		_tmp32_ = has_next;
		if (!_tmp32_) {
			break;
		}
		_tmp33_ = iterator;
		_tmp34_ = gee_iterator_get (_tmp33_);
		element = (gchar*) _tmp34_;
		_tmp35_ = iterator;
		_tmp36_ = gee_iterator_get_valid (_tmp35_);
		_tmp37_ = _tmp36_;
		g_assert (_tmp37_);
		_tmp38_ = element;
		if (g_strcmp0 (_tmp38_, "one") == 0) {
			gboolean _tmp39_;
			_tmp39_ = one_found;
			if (_tmp39_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp40_;
			_tmp40_ = element;
			if (g_strcmp0 (_tmp40_, "two") == 0) {
				gboolean _tmp41_;
				_tmp41_ = two_found;
				if (_tmp41_) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
			} else {
				const gchar* _tmp42_;
				_tmp42_ = element;
				if (g_strcmp0 (_tmp42_, "three") == 0) {
					gboolean _tmp43_;
					_tmp43_ = three_found;
					if (_tmp43_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_g_free0 (element);
	}
	_tmp44_ = iterator;
	_tmp45_ = gee_iterator_has_next (_tmp44_);
	has_next = _tmp45_;
	_tmp46_ = has_next;
	g_assert (!_tmp46_);
	_tmp47_ = iterator;
	_tmp48_ = gee_iterator_get_valid (_tmp47_);
	_tmp49_ = _tmp48_;
	g_assert (_tmp49_);
	_tmp50_ = has_next;
	_tmp51_ = iterator;
	_tmp52_ = gee_iterator_next (_tmp51_);
	g_assert (_tmp50_ == _tmp52_);
	_tmp53_ = iterator;
	_tmp54_ = gee_iterator_get_valid (_tmp53_);
	_tmp55_ = _tmp54_;
	g_assert (_tmp55_);
	_tmp56_ = one_found;
	g_assert (_tmp56_);
	_tmp57_ = one_found_once;
	g_assert (_tmp57_);
	_tmp58_ = two_found;
	g_assert (_tmp58_);
	_tmp59_ = two_found_once;
	g_assert (_tmp59_);
	_tmp60_ = three_found;
	g_assert (_tmp60_);
	_tmp61_ = three_found_once;
	g_assert (_tmp61_);
	_tmp62_ = self->test_collection;
	_tmp63_ = gee_iterable_iterator ((GeeIterable*) _tmp62_);
	_g_object_unref0 (iterator);
	iterator = _tmp63_;
	_tmp64_ = iterator;
	_tmp65_ = gee_iterator_has_next (_tmp64_);
	g_assert (_tmp65_);
	_tmp66_ = iterator;
	_tmp67_ = gee_iterator_get_valid (_tmp66_);
	_tmp68_ = _tmp67_;
	g_assert (!_tmp68_);
	_tmp69_ = iterator;
	_tmp70_ = gee_iterator_next (_tmp69_);
	g_assert (_tmp70_);
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	while (TRUE) {
		GeeIterator* _tmp71_;
		gpointer _tmp72_ = NULL;
		gchar* element;
		const gchar* _tmp73_;
		GeeIterator* _tmp79_;
		gboolean _tmp80_ = FALSE;
		gboolean _tmp81_;
		GeeIterator* _tmp82_;
		gboolean _tmp83_ = FALSE;
		gboolean _tmp84_;
		_tmp71_ = iterator;
		_tmp72_ = gee_iterator_get (_tmp71_);
		element = (gchar*) _tmp72_;
		_tmp73_ = element;
		if (g_strcmp0 (_tmp73_, "one") == 0) {
			gboolean _tmp74_;
			_tmp74_ = one_found;
			if (_tmp74_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp75_;
			_tmp75_ = element;
			if (g_strcmp0 (_tmp75_, "two") == 0) {
				gboolean _tmp76_;
				_tmp76_ = two_found;
				if (_tmp76_) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
			} else {
				const gchar* _tmp77_;
				_tmp77_ = element;
				if (g_strcmp0 (_tmp77_, "three") == 0) {
					gboolean _tmp78_;
					_tmp78_ = three_found;
					if (_tmp78_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_tmp79_ = iterator;
		_tmp80_ = gee_iterator_has_next (_tmp79_);
		has_next = _tmp80_;
		_tmp81_ = has_next;
		_tmp82_ = iterator;
		_tmp83_ = gee_iterator_next (_tmp82_);
		g_assert (_tmp81_ == _tmp83_);
		_tmp84_ = has_next;
		if (!_tmp84_) {
			_g_free0 (element);
			break;
		}
		_g_free0 (element);
	}
	_tmp85_ = iterator;
	_tmp86_ = gee_iterator_has_next (_tmp85_);
	has_next = _tmp86_;
	_tmp87_ = has_next;
	g_assert (!_tmp87_);
	_tmp88_ = has_next;
	_tmp89_ = iterator;
	_tmp90_ = gee_iterator_next (_tmp89_);
	g_assert (_tmp88_ == _tmp90_);
	_tmp91_ = one_found;
	g_assert (_tmp91_);
	_tmp92_ = one_found_once;
	g_assert (_tmp92_);
	_tmp93_ = two_found;
	g_assert (_tmp93_);
	_tmp94_ = two_found_once;
	g_assert (_tmp94_);
	_tmp95_ = three_found;
	g_assert (_tmp95_);
	_tmp96_ = three_found_once;
	g_assert (_tmp96_);
	_g_object_unref0 (iterator);
}


void collection_tests_test_mutable_iterator (CollectionTests* self) {
	GeeCollection* _tmp0_;
	gboolean has_next = FALSE;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iterator;
	GeeCollection* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeCollection* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean one_found;
	gboolean two_found;
	gboolean three_found;
	gboolean one_found_once;
	gboolean two_found_once;
	gboolean three_found_once;
	GeeCollection* _tmp9_;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* _tmp35_;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_;
	gboolean _tmp38_;
	GeeIterator* _tmp39_;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	GeeCollection* _tmp47_;
	GeeIterator* _tmp48_ = NULL;
	GeeIterator* _tmp49_;
	gboolean _tmp50_ = FALSE;
	GeeIterator* _tmp51_;
	gboolean _tmp52_ = FALSE;
	GeeIterator* _tmp66_;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_;
	gboolean _tmp69_;
	GeeIterator* _tmp70_;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_;
	gboolean _tmp73_;
	gboolean _tmp74_;
	gboolean _tmp75_;
	gboolean _tmp76_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	iterator = _tmp2_;
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_collection_add (_tmp3_, "one");
	g_assert (_tmp4_);
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_collection_add (_tmp5_, "two");
	g_assert (_tmp6_);
	_tmp7_ = self->test_collection;
	_tmp8_ = gee_collection_add (_tmp7_, "three");
	g_assert (_tmp8_);
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
	_g_object_unref0 (iterator);
	iterator = _tmp10_;
	while (TRUE) {
		GeeIterator* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		GeeIterator* _tmp14_;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
		GeeIterator* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		GeeIterator* _tmp20_;
		gpointer _tmp21_ = NULL;
		gchar* element;
		const gchar* _tmp22_;
		_tmp11_ = iterator;
		_tmp12_ = gee_iterator_has_next (_tmp11_);
		has_next = _tmp12_;
		_tmp13_ = has_next;
		_tmp14_ = iterator;
		_tmp15_ = gee_iterator_next (_tmp14_);
		g_assert (_tmp13_ == _tmp15_);
		_tmp16_ = has_next;
		if (!_tmp16_) {
			break;
		}
		_tmp17_ = iterator;
		_tmp18_ = gee_iterator_get_valid (_tmp17_);
		_tmp19_ = _tmp18_;
		g_assert (_tmp19_);
		_tmp20_ = iterator;
		_tmp21_ = gee_iterator_get (_tmp20_);
		element = (gchar*) _tmp21_;
		_tmp22_ = element;
		if (g_strcmp0 (_tmp22_, "one") == 0) {
			gboolean _tmp23_;
			_tmp23_ = one_found;
			if (_tmp23_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp24_;
			_tmp24_ = element;
			if (g_strcmp0 (_tmp24_, "two") == 0) {
				gboolean _tmp25_;
				GeeIterator* _tmp26_;
				gboolean _tmp27_;
				gboolean _tmp28_;
				GeeIterator* _tmp29_;
				GeeIterator* _tmp30_;
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp25_ = two_found;
				if (_tmp25_) {
					two_found_once = FALSE;
				}
				two_found = TRUE;
				_tmp26_ = iterator;
				_tmp27_ = gee_iterator_get_read_only (_tmp26_);
				_tmp28_ = _tmp27_;
				g_assert (!_tmp28_);
				_tmp29_ = iterator;
				gee_iterator_remove (_tmp29_);
				_tmp30_ = iterator;
				_tmp31_ = gee_iterator_get_valid (_tmp30_);
				_tmp32_ = _tmp31_;
				g_assert (!_tmp32_);
			} else {
				const gchar* _tmp33_;
				_tmp33_ = element;
				if (g_strcmp0 (_tmp33_, "three") == 0) {
					gboolean _tmp34_;
					_tmp34_ = three_found;
					if (_tmp34_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_g_free0 (element);
	}
	_tmp35_ = iterator;
	_tmp36_ = gee_iterator_has_next (_tmp35_);
	has_next = _tmp36_;
	_tmp37_ = has_next;
	g_assert (!_tmp37_);
	_tmp38_ = has_next;
	_tmp39_ = iterator;
	_tmp40_ = gee_iterator_next (_tmp39_);
	g_assert (_tmp38_ == _tmp40_);
	_tmp41_ = one_found;
	g_assert (_tmp41_);
	_tmp42_ = one_found_once;
	g_assert (_tmp42_);
	_tmp43_ = two_found;
	g_assert (_tmp43_);
	_tmp44_ = two_found_once;
	g_assert (_tmp44_);
	_tmp45_ = three_found;
	g_assert (_tmp45_);
	_tmp46_ = three_found_once;
	g_assert (_tmp46_);
	_tmp47_ = self->test_collection;
	_tmp48_ = gee_iterable_iterator ((GeeIterable*) _tmp47_);
	_g_object_unref0 (iterator);
	iterator = _tmp48_;
	_tmp49_ = iterator;
	_tmp50_ = gee_iterator_has_next (_tmp49_);
	g_assert (_tmp50_);
	_tmp51_ = iterator;
	_tmp52_ = gee_iterator_next (_tmp51_);
	g_assert (_tmp52_);
	one_found = FALSE;
	two_found = FALSE;
	three_found = FALSE;
	one_found_once = TRUE;
	two_found_once = TRUE;
	three_found_once = TRUE;
	while (TRUE) {
		GeeIterator* _tmp53_;
		gpointer _tmp54_ = NULL;
		gchar* element;
		const gchar* _tmp55_;
		GeeIterator* _tmp60_;
		gboolean _tmp61_ = FALSE;
		gboolean _tmp62_;
		GeeIterator* _tmp63_;
		gboolean _tmp64_ = FALSE;
		gboolean _tmp65_;
		_tmp53_ = iterator;
		_tmp54_ = gee_iterator_get (_tmp53_);
		element = (gchar*) _tmp54_;
		_tmp55_ = element;
		if (g_strcmp0 (_tmp55_, "one") == 0) {
			gboolean _tmp56_;
			_tmp56_ = one_found;
			if (_tmp56_) {
				one_found_once = FALSE;
			}
			one_found = TRUE;
		} else {
			const gchar* _tmp57_;
			_tmp57_ = element;
			if (g_strcmp0 (_tmp57_, "two") == 0) {
				two_found = TRUE;
			} else {
				const gchar* _tmp58_;
				_tmp58_ = element;
				if (g_strcmp0 (_tmp58_, "three") == 0) {
					gboolean _tmp59_;
					_tmp59_ = three_found;
					if (_tmp59_) {
						three_found_once = FALSE;
					}
					three_found = TRUE;
				}
			}
		}
		_tmp60_ = iterator;
		_tmp61_ = gee_iterator_has_next (_tmp60_);
		has_next = _tmp61_;
		_tmp62_ = has_next;
		_tmp63_ = iterator;
		_tmp64_ = gee_iterator_next (_tmp63_);
		g_assert (_tmp62_ == _tmp64_);
		_tmp65_ = has_next;
		if (!_tmp65_) {
			_g_free0 (element);
			break;
		}
		_g_free0 (element);
	}
	_tmp66_ = iterator;
	_tmp67_ = gee_iterator_has_next (_tmp66_);
	has_next = _tmp67_;
	_tmp68_ = has_next;
	g_assert (!_tmp68_);
	_tmp69_ = has_next;
	_tmp70_ = iterator;
	_tmp71_ = gee_iterator_next (_tmp70_);
	g_assert (_tmp69_ == _tmp71_);
	_tmp72_ = one_found;
	g_assert (_tmp72_);
	_tmp73_ = one_found_once;
	g_assert (_tmp73_);
	_tmp74_ = two_found;
	g_assert (!_tmp74_);
	_tmp75_ = three_found;
	g_assert (_tmp75_);
	_tmp76_ = three_found_once;
	g_assert (_tmp76_);
	_g_object_unref0 (iterator);
}


void collection_tests_test_contains_size_and_is_empty (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeCollection* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeCollection* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeCollection* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GeeCollection* _tmp13_;
	gboolean _tmp14_ = FALSE;
	GeeCollection* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GeeCollection* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GeeCollection* _tmp19_;
	gboolean _tmp20_ = FALSE;
	GeeCollection* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GeeCollection* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	GeeCollection* _tmp27_;
	gboolean _tmp28_ = FALSE;
	GeeCollection* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GeeCollection* _tmp31_;
	gboolean _tmp32_ = FALSE;
	GeeCollection* _tmp33_;
	gboolean _tmp34_ = FALSE;
	GeeCollection* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	GeeCollection* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	GeeCollection* _tmp41_;
	gboolean _tmp42_ = FALSE;
	GeeCollection* _tmp43_;
	gboolean _tmp44_ = FALSE;
	GeeCollection* _tmp45_;
	gboolean _tmp46_ = FALSE;
	GeeCollection* _tmp47_;
	gboolean _tmp48_ = FALSE;
	GeeCollection* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GeeCollection* _tmp52_;
	gboolean _tmp53_;
	gboolean _tmp54_;
	GeeCollection* _tmp55_;
	gboolean _tmp56_ = FALSE;
	GeeCollection* _tmp57_;
	gboolean _tmp58_ = FALSE;
	GeeCollection* _tmp59_;
	gboolean _tmp60_ = FALSE;
	GeeCollection* _tmp61_;
	gboolean _tmp62_ = FALSE;
	GeeCollection* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	GeeCollection* _tmp66_;
	gboolean _tmp67_;
	gboolean _tmp68_;
	GeeCollection* _tmp69_;
	gboolean _tmp70_ = FALSE;
	GeeCollection* _tmp71_;
	gboolean _tmp72_ = FALSE;
	GeeCollection* _tmp73_;
	gboolean _tmp74_ = FALSE;
	GeeCollection* _tmp75_;
	gboolean _tmp76_ = FALSE;
	GeeCollection* _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	GeeCollection* _tmp80_;
	gboolean _tmp81_;
	gboolean _tmp82_;
	GeeCollection* _tmp83_;
	gboolean _tmp84_ = FALSE;
	GeeCollection* _tmp85_;
	gboolean _tmp86_ = FALSE;
	GeeCollection* _tmp87_;
	gboolean _tmp88_ = FALSE;
	GeeCollection* _tmp89_;
	gboolean _tmp90_ = FALSE;
	GeeCollection* _tmp91_;
	gint _tmp92_;
	gint _tmp93_;
	GeeCollection* _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp96_;
	GeeCollection* _tmp97_;
	gboolean _tmp98_ = FALSE;
	GeeCollection* _tmp99_;
	gboolean _tmp100_ = FALSE;
	GeeCollection* _tmp101_;
	gboolean _tmp102_ = FALSE;
	GeeCollection* _tmp103_;
	gboolean _tmp104_ = FALSE;
	GeeCollection* _tmp105_;
	gint _tmp106_;
	gint _tmp107_;
	GeeCollection* _tmp108_;
	gboolean _tmp109_;
	gboolean _tmp110_;
	GeeCollection* _tmp111_;
	GeeCollection* _tmp112_;
	gboolean _tmp113_ = FALSE;
	GeeCollection* _tmp114_;
	gboolean _tmp115_ = FALSE;
	GeeCollection* _tmp116_;
	gboolean _tmp117_ = FALSE;
	GeeCollection* _tmp118_;
	gint _tmp119_;
	gint _tmp120_;
	GeeCollection* _tmp121_;
	gboolean _tmp122_;
	gboolean _tmp123_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_collection_contains (_tmp1_, "one");
	g_assert (!_tmp2_);
	_tmp3_ = self->test_collection;
	_tmp4_ = gee_collection_contains (_tmp3_, "two");
	g_assert (!_tmp4_);
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_collection_contains (_tmp5_, "three");
	g_assert (!_tmp6_);
	_tmp7_ = self->test_collection;
	_tmp8_ = gee_collection_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	g_assert (_tmp9_ == 0);
	_tmp10_ = self->test_collection;
	_tmp11_ = gee_collection_get_is_empty (_tmp10_);
	_tmp12_ = _tmp11_;
	g_assert (_tmp12_);
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_collection_add (_tmp13_, "one");
	g_assert (_tmp14_);
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_collection_contains (_tmp15_, "one");
	g_assert (_tmp16_);
	_tmp17_ = self->test_collection;
	_tmp18_ = gee_collection_contains (_tmp17_, "two");
	g_assert (!_tmp18_);
	_tmp19_ = self->test_collection;
	_tmp20_ = gee_collection_contains (_tmp19_, "three");
	g_assert (!_tmp20_);
	_tmp21_ = self->test_collection;
	_tmp22_ = gee_collection_get_size (_tmp21_);
	_tmp23_ = _tmp22_;
	g_assert (_tmp23_ == 1);
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_get_is_empty (_tmp24_);
	_tmp26_ = _tmp25_;
	g_assert (!_tmp26_);
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_remove (_tmp27_, "one");
	g_assert (_tmp28_);
	_tmp29_ = self->test_collection;
	_tmp30_ = gee_collection_contains (_tmp29_, "one");
	g_assert (!_tmp30_);
	_tmp31_ = self->test_collection;
	_tmp32_ = gee_collection_contains (_tmp31_, "two");
	g_assert (!_tmp32_);
	_tmp33_ = self->test_collection;
	_tmp34_ = gee_collection_contains (_tmp33_, "three");
	g_assert (!_tmp34_);
	_tmp35_ = self->test_collection;
	_tmp36_ = gee_collection_get_size (_tmp35_);
	_tmp37_ = _tmp36_;
	g_assert (_tmp37_ == 0);
	_tmp38_ = self->test_collection;
	_tmp39_ = gee_collection_get_is_empty (_tmp38_);
	_tmp40_ = _tmp39_;
	g_assert (_tmp40_);
	_tmp41_ = self->test_collection;
	_tmp42_ = gee_collection_add (_tmp41_, "one");
	g_assert (_tmp42_);
	_tmp43_ = self->test_collection;
	_tmp44_ = gee_collection_contains (_tmp43_, "one");
	g_assert (_tmp44_);
	_tmp45_ = self->test_collection;
	_tmp46_ = gee_collection_contains (_tmp45_, "two");
	g_assert (!_tmp46_);
	_tmp47_ = self->test_collection;
	_tmp48_ = gee_collection_contains (_tmp47_, "three");
	g_assert (!_tmp48_);
	_tmp49_ = self->test_collection;
	_tmp50_ = gee_collection_get_size (_tmp49_);
	_tmp51_ = _tmp50_;
	g_assert (_tmp51_ == 1);
	_tmp52_ = self->test_collection;
	_tmp53_ = gee_collection_get_is_empty (_tmp52_);
	_tmp54_ = _tmp53_;
	g_assert (!_tmp54_);
	_tmp55_ = self->test_collection;
	_tmp56_ = gee_collection_add (_tmp55_, "two");
	g_assert (_tmp56_);
	_tmp57_ = self->test_collection;
	_tmp58_ = gee_collection_contains (_tmp57_, "one");
	g_assert (_tmp58_);
	_tmp59_ = self->test_collection;
	_tmp60_ = gee_collection_contains (_tmp59_, "two");
	g_assert (_tmp60_);
	_tmp61_ = self->test_collection;
	_tmp62_ = gee_collection_contains (_tmp61_, "three");
	g_assert (!_tmp62_);
	_tmp63_ = self->test_collection;
	_tmp64_ = gee_collection_get_size (_tmp63_);
	_tmp65_ = _tmp64_;
	g_assert (_tmp65_ == 2);
	_tmp66_ = self->test_collection;
	_tmp67_ = gee_collection_get_is_empty (_tmp66_);
	_tmp68_ = _tmp67_;
	g_assert (!_tmp68_);
	_tmp69_ = self->test_collection;
	_tmp70_ = gee_collection_add (_tmp69_, "three");
	g_assert (_tmp70_);
	_tmp71_ = self->test_collection;
	_tmp72_ = gee_collection_contains (_tmp71_, "one");
	g_assert (_tmp72_);
	_tmp73_ = self->test_collection;
	_tmp74_ = gee_collection_contains (_tmp73_, "two");
	g_assert (_tmp74_);
	_tmp75_ = self->test_collection;
	_tmp76_ = gee_collection_contains (_tmp75_, "three");
	g_assert (_tmp76_);
	_tmp77_ = self->test_collection;
	_tmp78_ = gee_collection_get_size (_tmp77_);
	_tmp79_ = _tmp78_;
	g_assert (_tmp79_ == 3);
	_tmp80_ = self->test_collection;
	_tmp81_ = gee_collection_get_is_empty (_tmp80_);
	_tmp82_ = _tmp81_;
	g_assert (!_tmp82_);
	_tmp83_ = self->test_collection;
	_tmp84_ = gee_collection_remove (_tmp83_, "two");
	g_assert (_tmp84_);
	_tmp85_ = self->test_collection;
	_tmp86_ = gee_collection_contains (_tmp85_, "one");
	g_assert (_tmp86_);
	_tmp87_ = self->test_collection;
	_tmp88_ = gee_collection_contains (_tmp87_, "two");
	g_assert (!_tmp88_);
	_tmp89_ = self->test_collection;
	_tmp90_ = gee_collection_contains (_tmp89_, "three");
	g_assert (_tmp90_);
	_tmp91_ = self->test_collection;
	_tmp92_ = gee_collection_get_size (_tmp91_);
	_tmp93_ = _tmp92_;
	g_assert (_tmp93_ == 2);
	_tmp94_ = self->test_collection;
	_tmp95_ = gee_collection_get_is_empty (_tmp94_);
	_tmp96_ = _tmp95_;
	g_assert (!_tmp96_);
	_tmp97_ = self->test_collection;
	_tmp98_ = gee_collection_remove (_tmp97_, "two");
	g_assert (!_tmp98_);
	_tmp99_ = self->test_collection;
	_tmp100_ = gee_collection_contains (_tmp99_, "one");
	g_assert (_tmp100_);
	_tmp101_ = self->test_collection;
	_tmp102_ = gee_collection_contains (_tmp101_, "two");
	g_assert (!_tmp102_);
	_tmp103_ = self->test_collection;
	_tmp104_ = gee_collection_contains (_tmp103_, "three");
	g_assert (_tmp104_);
	_tmp105_ = self->test_collection;
	_tmp106_ = gee_collection_get_size (_tmp105_);
	_tmp107_ = _tmp106_;
	g_assert (_tmp107_ == 2);
	_tmp108_ = self->test_collection;
	_tmp109_ = gee_collection_get_is_empty (_tmp108_);
	_tmp110_ = _tmp109_;
	g_assert (!_tmp110_);
	_tmp111_ = self->test_collection;
	gee_collection_clear (_tmp111_);
	_tmp112_ = self->test_collection;
	_tmp113_ = gee_collection_contains (_tmp112_, "one");
	g_assert (!_tmp113_);
	_tmp114_ = self->test_collection;
	_tmp115_ = gee_collection_contains (_tmp114_, "two");
	g_assert (!_tmp115_);
	_tmp116_ = self->test_collection;
	_tmp117_ = gee_collection_contains (_tmp116_, "three");
	g_assert (!_tmp117_);
	_tmp118_ = self->test_collection;
	_tmp119_ = gee_collection_get_size (_tmp118_);
	_tmp120_ = _tmp119_;
	g_assert (_tmp120_ == 0);
	_tmp121_ = self->test_collection;
	_tmp122_ = gee_collection_get_is_empty (_tmp121_);
	_tmp123_ = _tmp122_;
	g_assert (_tmp123_);
}


void collection_tests_test_add_remove (CollectionTests* self) {
	GeeCollection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar** _tmp40_ = NULL;
	gchar** to_add;
	gint to_add_length1;
	gint _to_add_size_;
	gint expected_size;
	gchar** _tmp41_;
	gint _tmp41__length1;
	GeeCollection* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gchar** _tmp59_;
	gint _tmp59__length1;
	gchar** _tmp60_;
	gint _tmp60__length1;
	gchar** _tmp65_;
	gint _tmp65__length1;
	GeeCollection* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = g_strdup ("one");
	_tmp2_ = g_strdup ("two");
	_tmp3_ = g_strdup ("three");
	_tmp4_ = g_strdup ("four");
	_tmp5_ = g_strdup ("five");
	_tmp6_ = g_strdup ("six");
	_tmp7_ = g_strdup ("seven");
	_tmp8_ = g_strdup ("eight");
	_tmp9_ = g_strdup ("nine");
	_tmp10_ = g_strdup ("ten");
	_tmp11_ = g_strdup ("eleven");
	_tmp12_ = g_strdup ("twelve");
	_tmp13_ = g_strdup ("thirteen");
	_tmp14_ = g_strdup ("fourteen");
	_tmp15_ = g_strdup ("fifteen");
	_tmp16_ = g_strdup ("sixteen");
	_tmp17_ = g_strdup ("seventeen");
	_tmp18_ = g_strdup ("eighteen");
	_tmp19_ = g_strdup ("nineteen");
	_tmp20_ = g_strdup ("twenty");
	_tmp21_ = g_strdup ("twenty one");
	_tmp22_ = g_strdup ("twenty two");
	_tmp23_ = g_strdup ("twenty three");
	_tmp24_ = g_strdup ("twenty four");
	_tmp25_ = g_strdup ("twenty five");
	_tmp26_ = g_strdup ("twenty six");
	_tmp27_ = g_strdup ("twenty seven");
	_tmp28_ = g_strdup ("twenty eight");
	_tmp29_ = g_strdup ("twenty nine");
	_tmp30_ = g_strdup ("thirty");
	_tmp31_ = g_strdup ("thirty one");
	_tmp32_ = g_strdup ("thirty two");
	_tmp33_ = g_strdup ("thirty four");
	_tmp34_ = g_strdup ("thirty five");
	_tmp35_ = g_strdup ("thirty six");
	_tmp36_ = g_strdup ("thirty seven");
	_tmp37_ = g_strdup ("thirty eight");
	_tmp38_ = g_strdup ("thirty nine");
	_tmp39_ = g_strdup ("fourty");
	_tmp40_ = g_new0 (gchar*, 39 + 1);
	_tmp40_[0] = _tmp1_;
	_tmp40_[1] = _tmp2_;
	_tmp40_[2] = _tmp3_;
	_tmp40_[3] = _tmp4_;
	_tmp40_[4] = _tmp5_;
	_tmp40_[5] = _tmp6_;
	_tmp40_[6] = _tmp7_;
	_tmp40_[7] = _tmp8_;
	_tmp40_[8] = _tmp9_;
	_tmp40_[9] = _tmp10_;
	_tmp40_[10] = _tmp11_;
	_tmp40_[11] = _tmp12_;
	_tmp40_[12] = _tmp13_;
	_tmp40_[13] = _tmp14_;
	_tmp40_[14] = _tmp15_;
	_tmp40_[15] = _tmp16_;
	_tmp40_[16] = _tmp17_;
	_tmp40_[17] = _tmp18_;
	_tmp40_[18] = _tmp19_;
	_tmp40_[19] = _tmp20_;
	_tmp40_[20] = _tmp21_;
	_tmp40_[21] = _tmp22_;
	_tmp40_[22] = _tmp23_;
	_tmp40_[23] = _tmp24_;
	_tmp40_[24] = _tmp25_;
	_tmp40_[25] = _tmp26_;
	_tmp40_[26] = _tmp27_;
	_tmp40_[27] = _tmp28_;
	_tmp40_[28] = _tmp29_;
	_tmp40_[29] = _tmp30_;
	_tmp40_[30] = _tmp31_;
	_tmp40_[31] = _tmp32_;
	_tmp40_[32] = _tmp33_;
	_tmp40_[33] = _tmp34_;
	_tmp40_[34] = _tmp35_;
	_tmp40_[35] = _tmp36_;
	_tmp40_[36] = _tmp37_;
	_tmp40_[37] = _tmp38_;
	_tmp40_[38] = _tmp39_;
	to_add = _tmp40_;
	to_add_length1 = 39;
	_to_add_size_ = to_add_length1;
	expected_size = 0;
	_tmp41_ = to_add;
	_tmp41__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp41_;
		a_collection_length1 = _tmp41__length1;
		for (a_it = 0; a_it < _tmp41__length1; a_it = a_it + 1) {
			gchar* _tmp42_;
			gchar* a = NULL;
			_tmp42_ = g_strdup (a_collection[a_it]);
			a = _tmp42_;
			{
				GeeCollection* _tmp43_;
				const gchar* _tmp44_;
				gboolean _tmp45_ = FALSE;
				GeeCollection* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				GeeCollection* _tmp50_;
				const gchar* _tmp51_;
				gboolean _tmp52_ = FALSE;
				GeeCollection* _tmp53_;
				const gchar* _tmp54_;
				gboolean _tmp55_ = FALSE;
				_tmp43_ = self->test_collection;
				_tmp44_ = a;
				_tmp45_ = gee_collection_contains (_tmp43_, _tmp44_);
				g_assert (!_tmp45_);
				_tmp46_ = self->test_collection;
				_tmp47_ = gee_collection_get_size (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = expected_size;
				expected_size = _tmp49_ + 1;
				g_assert (_tmp48_ == _tmp49_);
				_tmp50_ = self->test_collection;
				_tmp51_ = a;
				_tmp52_ = gee_collection_add (_tmp50_, _tmp51_);
				g_assert (_tmp52_);
				_tmp53_ = self->test_collection;
				_tmp54_ = a;
				_tmp55_ = gee_collection_contains (_tmp53_, _tmp54_);
				g_assert (_tmp55_);
				_g_free0 (a);
			}
		}
	}
	_tmp56_ = self->test_collection;
	_tmp57_ = gee_collection_get_size (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = to_add;
	_tmp59__length1 = to_add_length1;
	g_assert (_tmp58_ == _tmp59__length1);
	_tmp60_ = to_add;
	_tmp60__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp60_;
		a_collection_length1 = _tmp60__length1;
		for (a_it = 0; a_it < _tmp60__length1; a_it = a_it + 1) {
			gchar* _tmp61_;
			gchar* a = NULL;
			_tmp61_ = g_strdup (a_collection[a_it]);
			a = _tmp61_;
			{
				GeeCollection* _tmp62_;
				const gchar* _tmp63_;
				gboolean _tmp64_ = FALSE;
				_tmp62_ = self->test_collection;
				_tmp63_ = a;
				_tmp64_ = gee_collection_contains (_tmp62_, _tmp63_);
				g_assert (_tmp64_);
				_g_free0 (a);
			}
		}
	}
	_tmp65_ = to_add;
	_tmp65__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp65_;
		a_collection_length1 = _tmp65__length1;
		for (a_it = 0; a_it < _tmp65__length1; a_it = a_it + 1) {
			gchar* _tmp66_;
			gchar* a = NULL;
			_tmp66_ = g_strdup (a_collection[a_it]);
			a = _tmp66_;
			{
				GeeCollection* _tmp67_;
				const gchar* _tmp68_;
				gboolean _tmp69_ = FALSE;
				GeeCollection* _tmp70_;
				gint _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
				GeeCollection* _tmp74_;
				const gchar* _tmp75_;
				gboolean _tmp76_ = FALSE;
				GeeCollection* _tmp77_;
				const gchar* _tmp78_;
				gboolean _tmp79_ = FALSE;
				_tmp67_ = self->test_collection;
				_tmp68_ = a;
				_tmp69_ = gee_collection_contains (_tmp67_, _tmp68_);
				g_assert (_tmp69_);
				_tmp70_ = self->test_collection;
				_tmp71_ = gee_collection_get_size (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = expected_size;
				expected_size = _tmp73_ - 1;
				g_assert (_tmp72_ == _tmp73_);
				_tmp74_ = self->test_collection;
				_tmp75_ = a;
				_tmp76_ = gee_collection_remove (_tmp74_, _tmp75_);
				g_assert (_tmp76_);
				_tmp77_ = self->test_collection;
				_tmp78_ = a;
				_tmp79_ = gee_collection_contains (_tmp77_, _tmp78_);
				g_assert (!_tmp79_);
				_g_free0 (a);
			}
		}
	}
	_tmp80_ = self->test_collection;
	_tmp81_ = gee_collection_get_size (_tmp80_);
	_tmp82_ = _tmp81_;
	g_assert (_tmp82_ == 0);
	to_add = (_vala_array_free (to_add, to_add_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_clear (CollectionTests* self) {
	GeeCollection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar** _tmp40_ = NULL;
	gchar** to_add;
	gint to_add_length1;
	gint _to_add_size_;
	gint expected_size;
	gchar** _tmp41_;
	gint _tmp41__length1;
	GeeCollection* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gchar** _tmp59_;
	gint _tmp59__length1;
	GeeCollection* _tmp60_;
	GeeCollection* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	GeeCollection* _tmp64_;
	GeeIterator* _tmp65_ = NULL;
	GeeIterator* iter;
	gboolean _tmp66_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = g_strdup ("one");
	_tmp2_ = g_strdup ("two");
	_tmp3_ = g_strdup ("three");
	_tmp4_ = g_strdup ("four");
	_tmp5_ = g_strdup ("five");
	_tmp6_ = g_strdup ("six");
	_tmp7_ = g_strdup ("seven");
	_tmp8_ = g_strdup ("eight");
	_tmp9_ = g_strdup ("nine");
	_tmp10_ = g_strdup ("ten");
	_tmp11_ = g_strdup ("eleven");
	_tmp12_ = g_strdup ("twelve");
	_tmp13_ = g_strdup ("thirteen");
	_tmp14_ = g_strdup ("fourteen");
	_tmp15_ = g_strdup ("fifteen");
	_tmp16_ = g_strdup ("sixteen");
	_tmp17_ = g_strdup ("seventeen");
	_tmp18_ = g_strdup ("eighteen");
	_tmp19_ = g_strdup ("nineteen");
	_tmp20_ = g_strdup ("twenty");
	_tmp21_ = g_strdup ("twenty one");
	_tmp22_ = g_strdup ("twenty two");
	_tmp23_ = g_strdup ("twenty three");
	_tmp24_ = g_strdup ("twenty four");
	_tmp25_ = g_strdup ("twenty five");
	_tmp26_ = g_strdup ("twenty six");
	_tmp27_ = g_strdup ("twenty seven");
	_tmp28_ = g_strdup ("twenty eight");
	_tmp29_ = g_strdup ("twenty nine");
	_tmp30_ = g_strdup ("thirty");
	_tmp31_ = g_strdup ("thirty one");
	_tmp32_ = g_strdup ("thirty two");
	_tmp33_ = g_strdup ("thirty four");
	_tmp34_ = g_strdup ("thirty five");
	_tmp35_ = g_strdup ("thirty six");
	_tmp36_ = g_strdup ("thirty seven");
	_tmp37_ = g_strdup ("thirty eight");
	_tmp38_ = g_strdup ("thirty nine");
	_tmp39_ = g_strdup ("fourty");
	_tmp40_ = g_new0 (gchar*, 39 + 1);
	_tmp40_[0] = _tmp1_;
	_tmp40_[1] = _tmp2_;
	_tmp40_[2] = _tmp3_;
	_tmp40_[3] = _tmp4_;
	_tmp40_[4] = _tmp5_;
	_tmp40_[5] = _tmp6_;
	_tmp40_[6] = _tmp7_;
	_tmp40_[7] = _tmp8_;
	_tmp40_[8] = _tmp9_;
	_tmp40_[9] = _tmp10_;
	_tmp40_[10] = _tmp11_;
	_tmp40_[11] = _tmp12_;
	_tmp40_[12] = _tmp13_;
	_tmp40_[13] = _tmp14_;
	_tmp40_[14] = _tmp15_;
	_tmp40_[15] = _tmp16_;
	_tmp40_[16] = _tmp17_;
	_tmp40_[17] = _tmp18_;
	_tmp40_[18] = _tmp19_;
	_tmp40_[19] = _tmp20_;
	_tmp40_[20] = _tmp21_;
	_tmp40_[21] = _tmp22_;
	_tmp40_[22] = _tmp23_;
	_tmp40_[23] = _tmp24_;
	_tmp40_[24] = _tmp25_;
	_tmp40_[25] = _tmp26_;
	_tmp40_[26] = _tmp27_;
	_tmp40_[27] = _tmp28_;
	_tmp40_[28] = _tmp29_;
	_tmp40_[29] = _tmp30_;
	_tmp40_[30] = _tmp31_;
	_tmp40_[31] = _tmp32_;
	_tmp40_[32] = _tmp33_;
	_tmp40_[33] = _tmp34_;
	_tmp40_[34] = _tmp35_;
	_tmp40_[35] = _tmp36_;
	_tmp40_[36] = _tmp37_;
	_tmp40_[37] = _tmp38_;
	_tmp40_[38] = _tmp39_;
	to_add = _tmp40_;
	to_add_length1 = 39;
	_to_add_size_ = to_add_length1;
	expected_size = 0;
	_tmp41_ = to_add;
	_tmp41__length1 = to_add_length1;
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp41_;
		a_collection_length1 = _tmp41__length1;
		for (a_it = 0; a_it < _tmp41__length1; a_it = a_it + 1) {
			gchar* _tmp42_;
			gchar* a = NULL;
			_tmp42_ = g_strdup (a_collection[a_it]);
			a = _tmp42_;
			{
				GeeCollection* _tmp43_;
				const gchar* _tmp44_;
				gboolean _tmp45_ = FALSE;
				GeeCollection* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				GeeCollection* _tmp50_;
				const gchar* _tmp51_;
				gboolean _tmp52_ = FALSE;
				GeeCollection* _tmp53_;
				const gchar* _tmp54_;
				gboolean _tmp55_ = FALSE;
				_tmp43_ = self->test_collection;
				_tmp44_ = a;
				_tmp45_ = gee_collection_contains (_tmp43_, _tmp44_);
				g_assert (!_tmp45_);
				_tmp46_ = self->test_collection;
				_tmp47_ = gee_collection_get_size (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = expected_size;
				expected_size = _tmp49_ + 1;
				g_assert (_tmp48_ == _tmp49_);
				_tmp50_ = self->test_collection;
				_tmp51_ = a;
				_tmp52_ = gee_collection_add (_tmp50_, _tmp51_);
				g_assert (_tmp52_);
				_tmp53_ = self->test_collection;
				_tmp54_ = a;
				_tmp55_ = gee_collection_contains (_tmp53_, _tmp54_);
				g_assert (_tmp55_);
				_g_free0 (a);
			}
		}
	}
	_tmp56_ = self->test_collection;
	_tmp57_ = gee_collection_get_size (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = to_add;
	_tmp59__length1 = to_add_length1;
	g_assert (_tmp58_ == _tmp59__length1);
	_tmp60_ = self->test_collection;
	gee_collection_clear (_tmp60_);
	_tmp61_ = self->test_collection;
	_tmp62_ = gee_collection_get_size (_tmp61_);
	_tmp63_ = _tmp62_;
	g_assert (_tmp63_ == 0);
	_tmp64_ = self->test_collection;
	_tmp65_ = gee_iterable_iterator ((GeeIterable*) _tmp64_);
	iter = _tmp65_;
	g_assert (iter != NULL);
	_tmp66_ = gee_iterator_has_next (iter);
	g_assert (!_tmp66_);
	_g_object_unref0 (iter);
	to_add = (_vala_array_free (to_add, to_add_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_add_all (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* dummy;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GeeCollection* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeCollection* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GeeCollection* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeCollection* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GeeCollection* _tmp18_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GeeCollection* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GeeCollection* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GeeCollection* _tmp27_;
	gboolean _tmp28_ = FALSE;
	GeeCollection* _tmp29_;
	gboolean _tmp30_ = FALSE;
	GeeCollection* _tmp31_;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_;
	gint _tmp34_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	GeeCollection* _tmp38_;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	GeeCollection* _tmp42_;
	gboolean _tmp43_ = FALSE;
	GeeCollection* _tmp44_;
	gboolean _tmp45_ = FALSE;
	GeeCollection* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GeeCollection* _tmp49_;
	gboolean _tmp50_ = FALSE;
	GeeCollection* _tmp51_;
	gboolean _tmp52_ = FALSE;
	GeeCollection* _tmp53_;
	gboolean _tmp54_ = FALSE;
	GeeCollection* _tmp55_;
	gboolean _tmp56_ = FALSE;
	gint _tmp57_;
	gint _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	GeeCollection* _tmp62_;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp65_ = FALSE;
	GeeCollection* _tmp66_;
	gboolean _tmp67_ = FALSE;
	GeeCollection* _tmp68_;
	gboolean _tmp69_ = FALSE;
	GeeCollection* _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	GeeCollection* _tmp73_;
	gboolean _tmp74_ = FALSE;
	GeeCollection* _tmp75_;
	gboolean _tmp76_ = FALSE;
	GeeCollection* _tmp77_;
	gboolean _tmp78_ = FALSE;
	gint _tmp79_;
	gint _tmp80_;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add_all (_tmp2_, (GeeCollection*) dummy);
	g_assert (!_tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_get_is_empty (_tmp4_);
	_tmp6_ = _tmp5_;
	g_assert (_tmp6_);
	_tmp7_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	_tmp8_ = _tmp7_;
	g_assert (_tmp8_);
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_collection_add (_tmp9_, "hello");
	g_assert (_tmp10_);
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_add_all (_tmp11_, (GeeCollection*) dummy);
	g_assert (!_tmp12_);
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_collection_get_size (_tmp13_);
	_tmp15_ = _tmp14_;
	g_assert (_tmp15_ == 1);
	_tmp16_ = self->test_collection;
	_tmp17_ = gee_collection_contains (_tmp16_, "hello");
	g_assert (_tmp17_);
	_tmp18_ = self->test_collection;
	gee_collection_clear (_tmp18_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp19_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp19_);
	_tmp20_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp20_);
	_tmp21_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp21_);
	_tmp22_ = self->test_collection;
	_tmp23_ = gee_collection_add_all (_tmp22_, (GeeCollection*) dummy);
	g_assert (_tmp23_);
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_get_size (_tmp24_);
	_tmp26_ = _tmp25_;
	g_assert (_tmp26_ == 3);
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_contains (_tmp27_, "hello1");
	g_assert (_tmp28_);
	_tmp29_ = self->test_collection;
	_tmp30_ = gee_collection_contains (_tmp29_, "hello2");
	g_assert (_tmp30_);
	_tmp31_ = self->test_collection;
	_tmp32_ = gee_collection_contains (_tmp31_, "hello3");
	g_assert (_tmp32_);
	_tmp33_ = gee_collection_get_size ((GeeCollection*) dummy);
	_tmp34_ = _tmp33_;
	g_assert (_tmp34_ == 3);
	_tmp35_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp35_);
	_tmp36_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp36_);
	_tmp37_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp37_);
	_tmp38_ = self->test_collection;
	gee_collection_clear (_tmp38_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp39_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp39_);
	_tmp40_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp40_);
	_tmp41_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp41_);
	_tmp42_ = self->test_collection;
	_tmp43_ = gee_collection_add (_tmp42_, "hello");
	g_assert (_tmp43_);
	_tmp44_ = self->test_collection;
	_tmp45_ = gee_collection_add_all (_tmp44_, (GeeCollection*) dummy);
	g_assert (_tmp45_);
	_tmp46_ = self->test_collection;
	_tmp47_ = gee_collection_get_size (_tmp46_);
	_tmp48_ = _tmp47_;
	g_assert (_tmp48_ == 4);
	_tmp49_ = self->test_collection;
	_tmp50_ = gee_collection_contains (_tmp49_, "hello");
	g_assert (_tmp50_);
	_tmp51_ = self->test_collection;
	_tmp52_ = gee_collection_contains (_tmp51_, "hello1");
	g_assert (_tmp52_);
	_tmp53_ = self->test_collection;
	_tmp54_ = gee_collection_contains (_tmp53_, "hello2");
	g_assert (_tmp54_);
	_tmp55_ = self->test_collection;
	_tmp56_ = gee_collection_contains (_tmp55_, "hello3");
	g_assert (_tmp56_);
	_tmp57_ = gee_collection_get_size ((GeeCollection*) dummy);
	_tmp58_ = _tmp57_;
	g_assert (_tmp58_ == 3);
	_tmp59_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp59_);
	_tmp60_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp60_);
	_tmp61_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp61_);
	_tmp62_ = self->test_collection;
	gee_collection_clear (_tmp62_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp63_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp63_);
	_tmp64_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp64_);
	_tmp65_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp65_);
	_tmp66_ = self->test_collection;
	_tmp67_ = gee_collection_add (_tmp66_, "hello1");
	g_assert (_tmp67_);
	_tmp68_ = self->test_collection;
	_tmp69_ = gee_collection_add_all (_tmp68_, (GeeCollection*) dummy);
	g_assert (_tmp69_);
	_tmp70_ = self->test_collection;
	_tmp71_ = gee_collection_get_size (_tmp70_);
	_tmp72_ = _tmp71_;
	g_assert (_tmp72_ >= 3);
	_tmp73_ = self->test_collection;
	_tmp74_ = gee_collection_contains (_tmp73_, "hello1");
	g_assert (_tmp74_);
	_tmp75_ = self->test_collection;
	_tmp76_ = gee_collection_contains (_tmp75_, "hello2");
	g_assert (_tmp76_);
	_tmp77_ = self->test_collection;
	_tmp78_ = gee_collection_contains (_tmp77_, "hello3");
	g_assert (_tmp78_);
	_tmp79_ = gee_collection_get_size ((GeeCollection*) dummy);
	_tmp80_ = _tmp79_;
	g_assert (_tmp80_ == 3);
	_tmp81_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp81_);
	_tmp82_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp82_);
	_tmp83_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp83_);
	_g_object_unref0 (dummy);
}


void collection_tests_test_contains_all (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* dummy;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GeeCollection* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GeeCollection* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeCollection* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GeeCollection* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GeeCollection* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GeeCollection* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GeeCollection* _tmp20_;
	gboolean _tmp21_ = FALSE;
	GeeCollection* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GeeCollection* _tmp24_;
	gboolean _tmp25_ = FALSE;
	GeeCollection* _tmp26_;
	gboolean _tmp27_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp2_);
	_tmp3_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp3_);
	_tmp4_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp4_);
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_collection_get_is_empty (_tmp5_);
	_tmp7_ = _tmp6_;
	g_assert (_tmp7_);
	_tmp8_ = self->test_collection;
	_tmp9_ = gee_collection_contains_all (_tmp8_, (GeeCollection*) dummy);
	g_assert (!_tmp9_);
	_tmp10_ = self->test_collection;
	_tmp11_ = gee_collection_add (_tmp10_, "hello4");
	g_assert (_tmp11_);
	_tmp12_ = self->test_collection;
	_tmp13_ = gee_collection_add (_tmp12_, "hello5");
	g_assert (_tmp13_);
	_tmp14_ = self->test_collection;
	_tmp15_ = gee_collection_contains_all (_tmp14_, (GeeCollection*) dummy);
	g_assert (!_tmp15_);
	_tmp16_ = self->test_collection;
	_tmp17_ = gee_collection_add (_tmp16_, "hello1");
	g_assert (_tmp17_);
	_tmp18_ = self->test_collection;
	_tmp19_ = gee_collection_add (_tmp18_, "hello2");
	g_assert (_tmp19_);
	_tmp20_ = self->test_collection;
	_tmp21_ = gee_collection_contains_all (_tmp20_, (GeeCollection*) dummy);
	g_assert (!_tmp21_);
	_tmp22_ = self->test_collection;
	_tmp23_ = gee_collection_add (_tmp22_, "hello3");
	g_assert (_tmp23_);
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_contains_all (_tmp24_, (GeeCollection*) dummy);
	g_assert (_tmp25_);
	_tmp26_ = self->test_collection;
	_tmp27_ = gee_abstract_collection_contains_all ((GeeAbstractCollection*) dummy, _tmp26_);
	g_assert (!_tmp27_);
	_g_object_unref0 (dummy);
}


void collection_tests_test_remove_all (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* dummy;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GeeCollection* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	GeeCollection* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GeeCollection* _tmp21_;
	gboolean _tmp22_ = FALSE;
	GeeCollection* _tmp23_;
	gboolean _tmp24_ = FALSE;
	GeeCollection* _tmp25_;
	gboolean _tmp26_ = FALSE;
	GeeCollection* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GeeCollection* _tmp32_;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GeeCollection* _tmp36_;
	gboolean _tmp37_ = FALSE;
	GeeCollection* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GeeCollection* _tmp40_;
	gboolean _tmp41_ = FALSE;
	GeeCollection* _tmp42_;
	gboolean _tmp43_ = FALSE;
	GeeCollection* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GeeCollection* _tmp49_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_remove_all (_tmp2_, (GeeCollection*) dummy);
	g_assert (!_tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_get_is_empty (_tmp4_);
	_tmp6_ = _tmp5_;
	g_assert (_tmp6_);
	_tmp7_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	_tmp8_ = _tmp7_;
	g_assert (_tmp8_);
	_tmp9_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp9_);
	_tmp10_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp10_);
	_tmp11_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp11_);
	_tmp12_ = self->test_collection;
	_tmp13_ = gee_collection_remove_all (_tmp12_, (GeeCollection*) dummy);
	g_assert (!_tmp13_);
	_tmp14_ = self->test_collection;
	_tmp15_ = gee_collection_get_is_empty (_tmp14_);
	_tmp16_ = _tmp15_;
	g_assert (_tmp16_);
	_tmp17_ = self->test_collection;
	gee_collection_clear (_tmp17_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp18_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp18_);
	_tmp19_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp19_);
	_tmp20_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp20_);
	_tmp21_ = self->test_collection;
	_tmp22_ = gee_collection_add (_tmp21_, "hello4");
	g_assert (_tmp22_);
	_tmp23_ = self->test_collection;
	_tmp24_ = gee_collection_add (_tmp23_, "hello5");
	g_assert (_tmp24_);
	_tmp25_ = self->test_collection;
	_tmp26_ = gee_collection_remove_all (_tmp25_, (GeeCollection*) dummy);
	g_assert (!_tmp26_);
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	g_assert (_tmp29_ == 2);
	_tmp30_ = gee_collection_get_size ((GeeCollection*) dummy);
	_tmp31_ = _tmp30_;
	g_assert (_tmp31_ == 3);
	_tmp32_ = self->test_collection;
	gee_collection_clear (_tmp32_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp33_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp33_);
	_tmp34_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp34_);
	_tmp35_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp35_);
	_tmp36_ = self->test_collection;
	_tmp37_ = gee_collection_add (_tmp36_, "hello1");
	g_assert (_tmp37_);
	_tmp38_ = self->test_collection;
	_tmp39_ = gee_collection_add (_tmp38_, "hello2");
	g_assert (_tmp39_);
	_tmp40_ = self->test_collection;
	_tmp41_ = gee_collection_add (_tmp40_, "hello3");
	g_assert (_tmp41_);
	_tmp42_ = self->test_collection;
	_tmp43_ = gee_collection_remove_all (_tmp42_, (GeeCollection*) dummy);
	g_assert (_tmp43_);
	_tmp44_ = self->test_collection;
	_tmp45_ = gee_collection_get_is_empty (_tmp44_);
	_tmp46_ = _tmp45_;
	g_assert (_tmp46_);
	_tmp47_ = gee_collection_get_size ((GeeCollection*) dummy);
	_tmp48_ = _tmp47_;
	g_assert (_tmp48_ == 3);
	_tmp49_ = self->test_collection;
	gee_collection_clear (_tmp49_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}


void collection_tests_test_retain_all (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* dummy;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GeeCollection* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeCollection* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GeeCollection* _tmp13_;
	gboolean _tmp14_ = FALSE;
	GeeCollection* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GeeCollection* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GeeCollection* _tmp24_;
	gboolean _tmp25_ = FALSE;
	GeeCollection* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	GeeCollection* _tmp34_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	GeeCollection* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GeeCollection* _tmp40_;
	gboolean _tmp41_ = FALSE;
	GeeCollection* _tmp42_;
	gboolean _tmp43_ = FALSE;
	GeeCollection* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	GeeCollection* _tmp52_;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	GeeCollection* _tmp56_;
	gboolean _tmp57_ = FALSE;
	GeeCollection* _tmp58_;
	gboolean _tmp59_ = FALSE;
	GeeCollection* _tmp60_;
	gboolean _tmp61_ = FALSE;
	GeeCollection* _tmp62_;
	gboolean _tmp63_ = FALSE;
	GeeCollection* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	GeeCollection* _tmp67_;
	gboolean _tmp68_ = FALSE;
	GeeCollection* _tmp69_;
	gboolean _tmp70_ = FALSE;
	GeeCollection* _tmp71_;
	gboolean _tmp72_ = FALSE;
	gint _tmp73_;
	gint _tmp74_;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	GeeCollection* _tmp78_;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
	GeeCollection* _tmp82_;
	gboolean _tmp83_ = FALSE;
	GeeCollection* _tmp84_;
	gboolean _tmp85_ = FALSE;
	GeeCollection* _tmp86_;
	gboolean _tmp87_ = FALSE;
	GeeCollection* _tmp88_;
	gboolean _tmp89_ = FALSE;
	GeeCollection* _tmp90_;
	gint _tmp91_;
	gint _tmp92_;
	GeeCollection* _tmp93_;
	gboolean _tmp94_ = FALSE;
	GeeCollection* _tmp95_;
	gboolean _tmp96_ = FALSE;
	gint _tmp97_;
	gint _tmp98_;
	gboolean _tmp99_ = FALSE;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp101_ = FALSE;
	GeeCollection* _tmp102_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	dummy = _tmp1_;
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_retain_all (_tmp2_, (GeeCollection*) dummy);
	g_assert (!_tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_get_is_empty (_tmp4_);
	_tmp6_ = _tmp5_;
	g_assert (_tmp6_);
	_tmp7_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	_tmp8_ = _tmp7_;
	g_assert (_tmp8_);
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_collection_add (_tmp9_, "hello1");
	g_assert (_tmp10_);
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_collection_add (_tmp11_, "hello2");
	g_assert (_tmp12_);
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_collection_retain_all (_tmp13_, (GeeCollection*) dummy);
	g_assert (_tmp14_);
	_tmp15_ = self->test_collection;
	_tmp16_ = gee_collection_get_is_empty (_tmp15_);
	_tmp17_ = _tmp16_;
	g_assert (_tmp17_);
	_tmp18_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) dummy);
	_tmp19_ = _tmp18_;
	g_assert (_tmp19_);
	_tmp20_ = self->test_collection;
	gee_collection_clear (_tmp20_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp21_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp21_);
	_tmp22_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp22_);
	_tmp23_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp23_);
	_tmp24_ = self->test_collection;
	_tmp25_ = gee_collection_retain_all (_tmp24_, (GeeCollection*) dummy);
	g_assert (!_tmp25_);
	_tmp26_ = self->test_collection;
	_tmp27_ = gee_collection_get_is_empty (_tmp26_);
	_tmp28_ = _tmp27_;
	g_assert (_tmp28_);
	_tmp29_ = gee_collection_get_size ((GeeCollection*) dummy);
	_tmp30_ = _tmp29_;
	g_assert (_tmp30_ == 3);
	_tmp31_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp31_);
	_tmp32_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp32_);
	_tmp33_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp33_);
	_tmp34_ = self->test_collection;
	gee_collection_clear (_tmp34_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp35_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp35_);
	_tmp36_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp36_);
	_tmp37_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp37_);
	_tmp38_ = self->test_collection;
	_tmp39_ = gee_collection_add (_tmp38_, "hello4");
	g_assert (_tmp39_);
	_tmp40_ = self->test_collection;
	_tmp41_ = gee_collection_add (_tmp40_, "hello5");
	g_assert (_tmp41_);
	_tmp42_ = self->test_collection;
	_tmp43_ = gee_collection_retain_all (_tmp42_, (GeeCollection*) dummy);
	g_assert (_tmp43_);
	_tmp44_ = self->test_collection;
	_tmp45_ = gee_collection_get_is_empty (_tmp44_);
	_tmp46_ = _tmp45_;
	g_assert (_tmp46_);
	_tmp47_ = gee_collection_get_size ((GeeCollection*) dummy);
	_tmp48_ = _tmp47_;
	g_assert (_tmp48_ == 3);
	_tmp49_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp49_);
	_tmp50_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp50_);
	_tmp51_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp51_);
	_tmp52_ = self->test_collection;
	gee_collection_clear (_tmp52_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp53_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp53_);
	_tmp54_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp54_);
	_tmp55_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp55_);
	_tmp56_ = self->test_collection;
	_tmp57_ = gee_collection_add (_tmp56_, "hello1");
	g_assert (_tmp57_);
	_tmp58_ = self->test_collection;
	_tmp59_ = gee_collection_add (_tmp58_, "hello2");
	g_assert (_tmp59_);
	_tmp60_ = self->test_collection;
	_tmp61_ = gee_collection_add (_tmp60_, "hello3");
	g_assert (_tmp61_);
	_tmp62_ = self->test_collection;
	_tmp63_ = gee_collection_retain_all (_tmp62_, (GeeCollection*) dummy);
	g_assert (!_tmp63_);
	_tmp64_ = self->test_collection;
	_tmp65_ = gee_collection_get_size (_tmp64_);
	_tmp66_ = _tmp65_;
	g_assert (_tmp66_ == 3);
	_tmp67_ = self->test_collection;
	_tmp68_ = gee_collection_contains (_tmp67_, "hello1");
	g_assert (_tmp68_);
	_tmp69_ = self->test_collection;
	_tmp70_ = gee_collection_contains (_tmp69_, "hello2");
	g_assert (_tmp70_);
	_tmp71_ = self->test_collection;
	_tmp72_ = gee_collection_contains (_tmp71_, "hello3");
	g_assert (_tmp72_);
	_tmp73_ = gee_collection_get_size ((GeeCollection*) dummy);
	_tmp74_ = _tmp73_;
	g_assert (_tmp74_ == 3);
	_tmp75_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp75_);
	_tmp76_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp76_);
	_tmp77_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp77_);
	_tmp78_ = self->test_collection;
	gee_collection_clear (_tmp78_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_tmp79_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp79_);
	_tmp80_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp80_);
	_tmp81_ = gee_abstract_collection_add ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp81_);
	_tmp82_ = self->test_collection;
	_tmp83_ = gee_collection_add (_tmp82_, "hello2");
	g_assert (_tmp83_);
	_tmp84_ = self->test_collection;
	_tmp85_ = gee_collection_add (_tmp84_, "hello3");
	g_assert (_tmp85_);
	_tmp86_ = self->test_collection;
	_tmp87_ = gee_collection_add (_tmp86_, "hello4");
	g_assert (_tmp87_);
	_tmp88_ = self->test_collection;
	_tmp89_ = gee_collection_retain_all (_tmp88_, (GeeCollection*) dummy);
	g_assert (_tmp89_);
	_tmp90_ = self->test_collection;
	_tmp91_ = gee_collection_get_size (_tmp90_);
	_tmp92_ = _tmp91_;
	g_assert (_tmp92_ == 2);
	_tmp93_ = self->test_collection;
	_tmp94_ = gee_collection_contains (_tmp93_, "hello2");
	g_assert (_tmp94_);
	_tmp95_ = self->test_collection;
	_tmp96_ = gee_collection_contains (_tmp95_, "hello3");
	g_assert (_tmp96_);
	_tmp97_ = gee_collection_get_size ((GeeCollection*) dummy);
	_tmp98_ = _tmp97_;
	g_assert (_tmp98_ == 3);
	_tmp99_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello1");
	g_assert (_tmp99_);
	_tmp100_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello2");
	g_assert (_tmp100_);
	_tmp101_ = gee_abstract_collection_contains ((GeeAbstractCollection*) dummy, "hello3");
	g_assert (_tmp101_);
	_tmp102_ = self->test_collection;
	gee_collection_clear (_tmp102_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) dummy);
	_g_object_unref0 (dummy);
}


void collection_tests_test_to_array (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeCollection* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeCollection* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeCollection* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeCollection* _tmp10_;
	gint _tmp11_ = 0;
	gpointer* _tmp12_ = NULL;
	gchar** array;
	gint array_length1;
	gint _array_size_;
	gint index;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = self->test_collection;
	_tmp2_ = gee_collection_get_is_empty (_tmp1_);
	_tmp3_ = _tmp2_;
	g_assert (_tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "hello1");
	g_assert (_tmp5_);
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_collection_add (_tmp6_, "hello2");
	g_assert (_tmp7_);
	_tmp8_ = self->test_collection;
	_tmp9_ = gee_collection_add (_tmp8_, "hello3");
	g_assert (_tmp9_);
	_tmp10_ = self->test_collection;
	_tmp12_ = gee_collection_to_array (_tmp10_, &_tmp11_);
	array = (gchar**) _tmp12_;
	array_length1 = _tmp11_;
	_array_size_ = array_length1;
	index = 0;
	{
		GeeCollection* _tmp13_;
		GeeIterator* _tmp14_ = NULL;
		GeeIterator* _element_it;
		_tmp13_ = self->test_collection;
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
		_element_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			gboolean _tmp16_ = FALSE;
			GeeIterator* _tmp17_;
			gpointer _tmp18_ = NULL;
			gchar* element;
			const gchar* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			gint _tmp21_;
			const gchar* _tmp22_;
			_tmp15_ = _element_it;
			_tmp16_ = gee_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _element_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			element = (gchar*) _tmp18_;
			_tmp19_ = element;
			_tmp20_ = array;
			_tmp20__length1 = array_length1;
			_tmp21_ = index;
			index = _tmp21_ + 1;
			_tmp22_ = _tmp20_[_tmp21_];
			g_assert (g_strcmp0 (_tmp19_, _tmp22_) == 0);
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
}


void collection_tests_test_gobject_properties (CollectionTests* self) {
	GeeCollection* _tmp0_;
	GValue value = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	GeeCollection* _tmp3_;
	GType _tmp4_ = 0UL;
	GeeCollection* _tmp5_;
	GType _tmp6_;
	GType _tmp7_;
	GValue _tmp8_ = {0};
	GValue _tmp9_;
	GeeCollection* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GValue _tmp15_ = {0};
	GValue _tmp16_;
	GeeCollection* _tmp17_;
	gint _tmp18_ = 0;
	GeeCollection* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	g_assert (_tmp0_ != NULL);
	g_value_init (&_tmp1_, G_TYPE_GTYPE);
	_tmp2_ = _tmp1_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp2_;
	_tmp3_ = self->test_collection;
	g_object_get_property ((GObject*) _tmp3_, "element-type", &value);
	_tmp4_ = g_value_get_gtype (&value);
	_tmp5_ = self->test_collection;
	_tmp6_ = gee_iterable_get_element_type ((GeeIterable*) _tmp5_);
	_tmp7_ = _tmp6_;
	g_assert (_tmp4_ == _tmp7_);
	g_value_unset (&value);
	g_value_init (&_tmp8_, G_TYPE_BOOLEAN);
	_tmp9_ = _tmp8_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp9_;
	_tmp10_ = self->test_collection;
	g_object_get_property ((GObject*) _tmp10_, "is-empty", &value);
	_tmp11_ = g_value_get_boolean (&value);
	_tmp12_ = self->test_collection;
	_tmp13_ = gee_collection_get_is_empty (_tmp12_);
	_tmp14_ = _tmp13_;
	g_assert (_tmp11_ == _tmp14_);
	g_value_unset (&value);
	g_value_init (&_tmp15_, G_TYPE_INT);
	_tmp16_ = _tmp15_;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp16_;
	_tmp17_ = self->test_collection;
	g_object_get_property ((GObject*) _tmp17_, "size", &value);
	_tmp18_ = g_value_get_int (&value);
	_tmp19_ = self->test_collection;
	_tmp20_ = gee_collection_get_size (_tmp19_);
	_tmp21_ = _tmp20_;
	g_assert (_tmp18_ == _tmp21_);
	g_value_unset (&value);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}


static gint __lambda0_ (CollectionTests* self, gchar* x, gint y) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (x != NULL, 0);
	_tmp0_ = y;
	result = _tmp0_ + 1;
	_g_free0 (x);
	return result;
}


static gpointer ___lambda0__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda0_ (self, g, a);
	return result;
}


static gint __lambda1_ (CollectionTests* self, gchar* x, gint y) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (x != NULL, 0);
	_tmp0_ = y;
	result = _tmp0_ + 1;
	_g_free0 (x);
	return result;
}


static gpointer ___lambda1__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda1_ (self, g, a);
	return result;
}


void collection_tests_test_fold (CollectionTests* self) {
	GeeCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint count = 0;
	GeeCollection* _tmp6_;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_;
	gpointer _tmp9_ = NULL;
	gint _tmp10_;
	GeeCollection* _tmp11_;
	GeeIterator* _tmp12_ = NULL;
	GeeIterator* iter;
	gboolean _tmp13_ = FALSE;
	gpointer _tmp14_ = NULL;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	g_assert (_tmp1_);
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	g_assert (_tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	g_assert (_tmp5_);
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_traversable_fold ((GeeTraversable*) _tmp8_, G_TYPE_INT, NULL, NULL, ___lambda0__gee_fold_func, self, GINT_TO_POINTER (0));
	count = GPOINTER_TO_INT (_tmp9_);
	_g_object_unref0 (_tmp8_);
	_tmp10_ = count;
	g_assert (_tmp10_ == 3);
	_tmp11_ = self->test_collection;
	_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
	iter = _tmp12_;
	_tmp13_ = gee_iterator_next (iter);
	g_assert (_tmp13_);
	_tmp14_ = gee_traversable_fold ((GeeTraversable*) iter, G_TYPE_INT, NULL, NULL, ___lambda1__gee_fold_func, self, GINT_TO_POINTER (0));
	count = GPOINTER_TO_INT (_tmp14_);
	_tmp15_ = count;
	g_assert (_tmp15_ == 3);
	_g_object_unref0 (iter);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda2_ (Block1Data* _data1_, gchar* x) {
	CollectionTests * self;
	gint _tmp0_;
	self = _data1_->self;
	g_return_if_fail (x != NULL);
	_tmp0_ = _data1_->count;
	_data1_->count = _tmp0_ + 1;
	_g_free0 (x);
}


static void ___lambda2__gee_forall_func (gpointer g, gpointer self) {
	__lambda2_ (self, g);
}


static void __lambda3_ (Block1Data* _data1_, gchar* x) {
	CollectionTests * self;
	gint _tmp0_;
	self = _data1_->self;
	g_return_if_fail (x != NULL);
	_tmp0_ = _data1_->count;
	_data1_->count = _tmp0_ + 1;
	_g_free0 (x);
}


static void ___lambda3__gee_forall_func (gpointer g, gpointer self) {
	__lambda3_ (self, g);
}


void collection_tests_test_foreach (CollectionTests* self) {
	Block1Data* _data1_;
	GeeCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeCollection* _tmp6_;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_;
	GeeCollection* _tmp9_;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* iter;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	g_assert (_tmp1_);
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	g_assert (_tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	g_assert (_tmp5_);
	_data1_->count = 0;
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
	_tmp8_ = _tmp7_;
	gee_traversable_foreach ((GeeTraversable*) _tmp8_, ___lambda2__gee_forall_func, _data1_);
	_g_object_unref0 (_tmp8_);
	g_assert (_data1_->count == 3);
	_tmp9_ = self->test_collection;
	_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
	iter = _tmp10_;
	_tmp11_ = gee_iterator_next (iter);
	g_assert (_tmp11_);
	gee_traversable_foreach ((GeeTraversable*) iter, ___lambda3__gee_forall_func, _data1_);
	g_assert (_data1_->count == 6);
	_g_object_unref0 (iter);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gint __lambda4_ (Block2Data* _data2_, gchar* str) {
	CollectionTests * self;
	gint result = 0;
	const gchar* _tmp0_;
	gint _tmp6_;
	self = _data2_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "one") == 0) {
		gboolean _tmp1_;
		_tmp1_ = _data2_->one;
		g_assert (!_tmp1_);
		_data2_->one = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = str;
		if (g_strcmp0 (_tmp2_, "two") == 0) {
			gboolean _tmp3_;
			_tmp3_ = _data2_->two;
			g_assert (!_tmp3_);
			_data2_->two = TRUE;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = str;
			if (g_strcmp0 (_tmp4_, "three") == 0) {
				gboolean _tmp5_;
				_tmp5_ = _data2_->three;
				g_assert (!_tmp5_);
				_data2_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp6_ = _data2_->i;
	_data2_->i = _tmp6_ + 1;
	result = _tmp6_;
	_g_free0 (str);
	return result;
}


static gpointer ___lambda4__gee_map_func (gpointer g, gpointer self) {
	gpointer result;
	result = __lambda4_ (self, g);
	return result;
}


void collection_tests_test_map (CollectionTests* self) {
	Block2Data* _data2_;
	GeeCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeCollection* _tmp6_;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_ = NULL;
	GeeIterator* _tmp10_;
	GeeIterator* iter;
	gint j;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GeeCollection* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	g_assert (_tmp1_);
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	g_assert (_tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	g_assert (_tmp5_);
	_data2_->one = FALSE;
	_data2_->two = FALSE;
	_data2_->three = FALSE;
	_data2_->i = 0;
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_traversable_map ((GeeTraversable*) _tmp8_, G_TYPE_INT, NULL, NULL, ___lambda4__gee_map_func, _data2_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	iter = _tmp10_;
	j = 0;
	while (TRUE) {
		GeeIterator* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		GeeIterator* _tmp16_;
		gpointer _tmp17_ = NULL;
		gint _tmp18_;
		GeeIterator* _tmp19_;
		gpointer _tmp20_ = NULL;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp11_ = iter;
		_tmp12_ = gee_iterator_next (_tmp11_);
		if (!_tmp12_) {
			break;
		}
		_tmp13_ = _data2_->i;
		_tmp14_ = j;
		g_assert (_tmp13_ == _tmp14_);
		_tmp15_ = j;
		_tmp16_ = iter;
		_tmp17_ = gee_iterator_get (_tmp16_);
		g_assert (_tmp15_ == GPOINTER_TO_INT (_tmp17_));
		_tmp18_ = j;
		_tmp19_ = iter;
		_tmp20_ = gee_iterator_get (_tmp19_);
		g_assert (_tmp18_ == GPOINTER_TO_INT (_tmp20_));
		_tmp21_ = j;
		j = _tmp21_ + 1;
		_tmp22_ = _data2_->i;
		_tmp23_ = j;
		g_assert (_tmp22_ == _tmp23_);
	}
	_tmp24_ = _data2_->i;
	_tmp25_ = j;
	g_assert (_tmp24_ == _tmp25_);
	_tmp26_ = _data2_->i;
	_tmp27_ = self->test_collection;
	_tmp28_ = gee_collection_get_size (_tmp27_);
	_tmp29_ = _tmp28_;
	g_assert (_tmp26_ == _tmp29_);
	_tmp30_ = _data2_->one;
	g_assert (_tmp30_);
	_tmp31_ = _data2_->two;
	g_assert (_tmp31_);
	_tmp32_ = _data2_->three;
	g_assert (_tmp32_);
	_g_object_unref0 (iter);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gint __lambda5_ (Block3Data* _data3_, gchar* str, gint cur) {
	CollectionTests * self;
	gint result = 0;
	const gchar* _tmp0_;
	gint _tmp6_;
	self = _data3_->self;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "one") == 0) {
		gboolean _tmp1_;
		_tmp1_ = _data3_->one;
		g_assert (!_tmp1_);
		_data3_->one = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = str;
		if (g_strcmp0 (_tmp2_, "two") == 0) {
			gboolean _tmp3_;
			_tmp3_ = _data3_->two;
			g_assert (!_tmp3_);
			_data3_->two = TRUE;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = str;
			if (g_strcmp0 (_tmp4_, "three") == 0) {
				gboolean _tmp5_;
				_tmp5_ = _data3_->three;
				g_assert (!_tmp5_);
				_data3_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp6_ = cur;
	result = _tmp6_ + 1;
	_g_free0 (str);
	return result;
}


static gpointer ___lambda5__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda5_ (self, g, a);
	return result;
}


void collection_tests_test_scan (CollectionTests* self) {
	Block3Data* _data3_;
	GeeCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeCollection* _tmp6_;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_ = NULL;
	GeeIterator* _tmp10_;
	GeeIterator* iter;
	gint j;
	gint _tmp22_;
	GeeCollection* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	g_assert (_tmp1_);
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	g_assert (_tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	g_assert (_tmp5_);
	_data3_->one = FALSE;
	_data3_->two = FALSE;
	_data3_->three = FALSE;
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_traversable_scan ((GeeTraversable*) _tmp8_, G_TYPE_INT, NULL, NULL, ___lambda5__gee_fold_func, _data3_, GINT_TO_POINTER (0));
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	iter = _tmp10_;
	j = 0;
	{
		gboolean _tmp11_;
		_tmp11_ = TRUE;
		while (TRUE) {
			gboolean _tmp12_;
			gint _tmp15_;
			GeeIterator* _tmp16_;
			gpointer _tmp17_ = NULL;
			gint _tmp18_;
			GeeIterator* _tmp19_;
			gpointer _tmp20_ = NULL;
			gint _tmp21_;
			_tmp12_ = _tmp11_;
			if (!_tmp12_) {
				GeeIterator* _tmp13_;
				gboolean _tmp14_ = FALSE;
				_tmp13_ = iter;
				_tmp14_ = gee_iterator_next (_tmp13_);
				if (!_tmp14_) {
					break;
				}
			}
			_tmp11_ = FALSE;
			_tmp15_ = j;
			_tmp16_ = iter;
			_tmp17_ = gee_iterator_get (_tmp16_);
			g_assert (_tmp15_ == GPOINTER_TO_INT (_tmp17_));
			_tmp18_ = j;
			_tmp19_ = iter;
			_tmp20_ = gee_iterator_get (_tmp19_);
			g_assert (_tmp18_ == GPOINTER_TO_INT (_tmp20_));
			_tmp21_ = j;
			j = _tmp21_ + 1;
		}
	}
	_tmp22_ = j;
	_tmp23_ = self->test_collection;
	_tmp24_ = gee_collection_get_size (_tmp23_);
	_tmp25_ = _tmp24_;
	g_assert (_tmp22_ == (_tmp25_ + 1));
	_tmp26_ = _data3_->one;
	g_assert (_tmp26_);
	_tmp27_ = _data3_->two;
	g_assert (_tmp27_);
	_tmp28_ = _data3_->three;
	g_assert (_tmp28_);
	_g_object_unref0 (iter);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean __lambda6_ (Block4Data* _data4_, const gchar* str) {
	CollectionTests * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	self = _data4_->self;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "one") == 0) {
		gboolean _tmp1_;
		_tmp1_ = _data4_->one;
		g_assert (!_tmp1_);
		_data4_->one = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = str;
		if (g_strcmp0 (_tmp2_, "two") == 0) {
			gboolean _tmp3_;
			_tmp3_ = _data4_->two;
			g_assert (!_tmp3_);
			_data4_->two = TRUE;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = str;
			if (g_strcmp0 (_tmp4_, "three") == 0) {
				gboolean _tmp5_;
				_tmp5_ = _data4_->three;
				g_assert (!_tmp5_);
				_data4_->three = TRUE;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp6_ = str;
	result = g_strcmp0 (_tmp6_, "two") != 0;
	return result;
}


static gboolean ___lambda6__gee_predicate (gconstpointer g, gpointer self) {
	gboolean result;
	result = __lambda6_ (self, g);
	return result;
}


void collection_tests_test_filter (CollectionTests* self) {
	Block4Data* _data4_;
	GeeCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeCollection* _tmp6_;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_ = NULL;
	GeeIterator* _tmp10_;
	GeeIterator* iter;
	GeeIterator* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gint j;
	gint _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	g_assert (_tmp1_);
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	g_assert (_tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	g_assert (_tmp5_);
	_data4_->one = FALSE;
	_data4_->two = FALSE;
	_data4_->three = FALSE;
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_traversable_filter ((GeeTraversable*) _tmp8_, ___lambda6__gee_predicate, block4_data_ref (_data4_), block4_data_unref);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	iter = _tmp10_;
	_tmp11_ = iter;
	_tmp12_ = gee_iterator_get_valid (_tmp11_);
	_tmp13_ = _tmp12_;
	g_assert (!_tmp13_);
	j = 0;
	while (TRUE) {
		GeeIterator* _tmp14_;
		gboolean _tmp15_ = FALSE;
		gint _tmp16_;
		_tmp14_ = iter;
		_tmp15_ = gee_iterator_next (_tmp14_);
		if (!_tmp15_) {
			break;
		}
		_tmp16_ = j;
		j = _tmp16_ + 1;
	}
	_tmp17_ = j;
	g_assert (_tmp17_ == 2);
	_tmp18_ = _data4_->one;
	g_assert (_tmp18_);
	_tmp19_ = _data4_->two;
	g_assert (_tmp19_);
	_tmp20_ = _data4_->three;
	g_assert (_tmp20_);
	_g_object_unref0 (iter);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


void collection_tests_test_chop (CollectionTests* self) {
	GeeCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean one;
	gboolean two;
	gboolean three;
	GeeCollection* _tmp6_;
	GeeIterator* _tmp7_ = NULL;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_ = NULL;
	GeeIterator* _tmp10_;
	GeeIterator* iter;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GeeCollection* _tmp13_;
	GeeIterator* _tmp14_ = NULL;
	GeeIterator* iter2;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->test_collection;
	_tmp1_ = gee_collection_add (_tmp0_, "one");
	g_assert (_tmp1_);
	_tmp2_ = self->test_collection;
	_tmp3_ = gee_collection_add (_tmp2_, "two");
	g_assert (_tmp3_);
	_tmp4_ = self->test_collection;
	_tmp5_ = gee_collection_add (_tmp4_, "three");
	g_assert (_tmp5_);
	one = FALSE;
	two = FALSE;
	three = FALSE;
	_tmp6_ = self->test_collection;
	_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_traversable_chop ((GeeTraversable*) _tmp8_, 1, 1);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	iter = _tmp10_;
	_tmp11_ = gee_iterator_get_valid (iter);
	_tmp12_ = _tmp11_;
	g_assert (!_tmp12_);
	_tmp13_ = self->test_collection;
	_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
	iter2 = _tmp14_;
	_tmp15_ = gee_iterator_next (iter2);
	g_assert (_tmp15_);
	_tmp16_ = gee_iterator_next (iter2);
	g_assert (_tmp16_);
	_tmp17_ = gee_iterator_next (iter);
	g_assert (_tmp17_);
	_tmp18_ = gee_iterator_get (iter2);
	_tmp19_ = (gchar*) _tmp18_;
	_tmp20_ = gee_iterator_get (iter);
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp19_, _tmp21_) == 0);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_tmp22_ = gee_iterator_next (iter);
	g_assert (!_tmp22_);
	_tmp23_ = gee_iterator_next (iter2);
	g_assert (_tmp23_);
	_g_object_unref0 (iter2);
	_g_object_unref0 (iter);
}


static void collection_tests_class_init (CollectionTestsClass * klass) {
	collection_tests_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = collection_tests_finalize;
}


static void collection_tests_instance_init (CollectionTests * self) {
}


static void collection_tests_finalize (GObject* obj) {
	CollectionTests * self;
	self = COLLECTION_TESTS (obj);
	_g_object_unref0 (self->test_collection);
	G_OBJECT_CLASS (collection_tests_parent_class)->finalize (obj);
}


GType collection_tests_get_type (void) {
	static volatile gsize collection_tests_type_id__volatile = 0;
	if (g_once_init_enter (&collection_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CollectionTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) collection_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CollectionTests), 0, (GInstanceInitFunc) collection_tests_instance_init, NULL };
		GType collection_tests_type_id;
		collection_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "CollectionTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&collection_tests_type_id__volatile, collection_tests_type_id);
	}
	return collection_tests_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



