/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome.event;

import org.gnu.gtk.event.GtkEvent;
import org.gnu.gtk.event.GtkEventType;

/**
 * An event represeting action by a {@link org.gnu.gnome.ColorPicker} widget.
 */
public class ColorPickerEvent extends GtkEvent {

    public static class Type extends GtkEventType{
	private Type(int id, String name){
	    super(id, name);
	}
	/**
	 */
	public static final Type COLOR_SET = new Type(1, "COLOR_SET");
    }

	/**
	 * Creates a new ColorPickerEvent. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public ColorPickerEvent(Object source) {
	    super(source, Type.COLOR_SET);
	}
}
