/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:28:06 EDT
 */

package org.gnu.gnome;

import java.util.Vector;

import org.gnu.glib.EventMap;
import org.gnu.glib.Type;
import org.gnu.gnome.event.DruidPageChangeEvent;
import org.gnu.gnome.event.DruidPageChangeListener;
import org.gnu.gnome.event.DruidPageSetupEvent;
import org.gnu.gnome.event.DruidPageSetupListener;
import org.gnu.gtk.Bin;
import org.gnu.gtk.event.GtkEventType;
/**
 * This widget is a virtual widget to define the interface to a druid
 * page.
 */
public class DruidPage extends Bin {

	/**
	 */
	private Vector druidPageChangeListeners = null;
	private Vector druidPageSetupListeners = null;

	/**
	 * Construct a new DruidPage.
	 */
	public DruidPage() {
		noopInit();
	}

	/**
	 * Constructs a new DruidPage object form a native resource.
	 * @param handle The handle to the native resource.
	 */
	public DruidPage(int handle) {
		super(handle);
	}

	protected void noopInit() {
		if (-1 == handle) {
			handle = gnome_druid_page_new();
			initializeEventHandlers();
		}
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_druid_page_get_type());
	}

	//////////////////////////////
	// Event handling
	//////////////////////////////
	/**
	 * Register an object to handle DruidPageChange events.
	 * @see org.gnu.gnome.event.DruidPageChangeListener
	 */
	public void addListener(DruidPageChangeListener listener) {
		// Don't add the listener a second time if it is in the Vector.
		int i = findListener(druidPageChangeListeners, listener);
		if (i == -1) {
			if (null == druidPageChangeListeners) {
				druidPageChangeListeners = new Vector();
			}
			druidPageChangeListeners.addElement(listener);
		}
	}
	/**
	 * Removes a listener
	 * @see #addListener(DruidPageChangeListeners)
	 */
	public void removeListener(DruidPageChangeListener listener) {
		int i = findListener(druidPageChangeListeners, listener);
		if (i > -1) {
			druidPageChangeListeners.remove(i);
		}
		if (0 == druidPageChangeListeners.size()) {
			druidPageChangeListeners = null;
		}
	}
	protected boolean fireDruidPageChangeEvent(DruidPageChangeEvent event) {
		if (null == druidPageChangeListeners) {
			return false;
		}
		int size = druidPageChangeListeners.size();
		int i = 0;
		while (i < size) {
			DruidPageChangeListener dpl = (DruidPageChangeListener)druidPageChangeListeners.elementAt(i);
			if (dpl.druidPageChangeEvent(event))
				return true;
			i++;
		}
		return false;
	}
	/**
	 * Register an object to handle DruidPageSetup events.
	 * @see org.gnu.gnome.event.DruidPageSetupListener
	 */
	public void addListener(DruidPageSetupListener listener) {
		// Don't add the listener a second time if it is in the Vector.
		int i = findListener(druidPageSetupListeners, listener);
		if (i == -1) {
			if (null == druidPageSetupListeners) {
				druidPageSetupListeners = new Vector();
			}
			druidPageSetupListeners.addElement(listener);
		}
	}
	/**
	 * Removes a listener
	 * @see #addListener(DruidPageSetupListeners)
	 */
	public void removeListener(DruidPageSetupListener listener) {
		int i = findListener(druidPageSetupListeners, listener);
		if (i > -1) {
			druidPageSetupListeners.remove(i);
		}
		if (0 == druidPageSetupListeners.size()) {
			druidPageSetupListeners = null;
		}
	}
	protected void fireDruidPageSetupEvent(DruidPageSetupEvent event) {
		if (null == druidPageSetupListeners) {
			return;
		}
		int size = druidPageSetupListeners.size();
		int i = 0;
		while (i < size) {
			DruidPageSetupListener dpl = (DruidPageSetupListener)druidPageSetupListeners.elementAt(i);
			dpl.druidPageSetupEvent(event);
			i++;
		}
	}

	private boolean handleNext(int widget) {
		return fireDruidPageChangeEvent(new DruidPageChangeEvent(this, DruidPageChangeEvent.Type.NEXT));
	}

	private boolean handleBack(int widget) {
		return fireDruidPageChangeEvent(new DruidPageChangeEvent(this, DruidPageChangeEvent.Type.BACK));
	}

	private void handleFinish(int widget) {
		fireDruidPageSetupEvent(new DruidPageSetupEvent(this, DruidPageSetupEvent.Type.FINISH));
	}

	private boolean handleCancel(int widget) {
		return fireDruidPageChangeEvent(new DruidPageChangeEvent(this, DruidPageChangeEvent.Type.CANCEL));
	}

	private void handlePrepare(int widget) {
		fireDruidPageSetupEvent(new DruidPageSetupEvent(this, DruidPageSetupEvent.Type.PREPARE));
	}

	protected void initializeEventHandlers() {
		super.initializeEventHandlers();
		evtMap.initialize(this);
	}

	public Class getEventListenerClass(String signal) {
		return evtMap.getListenerClass(signal);
	}

	public GtkEventType getEventType(String signal) {
		return evtMap.getEventType(signal);
	}

	private static EventMap evtMap = new EventMap();
	static {
		addEvents(evtMap);
	}

	private static void addEvents(EventMap anEvtMap) {
		anEvtMap.addEvent("next", "handleNext", DruidPageChangeEvent.Type.NEXT, DruidPageChangeListener.class);
		anEvtMap.addEvent("back", "handleBack", DruidPageChangeEvent.Type.BACK, DruidPageChangeListener.class);
		anEvtMap.addEvent("finish", "handleFinish", DruidPageSetupEvent.Type.FINISH, DruidPageSetupListener.class);
		anEvtMap.addEvent("cancel", "handleCancel", DruidPageChangeEvent.Type.CANCEL, DruidPageChangeListener.class);
		anEvtMap.addEvent("prepare", "handlePrepare", DruidPageSetupEvent.Type.PREPARE, DruidPageSetupListener.class);
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_druid_page_get_type();
	native static final protected int gnome_druid_page_new();
	native static final protected boolean gnome_druid_page_next(int page);
	native static final protected void gnome_druid_page_prepare(int page);
	native static final protected boolean gnome_druid_page_back(int page);
	native static final protected boolean gnome_druid_page_cancel(int page);
	native static final protected void gnome_druid_page_finish(int page);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
