/* GNOME DB VFS access module
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__dbvfs_h__)
#  define __dbvfs_h__

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-method.h>

GnomeVFSResult dbvfs_do_open (GnomeVFSMethod *method,
			      GnomeVFSMethodHandle **method_handle,
			      GnomeVFSURI *uri,
			      GnomeVFSOpenMode mode,
			      GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_close (GnomeVFSMethod *method,
			       GnomeVFSMethodHandle *method_handle,
			       GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_read (GnomeVFSMethod *method,
			      GnomeVFSMethodHandle *method_handle,
			      gpointer buffer,
			      GnomeVFSFileSize num_bytes,
			      GnomeVFSFileSize *bytes_read,
			      GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_write (GnomeVFSMethod *method,
			       GnomeVFSMethodHandle *method_handle,
			       gconstpointer buffer,
			       GnomeVFSFileSize num_bytes,
			       GnomeVFSFileSize *bytes_written,
			       GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_create (GnomeVFSMethod *method,
				GnomeVFSMethodHandle **method_handle,
				GnomeVFSURI *uri,
				GnomeVFSOpenMode mode,
				gboolean exclusive,
				guint perm,
				GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_get_file_info (GnomeVFSMethod *method,
				       GnomeVFSURI *uri,
				       GnomeVFSFileInfo *vfs_file_info,
				       GnomeVFSFileInfoOptions options,
				       GnomeVFSContext *context);
gboolean dbvfs_do_is_local (GnomeVFSMethod *method, const GnomeVFSURI *uri);
GnomeVFSResult dbvfs_do_open_directory (GnomeVFSMethod *method,
					GnomeVFSMethodHandle **method_handle,
					GnomeVFSURI *uri,
					GnomeVFSFileInfoOptions options,
					GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_close_directory (GnomeVFSMethod *method,
					 GnomeVFSMethodHandle *method_handle,
					 GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_read_directory (GnomeVFSMethod *method,
					GnomeVFSMethodHandle *method_handle,
					GnomeVFSFileInfo *file_info,
					GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_seek (GnomeVFSMethod *method,
			      GnomeVFSMethodHandle *method_handle,
			      GnomeVFSSeekPosition whence,
			      GnomeVFSFileOffset offset,
			      GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_tell (GnomeVFSMethod *method,
			      GnomeVFSMethodHandle *method_handle,
			      GnomeVFSFileOffset *offset_return);
GnomeVFSResult dbvfs_do_unlink (GnomeVFSMethod *method,
				GnomeVFSURI *uri,
				GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_check_same_fs (GnomeVFSMethod *method,
				       GnomeVFSURI *a,
				       GnomeVFSURI *b,
				       gboolean *same_fs_return,
				       GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_move (GnomeVFSMethod *method,
			      GnomeVFSURI *old_uri,
			      GnomeVFSURI *new_uri,
			      gboolean force_replace,
			      GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_truncate_handle (GnomeVFSMethod *method,
					 GnomeVFSMethodHandle *method_handle,
					 GnomeVFSFileSize where,
					 GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_get_file_info_from_handle (GnomeVFSMethod *method,
						   GnomeVFSMethodHandle *method_handle,
						   GnomeVFSFileInfo *file_info,
						   GnomeVFSFileInfoOptions options,
						   GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_make_directory (GnomeVFSMethod *method,
					GnomeVFSURI *uri,
					guint perm,
					GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_remove_directory (GnomeVFSMethod *method,
					  GnomeVFSURI *uri,
					  GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_set_file_info (GnomeVFSMethod *method,
				       GnomeVFSURI *uri,
				       const GnomeVFSFileInfo *info,
				       GnomeVFSSetFileInfoMask mask,
				       GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_truncate (GnomeVFSMethod *method,
				  GnomeVFSURI *uri,
				  GnomeVFSFileSize where,
				  GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_find_directory (GnomeVFSMethod *method,
					GnomeVFSURI *near_uri,
					GnomeVFSFindDirectoryKind kind,
					GnomeVFSURI **result_uri,
					gboolean create_if_needed,
					gboolean find_if_needed,
					guint permissions,
					GnomeVFSContext *context);
GnomeVFSResult dbvfs_do_create_symbolic_link (GnomeVFSMethod *method,
					      GnomeVFSURI *uri,
					      const char *target_reference,
					      GnomeVFSContext *context);

#endif
