/* GNOME DB library
 * Copyright (C) 1999-2001, The Free Software Foundation
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <libgnomedb/gnome-db-connection-selector.h>

#define PARENT_TYPE GTK_TYPE_OPTION_MENU

struct _GnomeDbConnectionSelectorPrivate {
};

static void gnome_db_connection_selector_class_init (GnomeDbConnectionSelectorClass *klass);
static void gnome_db_connection_selector_init       (GnomeDbConnectionSelector *selector,
						     GnomeDbConnectionSelectorClass *klass);
static void gnome_db_connection_selector_finalize   (GObject *object);

static GObjectClass *parent_class = NULL;

/*
 * GnomeDbConnectionSelector class implementation
 */

static void
gnome_db_connection_selector_class_init (GnomeDbConnectionSelectorClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	parent_class = g_type_class_peek_parent (klass);

	object_class->finalize = gnome_db_connection_selector_finalize;
}

static void
gnome_db_connection_selector_init (GnomeDbConnectionSelector *selector,
				   GnomeDbConnectionSelectorClass *klass)
{
	g_return_if_fail (GNOME_DB_IS_CONNECTION_SELECTOR (selector));

	selector->priv = g_new0 (GnomeDbConnectionSelectorPrivate, 1);

	/* set up widgets */
}

static void
gnome_db_connection_selector_finalize (GObject *object)
{
	GnomeDbConnectionSelector *selector = (GnomeDbConnectionSelector *) object;

	g_return_if_fail (GNOME_DB_IS_CONNECTION_SELECTOR (selector));

	g_free (selector->priv);
	selector->priv = NULL;

	parent_class->finalize (object);
}

GType
gnome_db_connection_selector_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (GnomeDbConnectionSelectorClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_db_connection_selector_class_init,
			NULL,
			NULL,
			sizeof (GnomeDbConnectionSelector),
			0,
			(GInstanceInitFunc) gnome_db_connection_selector_init
		};
		type = g_type_register_static (PARENT_TYPE,
					       "GnomeDbConnectionSelector",
					       &info, 0);
	}
	return type;
}

/**
 * gnome_db_connection_selector_new
 */
GtkWidget *
gnome_db_connection_selector_new (void)
{
	GnomeDbConnectionSelector *selector;

	selector = g_object_new (GNOME_DB_TYPE_CONNECTION_SELECTOR, NULL);
	return GTK_WIDGET (selector);
}
