/* gnome-db-model-wrapper.h
 *
 * Copyright (C) 2004 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_MODEL_WRAPPER_H_
#define __GNOME_DB_MODEL_WRAPPER_H_

#include <glib-object.h>
#include "gnome-db-decl.h"
#include "gnome-db-base.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_MODEL_WRAPPER          (gnome_db_model_wrapper_get_type())
#define GNOME_DB_MODEL_WRAPPER(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_model_wrapper_get_type(), GnomeDbModelWrapper)
#define GNOME_DB_MODEL_WRAPPER_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_model_wrapper_get_type (), GnomeDbModelWrapperClass)
#define IS_GNOME_DB_MODEL_WRAPPER(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_model_wrapper_get_type ())


/* struct for the object's data */
struct _GnomeDbModelWrapper
{
	GnomeDbBase                 object;
	GnomeDbModelWrapperPrivate *priv;
};

/* struct for the object's class */
struct _GnomeDbModelWrapperClass
{
	GnomeDbBaseClass             class;
};

GType           gnome_db_model_wrapper_get_type         (void);
GObject        *gnome_db_model_wrapper_new              (GnomeDbDict *dict, GdaDataModel *model);

G_END_DECLS

#endif
