/* gnome-db-qf-all.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_QF_ALL_H_
#define __GNOME_DB_QF_ALL_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include "gnome-db-qfield.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_QF_ALL          (gnome_db_qf_all_get_type())
#define GNOME_DB_QF_ALL(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_qf_all_get_type(), GnomeDbQfAll)
#define GNOME_DB_QF_ALL_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_qf_all_get_type (), GnomeDbQfAllClass)
#define IS_GNOME_DB_QF_ALL(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_qf_all_get_type ())


/* error reporting */
extern GQuark gnome_db_qf_all_error_quark (void);
#define GNOME_DB_QF_ALL_ERROR gnome_db_qf_all_error_quark ()

enum
{
	GNOME_DB_QF_ALL_XML_LOAD_ERROR,
	GNOME_DB_QF_ALL_RENDER_ERROR
};


/* struct for the object's data */
struct _GnomeDbQfAll
{
	GnomeDbQfield              object;
	GnomeDbQfAllPrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbQfAllClass
{
	GnomeDbQfieldClass                  class;

	/* signals */
	void   (*templ_signal)        (GnomeDbQfAll *obj);
};

GType           gnome_db_qf_all_get_type          (void);
GObject        *gnome_db_qf_all_new_with_target   (GnomeDbQuery *query, GnomeDbTarget *target);
GObject        *gnome_db_qf_all_new_with_xml_id   (GnomeDbQuery *query, const gchar *target_xml_id);

GnomeDbTarget       *gnome_db_qf_all_get_target        (GnomeDbQfAll *field);

G_END_DECLS

#endif
